/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.dstore.internal.core.util.MemoryManager;

public class DataElementRemover
extends Handler {
    private LinkedList _queue;
    private static int numDisconnected = 0;
    public static final int DEFAULT_EXPIRY_TIME = 60;
    public static final int DEFAULT_INTERVAL_TIME = 60;
    private int _intervalTime = 60000;
    private int _expiryTime = 60000;
    public static final String EXPIRY_TIME_PROPERTY_NAME = "SPIRIT_EXPIRY_TIME";
    public static final String INTERVAL_TIME_PROPERTY_NAME = "SPIRIT_INTERVAL_TIME";
    public MemoryManager _memoryManager;

    public DataElementRemover(DataStore dataStore) {
        this._memoryManager = new MemoryManager(dataStore);
        this._dataStore = dataStore;
        this._queue = new LinkedList();
        this.getTimes();
        this.setWaitTime(this._intervalTime);
    }

    protected void getTimes() {
        try {
            String expiryTime = System.getProperty(EXPIRY_TIME_PROPERTY_NAME);
            if (expiryTime != null && !expiryTime.equals("")) {
                this._expiryTime = Integer.parseInt(expiryTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit expiry time property, using default.");
        }
        try {
            String intervalTime = System.getProperty(INTERVAL_TIME_PROPERTY_NAME);
            if (intervalTime != null && !intervalTime.equals("")) {
                this._intervalTime = Integer.parseInt(intervalTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit interval time property, using default.");
        }
    }

    public static void addToRemovedCount() {
    }

    public static void addToCreatedCount() {
    }

    public static void addToGCedCount() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueueForRemoval(DataElement element) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this.isMemoryThresholdExceeded()) {
                if (element.isSpirit()) {
                    this.unmap(element);
                }
                this.clearQueue(true);
                return;
            }
            if (this._dataStore.isDoSpirit() && this._dataStore == element.getDataStore()) {
                QueueItem item = new QueueItem(element, System.currentTimeMillis());
                this._queue.add(item);
            }
        }
        this.notifyInput();
    }

    private boolean isMemoryThresholdExceeded() {
        return this._memoryManager.isThresholdExceeded();
    }

    public void handle() {
        this.clearQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearQueue(boolean force) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._dataStore.memLog("           ");
            int disconnected = 0;
            if (!this._dataStore.isDoSpirit()) {
                if (this._queue.size() > 0) {
                    this._dataStore.memLog("Clearing queue of size " + this._queue.size() + ". DSTORE_SPIRIT_ON not set or set to false.");
                    this._queue.clear();
                }
                this._dataStore.memLog("Total heap size: " + Runtime.getRuntime().totalMemory());
                this._dataStore.memLog("Live elements: " + this._dataStore.getNumElements());
                this._dataStore.memLog("Recycled elements: " + this._dataStore.getNumRecycled());
                this._dataStore.memLog("Elements disconnected so far: " + numDisconnected);
                return;
            }
            this._dataStore.memLog("Total heap size before disconnection: " + Runtime.getRuntime().totalMemory());
            this._dataStore.memLog("Size of queue: " + this._queue.size());
            ArrayList<DataElement> toRefresh = new ArrayList<DataElement>();
            while (this._queue.size() > 0 && (force || System.currentTimeMillis() - ((QueueItem)this._queue.getFirst()).timeStamp > (long)this._expiryTime)) {
                DataElement toBeDisconnected = ((QueueItem)this._queue.removeFirst()).dataElement;
                if (!toBeDisconnected.isSpirit()) {
                    toBeDisconnected.setSpirit(true);
                    toBeDisconnected.setUpdated(false);
                    DataElement parent = toBeDisconnected.getParent();
                    if (!toRefresh.contains(parent)) {
                        toRefresh.add(toBeDisconnected.getParent());
                    }
                    ++disconnected;
                    ++numDisconnected;
                }
                this.unmap(toBeDisconnected);
            }
            this._dataStore.refresh(toRefresh);
            this._dataStore.memLog("Disconnected " + disconnected + " DataElements.");
            this._dataStore.memLog("Live elements: " + this._dataStore.getNumElements());
            this._dataStore.memLog("Recycled elements: " + this._dataStore.getNumRecycled());
            this._dataStore.memLog("Elements disconnected so far: " + numDisconnected);
            System.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmap(DataElement element) {
        HashMap map;
        HashMap hashMap = map = this._dataStore.getHashMap();
        synchronized (hashMap) {
            map.remove(element.getId());
            this._dataStore.addToRecycled(element);
        }
    }

    public void run() {
        while (this._keepRunning) {
            try {
                Thread.sleep(this._intervalTime);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.finish();
                return;
            }
            this.handle();
        }
    }

    protected class QueueItem {
        public DataElement dataElement;
        public long timeStamp;

        public QueueItem(DataElement element, long stamp) {
            this.dataElement = element;
            this.timeStamp = stamp;
        }
    }
}

