/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.HostOwnedFilterPoolPattern;
import org.eclipse.rse.internal.persistence.IRSEImportExportProvider;
import org.eclipse.rse.internal.persistence.dom.RSEDOMExporter;
import org.eclipse.rse.internal.persistence.dom.RSEDOMImporter;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;

public class RSEEnvelope {
    private static IStatus INVALID_FORMAT = new Status(4, "org.eclipse.rse.core", 2, RSECoreMessages.RSEEnvelope_IncorrectFormat, null);
    private static IStatus MODEL_NOT_EXPORTED = new Status(4, "org.eclipse.rse.core", RSECoreMessages.RSEEnvelope_ModelNotExported);
    private RSEDOM dom = null;

    public void get(InputStream in, IProgressMonitor monitor) throws CoreException {
        File envelopeFolder = this.getTemporaryFolder();
        IStatus status = this.unzip(in, envelopeFolder);
        if (status.isOK()) {
            String providerId = this.loadProviderId(envelopeFolder);
            IRSEPersistenceManager manager = RSECorePlugin.getThePersistenceManager();
            IRSEPersistenceProvider provider = manager.getPersistenceProvider(providerId);
            if (provider != null) {
                if (provider instanceof IRSEImportExportProvider) {
                    IRSEImportExportProvider ieProvider = (IRSEImportExportProvider)((Object)provider);
                    this.dom = ieProvider.importRSEDOM(envelopeFolder, monitor);
                    if (this.dom == null) {
                        status = INVALID_FORMAT;
                    }
                } else {
                    status = INVALID_FORMAT;
                }
            } else {
                status = INVALID_FORMAT;
            }
        }
        this.deleteFileSystemObject(envelopeFolder);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void put(OutputStream out, IRSEPersistenceProvider provider, IProgressMonitor monitor) throws CoreException {
        IStatus status = Status.OK_STATUS;
        if (provider instanceof IRSEImportExportProvider) {
            IRSEImportExportProvider exportProvider = (IRSEImportExportProvider)((Object)provider);
            File envelopeFolder = this.getTemporaryFolder();
            boolean saved = exportProvider.exportRSEDOM(envelopeFolder, this.dom, monitor);
            if (saved) {
                status = this.saveProviderId(envelopeFolder, exportProvider);
                if (status.isOK()) {
                    status = this.zip(envelopeFolder, out);
                }
                this.deleteFileSystemObject(envelopeFolder);
            } else {
                status = MODEL_NOT_EXPORTED;
            }
        } else {
            status = MODEL_NOT_EXPORTED;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public void add(final IHost host) {
        ISubSystem[] subsystems = host.getSubSystems();
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem subsystem = subsystems[i];
            ISystemFilterPool pool = subsystem.getUniqueOwningSystemFilterPool(false);
            if (pool != null) {
                this.add(pool);
            }
            ++i;
        }
        String type = "Host";
        String name = host.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, host, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void add(final ISystemFilterPool pool) {
        String type = "FilterPool";
        String name = pool.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, pool, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void add(final IPropertySet propertySet) {
        String type = "FilterPool";
        String name = propertySet.getName();
        Runnable action = new Runnable(){

            public void run() {
                RSEDOMExporter.getInstance().createNode((RSEDOMNode)RSEEnvelope.this.dom, propertySet, true);
            }
        };
        this.addNode(type, name, action);
    }

    public void mergeWith(ISystemProfile profile) throws CoreException {
        ArrayList<RSEDOMNode> hostNodes = new ArrayList<RSEDOMNode>(10);
        ArrayList<RSEDOMNode> filterPoolNodes = new ArrayList<RSEDOMNode>(10);
        ArrayList<RSEDOMNode> propertySetNodes = new ArrayList<RSEDOMNode>(10);
        HashMap<String, String> hostMap = new HashMap<String, String>(10);
        HashMap<String, String> filterPoolMap = new HashMap<String, String>(10);
        String originalProfileName = this.getOriginalProfileName();
        if (this.dom != null) {
            RSEDOMNode filterPoolNode;
            String originalName;
            RSEDOMNode hostNode;
            RSEDOMNode[] children = this.dom.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String nodeType = child.getType();
                if (nodeType.equals("Host")) {
                    hostNodes.add(child);
                } else if (nodeType.equals("FilterPool")) {
                    filterPoolNodes.add(child);
                } else if (nodeType.equals("PropertySet")) {
                    propertySetNodes.add(child);
                } else {
                    throw new IllegalArgumentException("invalid dom node type");
                }
                ++i;
            }
            Iterator z = hostNodes.iterator();
            while (z.hasNext()) {
                hostNode = (RSEDOMNode)z.next();
                originalName = hostNode.getName();
                String finalName = this.getFinalHostName(profile, originalName);
                hostMap.put(originalName, finalName);
            }
            z = filterPoolNodes.iterator();
            while (z.hasNext()) {
                filterPoolNode = (RSEDOMNode)z.next();
                originalName = filterPoolNode.getName();
                String subsystemConfigurationId = filterPoolNode.getAttribute("id").getValue();
                String finalName = this.getFinalFilterPoolName(profile, originalName, subsystemConfigurationId, hostMap);
                filterPoolMap.put(originalName, finalName);
            }
            z = hostNodes.iterator();
            while (z.hasNext()) {
                hostNode = (RSEDOMNode)z.next();
                this.mergeHost(profile, hostNode, hostMap, filterPoolMap, originalProfileName);
            }
            z = filterPoolNodes.iterator();
            while (z.hasNext()) {
                filterPoolNode = (RSEDOMNode)z.next();
                this.mergeFilterPool(profile, filterPoolNode, filterPoolMap);
            }
        }
    }

    private String getFinalHostName(ISystemProfile profile, String originalName) {
        int n = 0;
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        String finalName = originalName;
        while (registry.getHost(profile, finalName) != null) {
            finalName = String.valueOf(originalName) + "-" + ++n;
        }
        return finalName;
    }

    private String getFinalFilterPoolName(ISystemProfile profile, String originalName, String subsystemConfigurationId, Map hostMap) {
        String finalHostName;
        String finalName = null;
        HostOwnedFilterPoolPattern pattern = new HostOwnedFilterPoolPattern(subsystemConfigurationId);
        String originalHostName = pattern.extract(originalName);
        if (originalHostName != null && (finalHostName = (String)hostMap.get(originalHostName)) != null) {
            finalName = pattern.make(finalHostName);
        }
        if (finalName == null) {
            int n = 0;
            finalName = originalName;
            ISystemFilterPool filterPool = this.getFilterPool(profile, finalName, subsystemConfigurationId);
            while (filterPool != null) {
                finalName = String.valueOf(originalName) + "-" + ++n;
                filterPool = this.getFilterPool(profile, finalName, subsystemConfigurationId);
            }
        }
        return finalName;
    }

    private IHost mergeHost(ISystemProfile profile, RSEDOMNode hostNode, Map hostMap, Map filterPoolMap, String originalProfileName) {
        String originalHostName = hostNode.getName();
        String finalHostName = (String)hostMap.get(originalHostName);
        hostNode.setName(finalHostName);
        this.fixSubsystems(hostNode, profile, filterPoolMap, originalProfileName);
        RSEDOMImporter importer = RSEDOMImporter.getInstance();
        IHost host = importer.restoreHost(profile, hostNode);
        return host;
    }

    private void fixSubsystems(RSEDOMNode hostNode, ISystemProfile profile, Map filterPoolMap, String originalProfileName) {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        RSEDOMNode[] connectorServiceNodes = hostNode.getChildren("ConnectorService");
        int i = 0;
        while (i < connectorServiceNodes.length) {
            RSEDOMNode connectorServiceNode = connectorServiceNodes[i];
            RSEDOMNode[] subsystemNodes = connectorServiceNode.getChildren("SubSystem");
            int j = 0;
            while (j < subsystemNodes.length) {
                RSEDOMNode subsystemNode = subsystemNodes[j];
                String subsystemConfigurationId = this.getSubsystemConfigurationId(subsystemNode);
                String subsystemName = subsystemNode.getName();
                ISubSystemConfiguration subsystemConfiguration = registry.getSubSystemConfiguration(subsystemConfigurationId);
                if (subsystemConfiguration == null) {
                    connectorServiceNode.removeChild(subsystemNode);
                    String template = "The subsystem {0} cannot be imported. The subsystem configuration with identifier {1} is not installed.";
                    String message = NLS.bind((String)template, (Object)subsystemName, (Object)subsystemConfigurationId);
                    Status status = new Status(1, "org.eclipse.rse.core", message);
                    RSECorePlugin.getDefault().getLog().log((IStatus)status);
                } else {
                    subsystemConfiguration.getFilterPoolManager(profile, true);
                    this.fixFilterPoolReferences(subsystemNode, profile, filterPoolMap, originalProfileName);
                }
                ++j;
            }
            ++i;
        }
    }

    private void fixFilterPoolReferences(RSEDOMNode subsystemNode, ISystemProfile profile, Map filterPoolMap, String originalProfileName) {
        String subsystemConfigurationId = this.getSubsystemConfigurationId(subsystemNode);
        RSEDOMNode[] filterPoolReferenceNodes = subsystemNode.getChildren("FilterPoolReference");
        if (originalProfileName != null) {
            String newProfileName = profile.getName();
            int i = 0;
            while (i < filterPoolReferenceNodes.length) {
                RSEDOMNode filterPoolReferenceNode = filterPoolReferenceNodes[i];
                String[] parts = this.parseFilterPoolReferenceName(filterPoolReferenceNode);
                if (parts.length == 2) {
                    String originalFilterPoolName = parts[1];
                    String finalFilterPoolName = null;
                    if (this.isDefaultSubsystemFilterPoolName(originalFilterPoolName, originalProfileName, subsystemConfigurationId)) {
                        finalFilterPoolName = this.makeDefaultSubsystemFilterPoolName(newProfileName, subsystemConfigurationId);
                    } else {
                        finalFilterPoolName = (String)filterPoolMap.get(originalFilterPoolName);
                        if (finalFilterPoolName == null) {
                            finalFilterPoolName = originalFilterPoolName;
                        }
                    }
                    String qualifiedFilterPoolName = this.makeFilterPoolReferenceName(newProfileName, finalFilterPoolName);
                    filterPoolReferenceNode.setName(qualifiedFilterPoolName);
                }
                ++i;
            }
        }
    }

    private String getOriginalProfileName() {
        String originalProfileName = this.getOriginalProfileName(this.dom);
        if (originalProfileName == null) {
            originalProfileName = "DOM";
        }
        return originalProfileName;
    }

    private String getOriginalProfileName(RSEDOMNode node) {
        String result = null;
        if (this.isFilterPoolReference(node) && this.isConnectionPrivateFilterPoolReference(node)) {
            String[] names = this.parseFilterPoolReferenceName(node);
            result = names[0];
        }
        if (result == null) {
            RSEDOMNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                result = this.getOriginalProfileName(child);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    private String getSubsystemConfigurationId(RSEDOMNode subsystemNode) {
        String subsystemConfigurationId = subsystemNode.getAttribute("type").getValue();
        return subsystemConfigurationId;
    }

    private boolean isFilterPoolReference(RSEDOMNode node) {
        boolean result = node.getType().equals("FilterPoolReference");
        return result;
    }

    private boolean isDefaultSubsystemFilterPoolName(String filterPoolName, String profileName, String subsystemConfigurationId) {
        String defaultSubsystemFilterPoolName = this.makeDefaultSubsystemFilterPoolName(profileName, subsystemConfigurationId);
        boolean result = filterPoolName.equals(defaultSubsystemFilterPoolName);
        return result;
    }

    private boolean isConnectionPrivateFilterPoolReference(RSEDOMNode filterPoolReferenceNode) {
        String[] parts = this.parseFilterPoolReferenceName(filterPoolReferenceNode);
        boolean result = false;
        if (parts.length == 2) {
            String filterPoolName = parts[1];
            result = filterPoolName.startsWith("CN-");
        }
        return result;
    }

    private String[] parseFilterPoolReferenceName(RSEDOMNode filterPoolReferenceNode) {
        String name = filterPoolReferenceNode.getName();
        String[] result = name.split("___");
        return result;
    }

    private String makeFilterPoolReferenceName(String profileName, String filterPoolName) {
        String result = String.valueOf(profileName) + "___" + filterPoolName;
        return result;
    }

    private String makeDefaultSubsystemFilterPoolName(String profileName, String subsystemConfigurationId) {
        String defaultSubsystemFilterPoolName = String.valueOf(profileName) + ":" + subsystemConfigurationId;
        return defaultSubsystemFilterPoolName;
    }

    private ISystemFilterPool mergeFilterPool(ISystemProfile profile, RSEDOMNode filterPoolNode, Map filterPoolMap) {
        String originalName = filterPoolNode.getName();
        String subsystemConfigurationId = filterPoolNode.getAttribute("id").getValue();
        String finalName = (String)filterPoolMap.get(originalName);
        filterPoolNode.setName(finalName);
        RSEDOMImporter importer = RSEDOMImporter.getInstance();
        ISystemFilterPool filterPool = importer.restoreFilterPool(profile, filterPoolNode);
        HostOwnedFilterPoolPattern pattern = new HostOwnedFilterPoolPattern(subsystemConfigurationId);
        String hostName = pattern.extract(finalName);
        if (hostName != null) {
            filterPool.setOwningParentName(hostName);
        }
        return filterPool;
    }

    private ISystemFilterPool getFilterPool(ISystemProfile profile, String filterPoolName, String subsystemConfigurationId) {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration subsystemConfiguration = registry.getSubSystemConfiguration(subsystemConfigurationId);
        ISystemFilterPoolManager manager = subsystemConfiguration.getFilterPoolManager(profile);
        ISystemFilterPool filterPool = manager.getSystemFilterPool(filterPoolName);
        return filterPool;
    }

    private IStatus saveProviderId(File parent, IRSEImportExportProvider provider) {
        IStatus status = Status.OK_STATUS;
        String providerId = provider.getId();
        File idFile = new File(parent, "provider.id");
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(idFile));
            out.write(providerId);
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        return status;
    }

    private String loadProviderId(File parent) throws CoreException {
        String providerId = null;
        File idFile = new File(parent, "provider.id");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(idFile)));
            providerId = in.readLine();
            in.close();
        }
        catch (IOException iOException) {
            IStatus status = INVALID_FORMAT;
            throw new CoreException(status);
        }
        return providerId;
    }

    private void addNode(String type, String name, Runnable action) {
        this.ensureDOM();
        RSEDOMNode existingNode = this.dom.getChild(type, name);
        if (existingNode != null) {
            this.dom.removeChild(existingNode);
        }
        action.run();
    }

    private void ensureDOM() {
        if (this.dom == null) {
            this.dom = new RSEDOM("dom");
        }
    }

    private String generateName(List usedNames) {
        String prefix = "env_";
        int n = 0;
        String name = String.valueOf(prefix) + n;
        while (usedNames.contains(name)) {
            name = String.valueOf(prefix) + ++n;
        }
        return name;
    }

    private IStatus zip(File source, OutputStream target) {
        IStatus status = Status.OK_STATUS;
        try {
            ZipOutputStream out = new ZipOutputStream(target);
            this.zipEntry(out, source, "");
            out.close();
        }
        catch (IOException e) {
            status = this.makeStatus(e);
        }
        return status;
    }

    private void zipEntry(ZipOutputStream out, File file, String entryName) {
        if (file.isDirectory()) {
            this.zipDirectoryEntry(out, file, entryName);
        } else {
            this.zipFileEntry(out, file, entryName);
        }
    }

    private void zipDirectoryEntry(ZipOutputStream out, File file, String entryName) {
        String fileName = file.getName();
        if (!fileName.equals(".") && !fileName.equals("..")) {
            if (entryName.length() > 0) {
                try {
                    ZipEntry entry = new ZipEntry(String.valueOf(entryName) + "/");
                    out.putNextEntry(entry);
                    out.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File child = files[i];
                String childName = child.getName();
                String childEntryName = String.valueOf(entryName) + "/" + childName;
                this.zipEntry(out, child, childEntryName);
                ++i;
            }
        }
    }

    private void zipFileEntry(ZipOutputStream out, File file, String entryName) {
        try {
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            FileInputStream in = new FileInputStream(file);
            int n = in.read(buffer);
            while (n >= 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
            in.close();
            out.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private IStatus unzip(InputStream in, File root) {
        IStatus status = Status.OK_STATUS;
        try {
            try {
                ZipInputStream inZip = new ZipInputStream(in);
                ZipEntry entry = inZip.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    File target = new File(root, name);
                    if (entry.isDirectory()) {
                        target.mkdir();
                    } else {
                        byte[] buffer = new byte[4096];
                        FileOutputStream out = new FileOutputStream(target);
                        int n = inZip.read(buffer);
                        while (n >= 0) {
                            out.write(buffer, 0, n);
                            n = inZip.read(buffer);
                        }
                        out.close();
                    }
                    entry = inZip.getNextEntry();
                }
            }
            catch (FileNotFoundException e) {
                status = this.makeStatus(e);
                try {
                    in.close();
                }
                catch (IOException e2) {
                    status = this.makeStatus(e2);
                }
            }
            catch (ZipException e) {
                RSECorePlugin.getDefault().getLogger().logError(RSECoreMessages.RSEEnvelope_IncorrectFormat, e);
                status = INVALID_FORMAT;
                try {
                    in.close();
                }
                catch (IOException e3) {
                    status = this.makeStatus(e3);
                }
            }
            catch (IOException e) {
                status = this.makeStatus(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e4) {
                    status = this.makeStatus(e4);
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                status = this.makeStatus(e);
            }
        }
        return status;
    }

    private IStatus deleteFileSystemObject(File file) {
        IStatus status = Status.OK_STATUS;
        String fileName = file.getName();
        if (!fileName.equals(".") && !fileName.equals("..") && file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    File child = files[i];
                    this.deleteFileSystemObject(child);
                    ++i;
                }
            }
            file.delete();
        }
        return status;
    }

    private IStatus makeStatus(Exception e) {
        Status status = new Status(4, "org.eclipse.rse.core", "Unexpected exception", (Throwable)e);
        return status;
    }

    private File getTemporaryFolder() {
        IPath stateLocation = RSECorePlugin.getDefault().getStateLocation();
        File stateFolder = new File(stateLocation.toOSString());
        File envelopesFolder = new File(stateFolder, "envelopes");
        envelopesFolder.mkdir();
        List<String> envelopeNames = Arrays.asList(envelopesFolder.list());
        String envelopeName = this.generateName(envelopeNames);
        File envelopeFolder = new File(envelopesFolder, envelopeName);
        envelopeFolder.mkdir();
        return envelopeFolder;
    }
}

