/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.search;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.ISystemAddFileListener;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.internal.files.ui.search.SystemSearchRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.swt.widgets.Shell;

public class SystemSearchRemoteFolderAction
extends SystemSelectRemoteFolderAction {
    private IRSESystemType[] systemTypes;
    private IHost systemConnection;
    private IHost outputConnection;
    private IHost rootFolderConnection;
    private IRemoteFile preSelection;
    private String rootFolderAbsPath;
    private String message;
    private String treeTip;
    private String dlgTitle;
    private String addLabel;
    private String addToolTipText;
    private int expandDepth = 0;
    private boolean showNewConnectionPrompt = true;
    private boolean restrictFolders = false;
    private boolean showPropertySheet = false;
    private boolean showPropertySheetDetailsButtonInitialState;
    private boolean showPropertySheetDetailsButton = false;
    private boolean multipleSelectionMode = false;
    private boolean allowForMultipleParents = false;
    private boolean onlyConnection = false;
    private ISystemAddFileListener addButtonCallback = null;
    private IValidatorRemoteSelection selectionValidator;

    public SystemSearchRemoteFolderAction(Shell shell) {
        super(shell);
    }

    public SystemSearchRemoteFolderAction(Shell shell, String label, String tooltip) {
        super(shell, label, tooltip);
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.treeTip = tip;
    }

    public void setHost(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = true;
    }

    public void setDefaultConnection(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = false;
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(IRSESystemType systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new IRSESystemType[]{systemType});
        }
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public void setAutoExpandDepth(int depth) {
        this.expandDepth = depth;
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        this.rootFolderConnection = connection;
        this.rootFolderAbsPath = folderAbsolutePath;
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.setRootFolder(rootFolder.getHost(), rootFolder.getAbsolutePath());
    }

    public void setPreSelection(IRemoteFile selection) {
        this.preSelection = selection;
    }

    public void setRestrictFolders(boolean restrict) {
        this.restrictFolders = true;
    }

    public void enableAddMode(ISystemAddFileListener caller) {
        this.addButtonCallback = caller;
    }

    public void enableAddMode(ISystemAddFileListener caller, String addLabel, String addToolTipText) {
        this.enableAddMode(caller);
        this.addLabel = addLabel;
        this.addToolTipText = addToolTipText;
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        this.setShowPropertySheet(show);
        if (show) {
            this.showPropertySheetDetailsButton = true;
            this.showPropertySheetDetailsButtonInitialState = initialState;
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
    }

    public void setAllowForMultipleParents(boolean multiple) {
        this.allowForMultipleParents = multiple;
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public IRemoteFile getSelectedFolder() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return ((IRemoteFile[])o)[0];
        }
        if (o instanceof IRemoteFile) {
            return (IRemoteFile)o;
        }
        return null;
    }

    public IRemoteFile[] getSelectedFolders() {
        Object o = this.getValue();
        if (o instanceof Object[]) {
            Object[] temp = (Object[])o;
            IRemoteFile[] files = new IRemoteFile[temp.length];
            int i = 0;
            while (i < temp.length) {
                if (!(temp[i] instanceof IRemoteFile)) {
                    return new IRemoteFile[0];
                }
                files[i] = (IRemoteFile)temp[i];
                ++i;
            }
            return files;
        }
        if (o instanceof IRemoteFile[]) {
            return (IRemoteFile[])o;
        }
        if (o instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)o};
        }
        return new IRemoteFile[0];
    }

    public Object[] getSelectedObjects() {
        Object remoteObject = this.getValue();
        if (remoteObject == null) {
            return null;
        }
        if (remoteObject instanceof Object[]) {
            return (Object[])remoteObject;
        }
        if (remoteObject instanceof IRemoteFile[]) {
            return (Object[])remoteObject;
        }
        return new Object[]{remoteObject};
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    protected Dialog createDialog(Shell shell) {
        SystemSearchRemoteFolderDialog dlg = null;
        dlg = this.dlgTitle == null ? new SystemSearchRemoteFolderDialog(shell) : new SystemSearchRemoteFolderDialog(shell, this.dlgTitle);
        dlg.setMultipleSelectionMode(this.multipleSelectionMode);
        if (this.message != null) {
            dlg.setMessage(this.message);
        }
        if (this.treeTip != null) {
            dlg.setSelectionTreeToolTipText(this.treeTip);
        }
        if (this.systemConnection != null) {
            if (this.onlyConnection) {
                dlg.setDefaultSystemConnection(this.systemConnection, true);
            } else {
                dlg.setDefaultSystemConnection(this.systemConnection, false);
            }
        }
        if (this.systemTypes != null) {
            dlg.setSystemTypes(this.systemTypes);
        }
        if (this.preSelection != null) {
            dlg.setPreSelection(this.preSelection);
        }
        if (this.showPropertySheet) {
            if (this.showPropertySheetDetailsButton) {
                dlg.setShowPropertySheet(true, this.showPropertySheetDetailsButtonInitialState);
            } else {
                dlg.setShowPropertySheet(true);
            }
        }
        if (this.selectionValidator != null) {
            dlg.setSelectionValidator(this.selectionValidator);
        }
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemSearchRemoteFolderDialog ourDlg = (SystemSearchRemoteFolderDialog)dlg;
        Object outputObject = null;
        this.outputConnection = null;
        if (!ourDlg.wasCancelled()) {
            outputObject = this.multipleSelectionMode ? ourDlg.getSelectedObjects() : ourDlg.getSelectedObject();
            this.outputConnection = ourDlg.getSelectedConnection();
        }
        return outputObject;
    }
}

