/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SystemWorkOfflineAction
extends SystemBaseAction {
    public SystemWorkOfflineAction(Shell shell) {
        super(SystemResources.RESID_OFFLINE_WORKOFFLINE_LABEL, SystemResources.RESID_OFFLINE_WORKOFFLINE_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.setHelp("org.eclipse.rse.ui.wofa0000");
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof IHost;
    }

    public void run() {
        final IHost conn = (IHost)this.getFirstSelection();
        final ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (conn.isOffline()) {
            this.setChecked(false);
            sr.setHostOffline(conn, false);
        } else {
            sr.setHostOffline(conn, true);
            this.setChecked(true);
            final Display display = Display.getCurrent();
            String jobName = NLS.bind((String)CommonMessages.MSG_DISCONNECT_PROGRESS, (Object)conn.getName());
            Job disconnectJob = new Job(jobName){

                public IStatus run(IProgressMonitor monitor) {
                    ISubSystem[] subsystems = sr.getSubSystems(conn);
                    if (subsystems != null && subsystems.length > 0) {
                        boolean cancelled = false;
                        int i = 0;
                        while (i < subsystems.length && !cancelled) {
                            IConnectorService cs;
                            ISubSystem subSystem = subsystems[i];
                            if (subSystem.getSubSystemConfiguration().supportsSubSystemConnect() && subSystem.isConnected() && (cs = subSystem.getConnectorService()).isConnected()) {
                                try {
                                    cs.disconnect(monitor);
                                }
                                catch (Exception e) {
                                    SystemBasePlugin.logError(e.getMessage());
                                }
                                if (cs.isConnected()) {
                                    cancelled = true;
                                } else {
                                    cs.reset();
                                    display.asyncExec(new Runnable(this, sr, subSystem){
                                        final /* synthetic */ 1 this$1;
                                        private final /* synthetic */ ISystemRegistry val$sr;
                                        private final /* synthetic */ ISubSystem val$subSystem;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$sr = iSystemRegistry;
                                            this.val$subSystem = iSubSystem;
                                        }

                                        public void run() {
                                            this.val$sr.connectedStatusChange(this.val$subSystem, false, true, false);
                                        }
                                    });
                                }
                            }
                            if (monitor.isCanceled()) {
                                cancelled = true;
                            }
                            ++i;
                        }
                        if (cancelled) {
                            SystemWorkOfflineAction.this.setChecked(false);
                            sr.setHostOffline(conn, false);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            disconnectJob.schedule();
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection)) {
            this.setChecked(((IHost)selection.getFirstElement()).isOffline());
            return true;
        }
        return false;
    }
}

