/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;

public class XMLparser {
    public static final String KEEPALIVE_RESPONSE_TIMEOUT_PREFERENCE = "DSTORE_KEEPALIVE_RESPONSE_TIMEOUT";
    public static final String IO_SOCKET_READ_TIMEOUT_PREFERENCE = "DSTORE_IO_SOCKET_READ_TIMEOUT";
    public static final String KEEPALIVE_ENABLED_PREFERENCE = "DSTORE_KEEPALIVE_ENABLED";
    public int IO_SOCKET_READ_TIMEOUT = 3600000;
    public long KEEPALIVE_RESPONSE_TIMEOUT = 60000L;
    public static final boolean VERBOSE_KEEPALIVE = false;
    private DataStore _dataStore;
    private DataElement _rootDataElement;
    private Stack _tagStack;
    private Stack _objStack;
    private boolean _isFile;
    private boolean _isClass;
    private boolean _isRequestClass;
    private boolean _isKeepAlive;
    private boolean _isKeepAliveConfirm;
    private boolean _isSerialized;
    private String _tagType;
    private byte[] _byteBuffer;
    private byte[] _fileByteBuffer;
    private int _maxBuffer;
    private boolean _panic = false;
    private Throwable _panicException = null;
    private boolean _isKeepAliveCompatible = false;
    private boolean _isKeepAliveEnabled = true;
    private boolean _firstTime = true;
    private KeepAliveRequestThread _kart = null;
    private KeepAliveRequestThread _initialKart = null;
    public static String STR_DATAELEMENT = "DataElement";
    public static String STR_BUFFER_START = "<Buffer>";
    public static String STR_BUFFER_END = "</Buffer>";
    public static String STR_BUFFER = "Buffer";
    public static String STR_STATUS = "status";
    public static String STR_STATUS_DONE = "done";
    public static String STR_STATUS_ALMOST_DONE = "almost done";
    public static String STR_FILE = "File";
    public static String STR_CLASS = "Class";
    public static String STR_REQUEST_CLASS = "RequestClass";
    public static String STR_SERIALIZED = "Serialized";
    public static String STR_AMP = "&amp;";
    public static String STR_QUOTE = "&quot;";
    public static String STR_APOS = "&apos;";
    public static String STR_LT = "&lt;";
    public static String STR_GT = "&gt;";
    public static String STR_SEMI = "&#59;";
    public static String STR_NL = "&#92;&#110;";
    public static String STR_CR = "&#92;&#114;";
    public static String STR_EOL = "&#92;&#48;";

    public XMLparser(DataStore dataStore) {
        this._dataStore = dataStore;
        this._tagStack = new Stack();
        this._objStack = new Stack();
        this._maxBuffer = 100000;
        this._byteBuffer = new byte[this._maxBuffer];
    }

    public void setEnableKeepalive(boolean enable) {
        this._isKeepAliveCompatible = enable;
        this._isKeepAliveEnabled = enable;
    }

    public void setKeepaliveResponseTimeout(int timeout) {
        this.KEEPALIVE_RESPONSE_TIMEOUT = timeout;
    }

    public void setIOSocketReadTimeout(int timeout) {
        this.IO_SOCKET_READ_TIMEOUT = timeout;
    }

    public void readFile(BufferedInputStream reader, int size, String path, String byteStreamHandlerId) {
        boolean binary;
        if (this._fileByteBuffer == null || this._fileByteBuffer.length < size) {
            try {
                this._fileByteBuffer = new byte[size];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.exit(-1);
            }
        }
        int written = 0;
        while (written < size) {
            try {
                int read = reader.read(this._fileByteBuffer, written, size - written);
                written += read;
            }
            catch (SocketException se) {
                this._dataStore.trace(se);
                this.handlePanic(se);
                return;
            }
            catch (IOException e) {
                this._dataStore.trace(e);
                this.handlePanic(e);
            }
            catch (Error err) {
                System.out.println("error!");
                this.handlePanic(err);
            }
        }
        if (this._tagType.startsWith("File.Append")) {
            binary = this._tagType.equals("File.Append.Binary");
            this._dataStore.appendToFile(path, this._fileByteBuffer, size, binary, byteStreamHandlerId);
        } else {
            binary = this._tagType.equals("File.Binary");
            this._dataStore.saveFile(path, this._fileByteBuffer, size, binary, byteStreamHandlerId);
        }
    }

    public boolean readInstance(BufferedInputStream reader, int size, String classbyteStreamHandlerId) {
        int read;
        byte[] buffer = new byte[size];
        for (int written = 0; written < size; written += read) {
            try {
                read = reader.read(buffer, written, size - written);
                continue;
            }
            catch (SocketException se) {
                this._dataStore.trace(se);
                this.handlePanic(se);
                return false;
            }
            catch (IOException e) {
                this._dataStore.trace(e);
                this.handlePanic(e);
                return false;
            }
        }
        this._dataStore.saveClassInstance(buffer, size, classbyteStreamHandlerId);
        return true;
    }

    public boolean readClass(BufferedInputStream reader, int size, String className, String classbyteStreamHandlerId) {
        int read;
        byte[] buffer = new byte[size];
        for (int written = 0; written < size; written += read) {
            try {
                read = reader.read(buffer, written, size - written);
                continue;
            }
            catch (SocketException se) {
                this._dataStore.trace(se);
                this.handlePanic(se);
                return false;
            }
            catch (IOException e) {
                this._dataStore.trace(e);
                this.handlePanic(e);
                return false;
            }
        }
        this._dataStore.saveClass(className, buffer, size, classbyteStreamHandlerId);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine(BufferedInputStream reader, Socket socket) {
        boolean done = false;
        int offset = 0;
        try {
            boolean inquotes = false;
            while (!done) {
                int in;
                block29: {
                    if (this._isKeepAliveEnabled) {
                        if (this._firstTime) {
                            this._initialKart = new KeepAliveRequestThread(this.KEEPALIVE_RESPONSE_TIMEOUT, socket);
                            this._firstTime = false;
                            this._initialKart.start();
                            continue;
                        }
                        if (this._initialKart != null) {
                            int currentTimeout;
                            if (this._initialKart.isAlive() && (currentTimeout = socket.getSoTimeout()) != this.IO_SOCKET_READ_TIMEOUT) {
                                socket.setSoTimeout(this.IO_SOCKET_READ_TIMEOUT);
                            }
                            if (!this._initialKart.isAlive()) {
                                if (!this._initialKart.failed()) {
                                    this._isKeepAliveCompatible = true;
                                    this._initialKart = null;
                                } else {
                                    this._isKeepAliveCompatible = false;
                                    this._initialKart = null;
                                }
                            }
                        }
                    }
                    in = -1;
                    if (this._isKeepAliveEnabled && this._isKeepAliveCompatible) {
                        if (this._kart == null || !this._kart.isAlive()) {
                            socket.setSoTimeout(this.IO_SOCKET_READ_TIMEOUT);
                        }
                        try {
                            in = reader.read();
                            break block29;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            if (this._kart != null && this._kart.failed()) {
                                done = true;
                                if (this._dataStore.isVirtual()) {
                                    this.handlePanic(new Exception("KeepAlive request to server wasnt answered in time."));
                                    return null;
                                }
                                this.handlePanic(new Exception("KeepAlive request to client wasnt answered in time."));
                                return null;
                            }
                            if (this._kart == null || !this._kart.isAlive()) {
                                this._kart = new KeepAliveRequestThread(this.KEEPALIVE_RESPONSE_TIMEOUT, socket);
                                this._kart.start();
                                continue;
                            }
                            break block29;
                        }
                    }
                    in = reader.read();
                }
                if (in == -1) {
                    done = true;
                    Exception e = new Exception("The connection to the server has been lost.");
                    this.handlePanic(e);
                    continue;
                }
                if (in <= 0) {
                    done = true;
                } else if (this._kart != null) {
                    this._kart.interrupt();
                }
                byte aByte = (byte)in;
                switch (aByte) {
                    case 34: {
                        inquotes = !inquotes;
                        break;
                    }
                    case 0: 
                    case 10: 
                    case 13: {
                        if (inquotes) break;
                        done = true;
                        break;
                    }
                }
                if (offset >= this._maxBuffer) {
                    int newMaxBuffer = 2 * this._maxBuffer;
                    byte[] newBuffer = new byte[newMaxBuffer];
                    System.arraycopy(this._byteBuffer, 0, newBuffer, 0, this._maxBuffer);
                    this._maxBuffer = newMaxBuffer;
                    this._byteBuffer = newBuffer;
                }
                this._byteBuffer[offset] = aByte;
                ++offset;
            }
        }
        catch (IOException e) {
            this._dataStore.trace(e);
            done = true;
            this.handlePanic(e);
            return null;
        }
        if (offset <= 0) return null;
        String result = null;
        String encoding = "UTF-8";
        String serverEncoding = System.getProperty("DSTORE_SERVER_ENCODING");
        if (serverEncoding != null && serverEncoding.length() > 0) {
            encoding = serverEncoding;
        }
        try {
            return new String(this._byteBuffer, 0, offset, encoding);
        }
        catch (IOException e) {
            this._dataStore.trace(e);
        }
        return result;
    }

    private void handlePanic(Throwable e) {
        this._panic = true;
        this._panicException = e;
    }

    public Throwable getPanicException() {
        return this._panicException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public DataElement parseDocument(BufferedInputStream reader, Socket socket) throws IOException {
        this._tagStack.clear();
        this._objStack.clear();
        this._rootDataElement = null;
        this._isFile = false;
        this._isClass = false;
        this._isRequestClass = false;
        this._isKeepAlive = false;
        this._isKeepAliveConfirm = false;
        this._isSerialized = false;
        this._tagType = STR_DATAELEMENT;
        DataElement parent = null;
        String matchTag = null;
        boolean done = false;
        try {
            while (!done && this._dataStore != null && this._dataStore.isConnected()) {
                String trimmedTag;
                String xmlTag = this.readLine(reader, socket);
                if (xmlTag != null && (trimmedTag = xmlTag.trim()).length() > 0) {
                    if (this._dataStore.getReferenceTag() == null) {
                        if (trimmedTag.indexOf("isRef=") > -1) {
                            this._dataStore.setReferenceTag("isRef");
                        } else if (trimmedTag.indexOf("refType=") > -1) {
                            this._dataStore.setReferenceTag("refType");
                        }
                    }
                    if (!this._tagStack.empty()) {
                        matchTag = (String)this._tagStack.peek();
                    }
                    if (trimmedTag.equals(STR_BUFFER_START)) {
                        this._tagType = STR_BUFFER;
                        this._tagStack.push(STR_BUFFER_END);
                    } else if (trimmedTag.equals(STR_BUFFER_END)) {
                        this._tagType = STR_DATAELEMENT;
                        this._tagStack.pop();
                    } else if (this._tagType.equals(STR_BUFFER)) {
                        String buffer = XMLparser.convertStringFromXML(xmlTag);
                        if (parent != null) {
                            parent.appendToBuffer(buffer);
                        }
                    } else if (matchTag != null && trimmedTag.equals(matchTag)) {
                        if (parent != null && parent.getType().equals(STR_STATUS) && parent.getName().equals(STR_STATUS_ALMOST_DONE)) {
                            parent.setAttribute(2, STR_STATUS_DONE);
                            if (parent.getValue().equals(STR_STATUS_ALMOST_DONE)) {
                                parent.setAttribute(3, STR_STATUS_DONE);
                            }
                            if (this._dataStore.isWaiting(parent)) {
                                this._dataStore.stopWaiting(parent);
                                parent.notifyUpdate();
                            }
                        }
                        if (parent != null && parent.getNestedSize() > 0 && this._dataStore.isVirtual()) {
                            List nested;
                            ArrayList<DataElement> toDelete = new ArrayList<DataElement>();
                            List list = nested = parent.getNestedData();
                            synchronized (list) {
                                int s = 0;
                                while (s < nested.size()) {
                                    DataElement element = (DataElement)nested.get(s);
                                    if (element.isSpirit()) {
                                        boolean addedToDelete = false;
                                        String name = element.getName();
                                        String value = element.getValue();
                                        int n = 0;
                                        while (n < parent.getNestedSize() && !addedToDelete) {
                                            if (n != s) {
                                                DataElement compare = parent.get(n);
                                                String cname = compare.getName();
                                                String cvalue = compare.getValue();
                                                if (!compare.isSpirit() && cname.equals(name) && cvalue.equals(value)) {
                                                    toDelete.add(element);
                                                    addedToDelete = true;
                                                }
                                            }
                                            ++n;
                                        }
                                    }
                                    ++s;
                                }
                                int d = 0;
                                while (d < toDelete.size()) {
                                    DataElement delement = (DataElement)toDelete.get(d);
                                    this._dataStore.deleteObject(parent, delement);
                                    ++d;
                                }
                            }
                        }
                        this._tagStack.pop();
                        if (this._tagStack.empty()) {
                            done = true;
                        } else {
                            parent = this._tagStack.size() == 1 ? this._rootDataElement : (DataElement)this._objStack.pop();
                        }
                    } else if ((xmlTag = xmlTag.trim()).length() > 3) {
                        try {
                            if (parent != null && !this._objStack.contains(parent)) {
                                this._objStack.push(parent);
                            }
                            DataElement result = this.parseTag(xmlTag, parent);
                            if (this._panic) {
                                return null;
                            }
                            if (result != null) {
                                String classbyteStreamHandler;
                                result.setUpdated(true);
                                if (parent == null && this._rootDataElement == null) {
                                    this._rootDataElement = result;
                                    this._rootDataElement.setParent(null);
                                }
                                parent = result;
                                if (this._isFile) {
                                    String byteStreamHandler;
                                    int size = result.depth();
                                    String path = result.getSource();
                                    if (path.equals(byteStreamHandler = result.getName())) {
                                        byteStreamHandler = "default";
                                    }
                                    this.readFile(reader, size, path, byteStreamHandler);
                                    this._isFile = false;
                                } else if (this._isClass) {
                                    int size = result.depth();
                                    classbyteStreamHandler = result.getSource();
                                    if (result.getName() != null) {
                                        this.readClass(reader, size, result.getName(), classbyteStreamHandler);
                                    }
                                    this._isClass = false;
                                } else if (this._isRequestClass) {
                                    result.getDataStore().sendClass(result.getName());
                                    this._isRequestClass = false;
                                } else if (this._isKeepAlive) {
                                    result.getDataStore().sendKeepAliveConfirmation();
                                    this._isKeepAlive = false;
                                } else if (this._isKeepAliveConfirm) {
                                    if (this._initialKart != null) {
                                        this._initialKart.interrupt();
                                    }
                                    this._isKeepAliveConfirm = false;
                                } else if (this._isSerialized) {
                                    int size = result.depth();
                                    classbyteStreamHandler = result.getSource();
                                    if (result.getName() != null) {
                                        this.readInstance(reader, size, classbyteStreamHandler);
                                    }
                                    this._isSerialized = false;
                                }
                                StringBuffer endTag = new StringBuffer("</");
                                endTag.append(this._tagType);
                                endTag.append('>');
                                this._tagStack.push(endTag.toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this._dataStore.trace(e);
                            return this._rootDataElement;
                        }
                    }
                }
                if (!this._panic) continue;
                return null;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.exit(-1);
        }
        DataElement result = this._rootDataElement;
        this._rootDataElement.setParent(null);
        this._rootDataElement = null;
        return result;
    }

    protected synchronized DataElement parseTag(String fullTag, DataElement parent) {
        if (!fullTag.startsWith("<")) {
            return null;
        }
        try {
            fullTag = fullTag.substring(1, fullTag.length() - 1);
        }
        catch (Exception exception) {
            return null;
        }
        int nextSpace = fullTag.indexOf(32);
        if (nextSpace > 0) {
            String[] attributes = new String[8];
            String tagType = fullTag.substring(0, nextSpace);
            if (tagType.startsWith(STR_FILE)) {
                this._isFile = true;
                this._tagType = tagType;
            } else if (tagType.startsWith(STR_CLASS)) {
                this._isClass = true;
                this._tagType = tagType;
            } else if (tagType.startsWith(STR_REQUEST_CLASS)) {
                this._isRequestClass = true;
                this._tagType = tagType;
            } else if (tagType.startsWith(STR_SERIALIZED)) {
                this._isSerialized = true;
                this._tagType = tagType;
            }
            int index = 0;
            int nextQuote = 0;
            int nextnextQuote = nextSpace;
            while (index < 8 && nextQuote >= 0) {
                nextQuote = fullTag.indexOf(34, nextnextQuote + 1);
                nextnextQuote = fullTag.indexOf(34, nextQuote + 1);
                if (nextQuote < 0 || nextnextQuote <= nextQuote || fullTag.length() <= nextnextQuote) continue;
                String attribute = fullTag.substring(nextQuote + 1, nextnextQuote);
                attributes[index] = XMLparser.convertStringFromXML(attribute);
                ++index;
            }
            DataElement result = null;
            if (attributes.length == 8) {
                String type = attributes[0];
                if (type.equals("KEEPALIVE")) {
                    this._isKeepAlive = true;
                    result = this._dataStore.createTransientObject(attributes);
                } else if (type.equals("CONFIRMKEEPALIVE")) {
                    this._isKeepAliveConfirm = true;
                    result = this._dataStore.createTransientObject(attributes);
                } else if (type.equals("DOCUMENT")) {
                    String id = attributes[1];
                    if (this._dataStore.contains(id)) {
                        result = this._dataStore.find(id);
                        result.removeNestedData();
                    } else {
                        result = this._dataStore.createObject(null, attributes);
                    }
                } else if (this._isFile || this._isClass || this._isSerialized || parent == null) {
                    result = this._dataStore.createTransientObject(attributes);
                } else {
                    String refType = attributes[6];
                    boolean isSpirit = false;
                    if (refType != null) {
                        isSpirit = refType.equals("spirit");
                    }
                    if (refType != null && (refType.equals("true") || refType.equals("reference"))) {
                        String origId = attributes[2];
                        if (this._dataStore.contains(origId)) {
                            DataElement to = this._dataStore.find(origId);
                            result = this._dataStore.createReference(parent, to, attributes[0], false);
                        } else {
                            result = this._dataStore.createObject(parent, attributes);
                        }
                    } else {
                        String id = attributes[1];
                        if (id == null) {
                            this.handlePanic(new Exception(fullTag));
                            return null;
                        }
                        if (this._dataStore.contains(id)) {
                            result = this._dataStore.find(id);
                            String name = attributes[2];
                            String value = attributes[3];
                            if (type.equals(STR_STATUS) && name.equals(STR_STATUS_DONE)) {
                                attributes[2] = STR_STATUS_ALMOST_DONE;
                                if (value.equals(STR_STATUS_DONE)) {
                                    attributes[3] = STR_STATUS_ALMOST_DONE;
                                }
                                result.setAttributes(attributes);
                            } else {
                                if (isSpirit) {
                                    if (!this._dataStore.isVirtual()) {
                                        attributes[6] = "value";
                                    }
                                    result.setSpirit(this._dataStore.isVirtual());
                                } else {
                                    result.setSpirit(false);
                                }
                                result.setAttributes(attributes);
                            }
                            if (parent == this._rootDataElement) {
                                DataElement rParent;
                                parent = rParent = result.getParent();
                                this._rootDataElement.addNestedData(result, false);
                            } else if (result.getParent() == null && result != this._dataStore.getRoot()) {
                                result.setParent(parent);
                            }
                            if (parent != null) {
                                parent.addNestedData(result, true);
                            } else if (result != this._dataStore.getRoot()) {
                                this._dataStore.trace("parent of " + result.getName() + " is NULL!");
                            } else {
                                result.setParent(null);
                            }
                            if (result.isDeleted()) {
                                result.delete();
                            }
                        } else if (isSpirit) {
                            if (!this._dataStore.isVirtual()) {
                                attributes[6] = "value";
                            }
                            result = this._dataStore.createObject(parent, attributes);
                            result.setSpirit(this._dataStore.isVirtual());
                        } else {
                            result = this._dataStore.createObject(parent, attributes);
                            result.setSpirit(false);
                        }
                    }
                }
            }
            if (result != null && result.isDeleted()) {
                this._dataStore.deleteObject(parent, result);
            }
            return result;
        }
        return null;
    }

    public static String replaceSpecial(String input) {
        int indexOfAmp = input.indexOf(38);
        int indexOfSemi = input.indexOf(59);
        if (indexOfAmp >= 0 && indexOfSemi > indexOfAmp) {
            String converted = input.replaceAll(STR_AMP, "&").replaceAll(STR_SEMI, ";").replaceAll(STR_QUOTE, "\"").replaceAll(STR_APOS, "'").replaceAll(STR_LT, "<").replaceAll(STR_GT, ">").replaceAll(STR_NL, "\n").replaceAll(STR_CR, "\r").replaceAll(STR_EOL, "\u0000");
            return converted;
        }
        return input;
    }

    public static String convertStringFromXML(String input) {
        if (input.indexOf(38) > -1) {
            return XMLparser.replaceSpecial(input);
        }
        return input;
    }

    public class KeepAliveRequestThread
    extends Thread {
        private long _timeout;
        private boolean _failed;
        private Socket _socket;

        public KeepAliveRequestThread(long timeout, Socket socket) {
            this._timeout = timeout;
            this._failed = false;
            this._socket = socket;
        }

        public void run() {
            XMLparser.this._dataStore.sendKeepAliveRequest();
            try {
                this._socket.setSoTimeout((int)this._timeout);
                KeepAliveRequestThread.sleep(this._timeout);
            }
            catch (SocketException socketException) {
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this._failed = true;
        }

        public boolean failed() {
            return this._failed;
        }
    }
}

