/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;

public class RemoteFileUtility {
    public static String getSourceEncoding(IFile file) {
        String srcEncoding = null;
        try {
            srcEncoding = file.getCharset(true);
            if (srcEncoding == null || srcEncoding.length() == 0) {
                srcEncoding = file.getWorkspace().getRoot().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            srcEncoding = SystemEncodingUtil.ENCODING_UTF_8;
        }
        return srcEncoding;
    }

    public static IRemoteFileSubSystem getFileSubSystem(IHost connection) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                IRemoteFileSubSystem subSystem = (IRemoteFileSubSystem)sses[i];
                return subSystem;
            }
            ++i;
        }
        return null;
    }

    public static IRemoteFileSubSystem[] getFileSubSystems(IHost connection) {
        ArrayList<IRemoteFileSubSystem> results = new ArrayList<IRemoteFileSubSystem>();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] sses = sr.getSubSystems(connection);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                IRemoteFileSubSystem subSystem = (IRemoteFileSubSystem)sses[i];
                results.add(subSystem);
            }
            ++i;
        }
        return results.toArray(new IRemoteFileSubSystem[results.size()]);
    }

    public static IRemoteFileSubSystemConfiguration getFileSubSystemConfiguration(IRSESystemType systemType) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] sses = sr.getSubSystemConfigurationsBySystemType(systemType, false);
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystemConfiguration) {
                return (IRemoteFileSubSystemConfiguration)sses[i];
            }
            ++i;
        }
        return null;
    }

    public static ISystemFileTransferModeRegistry getSystemFileTransferModeRegistry() {
        return SystemFileTransferModeRegistry.getInstance();
    }
}

