/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.CoverageNodeImpl;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.FileSingleReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportFormatter;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiFormatter;
import org.jacoco.report.ZipMultiReportOutput;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTask
extends Task {
    private final Union executiondataElement = new Union();
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;
    private final GroupElement structure = new GroupElement();
    private final List<IFormatterElement> formatters = new ArrayList<IFormatterElement>();

    public Union createExecutiondata() {
        return this.executiondataElement;
    }

    public GroupElement createStructure() {
        return this.structure;
    }

    public HTMLFormatterElement createHtml() {
        HTMLFormatterElement element = new HTMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public CSVFormatterElement createCsv() {
        CSVFormatterElement element = new CSVFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public XMLFormatterElement createXml() {
        XMLFormatterElement element = new XMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public void execute() throws BuildException {
        this.loadExecutionData();
        try {
            IReportFormatter formatter = this.createFormatter();
            this.createReport(formatter);
            this.finishFormatters();
        }
        catch (IOException e) {
            throw new BuildException("Error while creating report.", (Throwable)e);
        }
    }

    private void loadExecutionData() {
        this.sessionInfoStore = new SessionInfoStore();
        this.executionDataStore = new ExecutionDataStore();
        for (Resource resource : this.executiondataElement) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(resource.getInputStream());
                ExecutionDataReader reader = new ExecutionDataReader(in);
                reader.setSessionInfoVisitor(this.sessionInfoStore);
                reader.setExecutionDataVisitor(this.executionDataStore);
                reader.read();
            }
            catch (IOException e) {
                try {
                    throw new BuildException("Unable to read execution data file " + resource.getName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close((InputStream)in);
        }
    }

    private IReportFormatter createFormatter() throws IOException {
        MultiFormatter multi = new MultiFormatter();
        for (IFormatterElement f : this.formatters) {
            multi.add(f.createFormatter());
        }
        return multi;
    }

    private void finishFormatters() throws IOException {
        for (IFormatterElement f : this.formatters) {
            f.finish();
        }
    }

    private void createReport(IReportFormatter formatter) throws IOException {
        CoverageNodeImpl node = this.createNode(this.structure);
        IReportVisitor visitor = formatter.createReportVisitor(node, this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
        SourceFileCollection sourceFileLocator = new SourceFileCollection(this.structure.sourcefiles);
        if (node.getElementType() == ICoverageNode.ElementType.BUNDLE) {
            this.visitBundle(visitor, (IBundleCoverage)((Object)node), sourceFileLocator);
        } else {
            for (GroupElement g : this.structure.children) {
                this.createReport(g, visitor, node);
            }
        }
        visitor.visitEnd(sourceFileLocator);
    }

    private void createReport(GroupElement group, IReportVisitor parentVisitor, CoverageNodeImpl parentNode) throws IOException {
        CoverageNodeImpl node = this.createNode(group);
        IReportVisitor visitor = parentVisitor.visitChild(node);
        SourceFileCollection sourceFileLocator = new SourceFileCollection(group.sourcefiles);
        if (node.getElementType() == ICoverageNode.ElementType.BUNDLE) {
            this.visitBundle(visitor, (IBundleCoverage)((Object)node), sourceFileLocator);
        } else {
            for (GroupElement g : group.children) {
                this.createReport(g, visitor, node);
            }
        }
        parentNode.increment(node);
        visitor.visitEnd(sourceFileLocator);
    }

    private CoverageNodeImpl createNode(GroupElement group) throws IOException {
        if (group.name == null) {
            throw new BuildException("Group name must be supplied");
        }
        if (group.children.size() > 0) {
            return new CoverageNodeImpl(ICoverageNode.ElementType.GROUP, group.name);
        }
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, builder);
        for (Resource resource : group.classfiles) {
            if (resource.isDirectory() && resource instanceof FileResource) {
                analyzer.analyzeAll(((FileResource)resource).getFile());
                continue;
            }
            InputStream in = resource.getInputStream();
            analyzer.analyzeAll(in);
            in.close();
        }
        return builder.getBundle(group.name);
    }

    private void visitBundle(IReportVisitor visitor, IBundleCoverage bundledata, SourceFileCollection sourceFileLocator) throws IOException {
        if (!sourceFileLocator.isEmpty()) {
            this.checkForMissingDebugInformation(bundledata);
        }
        for (IPackageCoverage p : bundledata.getPackages()) {
            ReportTask.visitPackage(visitor.visitChild(p), p, sourceFileLocator);
        }
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            this.log(String.format("To enable source code annotation class files for bundle '%s' have to be compiled with debug information.", node.getName()), 1);
        }
    }

    private static void visitPackage(IReportVisitor visitor, IPackageCoverage packagedata, ISourceFileLocator sourceFileLocator) throws IOException {
        ReportTask.visitLeafs(visitor, packagedata.getSourceFiles(), sourceFileLocator);
        for (IClassCoverage c : packagedata.getClasses()) {
            ReportTask.visitClass(visitor.visitChild(c), c, sourceFileLocator);
        }
        visitor.visitEnd(sourceFileLocator);
    }

    private static void visitClass(IReportVisitor visitor, IClassCoverage classdata, ISourceFileLocator sourceFileLocator) throws IOException {
        ReportTask.visitLeafs(visitor, classdata.getMethods(), sourceFileLocator);
        visitor.visitEnd(sourceFileLocator);
    }

    private static void visitLeafs(IReportVisitor visitor, Collection<? extends ICoverageNode> leafs, ISourceFileLocator sourceFileLocator) throws IOException {
        for (ICoverageNode iCoverageNode : leafs) {
            IReportVisitor child = visitor.visitChild(iCoverageNode);
            child.visitEnd(sourceFileLocator);
        }
    }

    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final String encoding;
        private final Map<String, Resource> resources = new HashMap<String, Resource>();

        SourceFileCollection(SourceFilesElement sourceFiles) {
            this.encoding = sourceFiles.encoding;
            Iterator i = sourceFiles.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                this.resources.put(r.getName().replace(File.separatorChar, '/'), r);
            }
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            Resource r = this.resources.get(packageName + '/' + fileName);
            if (r == null) {
                return null;
            }
            if (this.encoding == null) {
                return new InputStreamReader(r.getInputStream());
            }
            return new InputStreamReader(r.getInputStream(), this.encoding);
        }

        public boolean isEmpty() {
            return this.resources.isEmpty();
        }
    }

    public static class XMLFormatterElement
    implements IFormatterElement {
        private File destfile;
        private String encoding = "UTF-8";

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public IReportFormatter createFormatter() {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for xml report");
            }
            XMLFormatter formatter = new XMLFormatter();
            formatter.setReportOutput(new FileSingleReportOutput(this.destfile));
            formatter.setOutputEncoding(this.encoding);
            return formatter;
        }

        public void finish() {
        }
    }

    public static class CSVFormatterElement
    implements IFormatterElement {
        private File destfile;
        private String encoding = "UTF-8";

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public IReportFormatter createFormatter() {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for csv report");
            }
            CSVFormatter formatter = new CSVFormatter();
            formatter.setReportOutput(new FileSingleReportOutput(this.destfile));
            formatter.setOutputEncoding(this.encoding);
            return formatter;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void finish() {
        }
    }

    public static class HTMLFormatterElement
    implements IFormatterElement {
        private File destdir;
        private File destfile;
        private String footer = "";
        private String encoding = "UTF-8";
        private Locale locale = Locale.getDefault();
        private ZipOutputStream zipOutput;

        public void setDestdir(File destdir) {
            this.destdir = destdir;
        }

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setFooter(String text) {
            this.footer = text;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public IReportFormatter createFormatter() throws IOException {
            IMultiReportOutput output;
            if (this.destfile != null) {
                if (this.destdir != null) {
                    throw new BuildException("Either destination directory or file must be supplied, not both");
                }
                this.zipOutput = new ZipOutputStream(new FileOutputStream(this.destfile));
                output = new ZipMultiReportOutput(this.zipOutput);
            } else {
                if (this.destdir == null) {
                    throw new BuildException("Destination directory or file must be supplied for html report");
                }
                output = new FileMultiReportOutput(this.destdir);
            }
            HTMLFormatter formatter = new HTMLFormatter();
            formatter.setReportOutput(output);
            formatter.setFooterText(this.footer);
            formatter.setOutputEncoding(this.encoding);
            formatter.setLocale(this.locale);
            return formatter;
        }

        public void finish() throws IOException {
            if (this.zipOutput != null) {
                this.zipOutput.close();
            }
        }
    }

    private static interface IFormatterElement {
        public IReportFormatter createFormatter() throws IOException;

        public void finish() throws IOException;
    }

    public static class GroupElement {
        private final List<GroupElement> children = new ArrayList<GroupElement>();
        private final Union classfiles = new Union();
        private final SourceFilesElement sourcefiles = new SourceFilesElement();
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public GroupElement createGroup() {
            GroupElement group = new GroupElement();
            this.children.add(group);
            return group;
        }

        public Union createClassfiles() {
            return this.classfiles;
        }

        public SourceFilesElement createSourcefiles() {
            return this.sourcefiles;
        }
    }

    public static class SourceFilesElement
    extends Union {
        String encoding;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }
}

