/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.csv;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.report.ILanguageNames;
import org.jacoco.report.IReportFormatter;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISingleReportOutput;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.JavaNames;
import org.jacoco.report.csv.CSVGroupHandler;
import org.jacoco.report.csv.ClassRowWriter;
import org.jacoco.report.csv.DelimitedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFormatter
implements IReportFormatter {
    private ISingleReportOutput output;
    private ILanguageNames languageNames = new JavaNames();
    private String outputEncoding = "UTF-8";

    @Override
    public IReportVisitor createReportVisitor(ICoverageNode root, List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("No report output set.");
        }
        final DelimitedWriter writer = new DelimitedWriter(new OutputStreamWriter(this.output.createFile(), this.outputEncoding));
        ClassRowWriter rowWriter = new ClassRowWriter(writer, this.languageNames);
        return new CSVGroupHandler(rowWriter, root.getName()){

            public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
                writer.close();
                super.visitEnd(sourceFileLocator);
            }
        };
    }

    public void setReportOutput(ISingleReportOutput output) {
        this.output = output;
    }

    public void setLanguageNames(ILanguageNames languageNames) {
        this.languageNames = languageNames;
    }

    public ILanguageNames getLanguageNames() {
        return this.languageNames;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

