/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.resources.ISystemTextEditor;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.actions.SystemDownloadConflictAction;
import org.eclipse.rse.internal.files.ui.resources.SystemFileNameHelper;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeMapping;
import org.eclipse.rse.internal.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileTransferModeMapping;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SystemEditableRemoteFile
implements ISystemEditableRemoteObject,
IPartListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private IRemoteFile remoteFile;
    private String remotePath;
    private IRemoteFileSubSystem subsystem;
    private String root;
    private String localPath;
    private IEditorPart editor;
    private IFile localFile;
    private IWorkbenchPage page;
    private boolean _usingDefaultDescriptor = false;
    private IEditorDescriptor _editorDescriptor = null;
    private boolean _isRemoteFileMounted = false;
    private String _actualRemoteHost = null;
    private String _actualRemotePath = null;

    public SystemEditableRemoteFile(IWorkbenchPage page, IRemoteFile remoteFile, IEditorDescriptor editorDescriptor) {
        this.page = page;
        this.remoteFile = remoteFile;
        this.remotePath = remoteFile.getAbsolutePath();
        this.subsystem = remoteFile.getParentRemoteFileSubSystem();
        SystemRemoteEditManager mgr = SystemRemoteEditManager.getInstance();
        if (!mgr.doesRemoteEditProjectExist()) {
            mgr.getRemoteEditProject();
        }
        this.root = mgr.getRemoteEditProjectLocation().makeAbsolute().toOSString();
        this.localPath = this.getDownloadPath();
        this._editorDescriptor = editorDescriptor;
    }

    public SystemEditableRemoteFile(IRemoteFile remoteFile, IEditorDescriptor editorDescriptor) {
        this(null, remoteFile, editorDescriptor);
    }

    public SystemEditableRemoteFile(IRemoteFile remoteFile) {
        this.remoteFile = remoteFile;
        this.remotePath = remoteFile.getAbsolutePath();
        this.subsystem = remoteFile.getParentRemoteFileSubSystem();
        this.root = SystemRemoteEditManager.getInstance().getRemoteEditProjectLocation().makeAbsolute().toOSString();
        this.localPath = this.getDownloadPath();
        IFile localResource = this.getLocalResource();
        IEditorDescriptor descriptor = null;
        try {
            descriptor = IDE.getEditorDescriptor((IFile)localResource);
            if (!localResource.exists()) {
                this._usingDefaultDescriptor = true;
            }
        }
        catch (PartInitException partInitException) {}
        if (descriptor == null) {
            descriptor = this.getDefaultTextEditor();
        }
        this._editorDescriptor = descriptor;
    }

    protected IEditorRegistry getEditorRegistry() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getEditorRegistry();
        }
        return null;
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    public static SystemEditableRemoteFile getInstance(IFile file) {
        IPath path = file.getFullPath();
        int numSegments = path.segmentCount();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        ISubSystem fs = null;
        String subsystemId = properties.getRemoteFileSubSystem();
        if (subsystemId != null) {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            fs = registry.getSubSystem(subsystemId);
        }
        if (fs != null) {
            String remotePath = properties.getRemoteFilePath();
            if (remotePath == null) {
                IRSESystemType systemType = fs.getHost().getSystemType();
                boolean isWindows = systemType.isWindows();
                char fileSeparator = isWindows ? (char)'\\' : '/';
                StringBuffer tempRemotePath = new StringBuffer("");
                int i = 3;
                while (i < numSegments) {
                    if (i == 3 && !isWindows) {
                        tempRemotePath.append(fileSeparator);
                    }
                    if (i > 3) {
                        if (i == 4 && isWindows) {
                            tempRemotePath.append(":");
                        }
                        tempRemotePath.append(fileSeparator);
                    }
                    String seg = path.segment(i);
                    tempRemotePath.append(seg);
                    ++i;
                }
                remotePath = tempRemotePath.toString();
            }
            try {
                if (remotePath != null && fs instanceof IRemoteFileSubSystem) {
                    IRemoteFile remoteFile = ((IRemoteFileSubSystem)fs).getRemoteFileObject(remotePath, (IProgressMonitor)new NullProgressMonitor());
                    if (remoteFile != null) {
                        return new SystemEditableRemoteFile(remoteFile);
                    }
                    return null;
                }
                return null;
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)("Error getting remote file object " + remotePath), (Throwable)e);
            }
        }
        return null;
    }

    public void setRemoteFile(IRemoteFile remoteFile) {
        this.remoteFile = remoteFile;
        this.remotePath = remoteFile.getAbsolutePath();
        this.subsystem = remoteFile.getParentRemoteFileSubSystem();
        this.localPath = this.getDownloadPath();
        this.localFile = null;
    }

    public IRemoteFile getRemoteFile() {
        return this.remoteFile;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public boolean isReadOnly() {
        if (!this.subsystem.isConnected()) {
            try {
                if (Display.getCurrent() == null) {
                    this.subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                } else {
                    this.subsystem.connect(false, null);
                }
            }
            catch (Exception exception) {}
        }
        return !this.remoteFile.canWrite();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setEditorAsReadOnly();
            this.setFileAsReadOnly();
        } else {
            if (this.editor instanceof ISystemTextEditor) {
                ((ISystemTextEditor)this.editor).setReadOnly(false);
            }
            IFile file = this.getLocalResource();
            this.setReadOnly(file, false);
            SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
            properties.setReadOnly(false);
        }
    }

    public boolean download(Shell shell) throws Exception {
        if (shell != null) {
            InternalDownloadFileRunnable downloadFileRunnable = new InternalDownloadFileRunnable();
            IFile localFile = this.getLocalResource();
            SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
            listener.addIgnoreFile(localFile);
            downloadFileRunnable.setRule((ISchedulingRule)this.getRemoteFile());
            downloadFileRunnable.schedule();
            Display display = Display.getDefault();
            try {
                while (!downloadFileRunnable.didComplete()) {
                    while (display != null && display.readAndDispatch()) {
                    }
                    if (downloadFileRunnable.didComplete()) continue;
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {}
            listener.removeIgnoreFile(localFile);
            downloadFileRunnable.throwException();
            return !downloadFileRunnable.didFail();
        }
        return this.download((IProgressMonitor)new NullProgressMonitor());
    }

    protected void setReadOnly(IFile file, boolean flag) {
        ResourceAttributes attrs = file.getResourceAttributes();
        attrs.setReadOnly(flag);
        try {
            file.setResourceAttributes(attrs);
        }
        catch (CoreException coreException) {}
    }

    public boolean download(IProgressMonitor monitor) throws Exception {
        boolean newFile;
        IFile file = this.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (file.isReadOnly()) {
            this.setReadOnly(file, false);
        }
        properties.setReadOnly(false);
        if (!newFile && file.exists()) {
            boolean remoteNewer;
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            this.remoteFile = this.subsystem.getRemoteFileObject(this.remoteFile.getAbsolutePath(), monitor);
            long remoteModifiedStamp = this.remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean bl2 = remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            if (dirty) {
                SystemDownloadConflictAction conflictAction = new SystemDownloadConflictAction(file, remoteNewer);
                Display.getDefault().syncExec((Runnable)conflictAction);
                switch (conflictAction.getState()) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return this.doDownload(properties, monitor);
            }
            if (remoteNewer) {
                return this.doDownload(properties, monitor);
            }
            String encoding = properties.getEncoding();
            if (properties.getUsedBinaryTransfer() != this.remoteFile.isBinary() || encoding == null || !encoding.equals(this.remoteFile.getEncoding())) {
                return this.doDownload(properties, monitor);
            }
        } else {
            return this.doDownload(properties, monitor);
        }
        this.refresh();
        return true;
    }

    private boolean doDownload(SystemIFileProperties properties, IProgressMonitor monitor) throws Exception {
        if (!this.subsystem.isConnected()) {
            return false;
        }
        try {
            this.subsystem.download(this.remoteFile, this.localPath, this.remoteFile.getEncoding(), monitor);
        }
        catch (SystemMessageException e) {
            if (this.remoteFile.isText() && this.specializeFile(true)) {
                try {
                    this.subsystem.download(this.remoteFile, this.localPath, this.remoteFile.getEncoding(), monitor);
                }
                catch (SystemMessageException systemMessageException) {
                    this.specializeFile(false);
                    SystemMessageDialog.displayMessage((SystemMessageException)e);
                    return false;
                }
            }
            SystemMessageDialog.displayMessage((SystemMessageException)e);
            return false;
        }
        if (monitor.isCanceled()) {
            return false;
        }
        this.remoteFile = this.subsystem.getRemoteFileObject(this.remoteFile.getAbsolutePath(), monitor);
        this.refresh();
        IFile file = this.getLocalResource();
        properties.setRemoteFileTimeStamp(this.remoteFile.getLastModified());
        properties.setDownloadFileTimeStamp(file.getLocalTimeStamp());
        properties.setDirty(false);
        properties.setUsedBinaryTransfer(this.remoteFile.isBinary());
        boolean readOnly = !this.remoteFile.canWrite();
        properties.setReadOnly(readOnly);
        properties.setDownloadFileTimeStamp(file.getLocation().toFile().lastModified());
        return true;
    }

    private boolean specializeFile(boolean binary) {
        int i;
        String fname = this.remoteFile.getName();
        int dotIndex = fname.lastIndexOf(46);
        String name = null;
        String extension = null;
        if (dotIndex > 0) {
            name = fname.substring(0, dotIndex);
            extension = fname.substring(dotIndex + 1);
        } else {
            name = fname;
        }
        if (name == null) {
            return false;
        }
        SystemFileTransferModeRegistry reg = (SystemFileTransferModeRegistry)RemoteFileUtility.getSystemFileTransferModeRegistry();
        SystemFileTransferModeMapping[] newMappings = null;
        ISystemFileTransferModeMapping[] mappings = reg.getModeMappings();
        SystemFileTransferModeMapping mapping = null;
        int m = 0;
        while (m < mappings.length && mapping == null) {
            ISystemFileTransferModeMapping map = mappings[m];
            if (name.equals(map.getName())) {
                String ext = map.getExtension();
                if (extension != null && extension.equals(ext)) {
                    mapping = (SystemFileTransferModeMapping)map;
                } else if (extension == ext) {
                    mapping = (SystemFileTransferModeMapping)map;
                }
            }
            ++m;
        }
        if (mapping != null) {
            newMappings = new SystemFileTransferModeMapping[mappings.length];
            i = 0;
            while (i < mappings.length) {
                newMappings[i] = (SystemFileTransferModeMapping)mappings[i];
                ++i;
            }
        } else {
            newMappings = new SystemFileTransferModeMapping[mappings.length + 1];
            i = 0;
            while (i < mappings.length) {
                newMappings[i] = (SystemFileTransferModeMapping)mappings[i];
                ++i;
            }
            newMappings[i] = mapping = new SystemFileTransferModeMapping(name, extension);
        }
        if (binary) {
            mapping.setAsBinary();
        } else {
            mapping.setAsText();
        }
        reg.setModeMappings(newMappings);
        reg.saveAssociations();
        return true;
    }

    public boolean doImmediateSaveAndUpload() {
        if (this.editor != null) {
            this.editor.doSave(null);
        }
        SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
        listener.setEnabled(false);
        IRemoteFile remoteFile = this.getRemoteFile();
        IFile tempFile = this.getLocalResource();
        IRemoteFileSubSystem fs = remoteFile.getParentRemoteFileSubSystem();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)tempFile);
        try {
            remoteFile.markStale(true);
            remoteFile = fs.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            return false;
        }
        listener.upload(fs, remoteFile, tempFile, properties, properties.getRemoteFileTimeStamp(), this, null);
        listener.setEnabled(true);
        return !properties.getDirty();
    }

    private void upload(IProgressMonitor monitor) throws Exception {
        if (!this.subsystem.isConnected()) {
            if (Display.getCurrent() == null) {
                this.subsystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
            } else {
                this.subsystem.connect(false, null);
            }
        }
        IFile file = this.getLocalResource();
        String srcEncoding = RemoteFileUtility.getSourceEncoding((IFile)file);
        this.subsystem.upload(this.localPath, this.remoteFile, srcEncoding, monitor);
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        this.remoteFile = this.subsystem.getRemoteFileObject(this.remoteFile.getAbsolutePath(), monitor);
        properties.setRemoteFileTimeStamp(this.remoteFile.getLastModified());
    }

    public IFile getLocalResource() {
        if (this.localFile == null || !this.localFile.exists()) {
            IPath path = this.getLocalPathObject();
            this.localFile = SystemBasePlugin.getWorkspaceRoot().getFileForLocation(path);
        }
        return this.localFile;
    }

    private IPath getLocalPathObject() {
        IPath actualPath = null;
        Path expectedPath = new Path(this.localPath);
        Path rootPath = new Path(this.root);
        IContainer container = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)rootPath);
        if (container != null && container.exists()) {
            IResource lastMatch = null;
            int i = rootPath.segmentCount();
            while (i < expectedPath.segmentCount()) {
                String expectedFolderOrFile = expectedPath.segment(i).toLowerCase();
                IResource match = null;
                try {
                    IResource[] resources = container.members();
                    int r = 0;
                    while (r < resources.length && match == null) {
                        String resName;
                        IResource resource = resources[r];
                        if (resource instanceof IContainer) {
                            resName = resource.getName().toLowerCase();
                            if (expectedFolderOrFile.equals(resName)) {
                                lastMatch = match = resource;
                            }
                        } else if (i == expectedPath.segmentCount() - 1 && expectedFolderOrFile.equals(resName = resource.getName().toLowerCase())) {
                            return resource.getLocation();
                        }
                        ++r;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (match == null) {
                    if (lastMatch != null) {
                        IPath newPath = lastMatch.getLocation();
                        while (i < expectedPath.segmentCount()) {
                            newPath = newPath.append(expectedPath.segment(i));
                            ++i;
                        }
                        return newPath;
                    }
                    return expectedPath;
                }
                container = (IContainer)match;
                ++i;
            }
            String fileName = expectedPath.segment(expectedPath.segmentCount() - 1);
            actualPath = container.getLocation().append(fileName);
            return actualPath;
        }
        return expectedPath;
    }

    /*
     * Unable to fully structure code
     */
    public void delete() {
        rootPath = new Path(this.root).removeTrailingSeparator();
        rootLocation = rootPath.makeAbsolute().toOSString();
        resourceLocation = this.getLocalResource().getLocation().makeAbsolute().toOSString();
        tempFile = new File(resourceLocation);
        deleteResult = tempFile.delete();
        if (deleteResult) ** GOTO lbl-1000
        return;
        while (!(resourceLocation = (tempFile = tempFile.getParentFile()).getAbsolutePath()).equals(rootLocation) && (deleteResult = tempFile.delete())) lbl-1000:
        // 2 sources

        {
            if (resourceLocation.startsWith(rootLocation)) continue;
        }
        this.refresh();
    }

    private String getDownloadPath() {
        String os;
        Path path = new Path(this.root);
        this._actualRemoteHost = this.getActualHostFor(this.remotePath);
        path = path.append("/" + this._actualRemoteHost + "/");
        String absolutePath = this.getWorkspaceRemotePath(this.remotePath);
        int colonIndex = absolutePath.indexOf(58);
        if (colonIndex != -1) {
            absolutePath = colonIndex == 0 ? absolutePath.substring(1) : (colonIndex == absolutePath.length() - 1 ? absolutePath.substring(0, colonIndex) : String.valueOf(absolutePath.substring(0, colonIndex).toLowerCase()) + absolutePath.substring(colonIndex + 1));
        }
        if (!(os = System.getProperty("os.name").toLowerCase()).startsWith("win")) {
            absolutePath = absolutePath.replace('\\', '/');
        }
        Path remote = new Path(absolutePath);
        this._actualRemotePath = absolutePath = SystemFileNameHelper.getEscapedPath(remote.toOSString());
        return String.valueOf(path.makeAbsolute().toOSString()) + absolutePath;
    }

    public String getWorkspaceRemotePath(String remotePath) {
        if (this.subsystem != null) {
            return SystemRemoteEditManager.getInstance().getWorkspacePathFor(this.subsystem.getHost().getHostName(), remotePath, this.subsystem);
        }
        return remotePath;
    }

    public String getActualHostFor(String remotePath) {
        String hostname = this.subsystem.getHost().getHostName();
        if (this.subsystem != null) {
            String result = SystemRemoteEditManager.getInstance().getActualHostFor(hostname, remotePath, this.subsystem);
            if (!result.equals(hostname)) {
                this._isRemoteFileMounted = true;
            }
            return result;
        }
        return hostname;
    }

    public IEditorPart getEditorPart() {
        return this.editor;
    }

    public IAdaptable getRemoteObject() {
        return (IAdaptable)this.remoteFile;
    }

    public int checkOpenInEditor() {
        IWorkbenchPage activePage = this.page;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (activePage == null) {
            IWorkbenchWindow activeWindow = wb.getActiveWorkbenchWindow();
            if (activeWindow != null) {
                activePage = activeWindow.getActivePage();
            } else {
                IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
                if (windows != null && windows.length > 0) {
                    activePage = windows[0].getActivePage();
                }
            }
        }
        if (activePage == null) {
            return -1;
        }
        IEditorReference[] activeReferences = activePage.getEditorReferences();
        File lFile = new File(this.localPath);
        int k = 0;
        while (k < activeReferences.length) {
            IFile file;
            IPath path;
            IEditorInput editorInput;
            IEditorPart part = activeReferences[k].getEditor(false);
            if (part != null && (editorInput = part.getEditorInput()) instanceof IFileEditorInput && (path = (file = ((IFileEditorInput)editorInput).getFile()).getLocation()) != null && lFile.compareTo(new File(path.toOSString())) == 0 && !file.isLinked()) {
                return 0;
            }
            ++k;
        }
        IWorkbenchWindow[] windows = wb.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] references = pages[j].getEditorReferences();
                if (pages[j] != activePage) {
                    int k2 = 0;
                    while (k2 < references.length) {
                        IPath path;
                        IEditorPart temp = references[k2].getEditor(false);
                        IEditorInput editorInput = temp.getEditorInput();
                        if (editorInput instanceof IFileEditorInput && (path = ((IFileEditorInput)editorInput).getFile().getLocation()) != null && path.makeAbsolute().toOSString().equalsIgnoreCase(this.localPath)) {
                            return 1;
                        }
                        ++k2;
                    }
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void open(Shell shell) {
        this.open(shell, false);
    }

    public void open(Shell shell, boolean readOnly) {
        block17: {
            try {
                String msgDetails;
                String msgTxt;
                SimpleSystemMessage message;
                SystemMessageDialog dialog;
                boolean answer;
                int result = this.checkOpenInEditor();
                this.remoteFile.markStale(true, false);
                this.remoteFile = this.remoteFile.getParentRemoteFileSubSystem().getRemoteFileObject(this.remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                if (!this.remoteFile.exists()) {
                    String msgTxt2 = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName());
                    SimpleSystemMessage message2 = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt2);
                    SystemMessageDialog dialog2 = new SystemMessageDialog(shell, (SystemMessage)message2);
                    dialog2.open();
                    return;
                }
                if (result == -1) {
                    if (readOnly) {
                        if (this.download(shell)) {
                            this.setLocalResourceProperties();
                            this.setFileAsReadOnly();
                            this.openEditor(this.remoteFile, readOnly);
                            this.setEditorAsReadOnly();
                        }
                    } else if (!this.isReadOnly()) {
                        if (this.download(shell)) {
                            this.addAsListener();
                            this.setLocalResourceProperties();
                            this.openEditor(this.remoteFile, readOnly);
                        }
                    } else {
                        String msgDetails2;
                        String msgTxt3;
                        SimpleSystemMessage message3;
                        SystemMessageDialog dialog3;
                        boolean answer2;
                        IRemoteFile fakeRemoteFile = this.subsystem.getRemoteFileObject(this.remotePath, (IProgressMonitor)new NullProgressMonitor());
                        if (!fakeRemoteFile.exists()) {
                            this.download(shell);
                        }
                        if ((answer2 = (dialog3 = new SystemMessageDialog(shell, (SystemMessage)(message3 = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF5002", 2, msgTxt3 = NLS.bind((String)FileResources.MSG_DOWNLOAD_NO_WRITE, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName()), msgDetails2 = NLS.bind((String)FileResources.MSG_DOWNLOAD_NO_WRITE_DETAILS, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName()))))).openQuestion()) && this.download(shell)) {
                            this.setLocalResourceProperties();
                            this.setFileAsReadOnly();
                            this.openEditor(this.remoteFile, readOnly);
                            this.setEditorAsReadOnly();
                        }
                    }
                } else if (result == 0) {
                    this.openEditor(this.remoteFile, readOnly);
                } else if (result == 1 && (answer = (dialog = new SystemMessageDialog(shell, (SystemMessage)(message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF5009", 2, msgTxt = NLS.bind((String)FileResources.MSG_DOWNLOAD_ALREADY_OPEN_IN_EDITOR, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName()), msgDetails = NLS.bind((String)FileResources.MSG_DOWNLOAD_ALREADY_OPEN_IN_EDITOR_DETAILS, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName()))))).openQuestion())) {
                    this.setFileAsReadOnly();
                    this.openEditor(this.remoteFile, readOnly);
                    this.setEditorAsReadOnly();
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block17;
                if (e instanceof SystemMessageException) {
                    SystemMessageDialog dialog = new SystemMessageDialog(shell, ((SystemMessageException)((Object)e)).getSystemMessage());
                    dialog.open();
                }
                RemoteFileIOException exc = new RemoteFileIOException(e);
                SystemMessageDialog dialog = new SystemMessageDialog(shell, exc.getSystemMessage());
                dialog.open();
            }
        }
    }

    public void open(IProgressMonitor monitor) {
        this.open(false, monitor);
    }

    public void open(boolean readOnly, IProgressMonitor monitor) {
        block12: {
            try {
                this.remoteFile.markStale(true, false);
                this.remoteFile = this.remoteFile.getParentRemoteFileSubSystem().getRemoteFileObject(this.remoteFile.getAbsolutePath(), monitor);
                if (!this.remoteFile.exists()) {
                    String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName());
                    SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
                    DisplayMessageDialog dd = new DisplayMessageDialog((SystemMessage)message);
                    Display.getDefault().syncExec((Runnable)dd);
                    return;
                }
                if (readOnly) {
                    if (this.download(monitor)) {
                        this.setLocalResourceProperties();
                        this.setFileAsReadOnly();
                        this.openEditor(this.remoteFile, readOnly);
                        this.setEditorAsReadOnly();
                    }
                } else if (!this.isReadOnly()) {
                    if (this.download(monitor)) {
                        this.addAsListener();
                        this.setLocalResourceProperties();
                        this.openEditor(this.remoteFile, readOnly);
                    }
                } else {
                    IRemoteFile fakeRemoteFile = this.subsystem.getRemoteFileObject(this.remotePath, monitor);
                    if (!fakeRemoteFile.exists()) {
                        this.download(monitor);
                    }
                    String msgTxt = NLS.bind((String)FileResources.MSG_DOWNLOAD_NO_WRITE, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName());
                    String msgDetails = NLS.bind((String)FileResources.MSG_DOWNLOAD_NO_WRITE_DETAILS, (Object)this.remotePath, (Object)this.subsystem.getHost().getHostName());
                    SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF5002", 2, msgTxt, msgDetails);
                    DisplayQuestionDialog dd = new DisplayQuestionDialog((SystemMessage)message);
                    Display.getDefault().syncExec((Runnable)dd);
                    boolean answer = dd.getResponse();
                    if (answer && this.download(monitor)) {
                        this.setLocalResourceProperties();
                        this.setFileAsReadOnly();
                        this.openEditor(this.remoteFile, readOnly);
                        this.setEditorAsReadOnly();
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block12;
                if (e instanceof SystemMessageException) {
                    DisplayMessageDialog dd = new DisplayMessageDialog(((SystemMessageException)((Object)e)).getSystemMessage());
                    Display.getDefault().syncExec((Runnable)dd);
                }
                RemoteFileIOException exc = new RemoteFileIOException(e);
                DisplayMessageDialog dd = new DisplayMessageDialog(exc.getSystemMessage());
                Display.getDefault().syncExec((Runnable)dd);
            }
        }
    }

    public void openInSystemEditor(Shell shell) {
        try {
            if (this.remoteFile.getHost().getSystemType().isLocal()) {
                if (this.remoteFile instanceof IVirtualRemoteFile) {
                    Program.launch((String)this.remoteFile.getAbsolutePath());
                } else {
                    Program.launch((String)this.remotePath);
                }
            } else {
                this.download(shell);
                IFile file = this.getLocalResource();
                this.setReadOnly(file, true);
                this.openSystemEditor();
            }
        }
        catch (Exception e) {
            if (e instanceof SystemMessageException) {
                SystemMessageDialog dialog = new SystemMessageDialog(shell, ((SystemMessageException)((Object)e)).getSystemMessage());
                dialog.open();
            }
            RemoteFileIOException exc = new RemoteFileIOException(e);
            SystemMessageDialog dialog = new SystemMessageDialog(shell, exc.getSystemMessage());
            dialog.open();
        }
    }

    public void openInInPlaceEditor(Shell shell) {
        try {
            this.download(shell);
            IFile file = this.getLocalResource();
            this.setReadOnly(file, true);
            this.openInPlaceEditor();
        }
        catch (Exception e) {
            if (e instanceof SystemMessageException) {
                SystemMessageDialog dialog = new SystemMessageDialog(shell, ((SystemMessageException)((Object)e)).getSystemMessage());
                dialog.open();
            }
            RemoteFileIOException exc = new RemoteFileIOException(e);
            SystemMessageDialog dialog = new SystemMessageDialog(shell, exc.getSystemMessage());
            dialog.open();
        }
    }

    public void setLocalResourceProperties() throws CoreException {
        IFile file = this.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        String profileID = this.subsystem.getParentRemoteFileSubSystemConfiguration().getEditorProfileID();
        properties.setEditorProfileType(profileID);
        properties.setRemoteFileObject((Object)this);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        String subSystemId = registry.getAbsoluteNameForSubSystem((ISubSystem)this.subsystem);
        properties.setRemoteFileSubSystem(subSystemId);
        properties.setRemoteFilePath(this.remoteFile.getAbsolutePath());
        properties.setRemoteFileMounted(this._isRemoteFileMounted);
        if (this._isRemoteFileMounted) {
            properties.setResolvedMountedRemoteFileHost(this._actualRemoteHost);
            properties.setResolvedMountedRemoteFilePath(this._actualRemotePath);
        }
        SystemEncodingUtil util = SystemEncodingUtil.getInstance();
        String encoding = this.remoteFile.getEncoding();
        properties.setEncoding(encoding);
        String tempPath = file.getLocation().toOSString();
        if (util.isXML(tempPath)) {
            try {
                encoding = util.getXMLFileEncoding(tempPath);
            }
            catch (IOException e) {
                Status s = new Status(4, "org.eclipse.rse.ui", 4, e.getLocalizedMessage(), (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        }
        try {
            if (encoding != null) {
                if (this.remoteFile.isBinary()) {
                    if (!file.isSynchronized(0)) {
                        file.refreshLocal(0, null);
                    }
                    if (!file.getCharset().equals(encoding)) {
                        file.setCharset(encoding, null);
                    }
                } else if (properties.getLocalEncoding() != null) {
                    String localEncoding = properties.getLocalEncoding();
                    file.setCharset(localEncoding, null);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void addAsListener() {
        try {
            if (!this.isReadOnly()) {
                if (SystemBasePlugin.getActiveWorkbenchWindow() != null && SystemBasePlugin.getActiveWorkbenchWindow().getActivePage() != null) {
                    SystemBasePlugin.getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
                }
                SystemUniversalTempFileListener.getListener().registerEditedFile(this);
            }
        }
        catch (Exception exception) {}
    }

    public void openEditor() throws PartInitException {
        this.remoteFile.markStale(true);
        if (!this.remoteFile.getParentRemoteFileSubSystem().isOffline()) {
            try {
                this.remoteFile = this.subsystem.getRemoteFileObject(this.remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                SystemMessageDialog.displayExceptionMessage((Shell)SystemMessageDialog.getDefaultShell(), (Throwable)e);
                return;
            }
        }
        boolean readOnly = !this.remoteFile.canWrite();
        this.openEditor(this.remoteFile, readOnly);
    }

    private void openEditor(IRemoteFile remoteFile, boolean readOnly) throws PartInitException {
        IFile file;
        ResourceAttributes attr;
        IWorkbenchPage activePage = this.page;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (activePage == null) {
            activePage = wb.getActiveWorkbenchWindow().getActivePage();
        }
        if ((attr = (file = this.getLocalResource()).getResourceAttributes()) != null) {
            attr.setReadOnly(readOnly);
            try {
                file.setResourceAttributes(attr);
            }
            catch (Exception exception) {}
        }
        String editorId = null;
        if (this._editorDescriptor != null) {
            if (this._usingDefaultDescriptor) {
                this._editorDescriptor = IDE.getEditorDescriptor((IFile)file);
                editorId = this._editorDescriptor.getId();
                this._usingDefaultDescriptor = false;
            } else {
                editorId = this._editorDescriptor.getId();
            }
        }
        IDE.setDefaultEditor((IFile)file, editorId);
        if (this._editorDescriptor.isOpenExternal()) {
            this.openSystemEditor();
        } else {
            FileEditorInput finput = new FileEditorInput(file);
            this.editor = this._editorDescriptor != null && this._editorDescriptor.isOpenExternal() ? ((WorkbenchPage)activePage).openEditorFromDescriptor((IEditorInput)new FileEditorInput(file), this._editorDescriptor, true, null) : activePage.openEditor((IEditorInput)finput, this._editorDescriptor.getId());
            SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
            properties.setRemoteFileObject((Object)this);
            if (properties.getDirty()) {
                this.updateDirtyIndicator();
            }
        }
    }

    public void openSystemEditor() throws PartInitException {
        IWorkbenchPage activePage = this.page;
        if (activePage == null) {
            activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        }
        IFile file = this.getLocalResource();
        String editorId = null;
        if (this._editorDescriptor != null) {
            editorId = this._editorDescriptor.getId();
        }
        IDE.setDefaultEditor((IFile)file, editorId);
        FileEditorInput fileInput = new FileEditorInput(file);
        activePage.openEditor((IEditorInput)fileInput, "org.eclipse.ui.systemExternalEditor");
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        properties.setRemoteFileObject((Object)this);
    }

    private void openInPlaceEditor() throws PartInitException {
        IWorkbenchPage activePage = this.page;
        if (activePage == null) {
            activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        }
        IFile file = this.getLocalResource();
        FileEditorInput fileInput = new FileEditorInput(file);
        activePage.openEditor((IEditorInput)fileInput, "org.eclipse.ui.systemInPlaceEditor");
    }

    private void setEditorAsReadOnly() {
        if (this.editor instanceof ISystemTextEditor) {
            ((ISystemTextEditor)this.editor).setReadOnly(true);
        }
    }

    private void setFileAsReadOnly() {
        IFile file = this.getLocalResource();
        this.setReadOnly(file, true);
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        properties.setReadOnly(true);
    }

    private void refresh() {
        SystemRemoteEditManager.getInstance().refreshRemoteEditContainer(this.localFile.getParent());
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.editor == part) {
            IWorkbenchPage page;
            SystemUniversalTempFileListener.getListener().unregisterEditedFile(this);
            IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
            if (win != null && (page = win.getActivePage()) != null) {
                page.removePartListener((IPartListener)this);
                this.editor = null;
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getKind() == 4) {
            this.process(delta);
        }
        return true;
    }

    private void process(IResourceDelta delta) {
        IResource resource = delta.getResource();
        try {
            if (resource.getLocation().equals((Object)this.getLocalResource().getLocation())) {
                this.upload((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)"Error uploading file", (Throwable)e);
            if (e instanceof SystemMessageException) {
                SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), ((SystemMessageException)((Object)e)).getSystemMessage());
                dialog.open();
            }
            RemoteFileIOException exc = new RemoteFileIOException(e);
            SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), exc.getSystemMessage());
            dialog.open();
        }
    }

    public boolean saveAs(IRemoteFile newRemoteFile, IProgressMonitor progressMonitor) {
        boolean success;
        block28: {
            if (this.editor == null) {
                try {
                    this.openEditor();
                }
                catch (Exception exception) {}
            }
            final IDocumentProvider documentProvider = ((ITextEditor)this.editor).getDocumentProvider();
            SystemEditableRemoteFile tempFile = new SystemEditableRemoteFile(newRemoteFile);
            IFile newFile = tempFile.getLocalResource();
            if (newFile.getLocation().equals((Object)this.getLocalResource().getLocation())) {
                if (this.editor != null) {
                    this.editor.doSave(progressMonitor);
                    return true;
                }
                return true;
            }
            FileEditorInput newInput = new FileEditorInput(newFile);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((IFileEditorInput)newInput){
                private final /* synthetic */ IFileEditorInput val$newInput;
                {
                    this.val$newInput = iFileEditorInput;
                }

                public void execute(IProgressMonitor monitor) throws CoreException {
                    documentProvider.saveDocument(monitor, (Object)this.val$newInput, documentProvider.getDocument((Object)SystemEditableRemoteFile.this.editor.getEditorInput()), true);
                }
            };
            success = false;
            if (this.editor instanceof ISystemTextEditor) {
                documentProvider.aboutToChange((Object)newInput);
                ISystemTextEditor systemEditor = (ISystemTextEditor)this.editor;
                systemEditor.refresh();
                try {
                    new ProgressMonitorDialog(SystemBasePlugin.getActiveWorkbenchShell()).run(false, true, (IRunnableWithProgress)op);
                    success = true;
                }
                catch (InterruptedException interruptedException) {
                    documentProvider.changed((Object)newInput);
                    if (!success) break block28;
                    systemEditor.setInput((IEditorInput)newInput);
                    this.delete();
                    this.setRemoteFile(newRemoteFile);
                    try {
                        this.setLocalResourceProperties();
                        this.upload(progressMonitor);
                        systemEditor.setInput((IEditorInput)newInput);
                        break block28;
                    }
                    catch (SystemMessageException e) {
                        SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), e.getSystemMessage());
                        dialog.open();
                        return true;
                    }
                    catch (Exception e) {
                        SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e);
                        String msgTxt = CommonMessages.MSG_ERROR_UNEXPECTED;
                        SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG8002", 4, msgTxt);
                        SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)message);
                        dialog.open();
                        return true;
                    }
                }
                catch (InvocationTargetException e) {
                    try {
                        SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e);
                        String msgTxt = CommonMessages.MSG_ERROR_UNEXPECTED;
                        SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG8002", 4, msgTxt);
                        SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)message);
                        dialog.open();
                        return true;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        documentProvider.changed((Object)newInput);
                        if (success) {
                            systemEditor.setInput((IEditorInput)newInput);
                            this.delete();
                            this.setRemoteFile(newRemoteFile);
                            try {
                                this.setLocalResourceProperties();
                                this.upload(progressMonitor);
                                systemEditor.setInput((IEditorInput)newInput);
                            }
                            catch (SystemMessageException e2) {
                                SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), e2.getSystemMessage());
                                dialog.open();
                                return true;
                            }
                            catch (Exception e3) {
                                SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e3);
                                String msgTxt = CommonMessages.MSG_ERROR_UNEXPECTED;
                                SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG8002", 4, msgTxt);
                                SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)message);
                                dialog.open();
                                return true;
                            }
                        }
                    }
                }
                documentProvider.changed((Object)newInput);
                if (success) {
                    systemEditor.setInput((IEditorInput)newInput);
                    this.delete();
                    this.setRemoteFile(newRemoteFile);
                    try {
                        this.setLocalResourceProperties();
                        this.upload(progressMonitor);
                        systemEditor.setInput((IEditorInput)newInput);
                    }
                    catch (SystemMessageException e) {
                        SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), e.getSystemMessage());
                        dialog.open();
                        return true;
                    }
                    catch (Exception e) {
                        SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e);
                        String msgTxt = CommonMessages.MSG_ERROR_UNEXPECTED;
                        SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG8002", 4, msgTxt);
                        SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)message);
                        dialog.open();
                        return true;
                    }
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
        return true;
    }

    private void markEditorDirty() {
        ITextEditor textEditor = (ITextEditor)this.editor;
        IDocumentProvider provider = textEditor.getDocumentProvider();
        if (provider != null) {
            IDocument doc = provider.getDocument((Object)textEditor.getEditorInput());
            String content = doc.get();
            try {
                doc.replace(0, content.length(), content);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void updateDirtyIndicator() {
        if (this.editor != null) {
            SystemIFileProperties properties;
            if (this.editor instanceof ISystemTextEditor) {
                ((ISystemTextEditor)this.editor).updateDirtyIndicator();
            } else if (this.editor instanceof ITextEditor && (properties = new SystemIFileProperties((IResource)this.localFile)).getDirty()) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            SystemEditableRemoteFile.this.markEditorDirty();
                        }
                    });
                } else {
                    this.markEditorDirty();
                }
            }
        }
    }

    public boolean isDirty() {
        if (this.editor != null) {
            return this.editor.isDirty();
        }
        return false;
    }

    public String getAbsolutePath() {
        return this.remotePath;
    }

    public ISubSystem getSubSystem() {
        return this.subsystem;
    }

    public boolean exists() {
        return this.remoteFile.exists();
    }

    public boolean isStale() {
        return this.remoteFile.isStale();
    }

    public IEditorDescriptor getEditorDescriptor() {
        return this._editorDescriptor;
    }

    public void setEditorDescriptor(IEditorDescriptor descriptor) {
        this._editorDescriptor = descriptor;
    }

    public class DisplayMessageDialog
    implements Runnable {
        protected SystemMessage _msg;

        public DisplayMessageDialog(SystemMessage msg) {
            this._msg = msg;
        }

        public void run() {
            SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._msg);
            dialog.open();
        }
    }

    public class DisplayQuestionDialog
    implements Runnable {
        protected SystemMessage _msg;
        public boolean _responce = false;

        public DisplayQuestionDialog(SystemMessage msg) {
            this._msg = msg;
        }

        public boolean getResponse() {
            return this._responce;
        }

        public void run() {
            SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._msg);
            try {
                this._responce = dialog.openQuestion();
            }
            catch (Exception exception) {}
        }
    }

    private class InternalDownloadFileRunnable
    extends Job {
        private Exception e;
        private boolean completed = false;
        private boolean failed = false;

        private InternalDownloadFileRunnable() {
            super("Download");
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                this.failed = !SystemEditableRemoteFile.this.download(monitor);
                this.completed = true;
                monitor.done();
            }
            catch (CoreException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
                throw e;
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)"File can not be downloaded", (Throwable)e);
                this.e = e;
            }
        }

        public boolean didComplete() {
            return this.completed;
        }

        public boolean didFail() {
            return this.failed;
        }

        private void throwException() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                this.execute(monitor);
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

