/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.server.SystemServiceManager;
import org.eclipse.rse.internal.dstore.universal.miners.command.CommandMinerThread;
import org.eclipse.rse.internal.dstore.universal.miners.command.QueryPathThread;
import org.eclipse.rse.internal.dstore.universal.miners.command.patterns.Patterns;

public class CommandMiner
extends Miner {
    private HashMap _threads = new HashMap();
    private Patterns _patterns;
    private CommandMinerDescriptors _descriptors;

    private Patterns getPatterns() {
        if (this._patterns == null) {
            this._patterns = new Patterns(this._dataStore);
        }
        return this._patterns;
    }

    protected ArrayList getDependencies() {
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("org.eclipse.rse.dstore.universal.miners.EnvironmentMiner");
        return dependencies;
    }

    public void extendSchema(DataElement schemaRoot) {
        DataElement fsD = this._dataStore.findObjectDescriptor("directory");
        DataElement cancellable = this._dataStore.findObjectDescriptor("Cancellable");
        DataElement cmdD = this.createCommandDescriptor(fsD, "Command", "C_COMMAND", false);
        this._dataStore.createReference(cancellable, cmdD, "abstracts", "abstracted by");
        DataElement shellD = this.createCommandDescriptor(fsD, "Shell", "C_SHELL", false);
        this._dataStore.createReference(cancellable, shellD, "abstracts", "abstracted by");
        this.createCommandDescriptor(fsD, "CharConversion", "C_CHAR_CONVERSION", false);
        this._dataStore.createObject(cmdD, "input", "Enter command");
        this._dataStore.createObject(cmdD, "output", "Command Output");
        this._descriptors = new CommandMinerDescriptors();
        this._descriptors._stdout = this._dataStore.createObjectDescriptor(schemaRoot, "stdout");
        this._descriptors._stderr = this._dataStore.createObjectDescriptor(schemaRoot, "stderr");
        this._descriptors._prompt = this._dataStore.createObjectDescriptor(schemaRoot, "prompt");
        this._descriptors._grep = this._dataStore.createObjectDescriptor(schemaRoot, "grep");
        this._descriptors._pathenvvar = this._dataStore.createObjectDescriptor(schemaRoot, "pathenvvar");
        this._descriptors._envvar = this._dataStore.createObjectDescriptor(schemaRoot, "envvar");
        this._descriptors._libenvvar = this._dataStore.createObjectDescriptor(schemaRoot, "libenvvar");
        this._descriptors._error = this._dataStore.createObjectDescriptor(schemaRoot, "error");
        this._descriptors._warning = this._dataStore.createObjectDescriptor(schemaRoot, "warning");
        this._descriptors._informational = this._dataStore.createObjectDescriptor(schemaRoot, "informational");
        this._descriptors._process = this._dataStore.createObjectDescriptor(schemaRoot, "process");
        this.createCommandDescriptor(fsD, "Get Commands", "C_GET_POSSIBLE_COMMANDS", false);
        this._dataStore.refresh(schemaRoot);
    }

    public DataElement handleCommand(DataElement theElement) {
        String name = this.getCommandName(theElement);
        DataElement status = this.getCommandStatus(theElement);
        DataElement subject = this.getCommandArgument(theElement, 0);
        if (name.equals("C_COMMAND")) {
            DataElement invArg = this.getCommandArgument(theElement, 1);
            if (invArg != null) {
                String invocation = invArg.getName();
                if (invocation.trim().length() > 0) {
                    if (invocation.equals("?") || invocation.equals("help")) {
                        invocation = "cat " + theElement.getDataStore().getAttribute(0) + "/org.eclipse.rse.services.dstore/patterns.dat";
                    }
                    this.launchCommand(subject, invocation, status);
                }
                return status;
            }
            status.setAttribute(2, "done");
        } else if (name.equals("C_SHELL")) {
            String invocation = ">";
            DataElement encodingArg = this.getCommandArgument(theElement, 1);
            if (encodingArg.getType().equals("shell.encoding") && SystemServiceManager.getInstance().getSystemService() == null) {
                System.setProperty("dstore.stdin.encoding", encodingArg.getValue());
            }
            this.launchCommand(subject, invocation, status);
        } else if (name.equals("C_SEND_INPUT")) {
            DataElement input = this.getCommandArgument(theElement, 1);
            subject.dereference().get(1);
            this.sendInputToCommand(input.getName(), this.getCommandStatus(subject));
            status.setAttribute(2, "done");
        } else {
            DataElement cmdStatus;
            CommandMinerThread theThread;
            if (name.equals("C_CANCEL")) {
                DataElement de = subject.dereference().get(1);
                DataElement cancelStatus = this.getCommandStatus(subject);
                this.cancelCommand(de.getName().trim(), cancelStatus);
                return status;
            }
            if (name.equals("C_GET_POSSIBLE_COMMANDS")) {
                this.getPossibleCommands(status);
                return status;
            }
            if (name.equals("C_CHAR_CONVERSION") && (theThread = (CommandMinerThread)((Object)this._threads.get((cmdStatus = this.getCommandArgument(theElement, 0)).getAttribute(1)))) != null) {
                theThread._supportsCharConversion = true;
            }
        }
        return status;
    }

    public void getPossibleCommands(DataElement status) {
        QueryPathThread qpt = new QueryPathThread(status);
        qpt.start();
    }

    public void launchCommand(DataElement subject, String invocation, DataElement status) {
        Iterator iter = this._threads.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String threadName = (String)iter.next();
                CommandMinerThread theThread = (CommandMinerThread)((Object)this._threads.get(threadName));
                if (theThread != null && theThread.isAlive()) continue;
                this._threads.remove(threadName);
            }
        }
        catch (Exception e) {
            this._dataStore.trace((Throwable)e);
        }
        CommandMinerThread newCommand = new CommandMinerThread(subject, invocation, status, this.getPatterns(), this._descriptors);
        this._threads.put(status.getAttribute(1), newCommand);
        newCommand.start();
    }

    private void sendInputToCommand(String input, DataElement status) {
        CommandMinerThread theThread = (CommandMinerThread)((Object)this._threads.get(status.getAttribute(1)));
        if (theThread != null) {
            theThread.sendInput(input);
        }
    }

    private void cancelCommand(String theCommand, DataElement status) {
        CommandMinerThread theThread = (CommandMinerThread)((Object)this._threads.get(status.getAttribute(1)));
        if (theThread != null) {
            this._dataStore.createObject(status, "stdout", "Command Cancelled by User Request");
            theThread.stopThread();
            theThread.sendExit();
            boolean done = false;
            long stopIn = System.currentTimeMillis() + 3000L;
            while (!done) {
                if (theThread.isAlive() && stopIn >= System.currentTimeMillis()) continue;
                done = true;
            }
        }
    }

    public void finish() {
        Iterator pools = this._threads.entrySet().iterator();
        while (pools.hasNext()) {
            Map.Entry entry = pools.next();
            CommandMinerThread process = (CommandMinerThread)((Object)entry.getValue());
            process.sendExit();
        }
        this._threads.clear();
        super.finish();
    }

    public String getVersion() {
        return "8.0.0";
    }

    public class CommandMinerDescriptors {
        public DataElement _stdout;
        public DataElement _stderr;
        public DataElement _prompt;
        public DataElement _grep;
        public DataElement _pathenvvar;
        public DataElement _envvar;
        public DataElement _libenvvar;
        public DataElement _error;
        public DataElement _warning;
        public DataElement _informational;
        public DataElement _process;

        public DataElement getDescriptorFor(String type) {
            DataElement descriptor = null;
            if (type.equals("stdout")) {
                descriptor = this._stdout;
            } else if (type.equals("pathenvvar")) {
                descriptor = this._pathenvvar;
            } else if (type.equals("envvar")) {
                descriptor = this._envvar;
            } else if (type.equals("libenvvar")) {
                descriptor = this._libenvvar;
            } else if (type.equals("error")) {
                descriptor = this._error;
            } else if (type.equals("warning")) {
                descriptor = this._warning;
            } else if (type.equals("informational")) {
                descriptor = this._informational;
            } else if (type.equals("process")) {
                descriptor = this._process;
            } else if (type.equals("grep")) {
                descriptor = this._grep;
            } else if (type.equals("stderr")) {
                descriptor = this._stderr;
            }
            return descriptor;
        }
    }
}

