/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.util.tar;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.rse.services.clientserver.util.tar.ITarConstants;
import org.eclipse.rse.services.clientserver.util.tar.TarEntry;

public class TarOutputStream
extends OutputStream
implements ITarConstants {
    private OutputStream out;
    private boolean isClosed;
    private boolean entryOpen;
    private long dataCount;

    public TarOutputStream(OutputStream out) {
        this.out = out;
        this.isClosed = false;
        this.entryOpen = false;
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            byte[] dummy = new byte[512];
            this.out.write(dummy);
            this.out.close();
            this.isClosed = true;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
    }

    public void write(int b) throws IOException {
        this.ensureOpen();
        this.out.write(b);
        ++this.dataCount;
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        if (this.entryOpen) {
            this.closeEntry();
        }
        entry.writeFields(this.out);
        int diff = 12;
        if (diff != 0) {
            byte[] dummy = new byte[diff];
            this.out.write(dummy);
        }
        this.dataCount = 0L;
        this.entryOpen = true;
    }

    public void closeEntry() throws IOException {
        int temp = (int)(this.dataCount % 512L);
        if (temp != 0) {
            int diff = 512 - temp;
            byte[] dummy = new byte[diff];
            this.out.write(dummy);
        }
        this.entryOpen = false;
    }
}

