/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.CombineForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddToArchiveForm
extends CombineForm {
    protected Button savePathInfoCheckBox;
    protected Combo relativeToCombo;
    protected String[] _relativePathList = null;
    protected String relativePath = "";
    protected boolean saveFullPathInfo = false;

    public AddToArchiveForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        super(msgLine, caller, fileMode);
    }

    public AddToArchiveForm(ISystemMessageLine msgLine, Object caller, boolean fileMode, boolean prePopSelection) {
        super(msgLine, caller, fileMode, prePopSelection);
    }

    public AddToArchiveForm(ISystemMessageLine msgLine, Object caller, boolean fileMode, boolean prePopSelection, String[] relativePaths) {
        super(msgLine, caller, fileMode, prePopSelection);
        this._relativePathList = relativePaths;
        this.enableRelativePathFeature(relativePaths != null);
    }

    public void setRelativePathList(String[] relativePathList) {
        if (relativePathList != null) {
            this._relativePathList = relativePathList;
            if (this.relativeToCombo != null) {
                this.relativeToCombo.setItems(relativePathList);
            }
            this.enableRelativePathFeature(true);
        } else {
            this.enableRelativePathFeature(false);
        }
    }

    protected void enableRelativePathFeature(boolean enable) {
        if (this.relativeToCombo != null) {
            this.relativeToCombo.setEnabled(enable);
        }
        if (this.savePathInfoCheckBox != null) {
            this.savePathInfoCheckBox.setEnabled(enable);
        }
    }

    public Control createContents(Shell shell, Composite parent) {
        Control control = super.createContents(shell, parent);
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        this.savePathInfoCheckBox = SystemWidgetHelpers.createCheckBox((Composite)composite, null, (String)FileResources.RESID_ADDTOARCHIVE_SAVEPATH_LABEL, (String)FileResources.RESID_ADDTOARCHIVE_SAVEPATH_TOOLTIP);
        this.relativeToCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)composite, null, (String)FileResources.RESID_ADDTOARCHIVE_RELATIVETO_LABEL, (String)FileResources.RESID_ADDTOARCHIVE_RELATIVETO_LABEL);
        this.enableRelativePathFeature(this._relativePathList != null);
        if (this._relativePathList != null) {
            this.relativeToCombo.setItems(this._relativePathList);
            this.relativeToCombo.setEnabled(false);
        }
        this.savePathInfoCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AddToArchiveForm.this.setPageComplete();
                AddToArchiveForm.this.relativeToCombo.setEnabled(AddToArchiveForm.this.savePathInfoCheckBox.getSelection());
                if (!AddToArchiveForm.this.savePathInfoCheckBox.getSelection()) {
                    AddToArchiveForm.this.relativePath = "";
                }
                AddToArchiveForm.this.setSaveFullPathInfo();
            }

            public void widgetSelected(SelectionEvent e) {
                AddToArchiveForm.this.setPageComplete();
                AddToArchiveForm.this.relativeToCombo.setEnabled(AddToArchiveForm.this.savePathInfoCheckBox.getSelection());
                if (!AddToArchiveForm.this.savePathInfoCheckBox.getSelection()) {
                    AddToArchiveForm.this.relativePath = "";
                }
                AddToArchiveForm.this.setSaveFullPathInfo();
            }
        });
        this.relativeToCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddToArchiveForm.this.relativePath = AddToArchiveForm.this.relativeToCombo.getText();
                AddToArchiveForm.this.setPageComplete();
            }
        });
        return control;
    }

    public boolean isPageComplete() {
        boolean relPathComplete;
        boolean pathInfoChecked = this.savePathInfoCheckBox != null && this.savePathInfoCheckBox.getSelection();
        boolean relPathSelectionMade = this.relativePath != null && !this.relativePath.equals("");
        boolean bl = relPathComplete = this.savePathInfoCheckBox == null || !this.savePathInfoCheckBox.getEnabled();
        if (!relPathComplete) {
            relPathComplete = pathInfoChecked ? relPathSelectionMade : true;
        }
        return super.isPageComplete() && relPathComplete;
    }

    protected void setSaveFullPathInfo() {
        this.saveFullPathInfo = this.savePathInfoCheckBox != null && this.savePathInfoCheckBox.getEnabled() && this.savePathInfoCheckBox.getSelection();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean getSaveFullPathInfo() {
        return this.saveFullPathInfo;
    }
}

