/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPopupMenuActionContributor;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.ui.IWorkbenchPart;

public class SystemPopupMenuActionContributorManager {
    private static final String T_OBJECT_CONTRIBUTION = "objectContribution";
    private static final String POPUP_MENU_EXTENSION_POINT_ID = "org.eclipse.rse.ui.popupMenus";
    private static SystemPopupMenuActionContributorManager singleton;
    private Vector contributors = new Vector();

    public static SystemPopupMenuActionContributorManager getManager() {
        if (singleton == null) {
            singleton = new SystemPopupMenuActionContributorManager();
        }
        return singleton;
    }

    public SystemPopupMenuActionContributorManager() {
        this.loadContributors();
    }

    private void loadContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] popupMenus = registry.getConfigurationElementsFor(POPUP_MENU_EXTENSION_POINT_ID);
        int i = 0;
        while (i < popupMenus.length) {
            IConfigurationElement popupMenu = popupMenus[i];
            if (popupMenu.getName().equals(T_OBJECT_CONTRIBUTION)) {
                SystemPopupMenuActionContributor contributor = new SystemPopupMenuActionContributor(popupMenu);
                this.contributors.add(contributor);
            } else {
                IConfigurationElement[] popupMenuChildren = popupMenu.getChildren();
                int j = 0;
                while (j < popupMenuChildren.length) {
                    IConfigurationElement popupMenuChild = popupMenuChildren[j];
                    if (popupMenuChild.getName().equals(T_OBJECT_CONTRIBUTION)) {
                        SystemPopupMenuActionContributor contributor = new SystemPopupMenuActionContributor(popupMenuChild);
                        this.contributors.add(contributor);
                    } else {
                        SystemBasePlugin.logWarning("Invalid Tag found: " + popupMenuChild.getName());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean contributeObjectActions(IWorkbenchPart part, SystemMenuManager popupMenu, ISelectionProvider selectionProvider, List actionIdOverrides) {
        boolean contributed;
        SystemPopupMenuActionContributor contributor;
        ISelection selection = selectionProvider.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] selections = structuredSelection.toArray();
        Vector<SystemPopupMenuActionContributor> matchingContributors = new Vector<SystemPopupMenuActionContributor>(10);
        Iterator z = this.contributors.iterator();
        while (z.hasNext()) {
            boolean matches = true;
            contributor = (SystemPopupMenuActionContributor)((Object)z.next());
            int i = 0;
            while (i < selections.length && matches) {
                Object object = selections[i];
                if (!contributor.isApplicableTo(object)) {
                    matches = false;
                }
                ++i;
            }
            if (!matches) continue;
            matchingContributors.add(contributor);
        }
        int actualContributions = 0;
        Iterator z2 = matchingContributors.iterator();
        while (z2.hasNext()) {
            contributor = (SystemPopupMenuActionContributor)((Object)z2.next());
            contributed = contributor.contributeObjectMenus(popupMenu, selectionProvider);
            if (!contributed) continue;
            ++actualContributions;
        }
        z2 = matchingContributors.iterator();
        while (z2.hasNext()) {
            contributor = (SystemPopupMenuActionContributor)((Object)z2.next());
            contributed = contributor.contributeObjectActions(part, popupMenu, selectionProvider, actionIdOverrides);
            if (!contributed) continue;
            ++actualContributions;
        }
        return actualContributions > 0;
    }
}

