/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SystemFilterPropertyPage
extends SystemBasePropertyPage {
    protected Label labelType;
    protected Label labelName;
    protected Label labelFilterPool;
    protected Label labelStringCount;
    protected Label labelIsConnectionPrivate;
    protected Label labelProfile;
    protected String errorMessage;
    protected boolean initDone = false;

    public SystemFilterPropertyPage() {
        RSEUIPlugin.getDefault();
    }

    protected Control createContentArea(Composite parent) {
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, 2);
        this.labelType = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_PROPERTIES_TYPE_LABEL, SystemResources.RESID_PP_PROPERTIES_TYPE_TOOLTIP);
        this.labelType.setText(SystemResources.RESID_PP_FILTER_TYPE_VALUE);
        this.labelName = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_FILTER_NAME_LABEL, SystemResources.RESID_PP_FILTER_NAME_TOOLTIP);
        this.labelStringCount = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_FILTER_STRINGCOUNT_LABEL, SystemResources.RESID_PP_FILTER_STRINGCOUNT_TOOLTIP);
        this.labelIsConnectionPrivate = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_FILTER_ISCONNECTIONPRIVATE_LABEL, SystemResources.RESID_PP_FILTER_ISCONNECTIONPRIVATE_TOOLTIP);
        this.labelFilterPool = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_FILTER_FILTERPOOL_LABEL, SystemResources.RESID_PP_FILTER_FILTERPOOL_TOOLTIP);
        this.labelProfile = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_FILTER_PROFILE_LABEL, SystemResources.RESID_PP_FILTER_PROFILE_TOOLTIP);
        if (!this.initDone) {
            this.doInitializeFields();
        }
        return composite_prompts;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    protected ISystemFilter getFilter() {
        IAdaptable element = this.getElement();
        if (element instanceof ISystemFilter) {
            return (ISystemFilter)element;
        }
        return ((ISystemFilterReference)element).getReferencedFilter();
    }

    protected void doInitializeFields() {
        this.initDone = true;
        ISystemFilter filter = this.getFilter();
        boolean isTransient = filter.isTransient();
        this.labelName.setText(filter.getName());
        if (filter.isPromptable()) {
            this.labelType.setText(SystemResources.RESID_PP_FILTER_TYPE_PROMPTABLE_VALUE);
        }
        if (!isTransient) {
            ISystemFilterPool pool = filter.getParentFilterPool();
            this.labelFilterPool.setText(pool.getName());
            ISubSystemConfiguration ssFactory = (ISubSystemConfiguration)pool.getProvider();
            String profileName = ssFactory.getSystemProfile(pool).getName();
            this.labelProfile.setText(profileName);
            this.labelStringCount.setText(Integer.toString(filter.getFilterStringCount()));
            if (pool.getOwningParentName() == null) {
                this.labelIsConnectionPrivate.setText(SystemResources.TERM_NO);
            } else {
                this.labelIsConnectionPrivate.setText(SystemResources.TERM_YES);
            }
        }
    }
}

