/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SystemViewMenuListener
implements IMenuListener,
MenuListener,
ArmListener {
    protected boolean menuListenerAdded = false;
    protected boolean menuMnemonicsAdded = false;
    protected boolean doOnce = false;
    protected boolean armListeners = false;
    protected Mnemonics m = new Mnemonics();
    protected ISystemMessageLine msgLine;

    public SystemViewMenuListener() {
    }

    public SystemViewMenuListener(boolean doOnce) {
        this.doOnce = doOnce;
    }

    public void setShowToolTipText(boolean set, ISystemMessageLine msgLine) {
        this.armListeners = set;
        this.msgLine = msgLine;
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            m.addMenuListener((MenuListener)this);
        }
    }

    public void menuHidden(MenuEvent event) {
    }

    public void menuShown(MenuEvent event) {
        if (!this.menuMnemonicsAdded || !this.doOnce) {
            this.m.clear();
            if (!this.armListeners) {
                this.m.setMnemonics((Menu)event.getSource());
            } else {
                this.m.setMnemonicsAndArmListener((Menu)event.getSource(), this);
            }
            this.menuMnemonicsAdded = true;
            if (this.doOnce) {
                ((Menu)event.getSource()).removeMenuListener((MenuListener)this);
            }
        }
    }

    public void widgetArmed(ArmEvent event) {
        MenuItem mi;
        Object data;
        if (this.msgLine == null) {
            return;
        }
        this.msgLine.clearMessage();
        Widget w = event.widget;
        if (w instanceof MenuItem && (data = (mi = (MenuItem)w).getData()) != null) {
            String tip = null;
            if (data instanceof ActionContributionItem) {
                tip = ((ActionContributionItem)data).getAction().getToolTipText();
            } else if (data instanceof SystemSubMenuManager) {
                tip = ((SystemSubMenuManager)((Object)data)).getToolTipText();
            }
            if (tip != null) {
                this.msgLine.setMessage(tip);
            }
        }
    }
}

