/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.IServiceSubSystem;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.widgets.services.ConnectorServiceElement;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.RootServiceElement;
import org.eclipse.rse.ui.widgets.services.ServerLauncherPropertiesServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServicesForm;
import org.eclipse.rse.ui.wizards.AbstractSystemNewConnectionWizardPage;
import org.eclipse.rse.ui.wizards.ISubSystemPropertiesWizardPage;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SubSystemServiceWizardPage
extends AbstractSystemNewConnectionWizardPage
implements ISubSystemPropertiesWizardPage {
    private ServicesForm _form;
    private IServiceSubSystemConfiguration _selectedFactory;
    private ServiceElement _root;
    private ServiceElement[] _serviceElements;

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory, String pageName, String pageTitle, String pageDescription) {
        super(wizard, parentFactory, pageName, pageTitle, pageDescription);
    }

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory, String pageDescription) {
        super(wizard, parentFactory, pageDescription);
    }

    public SubSystemServiceWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory) {
        super(wizard, parentFactory);
    }

    public Control createContents(Composite parent) {
        this._form = new ServicesForm(this.getMessageLine());
        Control control = this._form.createContents(parent);
        ServiceElement[] elements = this.getServiceElements();
        this._root = new RootServiceElement(elements);
        this._form.init(this._root);
        return control;
    }

    protected ServiceElement[] getServiceElements() {
        if (this._serviceElements == null) {
            IServiceSubSystemConfiguration currentFactory = (IServiceSubSystemConfiguration)this.getSubSystemConfiguration();
            String systemTypeStr = this.getMainPage().getSystemType();
            IServiceSubSystemConfiguration[] factories = this.getServiceSubSystemFactories(systemTypeStr, currentFactory.getServiceType());
            IHost dummyHost = null;
            if (this.getWizard() instanceof RSENewConnectionWizard) {
                dummyHost = ((RSENewConnectionWizard)this.getWizard()).getDelegate().getDummyHost();
            }
            this._serviceElements = new ServiceElement[factories.length];
            int i = 0;
            while (i < factories.length) {
                IServiceSubSystemConfiguration factory = factories[i];
                this._serviceElements[i] = new FactoryServiceElement(dummyHost, factory);
                if (factory == currentFactory) {
                    this._serviceElements[i].setSelected(true);
                }
                ++i;
            }
        }
        return this._serviceElements;
    }

    protected IServiceSubSystemConfiguration[] getServiceSubSystemFactories(String systemType, Class serviceType) {
        ArrayList<IServiceSubSystemConfiguration> results = new ArrayList<IServiceSubSystemConfiguration>();
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType);
        int i = 0;
        while (i < factories.length) {
            IServiceSubSystemConfiguration sfactory;
            ISubSystemConfiguration factory = factories[i];
            if (factory instanceof IServiceSubSystemConfiguration && (sfactory = (IServiceSubSystemConfiguration)factory).getServiceType() == serviceType) {
                results.add(sfactory);
            }
            ++i;
        }
        return results.toArray(new IServiceSubSystemConfiguration[results.size()]);
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean performFinish() {
        if (this._root != null) {
            this._root.commit();
            this._selectedFactory = ((FactoryServiceElement)this._form.getSelectedService()).getFactory();
        }
        return true;
    }

    protected ServerLauncherPropertiesServiceElement[] getPropertiesServiceElement() {
        ArrayList<ServerLauncherPropertiesServiceElement> results = new ArrayList<ServerLauncherPropertiesServiceElement>();
        int i = 0;
        while (i < this._serviceElements.length) {
            ServiceElement el = this._serviceElements[i];
            ServiceElement[] children = el.getChildren();
            if (children != null) {
                int c = 0;
                while (c < children.length) {
                    ServiceElement[] cch;
                    ServiceElement child = children[c];
                    if (child instanceof ConnectorServiceElement && (cch = child.getChildren()) != null && cch.length > 0) {
                        ServerLauncherPropertiesServiceElement result = (ServerLauncherPropertiesServiceElement)cch[0];
                        results.add(result);
                    }
                    ++c;
                }
            }
            ++i;
        }
        return results.toArray(new ServerLauncherPropertiesServiceElement[results.size()]);
    }

    public boolean applyValues(ISubSystem ss) {
        IServiceSubSystemConfiguration currentFactory;
        if (this._selectedFactory != null && (currentFactory = (IServiceSubSystemConfiguration)ss.getSubSystemConfiguration()) != null) {
            ServerLauncherPropertiesServiceElement[] elements;
            if (this._selectedFactory != currentFactory) {
                ((IServiceSubSystem)ss).switchServiceFactory(this._selectedFactory);
            }
            if (this._root != null && (elements = this.getPropertiesServiceElement()).length > 0) {
                IServerLauncherProperties properties = elements[0].getServerLauncherProperties();
                IConnectorService rserv = ss.getConnectorService();
                properties.saveToProperties();
                rserv.setRemoteServerLauncherProperties(properties);
            }
        }
        return true;
    }

    protected IConnectorService getCustomConnectorService(IServiceSubSystemConfiguration config) {
        ServiceElement[] children = this._root.getChildren();
        int i = 0;
        while (i < children.length) {
            FactoryServiceElement fchild;
            ServiceElement child = children[i];
            if (child instanceof FactoryServiceElement && (fchild = (FactoryServiceElement)child).getFactory() == config) {
                return fchild.getConnectorService();
            }
            ++i;
        }
        return null;
    }

    public void handleVerifyComplete() {
        boolean complete = this.isPageComplete();
        this.clearErrorMessage();
        this.setPageComplete(complete);
    }
}

