/*
 * Decompiled with CFR 0.152.
 */
package samples.subsystems;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.actions.SystemChangeFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.view.SubSystemConfigurationAdapter;
import org.eclipse.swt.widgets.Shell;
import samples.RSESamplesPlugin;
import samples.subsystems.DeveloperFilterStringEditPane;

public class DeveloperSubSystemConfigurationAdapter
extends SubSystemConfigurationAdapter {
    protected IAction[] getNewFilterPoolFilterActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        SystemNewFilterAction teamAction = (SystemNewFilterAction)super.getNewFilterPoolFilterAction(factory, selectedPool, shell);
        teamAction.setWizardPageTitle(RSESamplesPlugin.getResourceString("filter.team.pagetitle"));
        teamAction.setPage1Description(RSESamplesPlugin.getResourceString("filter.team.pagetext"));
        teamAction.setType("team");
        teamAction.setText(String.valueOf(RSESamplesPlugin.getResourceString("filter.team.pagetitle")) + "...");
        SystemNewFilterAction devrAction = (SystemNewFilterAction)super.getNewFilterPoolFilterAction(factory, selectedPool, shell);
        devrAction.setWizardPageTitle(RSESamplesPlugin.getResourceString("filter.devr.pagetitle"));
        devrAction.setPage1Description(RSESamplesPlugin.getResourceString("filter.devr.pagetext"));
        devrAction.setType("devr");
        devrAction.setText(String.valueOf(RSESamplesPlugin.getResourceString("filter.devr.pagetitle")) + "...");
        devrAction.setFilterStringEditPane((SystemFilterStringEditPane)new DeveloperFilterStringEditPane(shell));
        IAction[] actions = new IAction[]{teamAction, devrAction};
        return actions;
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        SystemChangeFilterAction action = (SystemChangeFilterAction)super.getChangeFilterAction(factory, selectedFilter, shell);
        String type = selectedFilter.getType();
        if (type == null) {
            type = "team";
        }
        if (type.equals("team")) {
            action.setDialogTitle(RSESamplesPlugin.getResourceString("filter.team.dlgtitle"));
        } else {
            action.setDialogTitle(RSESamplesPlugin.getResourceString("filter.devr.dlgtitle"));
            action.setFilterStringEditPane((SystemFilterStringEditPane)new DeveloperFilterStringEditPane(shell));
        }
        return action;
    }

    public ImageDescriptor getSystemFilterImage(ISystemFilter filter) {
        String type = filter.getType();
        if (type == null) {
            type = "team";
        }
        if (type.equals("team")) {
            return RSESamplesPlugin.getDefault().getImageDescriptor("ICON_ID_TEAMFILTER");
        }
        return RSESamplesPlugin.getDefault().getImageDescriptor("ICON_ID_DEVELOPERFILTER");
    }
}

