/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.rse.ui.filters.actions.SystemFilterPoolReferenceSelectAction;
import org.eclipse.rse.ui.view.SystemViewMenuListener;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterCascadingNewFilterPoolReferenceFPMgrAction
extends SystemBaseSubMenuAction
implements IMenuListener {
    private ISystemFilterPoolManager mgr;
    private ISystemFilterPoolReferenceManager refMgr;

    public SystemFilterCascadingNewFilterPoolReferenceFPMgrAction(Shell shell, ISystemFilterPoolManager mgr, ISystemFilterPoolReferenceManager refMgr) {
        super(mgr.getName(), shell);
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(false);
        this.mgr = mgr;
        this.refMgr = refMgr;
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public IMenuManager populateSubMenu(IMenuManager menu) {
        menu.addMenuListener((IMenuListener)this);
        menu.setRemoveAllWhenShown(true);
        menu.add((IAction)new SystemBaseAction("dummy", null));
        return menu;
    }

    public void menuAboutToShow(IMenuManager ourSubMenu) {
        ISystemFilterPool[] pools = this.mgr.getSystemFilterPools();
        SystemFilterPoolReferenceSelectAction action = null;
        ISystemFilterPool pool = null;
        Shell shell = this.getShell();
        String helpId = this.getHelpContextId();
        int idx = 0;
        while (idx < pools.length) {
            pool = pools[idx];
            if (!this.isPoolAlreadyReferenced(pool) && !this.isPoolConnectionUnique(pool)) {
                action = new SystemFilterPoolReferenceSelectAction(shell, pool, this.refMgr);
                if (helpId != null) {
                    action.setHelp(helpId);
                }
                ourSubMenu.add((IAction)action);
            }
            ++idx;
        }
    }

    private boolean isPoolAlreadyReferenced(ISystemFilterPool pool) {
        return this.refMgr.isSystemFilterPoolReferenced(pool);
    }

    private boolean isPoolConnectionUnique(ISystemFilterPool pool) {
        return pool.getOwningParentName() != null;
    }

    protected SystemViewMenuListener createMnemonicsListener(boolean setMnemonicsOnlyOnce) {
        return new SystemViewMenuListener(false);
    }
}

