/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.model.SystemPreferenceChangeEvent;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.ui.ISystemPreferencesConstants;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBooleanFieldEditor;
import org.eclipse.rse.ui.propertypages.SystemComboBoxFieldEditor;
import org.eclipse.rse.ui.propertypages.SystemTypeFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class RemoteSystemsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ISystemPreferencesConstants {
    private SystemBooleanFieldEditor showFilterPoolsEditor;
    private SystemBooleanFieldEditor qualifyConnectionNamesEditor;
    private SystemBooleanFieldEditor rememberStateEditor;
    private SystemBooleanFieldEditor useDeferredQueryEditor;
    private SystemBooleanFieldEditor restoreFromCache;
    private Composite innerComposite;
    private SystemTypeFieldEditor systemTypesEditor;
    private SystemBooleanFieldEditor showNewConnectionPromptEditor;
    private boolean lastShowFilterPoolsValue = false;
    private boolean lastQualifyConnectionNamesValue = false;
    private boolean lastRememberStateValue = true;
    private boolean lastShowNewConnectionPromptValue = true;
    private boolean lastUseDeferredQueryValue = false;
    static /* synthetic */ Class class$0;

    public RemoteSystemsPreferencePage() {
        super(1);
        this.setTitle(SystemResources.RESID_PREF_ROOT_PAGE);
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.rsep0000");
    }

    protected void createFieldEditors() {
        SystemComboBoxFieldEditor systemTypeEditor = new SystemComboBoxFieldEditor("org.eclipse.rse.preferences.systemtype", SystemResources.RESID_PREF_SYSTEMTYPE_PREFIX_LABEL, RSECorePlugin.getDefault().getRegistry().getSystemTypeNames(), true, this.getFieldEditorParent());
        systemTypeEditor.setToolTipText(SystemResources.RESID_PREF_SYSTEMTYPE_PREFIX_TOOLTIP);
        this.addField(systemTypeEditor);
        this.systemTypesEditor = new SystemTypeFieldEditor("org.eclipse.rse.preferences.systemtype.info", SystemResources.RESID_PREF_USERID_PERTYPE_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField(this.systemTypesEditor);
        this.systemTypesEditor.setToolTipText(SystemResources.RESID_PREF_USERID_PERTYPE_PREFIX_TOOLTIP);
        this.qualifyConnectionNamesEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.qualifyconnectionnames", SystemResources.RESID_PREF_QUALIFYCONNECTIONNAMES_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.qualifyConnectionNamesEditor);
        this.qualifyConnectionNamesEditor.setToolTipText(SystemResources.RESID_PREF_QUALIFYCONNECTIONNAMES_PREFIX_TOOLTIP);
        this.lastQualifyConnectionNamesValue = this.getPreferenceStore().getBoolean(this.qualifyConnectionNamesEditor.getPreferenceName());
        this.showFilterPoolsEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.filterpools.show", SystemResources.RESID_PREF_SHOWFILTERPOOLS_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showFilterPoolsEditor);
        this.showFilterPoolsEditor.setToolTipText(SystemResources.RESID_PREF_SHOWFILTERPOOLS_PREFIX_TOOLTIP);
        this.lastShowFilterPoolsValue = this.getPreferenceStore().getBoolean(this.showFilterPoolsEditor.getPreferenceName());
        this.showNewConnectionPromptEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.shownewconnection", SystemResources.RESID_PREF_SHOWNEWCONNECTIONPROMPT_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showNewConnectionPromptEditor);
        this.showNewConnectionPromptEditor.setToolTipText(SystemResources.RESID_PREF_SHOWNEWCONNECTIONPROMPT_PREFIX_TOOLTIP);
        this.lastShowNewConnectionPromptValue = this.getPreferenceStore().getBoolean(this.showNewConnectionPromptEditor.getPreferenceName());
        this.rememberStateEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.rememberState", SystemResources.RESID_PREF_REMEMBERSTATE_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.rememberStateEditor);
        this.rememberStateEditor.setToolTipText(SystemResources.RESID_PREF_REMEMBERSTATE_PREFIX_TOOLTIP);
        this.lastRememberStateValue = this.getPreferenceStore().getBoolean(this.rememberStateEditor.getPreferenceName());
        this.innerComposite = SystemWidgetHelpers.createComposite(this.getFieldEditorParent(), 0);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 20;
        this.innerComposite.setLayoutData((Object)gd);
        this.restoreFromCache = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.restoreStateFromCache", SystemResources.RESID_PREF_RESTOREFROMCACHE_PREFIX_LABEL, this.innerComposite);
        this.restoreFromCache.setEnabled(this.lastRememberStateValue, this.innerComposite);
        this.addField((FieldEditor)this.restoreFromCache);
        this.restoreFromCache.setToolTipText(SystemResources.RESID_PREF_RESTOREFROMCACHE_PREFIX_TOOLTIP);
        this.useDeferredQueryEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.useDeferredQueries", SystemResources.RESID_PREF_USEDEFERREDQUERIES_PREFIX_LABEL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.useDeferredQueryEditor);
        this.useDeferredQueryEditor.setToolTipText(SystemResources.RESID_PREF_USEDEFERREDQUERIES_PREFIX_TOOLTIP);
        this.lastUseDeferredQueryValue = this.getPreferenceStore().getBoolean(this.useDeferredQueryEditor.getPreferenceName());
        new Mnemonics().setOnPreferencePage(true).setMnemonics(this.getFieldEditorParent());
    }

    public static String[] getActiveProfiles() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return RemoteSystemsPreferencePage.parseStrings(store.getString("org.eclipse.rse.preferences.activeuserprofiles"));
    }

    public static void setActiveProfiles(String[] newProfileNames) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.activeuserprofiles", RemoteSystemsPreferencePage.makeString(newProfileNames));
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static String[] getConnectionNamesOrder() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return RemoteSystemsPreferencePage.parseStrings(store.getString("org.eclipse.rse.preferences.order.connections"));
    }

    public static void setConnectionNamesOrder(String[] newConnectionNamesOrder) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.order.connections", RemoteSystemsPreferencePage.makeString(newConnectionNamesOrder));
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getShowFilterPoolsPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.filterpools.show");
    }

    public static void setShowFilterPoolsPreference(boolean show) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.filterpools.show", show);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getShowNewConnectionPromptPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean value = store.getBoolean("org.eclipse.rse.preferences.shownewconnection");
        return value;
    }

    public static void setShowNewConnectionPromptPreference(boolean show) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.shownewconnection", show);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getQualifyConnectionNamesPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.qualifyconnectionnames");
    }

    public static void setQualifyConnectionNamesPreference(boolean set) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.qualifyconnectionnames", set);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getRememberStatePreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.rememberState");
    }

    public static void setRememberStatePreference(boolean set) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.rememberState", set);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getRestoreStateFromCachePreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.restoreStateFromCache");
    }

    public static void setRestoreStateFromCachePreference(boolean set) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.restoreStateFromCache", set);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static boolean getCascadeUserActionsPreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.rse.preferences.uda.cascade");
    }

    public static void setCascadeUserActionsPreference(boolean set) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.uda.cascade", set);
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static String getUserIdPreference(String systemType) {
        Object adapter;
        if (systemType == null) {
            return null;
        }
        IRSESystemType sysType = RSECorePlugin.getDefault().getRegistry().getSystemType(systemType);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.IRSESystemType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = sysType.getAdapter((Class)clazz)) instanceof RSESystemTypeAdapter) {
            RSESystemTypeAdapter sysTypeAdapter = (RSESystemTypeAdapter)adapter;
            return sysTypeAdapter.getDefaultUserId(sysType);
        }
        return null;
    }

    public static void setUserIdPreference(String systemType, String userId) {
        RSESystemTypeAdapter sysTypeAdapter;
        IRSESystemType sysType = RSECorePlugin.getDefault().getRegistry().getSystemType(systemType);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.IRSESystemType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((sysTypeAdapter = (RSESystemTypeAdapter)sysType.getAdapter((Class)clazz)) == null) {
            return;
        }
        sysTypeAdapter.setDefaultUserId(sysType, userId);
        String value = RSEUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.rse.preferences.systemtype.info");
        Hashtable keyValues = null;
        keyValues = value == null || value.length() == 0 ? new Hashtable() : RemoteSystemsPreferencePage.parseString(value);
        String defaultUserId = sysTypeAdapter.getDefaultUserId(sysType);
        if (defaultUserId == null) {
            defaultUserId = "null";
        }
        keyValues.put(sysType.getName(), "" + sysTypeAdapter.isEnabled(sysType) + '+' + defaultUserId);
        String s = SystemTypeFieldEditor.createString(keyValues);
        if (s != null) {
            RSEUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.rse.preferences.systemtype.info", s);
        }
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    public static String getSystemTypePreference() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return store.getString("org.eclipse.rse.preferences.systemtype");
    }

    public static String[] getFolderHistory() {
        return RemoteSystemsPreferencePage.getWidgetHistory("org.eclipse.rse.preferences.history.folder");
    }

    public static void setFolderHistory(String[] newHistory) {
        RemoteSystemsPreferencePage.setWidgetHistory("org.eclipse.rse.preferences.history.folder", newHistory);
    }

    public static String[] getWidgetHistory(String key) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        return RemoteSystemsPreferencePage.parseStrings(store.getString(key));
    }

    public static void setWidgetHistory(String key, String[] newHistory) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(key, RemoteSystemsPreferencePage.makeString(newHistory));
        RemoteSystemsPreferencePage.savePreferenceStore();
    }

    protected static Hashtable parseString(String allvalues) {
        StringTokenizer tokens = new StringTokenizer(allvalues, "=;");
        Hashtable<String, String> keyValues = new Hashtable<String, String>(10);
        int count = 0;
        String token1 = null;
        String token2 = null;
        while (tokens.hasMoreTokens()) {
            if (++count % 2 == 0) {
                token2 = tokens.nextToken();
                keyValues.put(token1, token2);
                continue;
            }
            token1 = tokens.nextToken();
        }
        return keyValues;
    }

    protected static String[] parseStrings(String allvalues) {
        if (allvalues == null) {
            return new String[0];
        }
        String[] tokens = allvalues.split(";");
        return tokens;
    }

    protected static String makeString(String[] values) {
        StringBuffer allValues = new StringBuffer();
        boolean first = true;
        int idx = 0;
        while (idx < values.length) {
            if (values[idx] != null) {
                if (!first) {
                    allValues = allValues.append(';');
                }
                allValues.append(values[idx]);
                first = false;
            }
            ++idx;
        }
        return allValues.toString();
    }

    private static void savePreferenceStore() {
        RSEUIPlugin.getDefault().savePluginPreferences();
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore store, boolean showNewConnectionPromptDefault) {
        store.setDefault("org.eclipse.rse.preferences.systemtype", "");
        store.setDefault("org.eclipse.rse.preferences.qualifyconnectionnames", false);
        store.setDefault("org.eclipse.rse.preferences.filterpools.show", false);
        String defaultProfileNames = "Team";
        String userProfileName = SystemProfileManager.getDefaultPrivateSystemProfileName();
        defaultProfileNames = String.valueOf(defaultProfileNames) + ";" + userProfileName;
        store.setDefault("org.eclipse.rse.preferences.activeuserprofiles", defaultProfileNames);
        store.setDefault("org.eclipse.rse.preferences.order.connections", "");
        store.setDefault("org.eclipse.rse.preferences.history.folder", "");
        store.setDefault("org.eclipse.rse.preferences.rememberState", true);
        store.setDefault("org.eclipse.rse.preferences.restoreStateFromCache", true);
        store.setDefault("org.eclipse.rse.preferences.shownewconnection", showNewConnectionPromptDefault);
        store.setDefault("org.eclipse.rse.preferences.uda.cascade", false);
        store.setDefault("org.eclipse.rse.preferences.useDeferredQueries", true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object newValue;
        if (event.getSource() == this.rememberStateEditor && (newValue = event.getNewValue()) instanceof Boolean) {
            this.restoreFromCache.setEnabled((Boolean)newValue, this.innerComposite);
        }
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean newValue;
        boolean ok = super.performOk();
        RemoteSystemsPreferencePage.savePreferenceStore();
        if (!RSEUIPlugin.getDefault().isSystemRegistryActive()) {
            return ok;
        }
        if (this.showFilterPoolsEditor != null) {
            newValue = this.showFilterPoolsEditor.getBooleanValue();
            if (newValue != this.lastShowFilterPoolsValue) {
                RSEUIPlugin.getDefault().getSystemRegistry().setShowFilterPools(newValue);
                this.firePreferenceChangeEvent(5, this.lastShowFilterPoolsValue, newValue);
            }
            this.lastShowFilterPoolsValue = newValue;
        }
        if (this.showNewConnectionPromptEditor != null) {
            newValue = this.showNewConnectionPromptEditor.getBooleanValue();
            if (newValue != this.lastShowNewConnectionPromptValue) {
                RSEUIPlugin.getDefault().getSystemRegistry().setShowNewHostPrompt(newValue);
            }
            this.lastShowNewConnectionPromptValue = newValue;
        }
        if (this.qualifyConnectionNamesEditor != null) {
            newValue = this.qualifyConnectionNamesEditor.getBooleanValue();
            if (newValue != this.lastQualifyConnectionNamesValue) {
                RSEUIPlugin.getDefault().getSystemRegistry().setQualifiedHostNames(newValue);
                this.firePreferenceChangeEvent(15, this.lastQualifyConnectionNamesValue, newValue);
            }
            this.lastQualifyConnectionNamesValue = newValue;
        }
        if (this.rememberStateEditor != null) {
            newValue = this.rememberStateEditor.getBooleanValue();
            if (newValue != this.lastRememberStateValue) {
                this.firePreferenceChangeEvent(20, this.lastRememberStateValue, newValue);
            }
            this.lastRememberStateValue = newValue;
        }
        if (this.useDeferredQueryEditor != null) {
            newValue = this.useDeferredQueryEditor.getBooleanValue();
            if (newValue != this.lastUseDeferredQueryValue) {
                this.firePreferenceChangeEvent(20, this.lastUseDeferredQueryValue, newValue);
            }
            this.lastUseDeferredQueryValue = newValue;
        }
        return ok;
    }

    private void firePreferenceChangeEvent(int type, boolean oldValue, boolean newValue) {
        RSEUIPlugin.getDefault().getSystemRegistry().fireEvent(new SystemPreferenceChangeEvent(type, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE));
    }
}

