/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemRemoteResourceSet;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class SystemDNDTransferRunnable
extends Job {
    public static final int SRC_TYPE_RSE_RESOURCE = 0;
    public static final int SRC_TYPE_ECLIPSE_RESOURCE = 1;
    public static final int SRC_TYPE_OS_RESOURCE = 2;
    public static final int SRC_TYPE_TEXT = 3;
    public static final int SRC_TYPE_UNKNOWN = 4;
    private List _srcObjects;
    private List _resultSrcObjects;
    private List _resultTgtObjects;
    private List _setList;
    private Object _currentTarget;
    private int _sourceType;
    private Viewer _originatingViewer;
    private boolean _ok;
    static /* synthetic */ Class class$0;

    public SystemDNDTransferRunnable(Object target, ArrayList srcObjects, Viewer originatingViewer, int sourceType) {
        super(GenericMessages.TransferOperation_message);
        this._srcObjects = srcObjects;
        this._currentTarget = target;
        this._sourceType = sourceType;
        this._originatingViewer = originatingViewer;
        this._resultSrcObjects = new ArrayList(this._srcObjects.size());
        this._resultTgtObjects = new ArrayList();
        this._setList = new ArrayList();
        this.setUser(true);
    }

    protected SystemRemoteResourceSet getSetFor(ISubSystem subSystem, ISystemDragDropAdapter adapter) {
        int i = 0;
        while (i < this._setList.size()) {
            SystemRemoteResourceSet set = (SystemRemoteResourceSet)((Object)this._setList.get(i));
            if (set.getAdapter() == adapter && set.getSubSystem() == subSystem) {
                return set;
            }
            ++i;
        }
        SystemRemoteResourceSet newSet = new SystemRemoteResourceSet(subSystem, adapter);
        this._setList.add(newSet);
        return newSet;
    }

    protected boolean transferRSEResources(IProgressMonitor monitor, Object target, ISubSystem targetSubSystem, ISystemDragDropAdapter targetAdapter) {
        SystemRemoteResourceSet set;
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
                return this._ok;
            }
            if (srcObject != null) {
                ISystemDragDropAdapter srcAdapter;
                IAdaptable iAdaptable = (IAdaptable)srcObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                    if (srcObject instanceof IHost) {
                        Object tempObject = srcAdapter.doDrag(srcObject, false, monitor);
                        if (targetAdapter.validateDrop(tempObject, target, false)) {
                            targetAdapter.doDrop(tempObject, target, false, false, this._sourceType, monitor);
                            this._resultTgtObjects.add(tempObject);
                        }
                    } else {
                        ISubSystem srcSubSystem = srcAdapter.getSubSystem(srcObject);
                        if (srcSubSystem.isConnected() || srcObject instanceof ISystemFilterReference || srcObject instanceof ISubSystem) {
                            set = this.getSetFor(srcSubSystem, srcAdapter);
                            set.addResource(srcObject);
                        }
                    }
                }
            }
            ++i;
        }
        String targetPath = targetAdapter.getAbsoluteName(target);
        boolean sameSubSystemType = true;
        String targetType = "";
        if (targetSubSystem != null) {
            targetType = targetSubSystem.getName();
        }
        int s = 0;
        while (s < this._setList.size()) {
            set = (SystemRemoteResourceSet)((Object)this._setList.get(s));
            ISubSystem srcSubSystem = set.getSubSystem();
            ISystemDragDropAdapter srcAdapter = set.getAdapter();
            String srcType = srcSubSystem.getName();
            sameSubSystemType = targetType.equals(srcType);
            if (!sameSubSystemType && targetSubSystem != null) {
                ISystemResourceSet tempObjects = srcAdapter.doDrag(set, monitor);
                if (tempObjects == null) {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                } else if (tempObjects.hasMessage()) {
                    this.operationFailed(monitor);
                    this.showErrorMessage(tempObjects.getMessage());
                } else if (targetAdapter.validateDrop(tempObjects, target, targetSubSystem == srcSubSystem)) {
                    ISystemResourceSet droppedObjects;
                    ISubSystemConfiguration factory;
                    if (target instanceof ISystemFilterReference && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters()) {
                        target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                        IAdaptable iAdaptable = (IAdaptable)target;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                    }
                    if ((droppedObjects = targetAdapter.doDrop(tempObjects, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor)) == null) {
                        this.operationFailed(monitor);
                    } else if (droppedObjects.hasMessage()) {
                        this.operationFailed(monitor);
                        this.showErrorMessage(droppedObjects.getMessage());
                    } else {
                        List results = droppedObjects.getResourceSet();
                        int d = 0;
                        while (d < results.size()) {
                            this._resultTgtObjects.add(results.get(d));
                            ++d;
                        }
                    }
                } else {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                }
            } else {
                ISubSystemConfiguration factory;
                if (target instanceof ISystemFilterReference && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters()) {
                    target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                    IAdaptable iAdaptable = (IAdaptable)target;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                }
                if (targetAdapter.validateDrop((ISystemResourceSet)set, target, targetSubSystem == srcSubSystem)) {
                    ISystemResourceSet droppedObjects = targetAdapter.doDrop((ISystemResourceSet)set, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor);
                    if (droppedObjects == null) {
                        this.operationFailed(monitor);
                    } else if (droppedObjects.hasMessage()) {
                        this.operationFailed(monitor);
                        this.showErrorMessage(droppedObjects.getMessage());
                    } else {
                        List results = droppedObjects.getResourceSet();
                        int d = 0;
                        while (d < results.size()) {
                            this._resultTgtObjects.add(results.get(d));
                            ++d;
                        }
                    }
                } else {
                    this.operationFailed(monitor);
                    this.showInvalidTransferMessage((ISystemResourceSet)set, targetPath);
                }
            }
            ++s;
        }
        return this._ok;
    }

    protected boolean transferRSEResourcesToEclipseResource(IProgressMonitor monitor, IResource target, ISubSystem targetSubSystem) {
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
            } else if (srcObject != null) {
                ISystemDragDropAdapter srcAdapter;
                Object tempFile;
                IAdaptable iAdaptable = (IAdaptable)srcObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((tempFile = (srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)).doDrag(srcObject, true, monitor)) instanceof IResource) {
                    IResource res = (IResource)tempFile;
                    try {
                        IPath destPath = target.getFullPath();
                        destPath = destPath.append(res.getName());
                        res.copy(destPath, false, monitor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean transferNonRSEResources(IProgressMonitor monitor, Object target, ISubSystem targetSubSystem, ISystemDragDropAdapter targetAdapter) {
        int i = 0;
        while (i < this._srcObjects.size() && this._ok) {
            Object srcObject = this._srcObjects.get(i);
            this._resultSrcObjects.add(srcObject);
            if (srcObject instanceof SystemMessage) {
                this.operationFailed(monitor);
                this.showErrorMessage((SystemMessage)srcObject);
            } else if (srcObject != null) {
                Object droppedObject;
                ISubSystemConfiguration factory;
                if (target instanceof ISystemFilterReference && (factory = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory.providesCustomDropInFilters()) {
                    ((ISystemFilterReference)target).markStale(true);
                    target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                    IAdaptable iAdaptable = (IAdaptable)target;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                }
                if (this._sourceType == 1) {
                    if (srcObject instanceof IResource) {
                        IResource resource = (IResource)srcObject;
                        droppedObject = targetAdapter.doDrop(resource, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 2) {
                    if (srcObject instanceof String) {
                        String file = (String)srcObject;
                        droppedObject = targetAdapter.doDrop(file, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 3) {
                    if (srcObject instanceof String) {
                        String text = (String)srcObject;
                        droppedObject = targetAdapter.doDrop(text, target, false, false, this._sourceType, monitor);
                        if (droppedObject == null) {
                            this.operationFailed(monitor);
                        } else {
                            this._resultTgtObjects.add(droppedObject);
                        }
                    }
                } else if (this._sourceType == 0) {
                    ISystemDragDropAdapter srcAdapter;
                    IAdaptable iAdaptable = (IAdaptable)srcObject;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                        if (srcObject instanceof IHost) {
                            Object tempObject = srcAdapter.doDrag(srcObject, false, monitor);
                            if (targetAdapter.validateDrop(tempObject, target, false)) {
                                targetAdapter.doDrop(tempObject, target, false, false, this._sourceType, monitor);
                                this._resultTgtObjects.add(tempObject);
                            }
                        } else {
                            ISubSystem srcSubSystem = srcAdapter.getSubSystem(srcObject);
                            if (srcSubSystem.isConnected() || srcObject instanceof ISystemFilterReference || srcObject instanceof ISubSystem) {
                                String srcType = srcSubSystem.getName();
                                String srcPath = srcAdapter.getAbsoluteName(srcObject);
                                String targetPath = targetAdapter.getAbsoluteName(target);
                                boolean sameSubSystemType = true;
                                if (targetSubSystem != null) {
                                    String targetType = targetSubSystem.getName();
                                    sameSubSystemType = targetType.equals(srcType);
                                }
                                if (!sameSubSystemType) {
                                    Object tempObject = srcAdapter.doDrag(srcObject, sameSubSystemType, monitor);
                                    if (tempObject == null) {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    } else if (tempObject instanceof SystemMessage) {
                                        this.operationFailed(monitor);
                                        this.showErrorMessage((SystemMessage)tempObject);
                                    } else if (targetAdapter.validateDrop(tempObject, target, targetSubSystem == srcSubSystem)) {
                                        Object droppedObject2;
                                        ISubSystemConfiguration factory2;
                                        if (target instanceof ISystemFilterReference && (factory2 = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory2.providesCustomDropInFilters()) {
                                            target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                                            IAdaptable iAdaptable2 = (IAdaptable)target;
                                            Class<?> clazz2 = class$0;
                                            if (clazz2 == null) {
                                                try {
                                                    clazz2 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            targetAdapter = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
                                        }
                                        if ((droppedObject2 = targetAdapter.doDrop(tempObject, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor)) == null) {
                                            this.operationFailed(monitor);
                                        } else if (droppedObject2 instanceof SystemMessage) {
                                            this.operationFailed(monitor);
                                            this.showErrorMessage((SystemMessage)droppedObject2);
                                        } else {
                                            this._resultTgtObjects.add(droppedObject2);
                                        }
                                    } else {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    }
                                } else if (srcObject != target && !srcPath.equals(targetPath)) {
                                    ISubSystemConfiguration factory3;
                                    if (target instanceof ISystemFilterReference && (factory3 = targetSubSystem.getSubSystemConfiguration()).supportsDropInFilters() && factory3.providesCustomDropInFilters()) {
                                        target = targetSubSystem.getTargetForFilter((ISystemFilterReference)target);
                                        IAdaptable iAdaptable3 = (IAdaptable)target;
                                        Class<?> clazz3 = class$0;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        targetAdapter = (ISystemDragDropAdapter)iAdaptable3.getAdapter((Class)clazz3);
                                    }
                                    if (targetAdapter.validateDrop(srcObject, target, targetSubSystem == srcSubSystem)) {
                                        Object droppedObject3 = targetAdapter.doDrop(srcObject, target, sameSubSystemType, targetSubSystem == srcSubSystem, this._sourceType, monitor);
                                        if (droppedObject3 == null) {
                                            this.operationFailed(monitor);
                                        } else if (droppedObject3 instanceof SystemMessage) {
                                            this.operationFailed(monitor);
                                            this.showErrorMessage((SystemMessage)droppedObject3);
                                        } else {
                                            this._resultTgtObjects.add(droppedObject3);
                                        }
                                    } else {
                                        this.operationFailed(monitor);
                                        this.showInvalidTransferMessage(srcPath, targetPath);
                                    }
                                } else {
                                    this.operationFailed(monitor);
                                    this.showInvalidTransferMessage(srcPath, targetPath);
                                }
                            }
                        }
                    }
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                this._ok = false;
                return this._ok;
            }
            ++i;
        }
        return true;
    }

    public IStatus run(IProgressMonitor monitor) {
        this._ok = true;
        Object target = this._currentTarget;
        ISubSystem targetSubSystem = null;
        if (target instanceof IAdaptable) {
            ISystemDragDropAdapter targetAdapter;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((targetAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                targetSubSystem = targetAdapter.getSubSystem(target);
                if (targetSubSystem != null && !targetSubSystem.isConnected()) {
                    try {
                        targetSubSystem.connect();
                    }
                    catch (Exception exception) {}
                }
                SystemMessage copyMessage = RSEUIPlugin.getPluginMessage("RSEG1115");
                if (monitor != null) {
                    monitor.beginTask(copyMessage.getLevelOneText(), -1);
                }
                if (this._sourceType == 0) {
                    this.transferRSEResources(monitor, target, targetSubSystem, targetAdapter);
                } else {
                    this.transferNonRSEResources(monitor, target, targetSubSystem, targetAdapter);
                }
            } else if (target instanceof IResource) {
                this.transferRSEResourcesToEclipseResource(monitor, (IResource)target, targetSubSystem);
            }
        }
        if (this._ok && monitor != null) {
            monitor.done();
        }
        if (target != null && target instanceof ISystemContainer) {
            ((ISystemContainer)target).markStale(true);
        }
        RefreshJob refresh = new RefreshJob(target, targetSubSystem);
        refresh.schedule();
        return Status.OK_STATUS;
    }

    private void operationFailed(IProgressMonitor monitor) {
        this._ok = false;
        if (monitor != null) {
            monitor.done();
        }
    }

    private void showInvalidTransferMessage(String srcPath, String targetPath) {
        SystemMessage errorMessage = RSEUIPlugin.getPluginMessage("RSEG1270");
        errorMessage.makeSubstitution((Object)srcPath, (Object)targetPath);
        this.showErrorMessage(errorMessage);
    }

    private void showInvalidTransferMessage(ISystemResourceSet resourceSet, String targetPath) {
        SystemMessage errorMessage = RSEUIPlugin.getPluginMessage("RSEG1270");
        errorMessage.makeSubstitution((Object)resourceSet.toString(), (Object)targetPath);
        this.showErrorMessage(errorMessage);
    }

    private void showErrorMessage(SystemMessage errorMessage) {
        Display.getDefault().asyncExec((Runnable)new ShowErrorRunnable(errorMessage));
    }

    public boolean dropOkay() {
        return this._ok;
    }

    public class RefreshJob
    extends UIJob {
        private Object _target;
        private ISubSystem _targetSubSystem;

        public RefreshJob(Object target, ISubSystem targetSubSystem) {
            super("Refresh");
            this._target = target;
            this._targetSubSystem = targetSubSystem;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            if (SystemDNDTransferRunnable.this._resultTgtObjects.size() > 0) {
                boolean doRefresh = SystemDNDTransferRunnable.this._ok;
                int t = 0;
                while (t < SystemDNDTransferRunnable.this._resultTgtObjects.size() && t < SystemDNDTransferRunnable.this._resultSrcObjects.size()) {
                    Object src;
                    Object tgt = SystemDNDTransferRunnable.this._resultTgtObjects.get(t);
                    doRefresh = tgt != (src = SystemDNDTransferRunnable.this._resultSrcObjects.get(t)) && tgt != null;
                    ++t;
                }
                if (SystemDNDTransferRunnable.this._originatingViewer instanceof TreeViewer) {
                    try {
                        TreeViewer viewer = (TreeViewer)SystemDNDTransferRunnable.this._originatingViewer;
                        viewer.setExpandedState(this._target, true);
                    }
                    catch (Exception exception) {}
                }
                if (doRefresh) {
                    registry.fireRemoteResourceChangeEvent(1, SystemDNDTransferRunnable.this._resultTgtObjects, this._target, this._targetSubSystem, null, SystemDNDTransferRunnable.this._originatingViewer);
                }
            }
            registry.fireEvent(new SystemResourceChangeEvent(this._target, 82, this._target));
            return Status.OK_STATUS;
        }
    }

    public class ShowErrorRunnable
    implements Runnable {
        SystemMessage _errorMessage;

        public ShowErrorRunnable(SystemMessage errorMessage) {
            this._errorMessage = errorMessage;
        }

        public void run() {
            Shell shell = SystemBasePlugin.getActiveWorkbenchShell();
            SystemMessageDialog dlg = new SystemMessageDialog(shell, this._errorMessage);
            dlg.open();
        }
    }
}

