/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.filesystem;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.dstore.core.miners.miner.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.IByteStreamHandler;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.IUniversalDataStoreConstants;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.dstore.universal.miners.filesystem.ClassFileParser;
import org.eclipse.rse.dstore.universal.miners.filesystem.FileClassifier;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalByteStreamHandler;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalDownloadHandler;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalFileSystemFilter;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalSearchHandler;
import org.eclipse.rse.services.clientserver.IClientServerConstants;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.ClassFileUtil;

public class UniversalFileSystemMiner
extends Miner
implements IUniversalDataStoreConstants,
IClientServerConstants {
    public static final String MINER_ID;
    private DataElement deUFSnode;
    private DataElement deUFSuploadlog;
    private DataElement deUniversalFileObject;
    private DataElement deUniversalFolderObject;
    private DataElement deUniversalVirtualFileObject;
    private DataElement deUniversalVirtualFolderObject;
    private DataElement deUniversalArchiveFileObject;
    protected String filterString = "*";
    protected ArchiveHandlerManager _archiveHandlerManager;
    protected boolean showHidden = false;
    public static final String CLASSNAME = "UniversalFileSystemMiner";
    protected HashMap _cancellableThreads = new HashMap();
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.filesystem.UniversalFileSystemMiner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MINER_ID = clazz.getName();
    }

    public UniversalFileSystemMiner() {
        this._archiveHandlerManager = ArchiveHandlerManager.getInstance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemZipHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("zip", (Class)clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemJarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("jar", (Class)clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemTarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("tar", (Class)clazz3);
    }

    protected FileClassifier getFileClassifier(DataElement subject) {
        return new FileClassifier(subject);
    }

    public DataElement handleCommand(DataElement theElement) {
        boolean caseSensitive;
        String name = this.getCommandName(theElement);
        DataElement status = this.getCommandStatus(theElement);
        DataElement subject = this.getCommandArgument(theElement, 0);
        UniversalServerUtilities.logInfo(this.getName(), String.valueOf(name) + ":" + subject);
        String queryType = (String)subject.getElementProperty((Object)"type");
        boolean bl = caseSensitive = !this._isWindows;
        if ("C_QUERY_VIEW_ALL".equals(name)) {
            if (subject != null) {
                DataElement attributes = this.getCommandArgument(theElement, 1);
                if (attributes != null && attributes.getType().equals("attributes")) {
                    return this.handleQueryAll(subject, attributes, status, queryType, caseSensitive);
                }
                return this.handleQueryAll(subject, null, status, queryType, caseSensitive);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_VIEW_ALL - subject is null", null);
        } else if ("C_QUERY_VIEW_FILES".equals(name)) {
            if (subject != null) {
                DataElement attributes = this.getCommandArgument(theElement, 1);
                if (attributes != null && attributes.getType().equals("attributes")) {
                    return this.handleQueryFiles(subject, attributes, status, queryType, caseSensitive);
                }
                return this.handleQueryFiles(subject, null, status, queryType, caseSensitive);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_VIEW_FILES - subject is null", null);
        } else if ("C_QUERY_VIEW_FOLDERS".equals(name)) {
            if (subject != null) {
                DataElement attributes = this.getCommandArgument(theElement, 1);
                if (attributes != null && attributes.getType().equals("attributes")) {
                    return this.handleQueryFolders(subject, attributes, status, queryType, caseSensitive);
                }
                return this.handleQueryFolders(subject, null, status, queryType, caseSensitive);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_VIEW_FOLDERS - subject is null", null);
        } else if ("C_QUERY_ROOTS".equals(name)) {
            if (subject != null) {
                return this.handleQueryRoots(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_ROOTS - subject is null", null);
        } else if ("C_SEARCH".equals(name)) {
            if (subject != null) {
                return this.handleSearch(theElement, status, queryType, caseSensitive);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_SEARCH - subject is null", null);
        } else if ("C_CANCEL".equals(name)) {
            if (subject != null) {
                subject.getName();
                return this.handleCancel(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_CANCEL - subject is null", null);
        } else if ("C_RENAME".equals(name)) {
            if (subject != null) {
                return this.handleRename(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_RENAME - subject is null", null);
        } else if ("C_DELETE".equals(name)) {
            if (subject != null) {
                return this.handleDelete(subject, status, true);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_DELETE - subject is null", null);
        } else if ("C_DELETE_BATCH".equals(name)) {
            if (subject != null) {
                return this.handleDeleteBatch(theElement, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_DELETE_BATCH - subject is null", null);
        } else if ("C_COPY".equals(name)) {
            if (subject != null) {
                return this.handleCopy(subject, this.getCommandArgument(theElement, 1), this.getCommandArgument(theElement, 2), status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_COPY - subject is null", null);
        } else if ("C_COPY_BATCH".equals(name)) {
            if (subject != null) {
                return this.handleCopyBatch(subject, theElement, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_COPY_BATCH - subject is null", null);
        } else if ("C_CREATE_FILE".equals(name)) {
            if (subject != null) {
                return this.handleCreateFile(subject, status, queryType);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_CREATE_FILE - subject is null", null);
        } else if ("C_CREATE_FOLDER".equals(name)) {
            if (subject != null) {
                return this.handleCreateFolder(subject, status, queryType);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_CREATE_FOLDERS - subject is null", null);
        } else if ("C_SET_READONLY".equals(name)) {
            if (subject != null) {
                return this.handleSetReadOnly(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_SET_READONLY - subject is null", null);
        } else if ("C_SET_LASTMODIFIED".equals(name)) {
            if (subject != null) {
                return this.handleSetLastModified(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_SET_LASTMODIFIED - subject is null", null);
        } else if ("C_QUERY_BASIC_PROPERTY".equals(name)) {
            if (subject != null) {
                return this.handleQueryBasicProperty(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_BASIC_PROPERTY - subject is null", null);
        } else if ("C_QUERY_CAN_WRITE_PROPERTY".equals(name)) {
            if (subject != null) {
                return this.handleQuerycanWriteProperty(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_CAN_WRITE_PROPERTY - subject is null", null);
        } else if ("C_QUERY_ADVANCE_PROPERTY".equals(name)) {
            if (subject != null) {
                return this.handleQueryAdvanceProperty(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_ADVANCE_PROPERTY - subject is null", null);
        } else if ("C_QUERY_FILE_CLASSIFICATIONS".equals(name)) {
            if (subject != null) {
                return this.handleQueryFileClassification(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_FILE_CLASSIFICATION - subject is null", null);
        } else if ("C_QUERY_FILE_CLASSIFICATION".equals(name)) {
            if (subject != null) {
                return this.handleQueryFileClassification(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_FOLDER_CLASSIFICATION - subject is null", null);
        } else if ("C_QUERY_EXISTS".equals(name)) {
            if (subject != null) {
                return this.handleQueryExists(subject, status, queryType);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_EXISTS - subject is null", null);
        } else if ("C_QUERY_GET_REMOTE_OBJECT".equals(name)) {
            if (subject != null) {
                return this.handleQueryGetRemoteObject(subject, status, queryType);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_GET_REMOTE_OBJECT- subject is null", null);
        } else if ("C_GET_OSTYPE".equals(name)) {
            if (subject != null) {
                return this.handleGetOSType(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_GET_OSTYPE - subject is null", null);
        } else if ("C_DOWNLOAD_FILE".equals(name)) {
            if (subject != null) {
                return this.handleDownload(theElement, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_DOWNLOAD_FILE - subject is null", null);
        } else if ("C_SYSTEM_ENCODING".equals(name)) {
            if (subject != null) {
                return this.handleQueryEncoding(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_SYSTEM_ENCODING - subject is null", null);
        } else if ("C_QUERY_UNUSED_PORT".equals(name)) {
            if (subject != null) {
                return this.handleQueryUnusedPort(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_UNUSED_PORT - subject is null", null);
        } else if ("C_QUERY_CLASSNAME".equals(name)) {
            if (subject != null) {
                return this.handleQueryClassName(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_CLASSNAME- subject is null", null);
        } else if ("C_QUERY_QUALIFIED_CLASSNAME".equals(name)) {
            if (subject != null) {
                return this.handleQueryQualifiedClassName(subject, status);
            }
            UniversalServerUtilities.logError(CLASSNAME, "C_QUERY_QUALIFIED_CLASSNAME - subject is null", null);
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query to handlecommand", null);
        }
        return this.statusDone(status);
    }

    private DataElement handleCopyBatch(DataElement targetFolder, DataElement theElement, DataElement status) {
        String targetType = targetFolder.getType();
        File tgtFolder = this.getFileFor(targetFolder);
        int numOfSources = theElement.getNestedSize() - 2;
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            boolean result;
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(targetFolder);
            ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
            if (handler == null) {
                status.setAttribute(4, "failed");
                return this.statusDone(status);
            }
            File[] srcFiles = new File[numOfSources];
            String[] names = new String[numOfSources];
            int i = 0;
            while (i < numOfSources) {
                DataElement sourceFile = this.getCommandArgument(theElement, i + 1);
                String srcType = sourceFile.getType();
                names[i] = sourceFile.getName();
                if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                    srcFiles[i] = this.getFileFor(sourceFile);
                } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                    AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                    ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    if (shandler == null) {
                        status.setAttribute(4, "failed");
                        return this.statusDone(status);
                    }
                    VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
                    srcFiles[i] = child.getExtractedFile();
                }
                ++i;
            }
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            if (result = handler.add(srcFiles, virtualContainer, names)) {
                status.setAttribute(4, "success");
            } else {
                status.setAttribute(4, "failed");
            }
            return this.statusDone(status);
        }
        boolean folderCopy = false;
        String source = "";
        String tgt = this.enQuote(tgtFolder.getAbsolutePath());
        int numOfNonVirtualSources = 0;
        int i = 0;
        while (i < numOfSources) {
            DataElement sourceFile = this.getCommandArgument(theElement, i + 1);
            String srcType = sourceFile.getType();
            if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                if (shandler == null) {
                    status.setAttribute(4, "failed");
                    return this.statusDone(status);
                }
                VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
                File parentDir = this.getFileFor(targetFolder);
                File destination = new File(parentDir, sourceFile.getName());
                if (child.isDirectory) {
                    shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination);
                } else {
                    shandler.extractVirtualFile(svpath.getVirtualPart(), destination);
                }
            } else {
                File srcFile = this.getFileFor(sourceFile);
                folderCopy = folderCopy || srcFile.isDirectory();
                String src = srcFile.getAbsolutePath();
                src = this.enQuote(src);
                source = numOfNonVirtualSources == 0 ? String.valueOf(source) + src : String.valueOf(source) + " " + src;
                ++numOfNonVirtualSources;
            }
            ++i;
        }
        if (numOfNonVirtualSources > 0) {
            this.doCopyCommand(source, tgt, folderCopy, status);
        }
        return this.statusDone(status);
    }

    protected void doCopyCommand(String source, String tgt, boolean folderCopy, DataElement status) {
        String command = null;
        command = this._isWindows ? (folderCopy ? "xcopy " + source + " " + tgt + " /S /E /K /O /Q /H /I" : "copy " + source + " " + tgt) : (folderCopy ? "cp  -r " + source + " " + tgt : "cp " + source + " " + tgt);
        try {
            String theShell;
            Runtime runtime = Runtime.getRuntime();
            Process p = null;
            if (this._isWindows) {
                theShell = "cmd /C ";
                p = runtime.exec(String.valueOf(theShell) + command);
            } else {
                theShell = "sh";
                String[] args = new String[]{theShell, "-c", command};
                p = runtime.exec(args);
            }
            if (p != null) {
                p.waitFor();
                int result = p.exitValue();
                if (result != 0) {
                    InputStream errStream = p.getErrorStream();
                    StringBuffer errBuf = new StringBuffer();
                    byte[] bytes = null;
                    int numOfBytesRead = 0;
                    int available = errStream.available();
                    while (available > 0) {
                        bytes = new byte[available];
                        numOfBytesRead = errStream.read(bytes);
                        if (numOfBytesRead <= -1) break;
                        errBuf.append(new String(bytes, 0, numOfBytesRead));
                        available = errStream.available();
                    }
                    String err = errBuf.toString();
                    String newLine = System.getProperty("line.separator");
                    if (newLine != null && err.endsWith(newLine)) {
                        err = err.substring(0, err.length() - newLine.length());
                    }
                    if (err.length() > 0) {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, err);
                    } else {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, "unexpectedError");
                    }
                } else {
                    status.setAttribute(4, "success");
                }
            } else {
                status.setAttribute(4, "failed");
                status.setAttribute(3, "unexpectedError");
            }
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(CLASSNAME, "Exception is handleCopy", e);
            status.setAttribute(4, "failed");
            status.setAttribute(3, e.getMessage());
        }
    }

    public void deleteDir(File fileObj, DataElement status) {
        try {
            File[] list = fileObj.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile()) {
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed");
                    }
                } else {
                    this.deleteDir(list[i], status);
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            status.setAttribute(4, "failed with exception");
            status.setAttribute(3, e.getLocalizedMessage());
            UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir failed", e);
        }
    }

    public DataElement handleSearch(DataElement theElement, DataElement status, String queryType, boolean fileNamesCaseSensitive) {
        File fileobj = null;
        DataElement subject = this.getCommandArgument(theElement, 0);
        if (!(queryType.equals("universal.FolderObject") || queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFolderObject"))) {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleSearch", null);
            return this.statusDone(status);
        }
        fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        if (fileobj.exists()) {
            DataElement arg1 = this.getCommandArgument(theElement, 1);
            DataElement arg2 = this.getCommandArgument(theElement, 2);
            DataElement arg3 = this.getCommandArgument(theElement, 3);
            String textString = arg1.getType();
            boolean isCaseSensitive = Boolean.valueOf(arg1.getName());
            boolean isTextRegex = Boolean.valueOf(arg1.getSource());
            String fileNamesString = arg2.getType();
            boolean isFileNamesRegex = Boolean.valueOf(arg2.getName());
            String classification = arg2.getSource();
            boolean isIncludeArchives = Boolean.valueOf(arg3.getType());
            boolean isIncludeSubfolders = Boolean.valueOf(arg3.getName());
            Boolean.valueOf(arg3.getSource()).booleanValue();
            SystemSearchString searchString = new SystemSearchString(textString, isCaseSensitive, isTextRegex, fileNamesString, isFileNamesRegex, isIncludeArchives, isIncludeSubfolders, classification);
            UniversalSearchHandler searchThread = new UniversalSearchHandler(this._dataStore, this, searchString, !this._isWindows, fileobj, status);
            searchThread.start();
            this._cancellableThreads.put(status.getParent(), searchThread);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleCancel(DataElement subject, DataElement status) {
        ICancellableHandler thread = (ICancellableHandler)this._cancellableThreads.get(subject);
        if (thread != null && !thread.isDone()) {
            thread.cancel();
        }
        this.statusCancelled(status);
        return this.statusDone(status);
    }

    public DataElement handleQueryAll(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, false);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryAll", null);
        }
        if (fileobj != null) {
            this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 8);
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected void internalQueryAll(DataElement subject, File fileobj, String queryType, String filter, boolean caseSensitive, int inclusion) {
        if (fileobj.exists()) {
            boolean filterFiles = inclusion == 8 || inclusion == 2;
            boolean filterFolders = inclusion == 8 || inclusion == 4;
            UniversalFileSystemFilter filefilter = new UniversalFileSystemFilter(filter, filterFiles, filterFolders, caseSensitive);
            String theOS = System.getProperty("os.name");
            File[] list = null;
            if (theOS.equals("z/OS")) {
                File[] tempList = fileobj.listFiles();
                ArrayList<File> acceptedList = new ArrayList<File>(tempList.length);
                int i = 0;
                while (i < tempList.length) {
                    File afile = tempList[i];
                    if (filefilter.accept(fileobj, afile.getName())) {
                        acceptedList.add(afile);
                    }
                    ++i;
                }
                list = new File[acceptedList.size()];
                int l = 0;
                while (l < acceptedList.size()) {
                    list[l] = (File)acceptedList.get(l);
                    ++l;
                }
            } else {
                list = fileobj.listFiles(filefilter);
            }
            if (list != null) {
                this.createDataElement(this._dataStore, subject, list, queryType, filter, inclusion);
                String folderProperties = this.setProperties(fileobj);
                if (subject.getSource() == null || subject.getSource().equals("")) {
                    subject.setAttribute(4, folderProperties);
                }
                FileClassifier clsfy = this.getFileClassifier(subject);
                clsfy.start();
            }
        }
    }

    public DataElement handleQueryFiles(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFiles", null);
        }
        this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 2);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleQueryFolders(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, true);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFolders", null);
        }
        this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 4);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleQueryRoots(DataElement subject, DataElement status) {
        new File(subject.getName());
        DataElement deObj = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            String[] ALLDRIVES = new String[]{"c:\\", "d:\\", "e:\\", "f:\\", "g:\\", "h:\\", "i:\\", "j:\\", "k:\\", "l:\\", "m:\\", "n:\\", "o:\\", "p:\\", "q:\\", "r:\\", "s:\\", "t:\\", "u:\\", "v:\\", "w:\\", "x:\\", "y:\\", "z:\\"};
            int idx = 0;
            while (idx < ALLDRIVES.length) {
                File drive = new File(ALLDRIVES[idx]);
                if (drive.exists()) {
                    try {
                        String path = drive.getCanonicalPath();
                        deObj = this._dataStore.createObject(subject, "universal.FolderObject", path);
                        deObj.setAttribute(4, this.setProperties(drive));
                        deObj.setAttribute(2, "");
                        deObj.setAttribute(3, path);
                    }
                    catch (IOException iOException) {
                        return this.statusDone(status);
                    }
                }
                ++idx;
            }
        } else {
            File[] list = File.listRoots();
            int i = 0;
            while (i < list.length) {
                deObj = this._dataStore.createObject(subject, "universal.FolderObject", list[i].getAbsolutePath());
                deObj.setAttribute(4, this.setProperties(list[i]));
                deObj.setAttribute(2, "");
                deObj.setAttribute(3, list[i].getAbsolutePath());
                ++i;
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleDelete(DataElement subject, DataElement status, boolean refreshDataStore) {
        String type = subject.getType();
        if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject")) {
            return this.handleDeleteFromArchive(subject, status);
        }
        File deleteObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        DataElement deObj = null;
        if (!deleteObj.exists()) {
            status.setAttribute(4, "failed with does not exist|" + deleteObj.getAbsolutePath());
            UniversalServerUtilities.logError(CLASSNAME, "The object to delete does not exist", null);
        } else {
            try {
                if (deleteObj.isFile()) {
                    if (!deleteObj.delete()) {
                        status.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                    } else {
                        deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                        this._dataStore.deleteObject(subject, deObj);
                        status.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                    this._dataStore.refresh(subject);
                } else if (deleteObj.isDirectory()) {
                    this.deleteDir(deleteObj, status);
                    if (!deleteObj.delete()) {
                        status.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                        UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir fialed", null);
                    } else {
                        this._dataStore.deleteObjects(subject);
                        DataElement parent = subject.getParent();
                        this._dataStore.deleteObject(parent, subject);
                        this._dataStore.refresh(parent);
                    }
                } else {
                    UniversalServerUtilities.logError(CLASSNAME, "The object to delete is neither a File or Folder! in handleDelete", null);
                }
            }
            catch (Exception e) {
                status.setAttribute(4, "failed with exception|" + deleteObj.getAbsolutePath());
                status.setAttribute(3, e.getLocalizedMessage());
                UniversalServerUtilities.logError(CLASSNAME, "Delete of the object failed", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private DataElement handleDeleteBatch(DataElement theElement, DataElement status) {
        DataElement substatus = this._dataStore.createObject(null, "status", "substatus");
        int numOfSources = theElement.getNestedSize() - 2;
        int i = 0;
        while (i < numOfSources) {
            DataElement subject = this.getCommandArgument(theElement, i + 1);
            this.handleDelete(subject, substatus, false);
            ++i;
        }
        status.setAttribute(4, substatus.getSource());
        return this.statusDone(status);
    }

    public DataElement handleRename(DataElement subject, DataElement status) {
        File fileoldname = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        File filerename = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getAttribute(4));
        if (ArchiveHandlerManager.isVirtual((String)fileoldname.getAbsolutePath())) {
            boolean success;
            AbsoluteVirtualPath oldAbsPath = new AbsoluteVirtualPath(fileoldname.getAbsolutePath());
            AbsoluteVirtualPath newAbsPath = new AbsoluteVirtualPath(filerename.getAbsolutePath());
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(oldAbsPath.getContainingArchiveString()));
            boolean bl = success = handler != null && handler.fullRename(oldAbsPath.getVirtualPart(), newAbsPath.getVirtualPart());
            if (success) {
                subject.setAttribute(2, filerename.getName());
                subject.setAttribute(4, this.setProperties(handler.getVirtualFile(newAbsPath.getVirtualPart())));
                status.setAttribute(4, "success");
                this._dataStore.update(subject);
            } else {
                status.setAttribute(4, "failed");
            }
            this._dataStore.refresh(subject);
            return this.statusDone(status);
        }
        if (filerename.exists()) {
            status.setAttribute(4, "failed with exist");
        } else {
            try {
                boolean done = fileoldname.renameTo(filerename);
                if (done) {
                    subject.setAttribute(2, filerename.getName());
                    subject.setAttribute(4, this.setProperties(filerename));
                    status.setAttribute(4, "success");
                    if (filerename.isDirectory()) {
                        this.updateChildProperties(subject, filerename);
                    }
                    this._dataStore.update(subject);
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                status.setAttribute(4, "failed");
                UniversalServerUtilities.logError(CLASSNAME, "handleRename failed", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private void updateChildProperties(DataElement subject, File filerename) {
        int nestedSize = subject.getNestedSize();
        int i = 0;
        while (i < nestedSize) {
            DataElement child = subject.get(i);
            child.setAttribute(3, filerename.getAbsolutePath());
            if (child.getNestedSize() > 0) {
                File childFile = new File(filerename, child.getName());
                this.updateChildProperties(child, childFile);
            }
            ++i;
        }
    }

    public DataElement handleCreateFile(DataElement subject, DataElement status, String queryType) {
        boolean wasFilter = queryType.equals("universal.FilterObject");
        if (queryType.equals("universal.VirtualFileObject")) {
            return this.handleCreateVirtualFile(subject, status, queryType);
        }
        File filename = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                subject.setAttribute(0, "universal.VirtualFileObject");
                return this.handleCreateVirtualFile(subject, status, queryType);
            }
            filename = new File(subject.getValue());
            subject.setAttribute(0, "universal.FileObject");
            subject.setAttribute(4, this.setProperties(filename));
        } else if (queryType.equals("universal.FileObject")) {
            filename = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleCreateFile", null);
        }
        if (filename.exists()) {
            status.setAttribute(4, "failed with exist");
        } else {
            try {
                boolean done = filename.createNewFile();
                if (ArchiveHandlerManager.getInstance().isArchive(filename)) {
                    done = ArchiveHandlerManager.getInstance().createEmptyArchive(filename);
                    if (done) {
                        subject.setAttribute(0, "universal.ArchiveFileObject");
                    }
                } else if (done) {
                    subject.setAttribute(0, "universal.FileObject");
                }
                subject.setAttribute(4, this.setProperties(filename));
                if (done) {
                    status.setAttribute(4, "success");
                    if (wasFilter) {
                        String fullName = subject.getValue();
                        String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                        String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                        subject.setAttribute(2, name);
                        subject.setAttribute(3, path);
                    }
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleCreateFile failed", e);
                status.setAttribute(4, "failed");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleCreateFolder(DataElement subject, DataElement status, String queryType) {
        if (queryType.equals("universal.VirtualFolderObject")) {
            return this.handleCreateVirtualFolder(subject, status, queryType);
        }
        File filename = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                subject.setAttribute(0, "universal.VirtualFolderObject");
                return this.handleCreateVirtualFolder(subject, status, queryType);
            }
            filename = new File(subject.getValue());
            subject.setAttribute(0, "universal.FolderObject");
            subject.setAttribute(4, this.setProperties(filename));
        } else if (queryType.equals("universal.FolderObject")) {
            filename = new File(subject.getValue());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleCreateFolder", null);
        }
        if (filename.exists()) {
            status.setAttribute(4, "failed with exist");
        } else {
            try {
                boolean done = filename.mkdirs();
                if (done) {
                    status.setAttribute(4, "success");
                    subject.setAttribute(4, this.setProperties(filename));
                    subject.setAttribute(0, "universal.FolderObject");
                    subject.setAttribute(2, filename.getName());
                    subject.setAttribute(3, filename.getParentFile().getAbsolutePath());
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleCreateFolder failed", e);
                status.setAttribute(4, "failed");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleSetReadOnly(DataElement subject, DataElement status) {
        File filename = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                boolean done = filename.setReadOnly();
                if (done) {
                    status.setAttribute(4, "success");
                    subject.setAttribute(4, this.setProperties(filename));
                    this._dataStore.refresh(subject);
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetreadOnly", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleSetLastModified(DataElement subject, DataElement status) {
        File filename = new File(subject.getAttribute(3));
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                String str = subject.getAttribute(4);
                long date = Long.parseLong(str);
                boolean done = filename.setLastModified(date);
                filename = new File(subject.getAttribute(3));
                if (done) {
                    status.setAttribute(4, "success");
                    subject.setAttribute(4, this.setProperties(filename));
                    this._dataStore.refresh(subject);
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetLastModified", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryBasicProperty(DataElement subject, DataElement status) {
        File fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        subject.setAttribute(4, this.setProperties(fileobj));
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQuerycanWriteProperty(DataElement subject, DataElement status) {
        File fileObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(50);
        boolean canWrite = fileObj.canWrite();
        buffer.append(version).append("|").append(canWrite);
        subject.setAttribute(4, buffer.toString());
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryAdvanceProperty(DataElement subject, DataElement status) {
        return this.statusDone(status);
    }

    protected DataElement handleQueryFileClassification(DataElement subject, DataElement status) {
        FileClassifier classifier = this.getFileClassifier(subject);
        classifier.start();
        this.statusDone(status);
        return status;
    }

    protected DataElement handleQueryExists(DataElement subject, DataElement status, String queryType) {
        File fileobj = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                VirtualChild child = this._archiveHandlerManager.getVirtualObject(subject.getName());
                if (child.exists()) {
                    status.setAttribute(4, "true");
                    return this.statusDone(status);
                }
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FileObject") || queryType.equals("universal.ArchiveFileObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(subject.getAttribute(3));
        } else if (queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(subject);
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null) {
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            VirtualChild child = handler.getVirtualFile(vpath.getVirtualPart());
            if (child.exists()) {
                status.setAttribute(4, "true");
                return this.statusDone(status);
            }
        }
        if (fileobj.exists()) {
            status.setAttribute(4, "true");
        } else {
            status.setAttribute(4, "false");
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryGetRemoteObject(DataElement subject, DataElement status, String queryType) {
        block26: {
            String path;
            String name;
            File fileobj = null;
            boolean isVirtual = false;
            String fullName = subject.getValue();
            if (queryType.equals("universal.FilterObject")) {
                isVirtual = ArchiveHandlerManager.isVirtual((String)fullName);
                String filterValue = subject.getValue();
                if (filterValue.equals(".")) {
                    filterValue = System.getProperty("user.home");
                    subject.setAttribute(3, filterValue);
                }
                if (!isVirtual) {
                    fileobj = new File(filterValue);
                }
            } else if (queryType.equals("universal.FileObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = new File(path, name);
            } else if (queryType.equals("universal.FolderObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = name.length() == 0 ? new File(path) : new File(path, name);
            } else {
                UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryGetRemoteObject", null);
                return this.statusDone(status);
            }
            if (!isVirtual && fileobj.exists()) {
                try {
                    fullName = fileobj.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return this.statusDone(status);
                }
                if (fileobj.isFile()) {
                    if (this._archiveHandlerManager.isArchive(fileobj)) {
                        subject.setAttribute(0, "universal.ArchiveFileObject");
                    } else {
                        subject.setAttribute(0, "universal.FileObject");
                    }
                    name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                    path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                    subject.setAttribute(2, name);
                    subject.setAttribute(3, path);
                } else {
                    subject.setAttribute(0, "universal.FolderObject");
                    subject.setAttribute(2, "");
                    subject.setAttribute(3, fullName);
                }
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "success");
            } else if (isVirtual) {
                try {
                    String goodFullName = ArchiveHandlerManager.cleanUpVirtualPath((String)fullName);
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(goodFullName);
                    VirtualChild child = this._archiveHandlerManager.getVirtualObject(goodFullName);
                    if (child.exists()) {
                        if (child.isDirectory) {
                            subject.setAttribute(0, "universal.VirtualFolderObject");
                            subject.setAttribute(2, child.name);
                            if (child.path.equals("")) {
                                subject.setAttribute(3, avp.getContainingArchiveString());
                            } else {
                                subject.setAttribute(3, String.valueOf(avp.getContainingArchiveString()) + "#virtual#/" + child.path);
                            }
                        } else {
                            subject.setAttribute(0, "universal.VirtualFileObject");
                            String name2 = child.name;
                            String path2 = avp.getContainingArchiveString();
                            if (!child.path.equals("")) {
                                path2 = String.valueOf(path2) + "#virtual#/" + child.path;
                            }
                            subject.setAttribute(2, name2);
                            subject.setAttribute(3, path2);
                        }
                        subject.setAttribute(4, this.setProperties(child));
                        status.setAttribute(4, "success");
                        break block26;
                    }
                    UniversalServerUtilities.logWarning(CLASSNAME, "object does not exist");
                    subject.setAttribute(4, this.setProperties(child));
                    status.setAttribute(4, "failed with does not exist");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "failed with does not exist");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement getFileElement(DataElement subject, File file) {
        String fileName = file.getName();
        int i = 0;
        while (i < subject.getNestedSize()) {
            DataElement child = subject.get(i);
            if (child.getName().equals(fileName)) {
                String type = subject.getType();
                boolean isfile = file.isFile();
                if (isfile) {
                    return child;
                }
                if (type.equals("universal.FolderObject")) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    protected void createDataElement(DataStore ds, DataElement subject, File[] list, String queryType, String filter, int include) {
        this.createDataElement(ds, subject, list, queryType, filter, include, null);
    }

    protected void createDataElement(DataStore ds, DataElement subject, File[] list, String queryType, String filter, int include, String[] types) {
        IdentityHashMap<File, Object> foundMap = new IdentityHashMap<File, Object>(list.length);
        List children = subject.getNestedData();
        if (children != null) {
            ArrayList<DataElement> filteredChildren = new ArrayList<DataElement>();
            int f = 0;
            while (f < children.size()) {
                DataElement child = (DataElement)children.get(f);
                String type = child.getType();
                if (type.equals("universal.FileObject") || type.equals("universal.ArchiveFileObject")) {
                    if (StringCompare.compare((String)filter, (String)child.getName(), (boolean)false)) {
                        filteredChildren.add(child);
                    }
                } else {
                    filteredChildren.add(child);
                }
                ++f;
            }
            if (filteredChildren.size() != 0) {
                Object[] currentObjList = filteredChildren.toArray();
                try {
                    int i = 0;
                    while (i < currentObjList.length) {
                        boolean found = false;
                        DataElement previousElement = (DataElement)currentObjList[i];
                        int j = 0;
                        while (j < list.length && !found) {
                            if (previousElement.getName().equals(list[j].getName()) && !previousElement.isDeleted()) {
                                String type = ((DataElement)currentObjList[i]).getType();
                                boolean isfile = list[j].isFile();
                                if ((type.equals("universal.FileObject") || type.equals("universal.ArchiveFileObject")) && isfile || type.equals("universal.FolderObject") && !isfile) {
                                    if (types != null) {
                                        String thisType;
                                        String attributes = previousElement.getAttribute(4);
                                        if (attributes.indexOf(thisType = types[j]) != -1) {
                                            foundMap.put(list[j], currentObjList[i]);
                                            found = true;
                                        }
                                    } else {
                                        foundMap.put(list[j], currentObjList[i]);
                                        found = true;
                                    }
                                }
                            }
                            ++j;
                        }
                        if (!found) {
                            ds.deleteObject(subject, previousElement);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UniversalServerUtilities.logError(CLASSNAME, "createDataElement failed with exception - isFile ", e);
                }
            }
        }
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                DataElement deObj = null;
                File file = list[i];
                try {
                    boolean isHidden;
                    String fileName = file.getName();
                    boolean bl = isHidden = file.isHidden() || fileName.charAt(0) == '.';
                    if (!isHidden || this.showHidden) {
                        Object obj = foundMap.get(file);
                        if (obj != null && obj instanceof DataElement) {
                            deObj = (DataElement)obj;
                        }
                        if (deObj == null) {
                            String valueStr;
                            if (include == 8) {
                                deObj = file.isDirectory() ? ds.createObject(subject, this.deUniversalFolderObject, fileName) : (ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, this.deUniversalArchiveFileObject, fileName) : ds.createObject(subject, this.deUniversalFileObject, fileName));
                            } else if (include == 4) {
                                deObj = ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, this.deUniversalArchiveFileObject, fileName) : ds.createObject(subject, this.deUniversalFolderObject, fileName);
                            } else if (include == 2) {
                                deObj = ArchiveHandlerManager.getInstance().isArchive(file) ? ds.createObject(subject, this.deUniversalArchiveFileObject, fileName) : ds.createObject(subject, this.deUniversalFileObject, fileName);
                            }
                            if (queryType.equals("universal.FilterObject")) {
                                deObj.setAttribute(3, subject.getAttribute(3));
                            } else if (subject.getName().length() > 0) {
                                valueStr = subject.getAttribute(3);
                                StringBuffer valueBuffer = new StringBuffer(valueStr);
                                if (this._isWindows && valueStr.endsWith("\\") || valueStr.endsWith("/") || subject.getName().startsWith("/")) {
                                    valueBuffer.append(subject.getName());
                                    deObj.setAttribute(3, valueBuffer.toString());
                                } else {
                                    valueBuffer.append(File.separatorChar);
                                    valueBuffer.append(subject.getName());
                                    deObj.setAttribute(3, valueBuffer.toString());
                                }
                            } else {
                                valueStr = list[i].getParentFile().getAbsolutePath();
                                deObj.setAttribute(3, valueStr);
                            }
                        }
                        String properties = this.setProperties(file);
                        if (types != null) {
                            deObj.setAttribute(4, String.valueOf(properties) + "|" + types[i]);
                        } else {
                            deObj.setAttribute(4, properties);
                        }
                    }
                }
                catch (Exception e) {
                    UniversalServerUtilities.logError(CLASSNAME, "createDataElement failed with exception - isHidden ", e);
                }
                ++i;
            }
        }
    }

    protected void createDataElement(DataStore ds, DataElement subject, VirtualChild[] list, String filter, String rootPath, String virtualPath) {
        VirtualChild child;
        IdentityHashMap<VirtualChild, DataElement> foundMap = null;
        List children = subject.getNestedData();
        if (children != null) {
            ArrayList<VirtualChild> filteredChildren = new ArrayList<VirtualChild>();
            int f = 0;
            while (f < children.size()) {
                child = (DataElement)children.get(f);
                String type = child.getType();
                if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject")) {
                    if (StringCompare.compare((String)filter, (String)child.getName(), (boolean)false)) {
                        filteredChildren.add(child);
                    }
                } else {
                    filteredChildren.add(child);
                }
                ++f;
            }
            foundMap = new IdentityHashMap<VirtualChild, DataElement>(list.length);
            if (filteredChildren.size() != 0) {
                Object[] currentObjList = filteredChildren.toArray();
                try {
                    int i = 0;
                    while (i < currentObjList.length) {
                        boolean found = false;
                        DataElement previousElement = (DataElement)currentObjList[i];
                        int j = 0;
                        while (j < list.length && !found) {
                            if (!previousElement.isDeleted() && previousElement.getName().equals(list[j].name)) {
                                boolean isfile;
                                String type = previousElement.getType();
                                boolean bl = isfile = !list[j].isDirectory;
                                if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") && !isfile) {
                                    foundMap.put(list[j], previousElement);
                                    found = true;
                                }
                            }
                            ++j;
                        }
                        if (!found) {
                            ds.deleteObject(subject, previousElement);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UniversalServerUtilities.logError(CLASSNAME, "createDataElement failed with exception - isFile ", e);
                }
            }
        }
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                DataElement deObj = null;
                child = list[i];
                Object obj = null;
                if (foundMap != null) {
                    obj = foundMap.get(child);
                }
                if (obj != null && obj instanceof DataElement) {
                    deObj = obj;
                }
                if (deObj == null) {
                    deObj = child.isDirectory ? this._dataStore.createObject(subject, "universal.VirtualFolderObject", child.name) : this._dataStore.createObject(subject, "universal.VirtualFileObject", child.name);
                }
                deObj.setAttribute(3, String.valueOf(rootPath) + "#virtual#/" + virtualPath);
                deObj.setAttribute(4, this.setProperties(child));
                ++i;
            }
        }
    }

    public String setProperties(File fileObj) {
        return this.setProperties(fileObj, false);
    }

    public String setProperties(File fileObj, boolean doArchiveProperties) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.lastModified();
        long size = fileObj.length();
        boolean hidden = fileObj.isHidden();
        boolean canWrite = fileObj.canWrite();
        boolean canRead = fileObj.canRead();
        boolean isArchive = false;
        String comment = isArchive ? ArchiveHandlerManager.getInstance().getComment(fileObj) : " ";
        long compressedSize = size;
        String compressionMethod = " ";
        double compressionRatio = 0.0;
        long expandedSize = isArchive ? ArchiveHandlerManager.getInstance().getExpandedSize(fileObj) : size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        String buf = buffer.toString();
        return buf;
    }

    public String setProperties(VirtualChild fileObj) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.getTimeStamp();
        long size = fileObj.getSize();
        boolean hidden = false;
        boolean canWrite = fileObj.getContainingArchive().canWrite();
        boolean canRead = fileObj.getContainingArchive().canRead();
        String comment = fileObj.getComment();
        if (comment.equals("")) {
            comment = " ";
        }
        long compressedSize = fileObj.getCompressedSize();
        String compressionMethod = fileObj.getCompressionMethod();
        if (compressionMethod.equals("")) {
            compressionMethod = " ";
        }
        double compressionRatio = fileObj.getCompressionRatio();
        long expandedSize = size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        return buffer.toString();
    }

    protected String getClassificationString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 10) {
            return null;
        }
        return str[10];
    }

    protected String getFilterString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 1) {
            return str[1];
        }
        System.out.println("problem with properties:" + s);
        return "*";
    }

    protected boolean getShowHiddenFlag(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 2) {
            return new Boolean(str[2]);
        }
        System.out.println("show hidden flag problem:" + s);
        return true;
    }

    protected int getDepth(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 4) {
            return 1;
        }
        return new Integer(str[3]);
    }

    protected DataElement handleDownload(DataElement theElement, DataElement status) {
        UniversalDownloadHandler downloadThread = new UniversalDownloadHandler(this._dataStore, this, theElement, status);
        downloadThread.start();
        this._cancellableThreads.put(status.getParent(), downloadThread);
        return status;
    }

    protected DataElement handleQueryEncoding(DataElement subject, DataElement status) {
        String encoding = System.getProperty("file.encoding");
        subject.setAttribute(3, encoding);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryUnusedPort(DataElement subject, DataElement status) {
        int port = -1;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            UniversalServerUtilities.logError(CLASSNAME, "Can not get unused port", e);
            port = -1;
        }
        String portNum = String.valueOf(port);
        subject.setAttribute(3, portNum);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement statusDone(DataElement status) {
        status.setAttribute(2, DataStoreResources.model_done);
        this._dataStore.refresh(status);
        return status;
    }

    public DataElement statusCancelled(DataElement status) {
        status.setAttribute(2, "cancelled");
        this._dataStore.refresh(status);
        return status;
    }

    public void load() {
        this.deUFSnode = this._dataStore.createObject(this._minerData, "universal.node", "universal.node");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.temp");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.filters");
        this.deUFSuploadlog = this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.uploadlog");
        UniversalByteStreamHandler universalHandler = new UniversalByteStreamHandler(this._dataStore, this.deUFSuploadlog);
        this._dataStore.registerByteStreamHandler((IByteStreamHandler)universalHandler);
        this._dataStore.refresh(this._minerData);
        this._dataStore.refresh(this.deUFSuploadlog);
    }

    public void finish() {
        super.finish();
    }

    protected DataElement handleQueryClassName(DataElement subject, DataElement status) {
        String filename = String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName();
        try {
            ClassFileParser parser = new ClassFileParser(this.getInputStreamForFile(filename));
            String name = parser.getPackageName();
            if (name != null) {
                this._dataStore.createObject(status, "qualifiedClassName", name);
            } else {
                this._dataStore.createObject(status, "qualifiedClassName", "null");
            }
        }
        catch (IOException iOException) {
            this._dataStore.createObject(status, "qualifiedClassName", "null");
        }
        return this.statusDone(status);
    }

    protected DataElement handleQueryQualifiedClassName(DataElement subject, DataElement status) {
        String parentPath = subject.getAttribute(3);
        String sep = File.separator;
        boolean isParentArchive = ArchiveHandlerManager.getInstance().isRegisteredArchive(parentPath);
        boolean isParentVirtual = ArchiveHandlerManager.isVirtual((String)parentPath);
        if (isParentVirtual) {
            sep = "/";
        }
        String filePath = null;
        if (!isParentArchive) {
            if (!parentPath.endsWith(sep)) {
                parentPath = String.valueOf(parentPath) + sep;
            }
            filePath = String.valueOf(parentPath) + subject.getName();
        } else {
            filePath = String.valueOf(parentPath) + "#virtual#/" + subject.getName();
        }
        try {
            String className = null;
            if (!isParentArchive && !isParentVirtual) {
                className = ClassFileUtil.getInstance().getQualifiedClassName(filePath);
            } else {
                int jdx;
                String execJava;
                String classification = SystemFileClassifier.getInstance().classifyFile(filePath);
                int idx = classification.indexOf(execJava = "executable(java:");
                if (idx != -1 && (jdx = classification.indexOf(")", idx += execJava.length())) != -1) {
                    if (jdx > idx) {
                        className = classification.substring(idx, jdx);
                    } else if (jdx == idx) {
                        className = "";
                    }
                }
            }
            if (className != null) {
                this._dataStore.createObject(status, "fullClassName", className);
            } else {
                this._dataStore.createObject(status, "fullClassName", "null");
            }
        }
        catch (IOException iOException) {
            UniversalServerUtilities.logError(CLASSNAME, "I/O error occured trying to read class file " + filePath, null);
            this._dataStore.createObject(status, "fullClassName", "null");
        }
        return this.statusDone(status);
    }

    public DataElement handleGetOSType(DataElement subject, DataElement status) {
        String osType = System.getProperty("os.name").toLowerCase();
        status.setAttribute(4, osType);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected InputStream getInputStreamForFile(String filename) throws IOException {
        File file = new File(filename);
        return file.toURL().openStream();
    }

    public void extendSchema(DataElement schemaRoot) {
        this._dataStore.find(schemaRoot, 2, DataStoreResources.model_root, 1);
        this.createObjectDescriptor(schemaRoot, "universal.node");
        DataElement tempnode = this.createObjectDescriptor(schemaRoot, "universal.temp");
        DataElement UniversalFilter = this.createObjectDescriptor(schemaRoot, "universal.FilterObject");
        this.deUniversalFileObject = this.createObjectDescriptor(schemaRoot, "universal.FileObject");
        this.deUniversalFolderObject = this.createObjectDescriptor(schemaRoot, "universal.FolderObject");
        this.deUniversalArchiveFileObject = this.createObjectDescriptor(schemaRoot, "universal.ArchiveFileObject");
        this.deUniversalVirtualFileObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFileObject");
        this.deUniversalVirtualFolderObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFolderObject");
        this._dataStore.refresh(schemaRoot);
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_ALL");
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FILES");
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FOLDERS");
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_ROOTS");
        this.createCommandDescriptor(UniversalFilter, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(UniversalFilter, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(UniversalFilter, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(UniversalFilter, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(UniversalFilter, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Filter", "C_QUERY_VIEW_ALL");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FILES");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this.createCommandDescriptor(this.deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_ALL");
        this.createCommandDescriptor(this.deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FILES");
        this.createCommandDescriptor(this.deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(this.deUniversalFileObject, this.deUniversalArchiveFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(this.deUniversalFolderObject, this.deUniversalArchiveFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(this.deUniversalFileObject, this.deUniversalVirtualFileObject, "abstracts", "abstracted by");
        this._dataStore.createReference(this.deUniversalFolderObject, this.deUniversalVirtualFolderObject, "abstracts", "abstracted by");
        DataElement searchDescriptor = this.createCommandDescriptor(this.deUniversalFolderObject, "Search", "C_SEARCH");
        DataElement cancellable = this._dataStore.find(schemaRoot, 2, DataStoreResources.model_Cancellable, 1);
        this._dataStore.createReference(cancellable, searchDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(this.deUniversalFolderObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(tempnode, "Filter", "C_CREATE_TEMP");
        this.createCommandDescriptor(this.deUniversalFileObject, "Delete", "C_DELETE");
        this.createCommandDescriptor(this.deUniversalFileObject, "DeleteBatch", "C_DELETE_BATCH");
        this.createCommandDescriptor(this.deUniversalFileObject, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(this.deUniversalFileObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(this.deUniversalFileObject, "Rename", "C_RENAME");
        this.createCommandDescriptor(this.deUniversalFileObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(this.deUniversalFileObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(this.deUniversalFileObject, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Delete", "C_DELETE");
        this.createCommandDescriptor(this.deUniversalFolderObject, "DeleteBatch", "C_DELETE_BATCH");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Rename", "C_RENAME");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Copy", "C_COPY");
        this.createCommandDescriptor(this.deUniversalFolderObject, "CopyBatch", "C_COPY_BATCH");
        this.createCommandDescriptor(this.deUniversalFolderObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(this.deUniversalFolderObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(this.deUniversalFolderObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(this.deUniversalFolderObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(this.deUniversalFolderObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetFileClassifications", "C_QUERY_FILE_CLASSIFICATIONS");
        this.createCommandDescriptor(this.deUniversalFolderObject, "GetFolderClassifications", "C_QUERY_FILE_CLASSIFICATION");
        this.createCommandDescriptor(this.deUniversalFolderObject, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(this.deUniversalFolderObject, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(this.deUniversalFolderObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(this.deUniversalFolderObject, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetOSType", "C_GET_OSTYPE");
        DataElement downloadDescriptor = this.createCommandDescriptor(this.deUniversalFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, downloadDescriptor, "abstracts", "abstracted by");
        this._dataStore.createReference(cancellable, downloadDescriptor, "abstracts", "abstracted by");
        DataElement adownloadDescriptor = this.createCommandDescriptor(this.deUniversalArchiveFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, adownloadDescriptor, "abstracts", "abstracted by");
        this._dataStore.createReference(cancellable, adownloadDescriptor, "abstracts", "abstracted by");
        this.createCommandDescriptor(tempnode, "SystemEncoding", "C_SYSTEM_ENCODING");
        this.createCommandDescriptor(tempnode, "UnusedPort", "C_QUERY_UNUSED_PORT");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetQualifiedClassName", "C_QUERY_CLASSNAME");
        this.createCommandDescriptor(this.deUniversalFileObject, "GetFullClassName", "C_QUERY_QUALIFIED_CLASSNAME");
    }

    private AbsoluteVirtualPath getAbsoluteVirtualPath(DataElement subject) {
        StringBuffer path = new StringBuffer(subject.getAttribute(3));
        if (ArchiveHandlerManager.getInstance().isArchive(new File(path.toString()))) {
            path.append("#virtual#/");
        } else {
            path.append('/');
        }
        path.append(subject.getName());
        return this.getAbsoluteVirtualPath(path.toString());
    }

    public AbsoluteVirtualPath getAbsoluteVirtualPath(String path) {
        AbsoluteVirtualPath vp = new AbsoluteVirtualPath(path);
        return vp;
    }

    public DataElement handleDeleteFromArchive(DataElement subject, DataElement status) {
        String type = subject.getType();
        DataElement deObj = null;
        AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(subject);
        if (vpath != null) {
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null || !handler.delete(vpath.getVirtualPart())) {
                status.setAttribute(4, "failed");
                this._dataStore.refresh(subject);
                return this.statusDone(status);
            }
            if (type.equals("universal.VirtualFileObject")) {
                deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                this._dataStore.deleteObject(subject, deObj);
                status.setAttribute(4, "success");
            } else if (type.equals("universal.VirtualFolderObject")) {
                this._dataStore.deleteObjects(subject);
                DataElement parent = subject.getParent();
                this._dataStore.deleteObject(parent, subject);
                this._dataStore.refresh(parent);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleQueryAllArchive(DataElement subject, DataElement attributes, DataElement status, boolean caseSensitive, boolean foldersOnly) {
        File fileobj = null;
        try {
            String path;
            ArchiveHandlerManager mgr = ArchiveHandlerManager.getInstance();
            char separatorChar = File.separatorChar;
            if (ArchiveHandlerManager.isVirtual((String)subject.getAttribute(3))) {
                separatorChar = '/';
            }
            String rootPath = path = String.valueOf(subject.getAttribute(3)) + separatorChar + subject.getName();
            String virtualPath = "";
            VirtualChild[] children = null;
            if (subject.getType().equals("universal.ArchiveFileObject")) {
                fileobj = new File(rootPath);
                subject.setAttribute(4, this.setProperties(fileobj, true));
                children = foldersOnly ? mgr.getFolderContents(fileobj, "") : mgr.getContents(fileobj, "");
            } else if (subject.getType().equals("universal.VirtualFolderObject")) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
                rootPath = avp.getContainingArchiveString();
                virtualPath = avp.getVirtualPart();
                fileobj = new File(rootPath);
                if (fileobj.exists()) {
                    children = foldersOnly ? mgr.getFolderContents(fileobj, virtualPath) : mgr.getContents(fileobj, virtualPath);
                    subject.setAttribute(4, this.setProperties(mgr.getVirtualObject(virtualPath)));
                    if (children == null || children.length == 0) {
                        this._dataStore.trace("problem with virtual:" + virtualPath);
                    }
                } else {
                    this._dataStore.trace("problem with File:" + rootPath);
                }
            }
            this.createDataElement(this._dataStore, subject, children, "*", rootPath, virtualPath);
            this._dataStore.refresh(subject);
            FileClassifier clsfy = this.getFileClassifier(subject);
            clsfy.start();
            return this.statusDone(status);
        }
        catch (Exception exception) {
            if (fileobj != null) {
                try {
                    new FileReader(fileobj).read();
                }
                catch (IOException iOException) {
                    status.setAttribute(3, "RSEF5001");
                    status.setAttribute(4, "failed");
                    this._dataStore.refresh(subject);
                    return this.statusDone(status);
                }
            }
            status.setAttribute(3, "RSEG1122");
            status.setAttribute(4, "failed");
            return this.statusDone(status);
        }
    }

    public ISystemArchiveHandler getArchiveHandlerFor(String archivePath) {
        File file = new File(archivePath);
        return this._archiveHandlerManager.getRegisteredHandler(file);
    }

    public DataElement handleCreateVirtualFile(DataElement subject, DataElement status, String type) {
        AbsoluteVirtualPath vpath = null;
        vpath = type.equals("universal.FilterObject") ? this.getAbsoluteVirtualPath(subject.getValue()) : this.getAbsoluteVirtualPath(subject);
        ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
        if (handler == null) {
            status.setAttribute(4, "failed");
            return this.statusDone(status);
        }
        handler.getVirtualFile(vpath.getVirtualPart());
        handler.createFile(vpath.getVirtualPart());
        status.setAttribute(4, "success");
        if (type.equals("universal.FilterObject")) {
            String fullName = subject.getValue();
            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
            subject.setAttribute(2, name);
            subject.setAttribute(3, path);
            subject.setAttribute(0, "universal.VirtualFileObject");
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleCreateVirtualFolder(DataElement subject, DataElement status, String type) {
        AbsoluteVirtualPath vpath = null;
        vpath = type.equals("universal.FilterObject") ? this.getAbsoluteVirtualPath(subject.getValue()) : this.getAbsoluteVirtualPath(subject);
        ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
        if (handler == null) {
            status.setAttribute(4, "failed");
            return this.statusDone(status);
        }
        handler.getVirtualFile(vpath.getVirtualPart());
        handler.createFolder(vpath.getVirtualPart());
        status.setAttribute(4, "success");
        if (type.equals("universal.FilterObject")) {
            String fullName = subject.getValue();
            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
            subject.setAttribute(2, name);
            subject.setAttribute(3, path);
            subject.setAttribute(0, "universal.VirtualFolderObject");
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private File getFileFor(DataElement element) {
        File result = null;
        String type = element.getType();
        if (type.equals("universal.FilterObject")) {
            result = new File(element.getName());
        } else if (type.equals("universal.FileObject") || type.equals("universal.FolderObject") || type.equals("universal.ArchiveFileObject")) {
            StringBuffer buf = new StringBuffer(element.getAttribute(3));
            buf.append(File.separatorChar);
            buf.append(element.getName());
            result = new File(buf.toString());
        }
        return result;
    }

    public DataElement handleCopy(DataElement targetFolder, DataElement sourceFile, DataElement nameObj, DataElement status) {
        String newName = nameObj.getName();
        String targetType = targetFolder.getType();
        String srcType = sourceFile.getType();
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            boolean result;
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(targetFolder);
            ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
            if (handler == null) {
                status.setAttribute(4, "failed");
                return this.statusDone(status);
            }
            File srcFile = null;
            if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                srcFile = this.getFileFor(sourceFile);
            } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                if (shandler == null) {
                    status.setAttribute(4, "failed");
                    return this.statusDone(status);
                }
                VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
                srcFile = child.getExtractedFile();
            }
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            if (result = handler.add(srcFile, virtualContainer, newName)) {
                status.setAttribute(4, "success");
            } else {
                status.setAttribute(4, "failed");
            }
        } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
            ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
            if (shandler == null) {
                status.setAttribute(4, "failed");
                return this.statusDone(status);
            }
            VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
            File parentDir = this.getFileFor(targetFolder);
            File destination = new File(parentDir, newName);
            if (child.isDirectory) {
                shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination);
            } else {
                shandler.extractVirtualFile(svpath.getVirtualPart(), destination);
            }
        } else {
            File tgtFolder = this.getFileFor(targetFolder);
            File srcFile = this.getFileFor(sourceFile);
            boolean folderCopy = srcFile.isDirectory();
            String src = srcFile.getAbsolutePath();
            String tgt = String.valueOf(tgtFolder.getAbsolutePath()) + File.separatorChar + newName;
            File tgtFile = new File(tgt);
            if (tgtFile.exists() && tgtFile.isDirectory() && newName.equals(srcFile.getName())) {
                tgt = tgtFolder.getAbsolutePath();
            }
            this.doCopyCommand(this.enQuote(src), this.enQuote(tgt), folderCopy, status);
        }
        return this.statusDone(status);
    }

    protected String enQuote(String s) {
        if (this._isWindows) {
            return String.valueOf('\"') + s + '\"';
        }
        return PathUtility.enQuoteUnix((String)s);
    }

    public String getVersion() {
        return "7.0.0";
    }
}

