/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.ssh.shell;

import java.io.PrintWriter;

public class SshShellWriterThread
extends Thread {
    private PrintWriter fOutputWriter;
    private String fNextCommand;
    private boolean fIsCancelled;

    public SshShellWriterThread(PrintWriter outputWriter) {
        this.fOutputWriter = outputWriter;
        this.setName("Ssh ShellWriter" + this.getName());
        this.start();
    }

    public synchronized boolean isDone() {
        return this.fIsCancelled;
    }

    public synchronized void stopThread() {
        this.fIsCancelled = true;
        this.notifyAll();
    }

    public synchronized boolean sendCommand(String command) {
        try {
            while (!this.fIsCancelled && this.fNextCommand != null) {
                this.wait();
            }
            if (!this.fIsCancelled) {
                this.fNextCommand = command;
                this.notifyAll();
                while (!this.fIsCancelled && this.fNextCommand != null) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.stopThread();
        }
        return !this.fIsCancelled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            try {
                block5: while (true) {
                    if (this.fIsCancelled) {
                        return;
                    }
                    while (true) {
                        if (this.fNextCommand != null || this.fIsCancelled) {
                            if (this.fIsCancelled) continue block5;
                            this.fOutputWriter.println(this.fNextCommand);
                            this.fNextCommand = null;
                            this.notifyAll();
                            if (!this.fOutputWriter.checkError()) continue block5;
                            this.stopThread();
                            continue block5;
                        }
                        this.wait();
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        finally {
            this.stopThread();
            this.fOutputWriter.close();
            this.fOutputWriter = null;
        }
    }
}

