/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalFileSystemMiner;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.search.SystemSearchFileNameMatcher;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class UniversalSearchHandler
extends Thread
implements ICancellableHandler {
    protected HashSet _alreadySearched;
    private File _rootFile;
    protected boolean _isCancelled;
    protected boolean _isDone;
    protected int _depth = -1;
    protected DataStore _dataStore;
    protected UniversalFileSystemMiner _miner;
    protected DataElement _status;
    protected SystemSearchString _searchString;
    protected SystemSearchStringMatcher _stringMatcher;
    protected boolean _isFileSearch;
    protected SystemSearchFileNameMatcher _fileNameMatcher;
    protected String _classificationString;
    protected DataElement _deGrep;
    protected DataElement _deFile;
    protected DataElement _deFolder;
    protected DataElement _deArchiveFile;
    protected DataElement _deVirtualFile;
    protected boolean _fsCaseSensitive;

    public UniversalSearchHandler(DataStore dataStore, UniversalFileSystemMiner miner, SystemSearchString searchString, boolean fsCaseSensitive, File theFile, DataElement status) {
        this._dataStore = dataStore;
        this._miner = miner;
        this._searchString = searchString;
        this._fsCaseSensitive = fsCaseSensitive;
        this._alreadySearched = new HashSet();
        this._deGrep = this._dataStore.findObjectDescriptor("grep");
        this._deFile = this._dataStore.findObjectDescriptor("universal.FileObject");
        this._deFolder = this._dataStore.findObjectDescriptor("universal.FolderObject");
        this._deArchiveFile = this._dataStore.findObjectDescriptor("universal.ArchiveFileObject");
        this._deVirtualFile = this._dataStore.findObjectDescriptor("universal.VirtualFileObject");
        boolean includeSubfolders = searchString.isIncludeSubfolders();
        this._depth = includeSubfolders ? -1 : 1;
        this._rootFile = theFile;
        this._status = status;
        this._isCancelled = false;
        this._isDone = false;
        this._stringMatcher = new SystemSearchStringMatcher(this._searchString.getTextString(), this._searchString.isCaseSensitive(), this._searchString.isTextStringRegex());
        this._isFileSearch = this._stringMatcher.isSearchStringEmpty() || this._stringMatcher.isSearchStringAsterisk();
        this._fileNameMatcher = new SystemSearchFileNameMatcher(this._searchString.getFileNamesString(), fsCaseSensitive, this._searchString.isFileNamesRegex());
        this._classificationString = this._searchString.getClassificationString();
    }

    public void run() {
        try {
            this.internalSearch(this._rootFile, this._depth);
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(this._miner.getName(), "Error occured when calling internal search", e);
        }
        this._isDone = true;
        if (this._isCancelled) {
            this._miner.statusCancelled(this._status);
        } else {
            this._status.setAttribute(2, "done");
            this._dataStore.refresh(this._status, true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void cancel() {
        this._isCancelled = true;
    }

    protected boolean hasSearchedDirectory(File file) {
        try {
            return this._alreadySearched.contains(file.getCanonicalFile());
        }
        catch (IOException e) {
            this._dataStore.trace((Throwable)e);
            return this._alreadySearched.contains(file);
        }
    }

    protected void internalSearch(File theFile, int depth) {
        boolean isDirectory = theFile.isDirectory();
        boolean isArchive = ArchiveHandlerManager.getInstance().isArchive(theFile);
        String absPath = theFile.getAbsolutePath();
        String compareStr = theFile.getName();
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)absPath);
        boolean isVirtualDirectory = false;
        if (isVirtual) {
            VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(absPath);
            boolean bl = isVirtualDirectory = isVirtual && vc.isDirectory;
        }
        if (!isDirectory && (!isArchive || this._isFileSearch) && !isVirtualDirectory && this.doesFilePatternMatch(compareStr) && this.doesClassificationMatch(absPath)) {
            DataElement deObj = null;
            if (ArchiveHandlerManager.isVirtual((String)absPath)) {
                VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(absPath);
                if (!vc.isDirectory) {
                    deObj = this._dataStore.createObject(null, this._deVirtualFile, compareStr);
                    if (vc.path.equals("")) {
                        deObj.setAttribute(3, vc.getContainingArchive().getAbsolutePath());
                    } else {
                        deObj.setAttribute(3, String.valueOf(vc.getContainingArchive().getAbsolutePath()) + "#virtual#/" + vc.path);
                    }
                    deObj.setAttribute(4, this._miner.setProperties(vc));
                    SystemSearchLineMatch[] results = null;
                    if (!this._isFileSearch) {
                        results = vc.getHandler().search(vc.fullName, this._stringMatcher);
                        if (results != null && results.length > 0) {
                            this.convert(deObj, absPath, results);
                            deObj.setParent(this._status);
                            this._status.addNestedData(deObj, false);
                        }
                    } else {
                        deObj.setParent(this._status);
                        this._status.addNestedData(deObj, false);
                    }
                }
            } else {
                deObj = !isArchive ? this._dataStore.createObject(null, this._deFile, compareStr) : this._dataStore.createObject(null, this._deArchiveFile, compareStr);
                deObj.setAttribute(3, theFile.getParentFile().getAbsolutePath());
                deObj.setAttribute(4, this._miner.setProperties(theFile));
                if (this._isFileSearch || this.internalSearchWithinFile(deObj, absPath, theFile)) {
                    deObj.setParent(this._status);
                    this._status.addNestedData(deObj, false);
                }
            }
            this._dataStore.refresh(this._status, true);
        }
        if (depth != 0 && (isDirectory || (isArchive || isVirtualDirectory) && this._searchString.isIncludeArchives()) && !this.hasSearchedDirectory(theFile)) {
            try {
                this._alreadySearched.add(theFile.getCanonicalFile());
            }
            catch (IOException e) {
                this._dataStore.trace((Throwable)e);
                this._alreadySearched.add(theFile);
            }
            File[] children = null;
            if (isArchive || isVirtualDirectory) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
                File archive = new File(avp.getContainingArchiveString());
                String virtualPath = avp.getVirtualPart();
                VirtualChild[] virtualchildren = null;
                try {
                    virtualchildren = ArchiveHandlerManager.getInstance().getContents(archive, virtualPath);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError(this._miner.getName(), "Error occured trying to get the canonical file", e);
                }
                if (virtualchildren != null) {
                    children = new File[virtualchildren.length];
                    int i = 0;
                    while (i < virtualchildren.length) {
                        AbsoluteVirtualPath newAvp = new AbsoluteVirtualPath(absPath);
                        newAvp.setVirtualPart(virtualchildren[i].fullName);
                        children[i] = new File(newAvp.toString());
                        ++i;
                    }
                    if (virtualchildren.length == 0) {
                        children = null;
                    }
                }
            } else {
                children = theFile.listFiles();
            }
            if (children != null) {
                int i = 0;
                while (i < children.length && !this._isCancelled) {
                    File child = children[i];
                    this.internalSearch(child, depth - 1);
                    ++i;
                }
            }
        }
    }

    protected boolean internalSearchWithinFile(DataElement remoteFile, String absPath, File theFile) {
        if (this._isFileSearch) {
            return true;
        }
        FileInputStream inputStream = null;
        try {
            boolean foundMatches;
            inputStream = new FileInputStream(theFile);
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufReader = new BufferedReader(reader);
            SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator((Reader)bufReader, this._stringMatcher);
            SystemSearchLineMatch[] matches = locator.locateMatches();
            boolean bl = foundMatches = matches != null && matches.length > 0;
            if (foundMatches) {
                this.convert(remoteFile, absPath, matches);
            }
            return foundMatches;
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(this._miner.getName(), "Error occured when trying to locate matches", e);
            remoteFile.setAttribute(3, e.getMessage());
            return false;
        }
    }

    protected boolean doesFilePatternMatch(String compareStr) {
        return this._fileNameMatcher.matches(compareStr);
    }

    protected boolean doesClassificationMatch(String absolutePath) {
        if (this._classificationString == null || this._classificationString.equals("")) {
            return true;
        }
        String classification = SystemFileClassifier.getInstance().classifyFile(absolutePath);
        return StringCompare.compare((String)this._classificationString, (String)classification, (boolean)true);
    }

    protected void convert(DataElement deObj, String absPath, SystemSearchLineMatch[] lineMatches) {
        SystemSearchLineMatch match = null;
        int i = 0;
        while (i < lineMatches.length) {
            match = lineMatches[i];
            DataElement obj = this._dataStore.createObject(deObj, this._deGrep, match.getLine(), absPath);
            obj.setAttribute(4, String.valueOf(obj.getSource()) + ':' + match.getLineNumber());
            ++i;
        }
    }
}

