/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.ISchemaExtender;
import org.eclipse.dstore.core.model.ISchemaRegistry;
import org.eclipse.dstore.core.util.ExternalLoader;

public class SchemaRegistry
implements ISchemaRegistry {
    private ArrayList _initializedDataStores = new ArrayList();
    private ArrayList _extenders = new ArrayList();

    public void registerSchemaExtender(ISchemaExtender extender) {
        if (!this._extenders.contains(extender)) {
            this._extenders.add(extender);
            int i = 0;
            while (i < this._initializedDataStores.size()) {
                DataStore dataStore = (DataStore)this._initializedDataStores.get(i);
                DataElement schemaRoot = dataStore.getDescriptorRoot();
                extender.extendSchema(schemaRoot);
                ++i;
            }
        }
    }

    public void extendSchema(DataStore dataStore) {
        if (!this._initializedDataStores.contains(dataStore)) {
            DataElement schemaRoot = dataStore.getDescriptorRoot();
            int i = 0;
            while (i < this._extenders.size()) {
                ISchemaExtender extender = (ISchemaExtender)this._extenders.get(i);
                extender.extendSchema(schemaRoot);
                ++i;
            }
            this._initializedDataStores.add(dataStore);
        }
    }

    public ExternalLoader getLoaderFor(String source) {
        int i = 0;
        while (i < this._extenders.size()) {
            ISchemaExtender extender = (ISchemaExtender)this._extenders.get(i);
            ExternalLoader loader = extender.getExternalLoader();
            if (loader.canLoad(source)) {
                return loader;
            }
            ++i;
        }
        return null;
    }
}

