/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.shells;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.eclipse.core.runtime.Platform;

public class LocalShellThread
extends Thread {
    private volatile Thread _commandThread;
    protected boolean _isCancelled;
    private String _cwd;
    private String _invocation;
    private String[] _envVars;
    private String PSEUDO_TERMINAL;
    private boolean _isShell;
    private boolean _isDone;
    private Process _theProcess;
    private boolean _isTTY = false;
    private boolean _isWindows;
    private String _encoding;
    private BufferedReader _stdInput;
    private BufferedReader _stdError;

    public LocalShellThread(String cwd, String invocation, String encoding, String[] envVars) {
        this._encoding = encoding;
        this._isCancelled = false;
        this._cwd = cwd;
        this._invocation = invocation;
        this.PSEUDO_TERMINAL = System.getProperty("rse.pty");
        try {
            this.PSEUDO_TERMINAL = Platform.resolve((URL)new URL(this.PSEUDO_TERMINAL)).getPath();
        }
        catch (Exception exception) {}
        this._envVars = envVars;
        this.init();
    }

    public boolean isShell() {
        return this._isShell;
    }

    public boolean isWindows() {
        return this._isWindows;
    }

    public boolean isDone() {
        return this._isDone || this._isCancelled;
    }

    public String getInvocation() {
        return this._invocation;
    }

    public String getCWD() {
        return this._cwd;
    }

    public void setCWD(String cwd) {
        this._cwd = cwd;
    }

    private void init() {
        try {
            String[] envVars;
            File theDirectory = new File(this._cwd);
            if (!theDirectory.isDirectory()) {
                theDirectory = theDirectory.getParentFile();
            }
            String theOS = System.getProperty("os.name");
            this._isWindows = theOS.toLowerCase().startsWith("win");
            this._isTTY = this.PSEUDO_TERMINAL != null && new File(this.PSEUDO_TERMINAL).exists();
            String theShell = null;
            if (!this._isWindows) {
                String[] args;
                envVars = this.getEnvironmentVariables(false);
                if (theShell == null) {
                    String property = "SHELL=";
                    int i = 0;
                    while (i < envVars.length) {
                        String var = envVars[i];
                        if (var.startsWith(property) && (theShell = var.substring(property.length(), var.length())).endsWith("bash")) {
                            theShell = "sh";
                        }
                        ++i;
                    }
                    if (theShell == null) {
                        theShell = "sh";
                    }
                    if (this._isTTY) {
                        if (this._invocation.equals(">")) {
                            this._invocation = theShell;
                            this._isShell = true;
                        }
                        String[] args2 = new String[]{this.PSEUDO_TERMINAL, this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args2, envVars, theDirectory);
                    } else {
                        if (this._invocation.equals(">")) {
                            this._invocation = theShell;
                            this._isShell = true;
                        }
                        String[] args3 = new String[]{this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args3[0], envVars, theDirectory);
                    }
                } else if (this._isTTY) {
                    if (this._invocation.equals(">")) {
                        this._invocation = theShell;
                        this._isShell = true;
                    }
                    args = new String[]{this.PSEUDO_TERMINAL, theShell, "-c", this._invocation};
                    this._theProcess = Runtime.getRuntime().exec(args, envVars, theDirectory);
                } else {
                    if (this._invocation.equals(">")) {
                        this._invocation = theShell;
                        this._isShell = true;
                    }
                    args = new String[]{theShell, "-c", this._invocation};
                    this._theProcess = Runtime.getRuntime().exec(args, envVars, theDirectory);
                }
            } else {
                envVars = this.getEnvironmentVariables(true);
                theShell = theOS.indexOf("95") >= 0 || theOS.indexOf("98") >= 0 || theOS.indexOf("ME") >= 0 ? "start" : "cmd";
                if (this._invocation.equals(">")) {
                    this._invocation = theShell;
                    this._isShell = true;
                }
                theShell = theShell.equals("start") ? String.valueOf(theShell) + " /B " : String.valueOf(theShell) + " /C ";
                this._theProcess = Runtime.getRuntime().exec(String.valueOf(theShell) + this._invocation, envVars, theDirectory);
            }
            if (this._encoding == null || this._encoding.length() == 0) {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    this._encoding = osw.getEncoding();
                    osw.close();
                    os.close();
                }
                catch (Exception exception) {}
                if (this._encoding == null && (this._encoding == null || this._encoding.length() == 0)) {
                    this._encoding = System.getProperty("file.encoding");
                }
            }
            this._stdInput = new BufferedReader(new InputStreamReader(this._theProcess.getInputStream()));
            this._stdError = new BufferedReader(new InputStreamReader(this._theProcess.getErrorStream()));
        }
        catch (IOException e) {
            this._theProcess = null;
            e.printStackTrace();
            return;
        }
        if (this._isShell && !this._isWindows && !this._isTTY) {
            OutputStream output = this._theProcess.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
            this.createPrompt(writer);
        }
    }

    private void createPrompt(BufferedWriter writer) {
        try {
            writer.write("echo $PWD'>'");
            writer.write(10);
            writer.flush();
        }
        catch (Exception exception) {}
    }

    public BufferedReader getOutputStream() {
        return this._stdInput;
    }

    public BufferedReader getErrorStream() {
        return this._stdError;
    }

    public synchronized void stopThread() {
        if (this._commandThread != null) {
            this._isCancelled = true;
            try {
                this._commandThread = null;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.notify();
    }

    public void sendInput(String input) {
        if (!this._isDone) {
            input.getBytes();
            OutputStream output = this._theProcess.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
            try {
                writer.write(input);
                writer.write(10);
                writer.flush();
                if (!this._isWindows && !this._isTTY) {
                    this.createPrompt(writer);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException e) {
                System.out.println(e);
                this._isShell = false;
            }
        }
    }

    public void run() {
        Thread thisThread;
        this._commandThread = thisThread = Thread.currentThread();
        while (this._commandThread != null && this._commandThread == thisThread && this._commandThread.isAlive() && !this._isCancelled) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
            if (this.doThreadedWork()) continue;
            try {
                this._commandThread = null;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        this.cleanupThread();
    }

    public boolean doThreadedWork() {
        return this._stdInput != null && this._isShell;
    }

    public void cleanupThread() {
        block7: {
            if (this._isShell) {
                this.sendInput("exit");
            }
            this._isDone = true;
            try {
                this._stdInput.close();
                this._stdError.close();
                if (this._theProcess == null) break block7;
                try {
                    if (this._isCancelled) {
                        this._theProcess.destroy();
                    } else {
                        this._theProcess.exitValue();
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    this._theProcess.destroy();
                }
                this._theProcess = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPathEnvironmentVariable() {
        String[] vars = this._envVars;
        if (vars != null) {
            int i = 0;
            while (i < vars.length) {
                String var = vars[i].toUpperCase();
                if (var.startsWith("PATH=")) {
                    return var;
                }
                ++i;
            }
        }
        return null;
    }

    private String[] getEnvironmentVariables(boolean windows) {
        if (this._isTTY) {
            String[] newEnv = new String[this._envVars.length + 1];
            int i = 0;
            while (i < this._envVars.length) {
                newEnv[i] = this._envVars[i];
                ++i;
            }
            newEnv[this._envVars.length] = "PS1=$PWD/>";
            this._envVars = newEnv;
        }
        return this._envVars;
    }
}

