/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.processes.ui.dialogs;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.processes.ui.SystemProcessesResources;
import org.eclipse.rse.processes.ui.dialogs.SystemKillTableProvider;
import org.eclipse.rse.processes.ui.dialogs.SystemKillTableRow;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SystemKillDialog
extends SystemPromptDialog {
    private String warningMessage = SystemProcessesResources.RESID_KILL_WARNING_LABEL;
    private String warningTip = SystemProcessesResources.RESID_KILL_WARNING_TOOLTIP;
    private String promptLabel;
    private SystemKillTableProvider sktp;
    private Table table;
    private TableViewer tableViewer;
    private GridData tableData;
    private Combo cmbSignal;
    private String signalType;
    private String[] columnHeaders = new String[]{"", SystemProcessesResources.RESID_KILL_COLHDG_EXENAME, SystemProcessesResources.RESID_KILL_COLHDG_PID};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(150, 150, true), new ColumnWeightData(120, 120, true)};
    private static String[] tableColumnProperties = new String[]{"org.eclipse.rse.ui.ok", "org.eclipse.rse.ui.process.name", "org.eclipse.rse.ui.process.pid"};

    public SystemKillDialog(Shell shell) {
        super(shell, SystemProcessesResources.RESID_KILL_TITLE);
        super.setOkButtonLabel(SystemProcessesResources.RESID_KILL_BUTTON);
        this.setHelp("org.eclipse.rse.processes.ui.dkrp0000");
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.tableViewer.getControl();
    }

    protected Control createInner(Composite parent) {
        int height;
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        if (this.promptLabel == null) {
            Object input = this.getInputObject();
            if (input != null && input instanceof IStructuredSelection) {
                int size = ((IStructuredSelection)input).size();
                if (size > 1) {
                    SystemWidgetHelpers.createLabel((Composite)composite, (String)SystemProcessesResources.RESID_KILL_PROMPT, (int)nbrColumns);
                } else {
                    SystemWidgetHelpers.createLabel((Composite)composite, (String)SystemProcessesResources.RESID_KILL_PROMPT_SINGLE, (int)nbrColumns);
                }
            } else {
                SystemWidgetHelpers.createLabel((Composite)composite, (String)SystemProcessesResources.RESID_KILL_PROMPT, (int)nbrColumns);
            }
        } else {
            SystemWidgetHelpers.createVerbiage((Composite)composite, (String)this.promptLabel, (int)nbrColumns, (boolean)false, (int)200);
        }
        if (this.warningMessage != null) {
            SystemWidgetHelpers.createLabel((Composite)composite, (String)"", (int)nbrColumns);
            Image image = this.getShell().getDisplay().getSystemImage(8);
            Label imageLabel = null;
            if (image != null) {
                imageLabel = new Label(composite, 0);
                image.setBackground(imageLabel.getBackground());
                imageLabel.setImage(image);
                imageLabel.setLayoutData((Object)new GridData(66));
            }
            Label warningLabel = SystemWidgetHelpers.createLabel((Composite)composite, (String)this.warningMessage);
            if (this.warningTip != null) {
                warningLabel.setToolTipText(this.warningTip);
                if (imageLabel != null) {
                    imageLabel.setToolTipText(this.warningTip);
                }
            }
            GridData data = new GridData(32);
            data.widthHint = 350;
            data.grabExcessVerticalSpace = true;
            warningLabel.setLayoutData((Object)data);
            SystemWidgetHelpers.createLabel((Composite)composite, (String)"", (int)nbrColumns);
        }
        this.tableViewer = this.createTableViewer(composite, nbrColumns);
        this.createColumns();
        this.tableViewer.setColumnProperties(tableColumnProperties);
        this.sktp = new SystemKillTableProvider();
        int width = this.tableData.widthHint;
        int nbrRows = Math.min(this.getRows().length, 8);
        int rowHeight = this.table.getItemHeight() + this.table.getGridLineWidth();
        int sbHeight = this.table.getHorizontalBar().getSize().y;
        this.tableData.heightHint = height = nbrRows * rowHeight + sbHeight;
        this.table.setLayoutData((Object)this.tableData);
        this.table.setSize(width, height);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.sktp);
        this.tableViewer.setContentProvider((IContentProvider)this.sktp);
        Object input = this.getInputObject();
        this.tableViewer.setInput(input);
        this.cmbSignal = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)composite, null, (String)SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_LABEL, (String)SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_TOOLTIP);
        this.cmbSignal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemKillDialog.this.selectionChanged();
            }
        });
        this.cmbSignal.setItems(this.getSignalTypes());
        this.cmbSignal.add(SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT, 0);
        this.cmbSignal.setText(this.cmbSignal.getItem(0));
        this.signalType = this.cmbSignal.getText();
        this.cmbSignal.setLayoutData((Object)new GridData(32));
        return composite;
    }

    private String[] getSignalTypes() {
        Object selObj = this.getInputObject();
        if (selObj instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selObj;
            IRemoteProcess process = (IRemoteProcess)selection.getFirstElement();
            String[] types = null;
            try {
                types = process.getParentRemoteProcessSubSystem().getSignalTypes();
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage(), (Throwable)e);
                return new String[]{SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT};
            }
            if (types == null) {
                types = new String[]{SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT};
            }
            return types;
        }
        return new String[]{SystemProcessesResources.RESID_KILL_SIGNAL_TYPE_DEFAULT};
    }

    private TableViewer createTableViewer(Composite parent, int nbrColumns) {
        this.table = new Table(parent, 35584);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableData = new GridData();
        this.tableData.horizontalAlignment = 1;
        this.tableData.grabExcessHorizontalSpace = false;
        this.tableData.widthHint = 350;
        this.tableData.heightHint = 30;
        this.tableData.verticalAlignment = 2;
        this.tableData.grabExcessVerticalSpace = true;
        this.tableData.horizontalSpan = nbrColumns;
        this.table.setLayoutData((Object)this.tableData);
        return this.tableViewer;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
    }

    public void selectionChanged() {
        this.signalType = this.cmbSignal.getText();
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
    }

    protected boolean processOK() {
        return true;
    }

    public SystemKillTableRow[] getRows() {
        return (SystemKillTableRow[])this.sktp.getElements(this.getInputObject());
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter((Object)o);
    }

    public String getSignal() {
        if (this.cmbSignal == null) {
            return "";
        }
        if (this.cmbSignal.isDisposed()) {
            return this.signalType;
        }
        String signal = this.cmbSignal.getText();
        if (signal == null) {
            return "";
        }
        return signal;
    }
}

