/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.rse.ui.messages.SystemUIMessageFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class SystemBasePlugin
extends AbstractUIPlugin {
    private static SystemBasePlugin baseInst = null;
    protected static Logger log = null;
    private Hashtable imageDescriptorRegistry = null;
    private boolean headless;
    private boolean headlessSet;

    public static SystemBasePlugin getBaseDefault() {
        return baseInst;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SystemBasePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench wb = null;
        try {
            wb = SystemBasePlugin.getBaseDefault().getWorkbench();
        }
        catch (Exception exception) {
            wb = null;
        }
        if (wb != null) {
            if (Display.getCurrent() != null) {
                return wb.getActiveWorkbenchWindow();
            }
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows != null && windows.length > 0) {
                return windows[0];
            }
            return null;
        }
        return null;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return SystemBasePlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getIconPath() {
        return "icons/";
    }

    public static ImageDescriptor getPluginImage(Bundle bundle, String fileName) {
        URL path = bundle.getEntry("/" + fileName);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)path);
        return descriptor;
    }

    public static final URL resolveBundleNameNL(Bundle bundle, String name) {
        URL result = null;
        Stack<String> candidates = new Stack<String>();
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        candidates.push("/" + name);
        if (language.length() > 0) {
            candidates.push("/" + language + "/" + name);
            if (country.length() > 0) {
                candidates.push("/" + language + "/" + country + "/" + name);
            }
        }
        while (!candidates.isEmpty() && result == null) {
            String candidate = (String)candidates.pop();
            result = bundle.getEntry(candidate);
        }
        return result;
    }

    public static final SystemMessageFile loadMessageFile(Bundle bundle, String fileName) {
        SystemUIMessageFile mf = null;
        boolean ok = false;
        try {
            URL url = SystemBasePlugin.resolveBundleNameNL(bundle, fileName);
            if (url != null) {
                InputStream messageFileStream = url.openStream();
                mf = SystemUIMessageFile.getMessageFile(fileName, messageFileStream);
                messageFileStream.close();
                ok = true;
            }
        }
        catch (Throwable t) {
            SystemBasePlugin.logError("Error loading message file " + fileName + " in " + bundle.getHeaders().get("Bundle-Name"), t);
            ok = false;
        }
        if (!ok) {
            MessageBox mb = new MessageBox(SystemBasePlugin.getActiveWorkbenchShell());
            mb.setText("Unexpected Error");
            mb.setMessage("Unable to load message file " + fileName + " in " + bundle.getHeaders().get("Bundle-Name"));
            mb.open();
        }
        return mf;
    }

    public static final SystemMessageFile loadDefaultMessageFile(Bundle bundle, String fileName) {
        SystemUIMessageFile mf = null;
        boolean ok = false;
        try {
            URL url = bundle.getEntry("/" + fileName);
            if (url != null) {
                InputStream messageFileStream = url.openStream();
                mf = SystemUIMessageFile.getMessageFile(fileName, messageFileStream);
                messageFileStream.close();
                ok = true;
            }
        }
        catch (Throwable t) {
            SystemBasePlugin.logError("Error loading message file " + fileName + " in " + bundle.getHeaders().get("Bundle-Name"), t);
            ok = false;
        }
        if (!ok) {
            Shell s = SystemBasePlugin.getActiveWorkbenchShell();
            if (s == null) {
                Display d = Display.getCurrent();
                if (d != null) {
                    s = d.getActiveShell();
                } else {
                    d = Display.getDefault();
                    if (d != null) {
                        s = d.getActiveShell();
                    }
                }
            }
            if (s != null) {
                MessageBox mb = new MessageBox(s);
                mb.setText("Unexpected Error");
                mb.setMessage("Unable to load message file " + fileName + " in " + bundle.getHeaders().get("Bundle-Name"));
                mb.open();
            }
        }
        return mf;
    }

    public static SystemMessage getMessage(SystemMessageFile msgFile, String msgId) {
        SystemMessage msg = null;
        if (msgFile != null) {
            msg = msgFile.getMessage(msgId);
        } else {
            SystemBasePlugin.logWarning("No message file set.");
        }
        if (msg == null) {
            SystemBasePlugin.logWarning("Unable to find message ID: " + msgId);
        }
        return msg;
    }

    public static boolean scanForDuplicateMessages(SystemMessageFile msgFile) {
        return msgFile.scanForDuplicates();
    }

    public static boolean printMessages(SystemMessageFile msgFile, String fullyQualifiedTargetFile) {
        return msgFile.printHTML(fullyQualifiedTargetFile);
    }

    public static void logMessage(SystemMessage message) {
        SystemBasePlugin.logMessage(message, null);
    }

    public static void logMessage(SystemMessage message, Throwable ex) {
        char type = message.getIndicator();
        switch (type) {
            case 'E': {
                log.logError(message.toString(), ex);
                break;
            }
            case 'W': {
                log.logWarning(message.toString(), ex);
                break;
            }
            case 'C': 
            case 'I': {
                log.logInfo(message.toString(), ex);
                break;
            }
            default: {
                log.logInfo(message.toString(), ex);
            }
        }
    }

    public static void logInfo(String message) {
        log.logInfo(message);
    }

    public static void logWarning(String message) {
        log.logWarning(message);
    }

    public static void logError(String message) {
        log.logError(message, null);
    }

    public static void logError(String message, Throwable exception) {
        log.logError(message, exception);
    }

    public static void logDebugMessage(String prefix, String message) {
        log.logDebugMessage(prefix, message);
    }

    public SystemBasePlugin() {
        if (baseInst == null) {
            baseInst = this;
        }
        this.headless = false;
        this.headlessSet = false;
    }

    public String getSymbolicName() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (log == null) {
            log = LoggerFactory.getLogger((Plugin)this);
            log.logInfo("Loading " + ((Object)((Object)this)).getClass());
        }
    }

    public void stop(BundleContext context) throws Exception {
        SystemBasePlugin.logDebugMessage(((Object)((Object)this)).getClass().getName(), "SHUTDOWN");
        LoggerFactory.freeLogger((Plugin)this);
        super.stop(context);
    }

    public IWorkbench getWorkbench() {
        IWorkbench wb = null;
        if (this.headlessSet && this.headless) {
            return wb;
        }
        try {
            wb = PlatformUI.getWorkbench();
            this.headless = false;
        }
        catch (Exception exception) {
            this.headless = true;
        }
        this.headlessSet = true;
        return wb;
    }

    protected abstract void initializeImageRegistry();

    protected ImageDescriptor putImageInRegistry(String id, String fileName) {
        ImageDescriptor fid = this.getPluginImage(fileName);
        Hashtable t = this.getImageDescriptorRegistry();
        t.put(id, fid);
        return fid;
    }

    public ImageDescriptor getPluginImage(String imagePath) {
        return SystemBasePlugin.getPluginImage(this.getBundle(), imagePath);
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            if (descriptor != null) {
                imageRegistry.put(key, descriptor);
                image = imageRegistry.get(key);
            } else {
                SystemBasePlugin.logError("...error retrieving image for key: " + key);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        Hashtable t = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = (ImageDescriptor)t.get(key);
        return descriptor;
    }

    private Hashtable getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new Hashtable();
            this.initializeImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public ImageDescriptor getImageDescriptorFromIDE(String relativePath) {
        Hashtable registry = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = (ImageDescriptor)registry.get(relativePath);
        if (descriptor == null) {
            String iconPath = "icons/full/";
            String key = String.valueOf(iconPath) + relativePath;
            String[] bundleNames = new String[]{"org.eclipse.ui", "org.eclipse.ui.ide"};
            int i = 0;
            while (i < bundleNames.length && descriptor == null) {
                String bundleName = bundleNames[i];
                Bundle bundle = Platform.getBundle((String)bundleName);
                URL url = bundle.getResource(key);
                if (url != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)url);
                }
                ++i;
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            registry.put(relativePath, descriptor);
        }
        return descriptor;
    }

    public Logger getLogger() {
        return log;
    }

    public boolean isHeadless() {
        if (!this.headlessSet) {
            this.getWorkbench();
        }
        return this.headless;
    }
}

