/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemChangePasswordDialog
extends SystemPromptDialog {
    private String _hostname;
    private String _user;
    private String _newPassword = "";
    private Text _txtNewPassword;
    private Text _txtConfirmPassword;
    private boolean savePassword = false;
    protected Button _chkBoxSavePassword;
    private boolean newPasswordModified = false;
    private boolean confirmModified = false;

    public SystemChangePasswordDialog(Shell shell, String hostname, String userid, SystemMessage msg) {
        super(shell, SystemResources.RESID_CHANGE_PASSWORD_TITLE, false);
        this._hostname = hostname;
        this._user = userid;
        this.setErrorMessage(msg);
    }

    protected Control getInitialFocusControl() {
        return this._txtNewPassword;
    }

    protected Control createInner(Composite parent) {
        Label label = null;
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        c.setLayout((Layout)layout);
        label = new Label(c, 0);
        label.setText(SystemResources.RESID_PREF_SIGNON_HOSTNAME_LABEL);
        Text system = SystemWidgetHelpers.createTextField(c, null);
        system.setText(this._hostname);
        system.setEditable(false);
        system.setEnabled(false);
        system.setToolTipText(SystemResources.RESID_PREF_SIGNON_HOSTNAME_TOOLTIP);
        ((GridData)system.getLayoutData()).widthHint = 75;
        label = new Label(c, 0);
        label.setText(SystemResources.RESID_PREF_SIGNON_USERID_LABEL);
        Text userID = SystemWidgetHelpers.createTextField(c, null);
        userID.setText(this._user);
        userID.setEditable(false);
        userID.setEnabled(false);
        userID.setToolTipText(SystemResources.RESID_PREF_SIGNON_USERID_TOOLTIP);
        ((GridData)userID.getLayoutData()).widthHint = 75;
        label = new Label(c, 0);
        label.setText(SystemResources.RESID_CHANGE_PASSWORD_NEW_LABEL);
        this._txtNewPassword = SystemWidgetHelpers.createTextField(c, null);
        this._txtNewPassword.setEchoChar('*');
        this._txtNewPassword.setToolTipText(SystemResources.RESID_CHANGE_PASSWORD_NEW_TOOLTIP);
        ((GridData)this._txtNewPassword.getLayoutData()).widthHint = 75;
        label = new Label(c, 0);
        label.setText(SystemResources.RESID_CHANGE_PASSWORD_CONFIRM_LABEL);
        this._txtConfirmPassword = SystemWidgetHelpers.createTextField(c, null);
        this._txtConfirmPassword.setEchoChar('*');
        this._txtConfirmPassword.setToolTipText(SystemResources.RESID_CHANGE_PASSWORD_CONFIRM_TOOLTIP);
        ((GridData)this._txtConfirmPassword.getLayoutData()).widthHint = 75;
        this._chkBoxSavePassword = SystemWidgetHelpers.createCheckBox(c, 1, this, SystemResources.RESID_PASSWORD_SAVE_LABEL, SystemResources.RESID_PASSWORD_SAVE_TOOLTIP);
        this._chkBoxSavePassword.setSelection(this.savePassword);
        this._chkBoxSavePassword.setEnabled(false);
        this._txtNewPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemChangePasswordDialog.this.newPasswordModified = true;
                SystemChangePasswordDialog.this.validatePasswordInput();
            }
        });
        this._txtConfirmPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemChangePasswordDialog.this.confirmModified = true;
                SystemChangePasswordDialog.this.validatePasswordInput();
            }
        });
        this.setInitialOKButtonEnabledState(false);
        return parent;
    }

    private boolean internalGetIsSavePassword() {
        this.savePassword = this._chkBoxSavePassword.getSelection();
        return this.savePassword;
    }

    protected SystemMessage validatePasswordInput() {
        this.clearErrorMessage();
        this._chkBoxSavePassword.setEnabled(this.newPasswordModified || this.confirmModified);
        if (!this.newPasswordModified || !this.confirmModified) {
            return null;
        }
        this.okButton.setEnabled(true);
        String newPassword = this._txtNewPassword.getText().trim();
        String confirmPassword = this._txtConfirmPassword.getText().trim();
        if (!newPassword.equals(confirmPassword)) {
            return RSEUIPlugin.getPluginMessage("RSEC2102");
        }
        if (newPassword.equals("")) {
            return RSEUIPlugin.getPluginMessage("RSEC2103");
        }
        this._newPassword = newPassword;
        return null;
    }

    protected boolean processOK() {
        this.savePassword = this.internalGetIsSavePassword();
        SystemMessage error = this.validatePasswordInput();
        if (error == null) {
            return true;
        }
        this.setErrorMessage(error);
        return false;
    }

    public String getNewPassword() {
        return this._newPassword;
    }

    public boolean getIsSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean save) {
        this.savePassword = save;
    }
}

