/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.ISignonValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SystemPasswordPromptDialog
extends SystemPromptDialog
implements ISystemPasswordPromptDialog {
    private Text textPassword;
    private Text textUserId;
    private Button userIdPermanentCB;
    private Button savePasswordCB;
    private String originalUserId;
    private String userId;
    private String password;
    private boolean userIdPermanent = false;
    private boolean savePassword = false;
    private boolean forceToUpperCase;
    private boolean userIdChanged = false;
    private boolean validate = true;
    private ISystemValidator userIdValidator;
    private ISystemValidator passwordValidator;
    private ISignonValidator signonValidator;
    private IConnectorService connectorService = null;

    public SystemPasswordPromptDialog(Shell shell) {
        super(shell, SystemResources.RESID_PASSWORD_TITLE);
        this.setHelp("org.eclipse.rse.ui.pwdp0000");
    }

    public void setSystemInput(IConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public void setUserIdValidator(ISystemValidator v) {
        this.userIdValidator = v;
    }

    public void setPasswordValidator(ISystemValidator v) {
        this.passwordValidator = v;
    }

    public void setSignonValidator(ISignonValidator v) {
        this.signonValidator = v;
    }

    public void setForceToUpperCase(boolean force) {
        this.forceToUpperCase = force;
    }

    public boolean getForceToUpperCase() {
        return this.forceToUpperCase;
    }

    protected Control createInner(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Composite composite_prompts = SystemWidgetHelpers.createComposite(composite, 2);
        String text = SystemWidgetHelpers.appendColon(SystemResources.RESID_PASSWORD_SYSTEMTYPE_LABEL);
        Label label = SystemWidgetHelpers.createLabel(composite_prompts, text);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        label = SystemWidgetHelpers.createLabel(composite_prompts, this.connectorService.getHostType());
        gd = new GridData();
        label.setLayoutData((Object)gd);
        text = SystemWidgetHelpers.appendColon(SystemResources.RESID_PASSWORD_HOSTNAME_LABEL);
        label = SystemWidgetHelpers.createLabel(composite_prompts, text);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label = SystemWidgetHelpers.createLabel(composite_prompts, this.connectorService.getHostName());
        gd = new GridData();
        label.setLayoutData((Object)gd);
        if (this.connectorService.supportsUserId()) {
            this.textUserId = SystemWidgetHelpers.createLabeledTextField(composite_prompts, this, SystemResources.RESID_PASSWORD_USERID_LABEL, SystemResources.RESID_PASSWORD_USERID_TIP);
        }
        if (this.connectorService.supportsPassword()) {
            this.textPassword = SystemWidgetHelpers.createLabeledTextField(composite_prompts, this, SystemResources.RESID_PASSWORD_LABEL, SystemResources.RESID_PASSWORD_TIP);
            this.textPassword.setEchoChar('*');
        }
        if (this.connectorService.supportsUserId()) {
            SystemWidgetHelpers.createLabel(composite_prompts, "");
            this.userIdPermanentCB = SystemWidgetHelpers.createCheckBox(composite_prompts, 1, this, SystemResources.RESID_PASSWORD_USERID_ISPERMANENT_LABEL, SystemResources.RESID_PASSWORD_USERID_ISPERMANENT_TIP);
            this.userIdPermanentCB.setEnabled(false);
        }
        if (this.connectorService.supportsPassword()) {
            SystemWidgetHelpers.createLabel(composite_prompts, "");
            this.savePasswordCB = SystemWidgetHelpers.createCheckBox(composite_prompts, 1, this, SystemResources.RESID_PASSWORD_SAVE_LABEL, SystemResources.RESID_PASSWORD_SAVE_TOOLTIP);
            this.savePasswordCB.setSelection(this.savePassword);
        }
        this.initializeInput();
        if (this.textUserId != null) {
            this.textUserId.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemPasswordPromptDialog.this.processUserIdField();
                }
            });
        }
        if (this.textPassword != null) {
            this.textPassword.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemPasswordPromptDialog.this.processPasswordField();
                }
            });
        }
        return composite;
    }

    protected Control getInitialFocusControl() {
        this.okButton.setEnabled(true);
        this.processUserIdField();
        if (this.textUserId != null && (this.userId.length() == 0 || this.textPassword == null)) {
            return this.textUserId;
        }
        if (this.textPassword != null) {
            this.textPassword.selectAll();
            return this.textPassword;
        }
        if (this.okButton.isEnabled()) {
            return this.okButton;
        }
        return this.cancelButton;
    }

    private void initializeInput() {
        this.userId = this.originalUserId = this.connectorService.getUserId();
        if (this.connectorService.supportsUserId() && (this.userId == null || this.userId.length() == 0)) {
            this.userId = SystemPreferencesManager.getPreferencesManager().getDefaultUserId(this.connectorService.getHostType());
        }
        if (this.textUserId != null && this.userId != null) {
            this.textUserId.setText(this.userId);
            this.textUserId.setSelection(0, this.userId.length());
        }
        if (this.textPassword != null && this.password != null) {
            this.textPassword.setText(this.password);
            this.textPassword.setSelection(0, this.password.length());
        }
    }

    private void internalGetUserId() {
        if (this.textUserId != null) {
            this.userId = this.textUserId.getText().trim();
        }
    }

    private void internalGetPassword() {
        if (this.textPassword != null) {
            this.password = this.textPassword.getText().trim();
        }
    }

    private void internalGetIsUserIdChangePermanent() {
        if (this.userIdPermanentCB != null) {
            this.userIdPermanent = this.userIdPermanentCB.isEnabled() && this.userIdPermanentCB.getSelection();
        }
    }

    private void internalGetIsSavePassword() {
        if (this.savePasswordCB != null) {
            this.savePassword = this.savePasswordCB.isEnabled() && this.savePasswordCB.getSelection();
        }
    }

    private void processUserIdField() {
        this.clearErrorMessage();
        SystemMessage m = this.checkUserId();
        if (m == null) {
            m = this.checkPassword();
        }
        if (m != null) {
            this.setErrorMessage(m);
        }
        this.okButton.setEnabled(m == null);
        if (this.userId == null || this.originalUserId == null) {
            this.userIdChanged = this.userId != this.originalUserId;
        } else {
            boolean bl = this.userIdChanged = !this.userId.equals(this.originalUserId);
        }
        if (this.userIdPermanentCB != null) {
            this.userIdPermanentCB.setEnabled(this.userIdChanged);
        }
    }

    private SystemMessage checkUserId() {
        this.internalGetUserId();
        SystemMessage m = null;
        if (this.connectorService.supportsUserId() && this.validate) {
            if (this.userIdValidator != null) {
                m = this.userIdValidator.validate(this.userId);
            } else if (this.connectorService.requiresUserId() && this.userId.length() == 0) {
                m = RSEUIPlugin.getPluginMessage("RSEG1025");
            }
        }
        return m;
    }

    private void processPasswordField() {
        this.clearErrorMessage();
        SystemMessage m = this.checkPassword();
        if (m == null) {
            m = this.checkUserId();
        }
        if (m != null) {
            this.setErrorMessage(m);
        }
        this.okButton.setEnabled(m == null);
        if (this.savePasswordCB != null) {
            this.savePasswordCB.setEnabled(!this.connectorService.requiresPassword() || this.password.length() != 0);
        }
    }

    private SystemMessage checkPassword() {
        this.internalGetPassword();
        SystemMessage m = null;
        if (this.connectorService.supportsPassword() && this.validate) {
            if (this.passwordValidator != null) {
                m = this.passwordValidator.validate(this.password);
            } else if (this.connectorService.requiresPassword() && this.password.length() == 0) {
                m = RSEUIPlugin.getPluginMessage("RSEG1035");
            }
        }
        return m;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getIsUserIdChanged() {
        return this.userIdChanged;
    }

    public boolean getIsUserIdChangePermanent() {
        return this.userIdPermanent;
    }

    public boolean getIsSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean save) {
        this.savePassword = save;
    }

    private void verify() {
        Text controlInError = null;
        this.processUserIdField();
        if (this.getErrorMessage() != null) {
            controlInError = this.textUserId;
        } else {
            this.processPasswordField();
            if (this.getErrorMessage() != null) {
                controlInError = this.textPassword;
            }
        }
        if (controlInError != null) {
            controlInError.setFocus();
        }
    }

    protected boolean processOK() {
        this.setBusyCursor(true);
        this.internalGetPassword();
        this.internalGetUserId();
        this.internalGetIsUserIdChangePermanent();
        this.internalGetIsSavePassword();
        if (this.forceToUpperCase) {
            this.userId = this.userId.toUpperCase();
            this.password = this.password.toUpperCase();
            this.validate = false;
            this.textUserId.setText(this.userId);
            this.textPassword.setText(this.password);
            this.validate = true;
        }
        this.verify();
        this.setBusyCursor(false);
        if (this.getErrorMessage() == null && this.signonValidator != null) {
            SystemMessage m = this.signonValidator.isValid(this, this.userId, this.password);
            this.setErrorMessage(m);
        }
        boolean closeDialog = this.getErrorMessage() == null;
        return closeDialog;
    }
}

