/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.dstore.old;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.subsystems.files.dstore.old.StatusChangeListener;
import org.eclipse.swt.widgets.Shell;

public class FileTransferStatusListener
extends StatusChangeListener {
    protected String _remotePath;
    protected DataElement _log;
    protected DataElement _statusElement;

    public FileTransferStatusListener(String remotePath, Shell shell, IProgressMonitor monitor, IConnectorService system, DataStore ds, DataElement uploadLog) throws Exception {
        super(shell, monitor, system);
        this._remotePath = remotePath.replace('\\', '/');
        this._log = uploadLog;
        if (this._log == null) {
            throw new Exception("Could not find log in DataStore.");
        }
        this.setStatus(this.findOrCreateUploadStatus(ds));
    }

    protected DataElement findOrCreateUploadStatus(DataStore ds) {
        DataElement result = ds.find(this._log, 2, this._remotePath, 1);
        if (result == null) {
            result = this._log.getDataStore().createObject(this._log, "uploadstatus", this._remotePath);
            result.setAttribute(4, "running");
            result.setAttribute(3, "");
            DataElement cmd = ds.findCommandDescriptor("C_SET");
            ds.command(cmd, this._log, true);
        } else {
            result.setAttribute(4, "running");
            result.setAttribute(3, "");
        }
        this._statusElement = result;
        return result;
    }

    protected boolean determineStatusDone() {
        return this.getStatus().getAttribute(4).equals("success") || this.getStatus().getAttribute(4).equals("failed");
    }

    public boolean uploadHasFailed() {
        return this.getStatus().getAttribute(4).equals("failed");
    }

    public String getErrorMessage() {
        return this.getStatus().getAttribute(3);
    }

    public String getRemotePath() {
        return this._remotePath;
    }

    public void setRemotePath(String remotePath) {
        this._remotePath = remotePath;
    }
}

