/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging.ui;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.rse.logging.ui.LabelUtil;
import org.eclipse.rse.logging.ui.LoggingPreferenceLabels;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public abstract class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button radioButton0;
    private Button radioButton1;
    private Button radioButton2;
    private Button radioButton3;

    private Composite createComposite(Composite parent, int span, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Group createGroup(Composite parent, int span, int numColumns, String text) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        group.setLayoutData((Object)data);
        group.setText(text);
        return group;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite_tab = this.createComposite(parent, 1, 1);
        String topLabel2 = LoggingPreferenceLabels.LOGGING_PREFERENCE_PAGE_TOPLABEL2;
        Group group1 = this.createGroup(composite_tab, 1, 1, topLabel2);
        Set used = LabelUtil.usedFromString("ad");
        String text = LoggingPreferenceLabels.LOGGING_PREFERENCE_PAGE_ERRORS_ONLY;
        this.radioButton0 = this.createRadioButton((Composite)group1, LabelUtil.assignMnemonic(text, used));
        text = LoggingPreferenceLabels.LOGGING_PREFERENCE_PAGE_WARNINGS_ERRORS;
        this.radioButton1 = this.createRadioButton((Composite)group1, LabelUtil.assignMnemonic(text, used));
        text = LoggingPreferenceLabels.LOGGING_PREFERENCE_PAGE_INFO_DEBUG;
        this.radioButton2 = this.createRadioButton((Composite)group1, LabelUtil.assignMnemonic(text, used));
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.rse.logging.rsel0000");
        return composite_tab;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            AbstractUIPlugin plugin = this.getPlugin();
            if (plugin != null) {
                return plugin.getPreferenceStore();
            }
            return new PreferenceStore();
        }
        return new PreferenceStore();
    }

    protected abstract AbstractUIPlugin getPlugin();

    private Bundle getBundle() {
        AbstractUIPlugin plugin = this.getPlugin();
        Bundle bundle = plugin.getBundle();
        return bundle;
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.radioButton0.setSelection(false);
        this.radioButton1.setSelection(false);
        this.radioButton2.setSelection(false);
        if (this.radioButton3 != null) {
            this.radioButton3.setSelection(false);
        }
        int choice = store.getInt("debug_level");
        switch (choice) {
            case 0: {
                this.radioButton0.setSelection(true);
                break;
            }
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                if (this.radioButton3 != null) {
                    this.radioButton3.setSelection(true);
                    break;
                }
                this.radioButton2.setSelection(true);
            }
        }
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.radioButton0.setSelection(false);
        this.radioButton1.setSelection(false);
        this.radioButton2.setSelection(false);
        if (this.radioButton3 != null) {
            this.radioButton3.setSelection(false);
        }
        int choice = store.getDefaultInt("debug_level");
        switch (choice) {
            case 0: {
                this.radioButton0.setSelection(true);
                break;
            }
            case 1: {
                this.radioButton1.setSelection(true);
                break;
            }
            case 2: {
                this.radioButton2.setSelection(true);
                break;
            }
            case 3: {
                if (this.radioButton3 != null) {
                    this.radioButton3.setSelection(true);
                    break;
                }
                this.radioButton2.setSelection(true);
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        int choice = 0;
        if (this.radioButton1.getSelection()) {
            choice = 1;
        } else if (this.radioButton2.getSelection()) {
            choice = 2;
        } else if (this.radioButton3 != null && this.radioButton3.getSelection()) {
            choice = 3;
        }
        store.setValue("debug_level", choice);
    }
}

