/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.resources;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.SystemAdapterHelpers;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.widgets.SystemSelectRemoteFileOrFolderForm;
import org.eclipse.rse.filters.SystemFilterSimple;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ValidatorArchiveName;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CombineForm
extends SystemSelectRemoteFileOrFolderForm {
    protected Text fileNameText;
    protected Combo fileTypeCombo;
    protected Label nameAndTypeLabel;
    protected String fileName;
    protected String fileType;
    protected String initialFileName;
    protected ValidatorFileName validator = new ValidatorFileName();
    protected ValidatorArchiveName arcvalidator = new ValidatorArchiveName();
    protected boolean prePop;
    protected String nameAndTypePrompt = "";
    protected String[] disallowedExtensions;

    public CombineForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        super(msgLine, caller, fileMode);
        this.prePop = false;
    }

    public CombineForm(ISystemMessageLine msgLine, Object caller, boolean fileMode, boolean prePopSelection) {
        super(msgLine, caller, fileMode);
        this.prePop = prePopSelection;
    }

    public Control createContents(Shell shell, Composite parent) {
        Control control = super.createContents(shell, parent);
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        this.nameAndTypeLabel = SystemWidgetHelpers.createLabel((Composite)composite, (String)this.nameAndTypePrompt);
        Composite subcomp1 = SystemWidgetHelpers.createComposite((Composite)composite, (int)2);
        this.fileNameText = SystemWidgetHelpers.createLabeledTextField((Composite)subcomp1, null, (String)FileResources.RESID_COMBINE_NAME_LABEL, (String)FileResources.RESID_COMBINE_NAME_TOOLTIP);
        this.fileTypeCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)subcomp1, null, (String)FileResources.RESID_COMBINE_TYPE_LABEL, (String)FileResources.RESID_COMBINE_TYPE_TOOLTIP);
        String[] allowedExtensions = this.getAllowedArchiveExtensions();
        if (allowedExtensions != null && allowedExtensions.length != 0) {
            this.fileTypeCombo.setItems(allowedExtensions);
            this.fileTypeCombo.select(0);
            this.fileType = this.fileTypeCombo.getText();
        }
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemMessage isValidMsg;
                CombineForm.this.fileName = CombineForm.this.fileNameText.getText();
                CombineForm.this.setPageComplete();
                if (CombineForm.this.fileName.indexOf(".") != -1 && (isValidMsg = CombineForm.this.arcvalidator.validate(CombineForm.this.fileName)) == null) {
                    int i = CombineForm.this.fileName.lastIndexOf(".");
                    CombineForm.this.fileType = CombineForm.this.fileName.substring(i + 1);
                    CombineForm.this.fileTypeCombo.setText(CombineForm.this.fileType);
                }
            }
        });
        this.fileTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CombineForm.this.fileType = CombineForm.this.fileTypeCombo.getText();
                CombineForm.this.setPageComplete();
            }
        });
        if (this.fileName != null) {
            this.fileNameText.setText(this.fileName);
        }
        return control;
    }

    protected String[] getAllowedArchiveExtensions() {
        String[] allExtensions = ArchiveHandlerManager.getInstance().getRegisteredExtensions();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < allExtensions.length) {
            String extension = allExtensions[i];
            boolean keep = true;
            int j = 0;
            while (j < this.disallowedExtensions.length) {
                if (this.disallowedExtensions[j].toLowerCase().equals(extension)) {
                    keep = false;
                    break;
                }
                ++j;
            }
            if (keep) {
                list.add(extension);
            }
            ++i;
        }
        String[] allowedExtensions = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            allowedExtensions[i2] = (String)list.get(i2);
            ++i2;
        }
        return allowedExtensions;
    }

    public String[] getDisallowedArchiveExtensions() {
        return this.disallowedExtensions;
    }

    public void setDisallowedArchiveExtensions(String[] extensions) {
        this.disallowedExtensions = extensions;
    }

    public boolean verify() {
        boolean ok = super.verify();
        if (ok) {
            IRemoteFile file = (IRemoteFile)this.getSelectedObject();
            try {
                file.getParentRemoteFileSubSystem().getRemoteFileObject(file, this.getFileName());
            }
            catch (Exception exception) {}
        }
        return ok;
    }

    public boolean isPageComplete() {
        String nameToCheck = null;
        nameToCheck = this.fileName == null ? "" : this.fileName;
        SystemMessage errMsg = this.validator.validate(nameToCheck);
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        this.clearErrorMessage();
        return this.fileTypeCombo != null && this.fileTypeCombo.getText().length() > 0 && this.fileNameText != null && this.fileNameText.getText().length() > 0 && super.isPageComplete();
    }

    public String getFileName() {
        if (this.fileName.endsWith("." + this.fileType)) {
            return this.fileName;
        }
        return String.valueOf(this.fileName) + "." + this.fileType;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getAdapter((Object)o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        super.selectionChanged(e);
        this.clearErrorMessage();
        ISelection selection = e.getSelection();
        Object selectedObject = this.getFirstSelection(e.getSelection());
        if (selectedObject != null && selectedObject instanceof IRemoteFile) {
            IRemoteFile parentFile;
            IRemoteFile remoteFile = (IRemoteFile)selectedObject;
            ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(selectedObject);
            if (remoteAdapter != null && (remoteAdapter = this.getRemoteAdapter(parentFile = remoteFile)) != null) {
                String fullPath = remoteAdapter.getAbsoluteName((Object)parentFile);
                this.setNameText(fullPath);
                this.outputObjects = new Object[]{parentFile};
                this.setPageComplete();
                SystemMessage selectionMsg = null;
                if (this.selectionValidator != null) {
                    selectionMsg = this.selectionValidator.isValid(this.outputConnection, this.getSelections(selection), this.getRemoteAdapters(selection));
                }
                if (selectionMsg != null) {
                    this.valid = false;
                    this.setErrorMessage(selectionMsg);
                    this.setPageComplete();
                }
            }
        }
    }

    public void setPreSelection(IRemoteFile selection) {
        IRemoteFile parentFile;
        if (selection.isDirectory()) {
            super.setPreSelection(selection);
        } else if (selection.isFile() && (parentFile = selection.getParentRemoteFile()).isDirectory()) {
            super.setPreSelection(parentFile);
        }
        if (this.prePop) {
            String file = selection.getName();
            int i = file.lastIndexOf(".");
            if (i == -1) {
                this.fileName = file;
                this.fileType = "";
            } else {
                this.fileName = file.substring(0, i);
                this.fileType = selection.getExtension();
            }
        } else {
            this.fileName = "";
        }
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        int filterCount;
        this.setDefaultConnection(connection);
        this.setShowNewConnectionPrompt(true);
        this.setAutoExpandDepth(0);
        RSEUIPlugin.getTheSystemRegistry();
        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)connection);
        IRemoteFileSubSystemConfiguration ssf = ss.getParentRemoteFileSubSystemConfiguration();
        RemoteFileFilterString rffs = new RemoteFileFilterString(ssf);
        rffs.setShowFiles(this.fileMode);
        rffs.setShowSubDirs(!this.fileMode || !this.filesOnlyMode);
        if (this.fileTypes != null) {
            rffs.setFile(this.fileTypes);
        }
        String filterName = null;
        SystemFilterSimple filter = null;
        int n = filterCount = this.showRootFilter ? 2 : 1;
        if (this.preSelectRoot) {
            filterCount = 1;
        }
        ISystemFilter[] filters = new ISystemFilter[filterCount];
        int idx = 0;
        if (this.showRootFilter) {
            filterName = ssf.isUnixStyle() ? (!this.preSelectRoot ? (this.fileMode ? SystemFileResources.RESID_FILTER_ROOTFILES : SystemFileResources.RESID_FILTER_ROOTFOLDERS) : SystemFileResources.RESID_FILTER_ROOTS) : (this.fileMode ? SystemFileResources.RESID_FILTER_DRIVES : SystemFileResources.RESID_FILTER_DRIVES);
            filter = new SystemFilterSimple(filterName);
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx++] = filter;
            if (this.preSelectRoot) {
                this.preSelectFilter = filter;
                this.preSelectFilterChild = folderAbsolutePath;
            }
        }
        if (!this.preSelectRoot) {
            rffs.setPath(folderAbsolutePath);
            filter = new SystemFilterSimple(rffs.toStringNoSwitches());
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx] = filter;
            this.preSelectFilter = filter;
        }
        this.inputProvider.setFilterString(null);
        this.inputProvider.setQuickFilters(filters);
    }

    public void setPrePopSelection(boolean prePopSelection) {
        this.prePop = prePopSelection;
    }

    public void setNameAndTypePrompt(String prompt) {
        this.nameAndTypePrompt = prompt;
    }
}

