/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class Mnemonics {
    private static final String[] TransparentEndings = new String[]{"...", ">>", "<<", ">", "<", ":", "\uff0e\uff0e\uff0e", "\uff1e\uff1e", "\uff1c\uff1c", "\uff1e", "\uff1c", "\uff1a"};
    private StringBuffer mnemonics = new StringBuffer();
    private static final String candidateChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private String preferencePageMnemonics = null;
    private String wizardPageMnemonics = null;
    public static final char MNEMONIC_CHAR = '&';
    private boolean onPrefPage = false;
    private boolean onWizardPage = false;
    private boolean applyMnemonicsToPrecedingLabels = true;

    public void clear() {
        this.mnemonics = new StringBuffer();
    }

    private static void insertMnemonic(StringBuffer label, String mnemonic) {
        int p = label.length();
        while (p > 0 && label.charAt(p - 1) == ' ') {
            --p;
        }
        int i = 0;
        while (i < TransparentEndings.length) {
            String labelEnding;
            String transparentEnding = TransparentEndings[i];
            int l = transparentEnding.length();
            int n = p - l;
            if (n >= 0 && (labelEnding = label.substring(n, n + l)).equals(transparentEnding)) {
                p = n;
                break;
            }
            ++i;
        }
        while (p > 0 && label.charAt(p - 1) == ' ') {
            --p;
        }
        if (p > 0) {
            label.insert(p, mnemonic);
        }
    }

    public String setUniqueMnemonic(String label) {
        int labelLen = (label = Mnemonics.removeMnemonic(label)).length();
        if (labelLen == 0) {
            return label;
        }
        if (labelLen == 1 && label.equals("?")) {
            return label;
        }
        StringBuffer newLabel = new StringBuffer(label);
        int mcharPos = this.findUniqueMnemonic(label);
        if (mcharPos != -1) {
            newLabel.insert(mcharPos, '&');
        } else {
            mcharPos = this.findUniqueMnemonic(candidateChars);
            if (mcharPos != -1) {
                String addedMnemonic = "(&" + candidateChars.charAt(mcharPos) + ")";
                Mnemonics.insertMnemonic(newLabel, addedMnemonic);
            }
        }
        return newLabel.toString();
    }

    public static String applyMnemonic(String label, char mnemonicChar) {
        int labelLen = label.length();
        if (labelLen == 0) {
            return label;
        }
        StringBuffer newLabel = new StringBuffer(label);
        int mcharPos = Mnemonics.findCharPos(label, mnemonicChar);
        if (mcharPos != -1) {
            newLabel.insert(mcharPos, '&');
        } else {
            String addedMnemonic = new String("(&" + mnemonicChar + ")");
            Mnemonics.insertMnemonic(newLabel, addedMnemonic);
        }
        return newLabel.toString();
    }

    private static int findCharPos(String label, char charToFind) {
        int pos = -1;
        int idx = 0;
        while (pos == -1 && idx < label.length()) {
            if (label.charAt(idx) == charToFind) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public boolean isUniqueMnemonic(char currchar) {
        boolean isUnique = true;
        int idx = 0;
        while (isUnique && idx < this.mnemonics.length()) {
            if (this.mnemonics.charAt(idx) == currchar) {
                isUnique = false;
            }
            ++idx;
        }
        return isUnique;
    }

    public int findUniqueMnemonic(String label) {
        int labelLen = label.length();
        if (labelLen == 0) {
            return -1;
        }
        int retcharPos = -1;
        label = label.toUpperCase();
        char currchar = label.charAt(0);
        boolean isUnique = false;
        if (this.onPrefPage && this.preferencePageMnemonics == null) {
            this.preferencePageMnemonics = this.getPreferencePageMnemonics();
        }
        if (this.onWizardPage && this.wizardPageMnemonics == null) {
            this.wizardPageMnemonics = this.getWizardPageMnemonics();
        }
        int idx = 0;
        while (idx < labelLen && retcharPos == -1) {
            currchar = label.charAt(idx);
            if (!(this.onPrefPage && this.preferencePageMnemonics.indexOf(currchar) != -1 || this.onWizardPage && this.wizardPageMnemonics.indexOf(currchar) != -1 || candidateChars.indexOf(currchar) == -1 || !(isUnique = this.isUniqueMnemonic(currchar)))) {
                this.mnemonics.append(currchar);
                retcharPos = idx;
            }
            ++idx;
        }
        return retcharPos;
    }

    private String getPreferencePageMnemonics() {
        String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
        return this.getMnemonicsFromStrings(labels).toUpperCase();
    }

    private String getWizardPageMnemonics() {
        String[] labels = new String[]{IDialogConstants.BACK_LABEL, IDialogConstants.NEXT_LABEL, IDialogConstants.FINISH_LABEL};
        return this.getMnemonicsFromStrings(labels).toUpperCase();
    }

    private String getMnemonicsFromStrings(String[] strings) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            int idx = strings[i].indexOf(38);
            if (idx != -1) {
                result.append(strings[i].charAt(idx + 1));
            }
            ++i;
        }
        return result.toString();
    }

    public void setMnemonic(Button button) {
        this.removeMnemonic(button);
        String text = button.getText();
        if (text != null && text.trim().length() > 0) {
            button.setText(this.setUniqueMnemonic(text));
        }
    }

    public void removeMnemonic(Button button) {
        String text = button.getText();
        if (text == null) {
            return;
        }
        int idx = text.indexOf(38);
        if (idx >= 0) {
            StringBuffer buffer = new StringBuffer(text);
            char mchar = buffer.charAt(idx + 1);
            buffer.deleteCharAt(idx);
            boolean found = false;
            int mdx = 0;
            while (!found && mdx < this.mnemonics.length()) {
                if (this.mnemonics.charAt(mdx) == mchar) {
                    found = true;
                    this.mnemonics.deleteCharAt(mdx);
                }
                ++mdx;
            }
            button.setText(buffer.toString());
        }
    }

    public static String removeMnemonic(String text) {
        int idx = text.indexOf(38);
        if (idx >= 0) {
            StringBuffer buffer = new StringBuffer(text);
            buffer.deleteCharAt(idx);
            if (buffer.length() > 1 + idx && idx > 1 && buffer.charAt(idx + 1) == ')' && buffer.charAt(idx - 1) == '(') {
                buffer.delete(idx - 1, idx + 2);
            }
            return buffer.toString();
        }
        return text;
    }

    public String removeAndFreeMnemonic(String text) {
        int idx = text.indexOf(38);
        if (idx >= 0) {
            StringBuffer buffer = new StringBuffer(text);
            char mchar = buffer.charAt(idx + 1);
            buffer.deleteCharAt(idx);
            boolean found = false;
            int mdx = 0;
            while (!found && mdx < this.mnemonics.length()) {
                if (this.mnemonics.charAt(mdx) == mchar) {
                    found = true;
                    this.mnemonics.deleteCharAt(mdx);
                }
                ++mdx;
            }
            return buffer.toString();
        }
        return text;
    }

    public static char getMnemonic(String text) {
        int idx = text.indexOf(38);
        if (idx >= 0) {
            return text.charAt(idx + 1);
        }
        return ' ';
    }

    public void setMnemonics(Composite parent) {
        Control[] children = parent.getChildren();
        if (children != null) {
            Control currChild = null;
            boolean bSetText = false;
            int idx = 0;
            while (idx < children.length) {
                Label currLabel;
                String text;
                currChild = children[idx];
                if (currChild instanceof Composite && (!this.applyMnemonicsToPrecedingLabels || this.applyMnemonicsToPrecedingLabels && !(currChild instanceof Combo) && !(currChild instanceof InheritableEntryField))) {
                    this.setMnemonics((Composite)currChild);
                } else if (currChild instanceof Button) {
                    Button currButton = (Button)currChild;
                    text = currButton.getText();
                    if (text != null && text.trim().length() > 0) {
                        currButton.setText(this.setUniqueMnemonic(text));
                        bSetText = true;
                    }
                } else if (this.applyMnemonicsToPrecedingLabels && idx > 0 && (currChild instanceof Text || currChild instanceof Combo || currChild instanceof InheritableEntryField) && children[idx - 1] instanceof Label && (text = (currLabel = (Label)children[idx - 1]).getText()) != null && text.trim().length() > 0) {
                    currLabel.setText(this.setUniqueMnemonic(text));
                    bSetText = true;
                }
                ++idx;
            }
            if (bSetText) {
                parent.layout(true);
            }
        }
    }

    public void setMnemonics(Menu menu) {
        MenuItem[] children = menu.getItems();
        if (children != null && children.length > 0) {
            MenuItem currChild = null;
            int idx = 0;
            while (idx < children.length) {
                currChild = children[idx];
                String text = currChild.getText();
                if (text != null && text.length() > 0 && text.indexOf(38) < 0) {
                    Image image = currChild.getImage();
                    currChild.setText(this.setUniqueMnemonic(text));
                    if (image != null) {
                        currChild.setImage(image);
                    }
                }
                ++idx;
            }
        }
    }

    public void setMnemonicsAndArmListener(Menu menu, ArmListener listener) {
        MenuItem[] children = menu.getItems();
        if (children != null && children.length > 0) {
            MenuItem currChild = null;
            int idx = 0;
            while (idx < children.length) {
                currChild = children[idx];
                String text = currChild.getText();
                if (text != null && text.length() > 0) {
                    Image image;
                    int mnemonicIndex = text.indexOf(38);
                    if (mnemonicIndex < 0) {
                        image = currChild.getImage();
                        currChild.setText(this.setUniqueMnemonic(text));
                        if (image != null) {
                            currChild.setImage(image);
                        }
                        currChild.addArmListener(listener);
                    } else {
                        image = currChild.getImage();
                        char c = text.charAt(mnemonicIndex + 1);
                        if (!this.isUniqueMnemonic(c)) {
                            int n = 0;
                            while (n < idx) {
                                MenuItem oChild = children[n];
                                String oText = oChild.getText();
                                char oldN = Mnemonics.getMnemonic(oText);
                                if (oldN == c) {
                                    String cleanText = Mnemonics.removeMnemonic(oText);
                                    oChild.setText(this.setUniqueMnemonic(cleanText));
                                }
                                ++n;
                            }
                        }
                        text = this.removeAndFreeMnemonic(text);
                        currChild.setText(this.setUniqueMnemonic(text));
                        if (image != null) {
                            currChild.setImage(image);
                        }
                        currChild.removeArmListener(listener);
                        currChild.addArmListener(listener);
                    }
                }
                ++idx;
            }
        }
    }

    public Mnemonics setOnPreferencePage(boolean page) {
        this.onPrefPage = page;
        return this;
    }

    public Mnemonics setOnWizardPage(boolean page) {
        this.onWizardPage = page;
        return this;
    }

    public Mnemonics setApplyMnemonicsToPrecedingLabels(boolean apply) {
        this.applyMnemonicsToPrecedingLabels = apply;
        return this;
    }
}

