/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.rse.ui.view.SystemInheritablePropertyData;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SystemInheritableTextCellEditor
extends CellEditor
implements SelectionListener {
    protected InheritableEntryField textField;
    protected Text text;
    protected SystemInheritablePropertyData data;
    private String toggleButtonToolTipText;
    private String entryFieldToolTipText;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public SystemInheritableTextCellEditor(Composite parent) {
        super(parent);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.getTextField().getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private Text getTextField() {
        return this.textField.getTextField();
    }

    public InheritableEntryField getInheritableEntryField() {
        return this.textField;
    }

    public String getToggleButtonToolTipText() {
        return this.toggleButtonToolTipText;
    }

    public void setToggleButtonToolTipText(String toggleButtonToolTipText) {
        this.toggleButtonToolTipText = toggleButtonToolTipText;
        if (this.textField != null) {
            this.textField.setToggleToolTipText(toggleButtonToolTipText);
        }
    }

    public String getEntryFieldToolTipText() {
        return this.entryFieldToolTipText;
    }

    public void setEntryFieldToolTipText(String entryFieldToolTipText) {
        this.entryFieldToolTipText = entryFieldToolTipText;
        if (this.textField != null) {
            this.textField.setTextFieldToolTipText(entryFieldToolTipText);
        }
    }

    protected Control createControl(Composite parent) {
        this.textField = new InheritableEntryField(parent, 0, 2048, 4);
        this.textField.setToggleButtonHeight(14);
        this.textField.setBackground(parent.getBackground());
        this.textField.addSelectionListener(this);
        if (this.toggleButtonToolTipText != null) {
            this.textField.setToggleToolTipText(this.toggleButtonToolTipText);
        }
        if (this.entryFieldToolTipText != null) {
            this.textField.setTextFieldToolTipText(this.entryFieldToolTipText);
        }
        this.text = this.getTextField();
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemInheritableTextCellEditor.this.keyReleaseOccured(e);
                if (SystemInheritableTextCellEditor.this.getControl() == null || SystemInheritableTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                SystemInheritableTextCellEditor.this.checkSelection();
                SystemInheritableTextCellEditor.this.checkDeleteable();
                SystemInheritableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SystemInheritableTextCellEditor.this.checkSelection();
                SystemInheritableTextCellEditor.this.checkDeleteable();
                SystemInheritableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SystemInheritableTextCellEditor.this.focusLost();
            }
        });
        this.textField.getToggleButton().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SystemInheritableTextCellEditor.this.focusLost();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.setFont(parent.getFont());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        this.setValueValid(true);
        return this.textField;
    }

    protected void focusLost() {
        super.focusLost();
    }

    protected Object doGetValue() {
        SystemInheritablePropertyData outputData = new SystemInheritablePropertyData();
        outputData.setIsLocal(this.textField.isLocal());
        outputData.setLocalValue(this.textField.getLocalText());
        outputData.setInheritedValue(this.textField.getInheritedText());
        return outputData;
    }

    protected void doSetFocus() {
        if (this.text != null) {
            if (this.text.isEnabled()) {
                this.text.selectAll();
                this.text.setFocus();
            } else {
                this.textField.setToggleButtonFocus();
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof SystemInheritablePropertyData ? 1 : 0) != 0);
        this.textField.removeModifyListener(this.getModifyListener());
        this.data = (SystemInheritablePropertyData)value;
        this.textField.setLocalText(this.data.getLocalValue());
        this.textField.setInheritedText(this.data.getInheritedValue());
        this.textField.setLocal(this.data.getIsLocal());
        this.textField.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemInheritableTextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed() || !this.text.isEnabled()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed() || !this.text.isEnabled()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed() || !this.text.isEnabled()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed() && this.text.isEnabled();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed() && this.text.isEnabled();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed() || !this.text.isEnabled()) {
            return false;
        }
        return this.text.getText().length() > 0;
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        boolean newValidState;
        boolean isLocal = this.textField.isLocal();
        String value = this.text.getText();
        this.data.setIsLocal(isLocal);
        boolean oldValidState = this.isValueValid();
        boolean bl = newValidState = isLocal ? this.isCorrect(value) : true;
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }
}

