/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteCmdSubSystem;
import org.eclipse.rse.shells.ui.ShellResources;
import org.eclipse.rse.shells.ui.view.EncodingForm;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SystemShellPropertyPage
extends SystemBasePropertyPage {
    private EncodingForm _form;

    public SystemShellPropertyPage() {
        this.setDescription(ShellResources.RESID_SHELL_PROPERTYPAGE_DESCRIPTION);
    }

    public void setShellEncodingDefaults(List encodings) {
        StringBuffer history = new StringBuffer();
        int i = 0;
        while (i < encodings.size()) {
            String encoding = (String)encodings.get(i);
            history.append(encoding);
            if (i < encodings.size()) {
                history.append(',');
            }
            ++i;
        }
        RSEUIPlugin.getDefault().getPreferenceStore().setValue("shell.encodingDefaults", history.toString());
    }

    public List getShellEncodingDefaults() {
        ArrayList<String> result = new ArrayList<String>();
        String attribute = RSEUIPlugin.getDefault().getPreferenceStore().getString("shell.encodingDefaults");
        if (attribute != null && attribute.length() > 0) {
            String[] list = attribute.split(",");
            int i = 0;
            while (i < list.length) {
                result.add(list[i]);
                ++i;
            }
        } else {
            result.add("UTF-8");
            result.add("UTF-16");
            result.add("US-ASCII");
            result.add("ISO-8859-1");
            result.add("Cp1252");
            result.add("Cp1256");
        }
        return result;
    }

    protected Control createContentArea(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(ShellResources.RESID_SHELL_PROPERTYPAGE_ENCODING);
        group.setFont(font);
        this._form = new EncodingForm(this.getShell(), this.getMessageLine());
        this._form.createContents((Composite)group);
        RemoteCmdSubSystem cmdSS = this.getCmdSubSystem();
        this._form.initialize(this.getShellEncodingDefaults(), cmdSS.getShellEncoding());
        return this._form.getDefaultControl();
    }

    public RemoteCmdSubSystem getCmdSubSystem() {
        return (RemoteCmdSubSystem)this.getElement();
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public boolean performOk() {
        String encoding = this._form.getEncoding();
        this.getCmdSubSystem().setShellEncoding(encoding);
        List defaults = this.getShellEncodingDefaults();
        if (!defaults.contains(encoding)) {
            defaults.add(encoding);
            this.setShellEncodingDefaults(defaults);
        }
        return true;
    }
}

