/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.rse.shells.ui.view.CommandsViewPage;
import org.eclipse.rse.shells.ui.view.SystemCommandsView;
import org.eclipse.rse.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.shells.ui.view.TabFolderLayout;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CommandsViewWorkbook
extends Composite {
    private CTabFolder _folder = new CTabFolder((Composite)this, 0);
    private SystemCommandsViewPart _viewPart;
    static /* synthetic */ Class class$0;

    public CommandsViewWorkbook(Composite parent, SystemCommandsViewPart viewPart) {
        super(parent, 0);
        this._folder.setLayout((Layout)new TabFolderLayout());
        this._folder.setLayoutData((Object)new GridData(1808));
        this.setLayout((Layout)new FillLayout());
        this._viewPart = viewPart;
    }

    public void dispose() {
        if (!this._folder.isDisposed()) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                CTabItem item = this._folder.getItem(i);
                if (!item.isDisposed()) {
                    CommandsViewPage page = (CommandsViewPage)item.getData();
                    page.dispose();
                }
                ++i;
            }
            this._folder.dispose();
        }
        super.dispose();
    }

    public CTabFolder getFolder() {
        return this._folder;
    }

    public void remove(Object root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CommandsViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (CommandsViewPage)item.getData()) != null && root == page.getInput()) {
                item.dispose();
                page.dispose();
                page = null;
                item = null;
                this._folder.redraw();
                return;
            }
            ++i;
        }
    }

    public CTabItem getSelectedTab() {
        if (this._folder.getItemCount() > 0) {
            int index = this._folder.getSelectionIndex();
            CTabItem item = this._folder.getItem(index);
            return item;
        }
        return null;
    }

    public CommandsViewPage getCurrentTabItem() {
        if (this._folder.getItemCount() > 0) {
            int index = this._folder.getSelectionIndex();
            CTabItem item = this._folder.getItem(index);
            return (CommandsViewPage)item.getData();
        }
        return null;
    }

    public void showCurrentPage() {
        this._folder.setFocus();
    }

    public Object getInput() {
        CommandsViewPage page = this.getCurrentTabItem();
        if (page != null) {
            return page.getInput();
        }
        return null;
    }

    public SystemCommandsView getViewer() {
        if (this.getCurrentTabItem() != null) {
            return this.getCurrentTabItem().getViewer();
        }
        return null;
    }

    public void updateOutput(IRemoteCommandShell root, boolean createTab) {
        if (!this._folder.isDisposed()) {
            int i = 0;
            while (i < this._folder.getItemCount()) {
                CTabItem item = this._folder.getItem(i);
                CommandsViewPage page = (CommandsViewPage)item.getData();
                if (page != null && root == page.getInput()) {
                    if (!root.isActive()) {
                        this.setTabTitle((IAdaptable)root, item);
                        page.updateTitle((IAdaptable)root);
                        page.setEnabled(false);
                    }
                    page.updateOutput();
                    this.updateActionStates();
                    return;
                }
                ++i;
            }
            if (createTab) {
                this.createTabItem((IAdaptable)root);
            }
        }
    }

    private void createTabItem(IAdaptable root) {
        CommandsViewPage commandsViewPage = new CommandsViewPage(this._viewPart);
        CTabItem titem = new CTabItem(this._folder, 0);
        this.setTabTitle(root, titem);
        titem.setData((Object)commandsViewPage);
        titem.setControl((Control)commandsViewPage.createTabFolderPage(this._folder, this._viewPart.getEditorActionHandler()));
        this._folder.setSelection(titem);
        commandsViewPage.setInput(root);
        SystemCommandsView viewer = commandsViewPage.getViewer();
        this._viewPart.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this._viewPart.getSite().registerContextMenu(viewer.getContextMenuManager(), (ISelectionProvider)viewer);
        commandsViewPage.setFocus();
    }

    private void setTabTitle(IAdaptable root, CTabItem titem) {
        ISystemViewElementAdapter va;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((va = (ISystemViewElementAdapter)root.getAdapter((Class)clazz)) != null) {
            titem.setText(va.getName((Object)root));
            titem.setImage(va.getImageDescriptor((Object)root).createImage());
        }
    }

    public void setInput(IAdaptable root) {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CTabItem item = this._folder.getItem(i);
            CommandsViewPage page = (CommandsViewPage)item.getData();
            if (root == page.getInput()) {
                this._folder.setSelection(i);
                page.getViewer().updateChildren();
                return;
            }
            ++i;
        }
    }

    public void updateActionStates() {
        int i = 0;
        while (i < this._folder.getItemCount()) {
            CommandsViewPage page;
            CTabItem item = this._folder.getItem(i);
            if (!item.isDisposed() && (page = (CommandsViewPage)item.getData()) != null) {
                page.updateActionStates();
            }
            ++i;
        }
    }
}

