/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.core.model;

import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.swt.widgets.Display;

public class SimpleCommandOperation {
    private IRemoteCmdSubSystem _subsystem;
    private IRemoteFile _workingDirectory;
    private IRemoteCommandShell _cmdShell;
    private int _outputLineIndex = 0;

    public SimpleCommandOperation(IRemoteCmdSubSystem subsystem, IRemoteFile workingDirectory) {
        this._subsystem = subsystem;
        this._workingDirectory = workingDirectory;
    }

    public void runCommand(String command) throws Exception {
        Object[] result = this._subsystem.runCommand(command, this._workingDirectory, false);
        this._cmdShell = (IRemoteCommandShell)result[0];
    }

    public IRemoteCommandShell getCommandShell() {
        return this._cmdShell;
    }

    public void putInput(String input) throws Exception {
        if (this.isActive()) {
            this._subsystem.sendCommandToShell(input, this._cmdShell);
        }
    }

    public boolean isActive() {
        if (this._cmdShell != null) {
            return this._cmdShell.isActive();
        }
        return false;
    }

    protected boolean hasMoreOutput() {
        return this._cmdShell != null && this._cmdShell.listOutput().length > this._outputLineIndex;
    }

    public void cancelCommand() throws Exception {
        if (this._cmdShell != null && this._cmdShell.isActive()) {
            this._cmdShell.getCommandSubSystem().cancelShell(this._cmdShell);
        }
    }

    public String readLine(boolean waitForOutput) {
        if (this._cmdShell != null) {
            if (!this.hasMoreOutput() && waitForOutput) {
                Display display = Display.getCurrent();
                try {
                    while (!this.hasMoreOutput() && this.isActive()) {
                        while (display != null && display.readAndDispatch()) {
                        }
                        if (this.hasMoreOutput() || !this.isActive()) continue;
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (!this.isActive()) {
                    return null;
                }
            }
            Object output = this._cmdShell.getOutputAt(this._outputLineIndex);
            ++this._outputLineIndex;
            if (output instanceof IRemoteOutput) {
                return ((IRemoteOutput)output).getText();
            }
            if (output instanceof IRemoteFile) {
                return ((IRemoteFile)output).getLabel();
            }
        }
        return "";
    }
}

