/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.processes.dstore;

import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.dstore.processes.DStoreHostProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IHostProcessToRemoteProcessAdapter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessContext;
import org.eclipse.rse.subsystems.processes.core.subsystem.impl.RemoteProcessImpl;

public class DStoreProcessAdapter
implements IHostProcessToRemoteProcessAdapter {
    public IRemoteProcess[] convertToRemoteProcesses(IRemoteProcessContext context, IRemoteProcess parent, IHostProcess[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<RemoteProcessImpl> list = new ArrayList<RemoteProcessImpl>(nodes.length);
        int idx = 0;
        while (idx < nodes.length) {
            DStoreHostProcess node = (DStoreHostProcess)nodes[idx];
            DataElement de = (DataElement)node.getObject();
            if (!de.isDeleted()) {
                RemoteProcessImpl newProcess = new RemoteProcessImpl(context, (IHostProcess)node);
                list.add(newProcess);
            }
            ++idx;
        }
        IRemoteProcess[] processes = new IRemoteProcess[list.size()];
        int idx2 = 0;
        while (idx2 < list.size()) {
            processes[idx2] = (IRemoteProcess)list.get(idx2);
            ++idx2;
        }
        return processes;
    }

    public IRemoteProcess convertToRemoteProcess(IRemoteProcessContext context, IRemoteProcess parent, IHostProcess node) {
        IHostProcess[] nodes = new IHostProcess[]{node};
        IRemoteProcess[] processes = this.convertToRemoteProcesses(context, parent, nodes);
        if (processes != null && processes.length > 0) {
            return processes[0];
        }
        return null;
    }
}

