/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.ssh.files;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.services.ssh.Activator;
import org.eclipse.rse.services.ssh.ISshService;
import org.eclipse.rse.services.ssh.ISshSessionProvider;
import org.eclipse.rse.services.ssh.SshServiceResources;
import org.eclipse.rse.services.ssh.files.SftpHostFile;

public class SftpFileService
extends AbstractFileService
implements IFileService,
ISshService {
    private ISshSessionProvider fSessionProvider;
    private ChannelSftp fChannelSftp;
    private String fUserHome;
    private Mutex fDirChannelMutex = new Mutex();
    private long fDirChannelTimeout = 5000L;

    public SftpFileService(ISshSessionProvider sessionProvider) {
        this.fSessionProvider = sessionProvider;
    }

    public String getName() {
        return SshServiceResources.SftpFileService_Name;
    }

    public String getDescription() {
        return SshServiceResources.SftpFileService_Description;
    }

    public void connect() throws SystemMessageException {
        Activator.trace("SftpFileService.connecting...");
        try {
            Session session = this.fSessionProvider.getSession();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            this.fChannelSftp = (ChannelSftp)channel;
            this.fUserHome = this.fChannelSftp.pwd();
            Activator.trace("SftpFileService.connected");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.connecting failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
    }

    protected boolean checkSessionConnected() {
        Session session = this.fSessionProvider.getSession();
        if (session == null) {
            return false;
        }
        if (session.isConnected()) {
            return true;
        }
        this.fSessionProvider.handleSessionLost();
        return false;
    }

    protected ChannelSftp getChannel(String task) throws SystemMessageException {
        Activator.trace(task);
        if (this.fChannelSftp == null || !this.fChannelSftp.isConnected()) {
            Activator.trace(String.valueOf(task) + ": channel not connected: " + this.fChannelSftp);
            if (this.checkSessionConnected()) {
                this.connect();
            } else {
                throw this.makeSystemMessageException(new IOException(SshServiceResources.SftpFileService_Error_JschSessionLost));
            }
        }
        return this.fChannelSftp;
    }

    public void disconnect() {
        Activator.trace("SftpFileService.disconnect");
        if (this.fChannelSftp != null && this.fChannelSftp.isConnected()) {
            this.fChannelSftp.disconnect();
        }
        this.fDirChannelMutex.interruptAll();
        this.fChannelSftp = null;
    }

    private SystemMessageException makeSystemMessageException(Exception e) {
        if (e instanceof SystemMessageException) {
            return (SystemMessageException)e;
        }
        if (e instanceof SftpException) {
            SftpException sftpe = (SftpException)e;
            Object messageException = sftpe.id == 3 ? new RemoteFileSecurityException(e) : new RemoteFileIOException(e);
            messageException.getSystemMessage().makeSubstitution((Object)("Sftp: " + sftpe.toString()));
            return messageException;
        }
        return new RemoteFileIOException(e);
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        SftpHostFile node = null;
        SftpATTRS attrs = null;
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    attrs = this.getChannel("SftpFileService.getFile").stat(String.valueOf(remoteParent) + '/' + fileName);
                    Activator.trace("SftpFileService.getFile done");
                    node = this.makeHostFile(remoteParent, fileName, attrs);
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.getFile failed: " + e.toString());
                    if (!(e instanceof SftpException) || ((SftpException)e).id != 2) {
                        throw this.makeSystemMessageException(e);
                    }
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        if (node == null) {
            node = new SftpHostFile(remoteParent, fileName, false, false, false, 0L, 0L);
            node.setExists(false);
        }
        return node;
    }

    public boolean isConnected() {
        try {
            return this.getChannel("SftpFileService.isConnected()").isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected IHostFile[] internalFetch(IProgressMonitor monitor, String parentPath, String fileFilter, int fileType) throws SystemMessageException {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher filematcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            filematcher = new FileTypeMatcher(types, true);
        } else {
            filematcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<SftpHostFile> results = new ArrayList<SftpHostFile>();
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    Vector vv = this.getChannel("SftpFileService.internalFetch").ls(parentPath);
                    int ii = 0;
                    while (ii < vv.size()) {
                        SftpHostFile node;
                        ChannelSftp.LsEntry lsEntry;
                        String fileName;
                        Object obj = vv.elementAt(ii);
                        if (obj instanceof ChannelSftp.LsEntry && !".".equals(fileName = (lsEntry = (ChannelSftp.LsEntry)obj).getFilename()) && !"..".equals(fileName) && (filematcher.matches(fileName) || lsEntry.getAttrs().isDir()) && this.isRightType(fileType, node = this.makeHostFile(parentPath, fileName, lsEntry.getAttrs()))) {
                            results.add(node);
                        }
                        ++ii;
                    }
                    Activator.trace("SftpFileService.internalFetch ok");
                }
                catch (Exception e) {
                    if (this.checkSessionConnected()) {
                        Activator.trace("SftpFileService.internalFetch failed: " + e.toString());
                        throw this.makeSystemMessageException(e);
                    }
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private SftpHostFile makeHostFile(String parentPath, String fileName, SftpATTRS attrs) {
        String perms;
        String linkTarget;
        SftpATTRS attrsTarget;
        block13: {
            attrsTarget = attrs;
            linkTarget = null;
            if (attrs.isLink()) {
                try {
                    this.getChannel("makeHostFile.chdir").cd(String.valueOf(parentPath) + '/' + fileName);
                    linkTarget = this.getChannel("makeHostFile.chdir").pwd();
                    if (linkTarget != null && !linkTarget.equals(String.valueOf(parentPath) + '/' + fileName)) {
                        attrsTarget = this.getChannel("SftpFileService.getFile").stat(linkTarget);
                    } else {
                        linkTarget = null;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SftpException) || ((SftpException)e).id != 2) break block13;
                    linkTarget = ":dangling link";
                }
            }
        }
        SftpHostFile node = new SftpHostFile(parentPath, fileName, attrsTarget.isDir(), false, attrs.isLink(), 1000L * (long)attrs.getMTime(), attrs.getSize());
        if (linkTarget != null) {
            node.setLinkTarget(linkTarget);
        }
        if ((perms = attrsTarget.getPermissionsString()).indexOf(114, 1) <= 0) {
            node.setReadable(false);
        }
        if (perms.indexOf(119, 1) <= 0) {
            node.setWritable(false);
        }
        if (node.isDirectory()) {
            if (perms.indexOf(120, 1) <= 0) {
                node.setWritable(false);
            }
        } else if (perms.indexOf(120, 1) > 0) {
            node.setExecutable(true);
        }
        if (attrs.getExtended() != null) {
            node.setExtendedData(attrs.getExtended());
        }
        return node;
    }

    public String getSeparator() {
        return "/";
    }

    public boolean upload(IProgressMonitor monitor, File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) throws SystemMessageException {
        ChannelSftp channel = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            MyProgressMonitor sftpMonitor = new MyProgressMonitor(monitor);
            int mode = 0;
            String dst = remoteParent;
            if (remoteFile != null) {
                if (!dst.endsWith("/")) {
                    dst = String.valueOf(dst) + '/';
                }
                dst = String.valueOf(dst) + remoteFile;
            }
            this.getChannel("SftpFileService.upload " + remoteFile);
            channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            channel.put(localFile.getAbsolutePath(), dst, (SftpProgressMonitor)sftpMonitor, mode);
            Activator.trace("SftpFileService.upload " + remoteFile + " ok");
            if (monitor.isCanceled()) {
                return false;
            }
            try {
                SftpATTRS attr = channel.stat(dst);
                attr.setACMODTIME(attr.getATime(), (int)(localFile.lastModified() / 1000L));
                channel.setStat(dst, attr);
                if (attr.getSize() != localFile.length()) {
                    throw this.makeSystemMessageException(new IOException(NLS.bind((String)SshServiceResources.SftpFileService_Error_upload_size, (Object)dst)));
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.upload " + remoteFile + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return true;
    }

    public boolean upload(IProgressMonitor monitor, InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("sftp", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            bos.close();
            this.upload(monitor, tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding);
        }
        catch (Exception e) {
            throw this.makeSystemMessageException(e);
        }
        return true;
    }

    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        ChannelSftp channel = null;
        try {
            File localParentFile;
            if (!localFile.exists() && !(localParentFile = localFile.getParentFile()).exists()) {
                localParentFile.mkdirs();
            }
            String remotePath = String.valueOf(remoteParent) + '/' + remoteFile;
            int mode = 0;
            MyProgressMonitor sftpMonitor = new MyProgressMonitor(monitor);
            this.getChannel("SftpFileService.download " + remoteFile);
            channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            channel.get(remotePath, localFile.getAbsolutePath(), (SftpProgressMonitor)sftpMonitor, mode);
            Activator.trace("SftpFileService.download " + remoteFile + " ok");
            if (monitor.isCanceled()) {
                return false;
            }
            try {
                SftpATTRS attr = channel.stat(remotePath);
                localFile.setLastModified(1000L * (long)attr.getMTime());
                if (attr.getSize() != localFile.length()) {
                    throw this.makeSystemMessageException(new IOException(NLS.bind((String)SshServiceResources.SftpFileService_Error_download_size, (Object)remotePath)));
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.download " + remoteFile + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return true;
    }

    public IHostFile getUserHome() {
        int lastSlash = this.fUserHome.lastIndexOf(47);
        String name = this.fUserHome.substring(lastSlash + 1);
        String parent = this.fUserHome.substring(0, lastSlash);
        try {
            return this.getFile(null, parent, name);
        }
        catch (SystemMessageException systemMessageException) {
            return new SftpHostFile("/", "/", true, true, false, 0L, 0L);
        }
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        SftpHostFile root = new SftpHostFile("/", "/", true, true, false, 0L, 0L);
        return new IHostFile[]{root};
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        SftpHostFile result = null;
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    String fullPath = String.valueOf(remoteParent) + '/' + fileName;
                    OutputStream os = this.getChannel("SftpFileService.createFile").put(fullPath);
                    os.write(32);
                    os.close();
                    SftpATTRS attrs = this.getChannel("SftpFileService.createFile.stat").stat(fullPath);
                    result = this.makeHostFile(remoteParent, fileName, attrs);
                    Activator.trace("SftpFileService.createFile ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.createFile failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return result;
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) throws SystemMessageException {
        SftpHostFile result = null;
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    String fullPath = String.valueOf(remoteParent) + '/' + folderName;
                    this.getChannel("SftpFileService.createFolder").mkdir(fullPath);
                    SftpATTRS attrs = this.getChannel("SftpFileService.createFolder.stat").stat(fullPath);
                    result = this.makeHostFile(remoteParent, folderName, attrs);
                    Activator.trace("SftpFileService.createFolder ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.createFolder failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return result;
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        boolean ok = false;
        Activator.trace("SftpFileService.delete.waitForLock");
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    String fullPath = String.valueOf(remoteParent) + '/' + fileName;
                    SftpATTRS attrs = null;
                    try {
                        attrs = this.getChannel("SftpFileService.delete").stat(fullPath);
                    }
                    catch (SftpException e) {
                        if (e.id == 2) {
                            this.getChannel("SftpFileService.delete.rm").rm(fullPath);
                        }
                        throw e;
                    }
                    if (attrs == null) {
                        ok = true;
                    } else if (attrs.isDir()) {
                        try {
                            this.getChannel("SftpFileService.delete.rmdir").rmdir(fullPath);
                            ok = true;
                        }
                        catch (SftpException e) {
                            if (e.id == 4) {
                                String fullPathQuoted = PathUtility.enQuoteUnix((String)fullPath);
                                int rv = this.runCommand(monitor, "rm -rf " + fullPathQuoted);
                                ok = rv == 0;
                            }
                            throw e;
                        }
                    } else {
                        this.getChannel("SftpFileService.delete.rm").rm(fullPath);
                        ok = true;
                    }
                    Activator.trace("SftpFileService.delete ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.delete: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) throws SystemMessageException {
        boolean ok = false;
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    String fullPathOld = String.valueOf(remoteParent) + '/' + oldName;
                    String fullPathNew = String.valueOf(remoteParent) + '/' + newName;
                    this.getChannel("SftpFileService.rename").rename(fullPathOld, fullPathNew);
                    ok = true;
                    Activator.trace("SftpFileService.rename ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.rename failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) throws SystemMessageException {
        return this.rename(monitor, remoteParent, oldName, newName);
    }

    private boolean progressWorked(IProgressMonitor monitor, int work) {
        boolean cancelRequested = false;
        if (monitor != null) {
            monitor.worked(work);
            cancelRequested = monitor.isCanceled();
        }
        return cancelRequested;
    }

    /*
     * Unable to fully structure code
     */
    public int runCommand(IProgressMonitor monitor, String command) throws SystemMessageException {
        Activator.trace("SftpFileService.runCommand " + command);
        result = -1;
        if (monitor != null) {
            monitor.beginTask(command, 20);
        }
        channel = null;
        try {
            try {
                channel = this.fSessionProvider.getSession().openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                channel.setInputStream(null);
                err = new ByteArrayOutputStream();
                ((ChannelExec)channel).setErrStream((OutputStream)err);
                in = channel.getInputStream();
                channel.connect();
                tmp = new byte[1024];
                while (!channel.isClosed()) {
                    if (!this.progressWorked(monitor, 1)) ** GOTO lbl-1000
                    break;
                    while ((i = in.read(tmp, 0, 1024)) >= 0) lbl-1000:
                    // 2 sources

                    {
                        if (in.available() > 0) continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception v0) {}
                }
                result = channel.getExitStatus();
                if (result != 0) {
                    errorMsg = err.toString();
                    Activator.trace("SftpFileService.runCommand ok, error: " + result + ", " + errorMsg);
                    if (errorMsg.length() > 0) {
                        throw this.makeSystemMessageException(new IOException(errorMsg));
                    }
                } else {
                    Activator.trace("SftpFileService.runCommand ok, result: " + result);
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.runCommand failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
        return result;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        Activator.trace("SftpFileService.move " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)(String.valueOf(srcParent) + '/' + srcName));
        String fullPathNew = PathUtility.enQuoteUnix((String)(String.valueOf(tgtParent) + '/' + tgtName));
        int rv = this.runCommand(monitor, "mv " + fullPathOld + ' ' + fullPathNew);
        return rv == 0;
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        Activator.trace("SftpFileService.copy " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)(String.valueOf(srcParent) + '/' + srcName));
        String fullPathNew = PathUtility.enQuoteUnix((String)(String.valueOf(tgtParent) + '/' + tgtName));
        int rv = this.runCommand(monitor, "cp -Rp " + fullPathOld + ' ' + fullPathNew);
        return rv == 0;
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) throws SystemMessageException {
        Activator.trace("SftpFileService.copyBatch " + srcNames);
        boolean ok = true;
        int i = 0;
        while (i < srcParents.length) {
            ok = ok && this.copy(monitor, srcParents[i], srcNames[i], tgtParent, srcNames[i]);
            ++i;
        }
        return ok;
    }

    public void initService(IProgressMonitor monitor) {
        Activator.trace("SftpFileService.initService");
        try {
            this.connect();
        }
        catch (Exception exception) {}
    }

    public void uninitService(IProgressMonitor monitor) {
        Activator.trace("SftpFileService.uninitService");
        this.disconnect();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(SshServiceResources.SftpFileService_Msg_Progress, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void end() {
            this.fMonitor.done();
        }
    }
}

