/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.discovery;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.discovery.Messages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemRefreshAllAction;
import org.eclipse.tm.discovery.model.Pair;
import org.eclipse.tm.discovery.model.Service;
import org.eclipse.tm.discovery.model.ServiceType;
import org.eclipse.tm.discovery.wizard.ServiceDiscoveryWizardDisplayPage;
import org.eclipse.tm.discovery.wizard.ServiceDiscoveryWizardMainPage;

public class ServiceDiscoveryWizard
extends Wizard {
    private ServiceDiscoveryWizardMainPage serviceDiscoveryMainPage;
    private ServiceDiscoveryWizardDisplayPage serviceDiscoveryPage = null;

    public ServiceDiscoveryWizard() {
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.serviceDiscoveryMainPage = new ServiceDiscoveryWizardMainPage();
        this.addPage((IWizardPage)this.serviceDiscoveryMainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ServiceDiscoveryWizardMainPage) {
            if (this.serviceDiscoveryPage == null) {
                this.serviceDiscoveryPage = new ServiceDiscoveryWizardDisplayPage(this.serviceDiscoveryMainPage.getQuery(), this.serviceDiscoveryMainPage.getAddress(), this.serviceDiscoveryMainPage.getTransport(), this.serviceDiscoveryMainPage.getProtocol(), this.serviceDiscoveryMainPage.getTimeOut());
                this.addPage((IWizardPage)this.serviceDiscoveryPage);
            } else {
                this.serviceDiscoveryPage.update(this.serviceDiscoveryMainPage.getQuery(), this.serviceDiscoveryMainPage.getAddress(), this.serviceDiscoveryMainPage.getTransport(), this.serviceDiscoveryMainPage.getProtocol(), this.serviceDiscoveryMainPage.getTimeOut());
            }
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        SystemRefreshAllAction systemRefreshAllAction = new SystemRefreshAllAction(null);
        String[] addresses = this.serviceDiscoveryPage.getAddresses();
        int i = 0;
        while (i < addresses.length) {
            String hostName = addresses[i];
            Vector discoveredServices = this.serviceDiscoveryPage.getSelectedServices(addresses[i]);
            Enumeration serviceEnumeration = discoveredServices.elements();
            while (serviceEnumeration.hasMoreElements()) {
                IHost conn = null;
                Service service = (Service)serviceEnumeration.nextElement();
                String sysTypeString = ((ServiceType)service.eContainer()).getName();
                try {
                    try {
                        conn = RSEUIPlugin.getDefault().getSystemRegistry().createHost(sysTypeString, String.valueOf(service.getName()) + "@" + hostName, hostName, "Discovered " + sysTypeString + " server in " + hostName);
                        if (conn == null) continue;
                        Iterator pairIterator = service.getPair().iterator();
                        IConnectorService[] services = conn.getConnectorServices();
                        while (pairIterator.hasNext()) {
                            Pair pair = (Pair)pairIterator.next();
                            int j = 0;
                            while (j < services.length) {
                                IPropertySet ps = services[j].getPropertySet(sysTypeString);
                                if (ps == null) {
                                    ps = services[j].createPropertySet(sysTypeString);
                                }
                                ps.addProperty(pair.getKey(), pair.getValue());
                                if (pair.getKey().equalsIgnoreCase(Messages.ServiceDiscoveryWizard_Port)) {
                                    int port = Integer.parseInt(pair.getValue());
                                    services[j].setPort(port);
                                }
                                ++j;
                            }
                        }
                        RSEUIPlugin.getDefault().getSystemRegistry().expandHost(conn);
                    }
                    catch (Exception exception) {
                        if (conn == null) continue;
                        RSEUIPlugin.getDefault().getSystemRegistry().deleteHost(conn);
                    }
                }
                finally {
                    systemRefreshAllAction.run();
                }
            }
            ++i;
        }
        return true;
    }
}

