/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.serial;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.comm.CommPortIdentifier;

public class SerialProperties {
    protected List fSerialPortTable;
    protected List fBaudRateTable;
    protected List fDataBitsTable;
    protected List fStopBitsTable;
    protected List fParityTable;
    protected List fFlowControlTable;
    protected String fDefaultConnType;
    protected String fDefaultSerialPort;
    protected String fDefaultBaudRate;
    protected String fDefaultDataBits;
    protected String fDefaultStopBits;
    protected String fDefaultParity;
    protected String fDefaultFlowControl;

    public SerialProperties() {
        this.setupProperties();
    }

    public List getSerialPortTable() {
        return this.fSerialPortTable;
    }

    public List getBaudRateTable() {
        return this.fBaudRateTable;
    }

    public List getDataBitsTable() {
        return this.fDataBitsTable;
    }

    public List getStopBitsTable() {
        return this.fStopBitsTable;
    }

    public List getParityTable() {
        return this.fParityTable;
    }

    public List getFlowControlTable() {
        return this.fFlowControlTable;
    }

    public String getDefaultConnType() {
        return this.fDefaultConnType;
    }

    public String getDefaultSerialPort() {
        return this.fDefaultSerialPort;
    }

    public String getDefaultBaudRate() {
        return this.fDefaultBaudRate;
    }

    public String getDefaultDataBits() {
        return this.fDefaultDataBits;
    }

    public String getDefaultStopBits() {
        return this.fDefaultStopBits;
    }

    public String getDefaultParity() {
        return this.fDefaultParity;
    }

    public String getDefaultFlowControl() {
        return this.fDefaultFlowControl;
    }

    public String getDefaultTimeout() {
        return "5";
    }

    protected void setupProperties() {
        this.fSerialPortTable = new Vector();
        this.fBaudRateTable = new Vector();
        this.fDataBitsTable = new Vector();
        this.fStopBitsTable = new Vector();
        this.fParityTable = new Vector();
        this.fFlowControlTable = new Vector();
        this.fDefaultConnType = "";
        this.fDefaultSerialPort = "";
        this.fDefaultBaudRate = "";
        this.fDefaultDataBits = "";
        this.fDefaultStopBits = "";
        this.fDefaultParity = "";
        this.fDefaultFlowControl = "";
        this.fBaudRateTable.add("300");
        this.fBaudRateTable.add("1200");
        this.fBaudRateTable.add("2400");
        this.fBaudRateTable.add("4800");
        this.fBaudRateTable.add("9600");
        this.fBaudRateTable.add("19200");
        this.fBaudRateTable.add("38400");
        this.fBaudRateTable.add("57600");
        this.fBaudRateTable.add("115200");
        this.fDataBitsTable.add("5");
        this.fDataBitsTable.add("6");
        this.fDataBitsTable.add("7");
        this.fDataBitsTable.add("8");
        this.fStopBitsTable.add("1");
        this.fStopBitsTable.add("1_5");
        this.fStopBitsTable.add("2");
        this.fParityTable.add("None");
        this.fParityTable.add("Even");
        this.fParityTable.add("Odd");
        this.fParityTable.add("Mark");
        this.fParityTable.add("Space");
        this.fFlowControlTable.add("None");
        this.fFlowControlTable.add("RTS/CTS");
        this.fFlowControlTable.add("Xon/Xoff");
        this.fDefaultBaudRate = (String)this.fBaudRateTable.get(4);
        this.fDefaultDataBits = (String)this.fDataBitsTable.get(3);
        this.fDefaultStopBits = (String)this.fStopBitsTable.get(0);
        this.fDefaultParity = (String)this.fParityTable.get(0);
        this.fDefaultFlowControl = (String)this.fFlowControlTable.get(0);
        Enumeration portIdEnum = CommPortIdentifier.getPortIdentifiers();
        while (portIdEnum.hasMoreElements()) {
            CommPortIdentifier identifier = (CommPortIdentifier)portIdEnum.nextElement();
            String strName = identifier.getName();
            int nPortType = identifier.getPortType();
            if (nPortType != 1) continue;
            this.fSerialPortTable.add(strName);
        }
        Collections.sort(this.fSerialPortTable);
        if (!this.fSerialPortTable.isEmpty()) {
            this.fDefaultSerialPort = (String)this.fSerialPortTable.get(0);
        }
    }
}

