/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.control.ITerminalListener;
import org.eclipse.tm.terminal.control.ITerminalViewControl;
import org.eclipse.tm.terminal.internal.control.ITerminalControlForText;
import org.eclipse.tm.terminal.internal.control.TerminalMessages;
import org.eclipse.tm.terminal.internal.control.TerminalPlugin;
import org.eclipse.tm.terminal.internal.control.TerminalText;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;

public class TerminalControl
implements ITerminalControlForText,
ITerminalControl,
ITerminalViewControl {
    protected static final String[] LINE_DELIMITERS = new String[]{"\n"};
    private TerminalText fTerminalText;
    private Display fDisplay;
    private StyledText fCtlText;
    private TextViewer fViewer;
    private Composite fWndParent;
    private Clipboard fClipboard;
    private TerminalModifyListener fModifyListener;
    private KeyListener fKeyHandler;
    private ITerminalListener fTerminalListener;
    private String fMsg = "";
    private VerifyKeyListener fVerifyKeyListener;
    private FocusListener fFocusListener;
    private ITerminalConnector fConnector;
    private final ITerminalConnector[] fConnectors;
    private volatile TerminalState fState;

    public TerminalControl(ITerminalListener target, Composite wndParent, ITerminalConnector[] connectors) {
        this.fConnectors = connectors;
        this.fTerminalListener = target;
        this.fWndParent = wndParent;
        this.setTerminalText(new TerminalText(this));
        this.setupTerminal();
    }

    public ITerminalConnector[] getConnectors() {
        return this.fConnectors;
    }

    public void copy() {
        this.getCtlText().copy();
    }

    public void paste() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        String strText = (String)this.fClipboard.getContents((Transfer)textTransfer);
        if (strText == null) {
            return;
        }
        int i = 0;
        while (i < strText.length()) {
            this.sendChar(strText.charAt(i), false);
            ++i;
        }
    }

    public void selectAll() {
        this.getCtlText().selectAll();
    }

    public void sendKey(char character) {
        Event event = new Event();
        event.widget = this.getCtlText();
        event.character = character;
        event.keyCode = 0;
        event.stateMask = 0;
        event.doit = true;
        KeyEvent keyEvent = new KeyEvent(event);
        this.fKeyHandler.keyPressed(keyEvent);
    }

    public void clearTerminal() {
        this.getTerminalText().clearTerminal();
    }

    public Clipboard getClipboard() {
        return this.fClipboard;
    }

    public String getSelection() {
        String txt = ((ITextSelection)this.fViewer.getSelection()).getText();
        if (txt == null) {
            txt = "";
        }
        return txt;
    }

    public void setFocus() {
        this.getCtlText().setFocus();
    }

    public boolean isEmpty() {
        return this.getCtlText().getCharCount() == 0;
    }

    public boolean isDisposed() {
        return this.getCtlText().isDisposed();
    }

    public boolean isConnected() {
        return this.fState == TerminalState.CONNECTED;
    }

    public void disposeTerminal() {
        Logger.log("entered.");
        this.disconnectTerminal();
        this.fClipboard.dispose();
        this.getTerminalText().dispose();
    }

    public void connectTerminal() {
        Logger.log("entered.");
        if (this.fConnector == null) {
            return;
        }
        this.fConnector.connect(this);
        this.waitForConnect();
    }

    public void disconnectTerminal() {
        Logger.log("entered.");
        if (this.getState() == TerminalState.CLOSED) {
            return;
        }
        if (this.fConnector != null) {
            this.fConnector.disconnect();
        }
    }

    private void waitForConnect() {
        Logger.log("entered.");
        while (this.getState() == TerminalState.CONNECTING) {
            if (this.fDisplay.readAndDispatch()) continue;
            this.fDisplay.sleep();
        }
        if (!this.getMsg().equals("")) {
            String strTitle = TerminalMessages.TerminalError;
            MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)this.getMsg());
            this.disconnectTerminal();
            return;
        }
        this.getCtlText().setFocus();
    }

    protected void sendString(String string) {
        try {
            this.getOutputStream().write(string.getBytes());
            this.getOutputStream().flush();
        }
        catch (SocketException socketException) {
            this.displayTextInTerminal(socketException.getMessage());
            String strTitle = TerminalMessages.TerminalError;
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            this.displayTextInTerminal(ioException.getMessage());
            String strTitle = TerminalMessages.TerminalError;
            String strMsg = String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)strMsg);
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    public Shell getShell() {
        return this.getCtlText().getShell();
    }

    protected void sendChar(char chKey, boolean altKeyPressed) {
        try {
            char byteToSend = chKey;
            if (altKeyPressed) {
                Logger.log("sending ESC + '" + byteToSend + "'");
                this.getOutputStream().write(27);
                this.getOutputStream().write(byteToSend);
            } else {
                Logger.log("sending '" + byteToSend + "'");
                this.getOutputStream().write(byteToSend);
            }
            this.getOutputStream().flush();
        }
        catch (SocketException socketException) {
            Logger.logException(socketException);
            this.displayTextInTerminal(socketException.getMessage());
            String strTitle = TerminalMessages.TerminalError;
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            Logger.logException(ioException);
            this.displayTextInTerminal(ioException.getMessage());
            String strTitle = TerminalMessages.TerminalError;
            String strMsg = String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)strMsg);
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    public void setupTerminal() {
        this.fState = TerminalState.CLOSED;
        this.setupControls();
        this.setupListeners();
        this.setupHelp(this.fWndParent, "org.eclipse.tm.terminal.terminal_view");
    }

    public void onFontChanged() {
        this.getTerminalText().fontChanged();
    }

    protected void setupControls() {
        this.fViewer = new TextViewer(this.fWndParent, 512);
        this.setCtlText(this.fViewer.getTextWidget());
        this.fDisplay = this.getCtlText().getDisplay();
        this.fClipboard = new Clipboard(this.fDisplay);
        this.fViewer.setDocument((IDocument)new TerminalDocument());
        this.getCtlText().setFont(JFaceResources.getTextFont());
    }

    protected void setupListeners() {
        this.fKeyHandler = new TerminalKeyHandler();
        this.fModifyListener = new TerminalModifyListener();
        this.fVerifyKeyListener = new TerminalVerifyKeyListener();
        this.fFocusListener = new TerminalFocusListener();
        this.getCtlText().addVerifyKeyListener(this.fVerifyKeyListener);
        this.getCtlText().addKeyListener(this.fKeyHandler);
        this.getCtlText().addModifyListener((ModifyListener)this.fModifyListener);
        this.getCtlText().addVerifyKeyListener(this.fVerifyKeyListener);
        this.getCtlText().addFocusListener(this.fFocusListener);
    }

    protected void setupHelp(Composite parent, String id) {
        Control[] children = parent.getChildren();
        int nIndex = 0;
        while (nIndex < children.length) {
            if (children[nIndex] instanceof Composite) {
                this.setupHelp((Composite)children[nIndex], id);
            }
            ++nIndex;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, id);
    }

    public void displayTextInTerminal(String text) {
        this.writeToTerminal(String.valueOf(text) + "\r\n");
    }

    public void writeToTerminal(String txt) {
        this.getTerminalText().setNewText(new StringBuffer(txt));
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            this.getTerminalText().run();
        } else {
            this.fDisplay.syncExec((Runnable)this.getTerminalText());
        }
    }

    protected boolean isLogCharEnabled() {
        return TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/char");
    }

    protected boolean isLogBufferSizeEnabled() {
        return TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/buffer/size");
    }

    public InputStream getInputStream() {
        if (this.fConnector != null) {
            return this.fConnector.getInputStream();
        }
        return null;
    }

    public OutputStream getOutputStream() {
        if (this.fConnector != null) {
            return this.fConnector.getOutputStream();
        }
        return null;
    }

    public void setMsg(String msg) {
        this.fMsg = msg;
    }

    public String getMsg() {
        return this.fMsg;
    }

    void setCtlText(StyledText ctlText) {
        this.fCtlText = ctlText;
        this.fTerminalText.setStyledText(ctlText);
    }

    public StyledText getCtlText() {
        return this.fCtlText;
    }

    void setTerminalText(TerminalText terminalText) {
        this.fTerminalText = terminalText;
    }

    public TerminalText getTerminalText() {
        return this.fTerminalText;
    }

    public ITerminalConnector getTerminalConnection() {
        return this.fConnector;
    }

    public void setTerminalTitle(String title) {
        this.fTerminalListener.setTerminalTitle(title);
    }

    public TerminalState getState() {
        return this.fState;
    }

    public void setState(TerminalState state) {
        this.fState = state;
        this.fTerminalListener.setState(state);
    }

    public String getStatusString(String strConnected) {
        if (this.fConnector != null) {
            return this.fConnector.getStatusString(strConnected);
        }
        return strConnected;
    }

    public void setConnector(ITerminalConnector connector) {
        this.fConnector = connector;
    }

    protected class TerminalModifyListener
    implements ModifyListener {
        protected TerminalModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.getSource() instanceof StyledText) {
                StyledText text = (StyledText)e.getSource();
                text.setSelection(text.getText().length());
            }
        }
    }

    protected class TerminalFocusListener
    implements FocusListener {
        private IContextActivation contextActivation = null;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        protected TerminalFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBindingService bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
            bindingService.setKeyFilterEnabled(false);
            IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbench2.getAdapter((Class)clazz2);
            this.contextActivation = contextService.activateContext("org.eclipse.tm.terminal.TerminalContext");
        }

        public void focusLost(FocusEvent event) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBindingService bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
            bindingService.setKeyFilterEnabled(true);
            IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbench2.getAdapter((Class)clazz2);
            contextService.deactivateContext(this.contextActivation);
        }
    }

    protected class TerminalVerifyKeyListener
    implements VerifyKeyListener {
        protected TerminalVerifyKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            event.doit = false;
        }
    }

    protected class TerminalKeyHandler
    extends KeyAdapter {
        protected TerminalKeyHandler() {
        }

        public void keyPressed(KeyEvent event) {
            boolean altKeyPressed;
            if (TerminalControl.this.getState() == TerminalState.CONNECTING) {
                return;
            }
            event.doit = false;
            char character = event.character;
            if (!TerminalControl.this.isConnected()) {
                if (character == '\r') {
                    TerminalControl.this.connectTerminal();
                    return;
                }
                return;
            }
            if (character == '\u0000' && event.keyCode != 50) {
                switch (event.keyCode) {
                    case 0x1000001: {
                        TerminalControl.this.sendString("\u001b[A");
                        break;
                    }
                    case 0x1000002: {
                        TerminalControl.this.sendString("\u001b[B");
                        break;
                    }
                    case 0x1000003: {
                        TerminalControl.this.sendString("\u001b[D");
                        break;
                    }
                    case 0x1000004: {
                        TerminalControl.this.sendString("\u001b[C");
                        break;
                    }
                    case 0x1000005: {
                        TerminalControl.this.sendString("\u001b[I");
                        break;
                    }
                    case 0x1000006: {
                        TerminalControl.this.sendString("\u001b[G");
                        break;
                    }
                    case 0x1000007: {
                        TerminalControl.this.sendString("\u001b[H");
                        break;
                    }
                    case 0x1000008: {
                        TerminalControl.this.sendString("\u001b[F");
                        break;
                    }
                    case 0x100000A: {
                        TerminalControl.this.sendString("\u001b[M");
                        break;
                    }
                    case 0x100000B: {
                        TerminalControl.this.sendString("\u001b[N");
                        break;
                    }
                    case 0x100000C: {
                        TerminalControl.this.sendString("\u001b[O");
                        break;
                    }
                    case 0x100000D: {
                        TerminalControl.this.sendString("\u001b[P");
                        break;
                    }
                    case 0x100000E: {
                        TerminalControl.this.sendString("\u001b[Q");
                        break;
                    }
                    case 0x100000F: {
                        TerminalControl.this.sendString("\u001b[R");
                        break;
                    }
                    case 0x1000010: {
                        TerminalControl.this.sendString("\u001b[S");
                        break;
                    }
                    case 0x1000011: {
                        TerminalControl.this.sendString("\u001b[T");
                        break;
                    }
                    case 0x1000012: {
                        TerminalControl.this.sendString("\u001b[U");
                        break;
                    }
                    case 0x1000013: {
                        TerminalControl.this.sendString("\u001b[V");
                        break;
                    }
                    case 0x1000014: {
                        TerminalControl.this.sendString("\u001b[W");
                        break;
                    }
                    case 0x1000015: {
                        TerminalControl.this.sendString("\u001b[X");
                        break;
                    }
                }
                return;
            }
            Logger.log("stateMask = " + event.stateMask);
            boolean bl = altKeyPressed = (event.stateMask & 0x10000) != 0 && (event.stateMask & 0x40000) == 0;
            if (!altKeyPressed && (event.stateMask & 0x40000) != 0 && character == ' ') {
                character = '\u0000';
            }
            TerminalControl.this.sendChar(character, altKeyPressed);
            if (character == '\r' && TerminalControl.this.getTerminalConnection() != null && TerminalControl.this.isConnected() && TerminalControl.this.getTerminalConnection().isLocalEcho()) {
                TerminalControl.this.sendChar('\n', false);
            }
            if (TerminalControl.this.getTerminalConnection() == null || !TerminalControl.this.getTerminalConnection().isLocalEcho() || altKeyPressed || character >= '\u0001' && character < '\t' || character > '\t' && character < '\r' || character > '\r' && character <= '\u001f' || character == '\u007f') {
                return;
            }
            StringBuffer charBuffer = new StringBuffer();
            charBuffer.append(character);
            if (character == '\r') {
                charBuffer.append('\n');
            }
            TerminalControl.this.writeToTerminal(charBuffer.toString());
        }
    }

    protected class TerminalDocument
    extends Document {
        protected TerminalDocument() {
            this.setLineTracker((ILineTracker)new ConfigurableLineTracker(LINE_DELIMITERS));
        }
    }
}

