/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.terminal.ISettingsStore;
import org.eclipse.ui.IMemento;

class SettingsStore
implements ISettingsStore {
    private static final String KEYS = "_keys_";
    private final Map fMap = new HashMap();

    public SettingsStore(IMemento memento) {
        if (memento == null) {
            return;
        }
        String keys = memento.getString(KEYS);
        if (keys != null) {
            String[] keyNames = keys.split(",");
            int i = 0;
            while (i < keyNames.length) {
                String key = keyNames[i];
                if (!KEYS.equals(key)) {
                    String[] path = key.split("\\.");
                    IMemento m = memento;
                    int iPath = 0;
                    while (m != null && iPath + 1 < path.length) {
                        m = m.getChild(path[iPath]);
                        ++iPath;
                    }
                    if (m != null) {
                        this.fMap.put(key, m.getString(path[path.length - 1]));
                    }
                }
                ++i;
            }
        }
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = (String)this.fMap.get(key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }

    public void put(String key, String value) {
        if (!key.matches("^[\\w.]+$")) {
            throw new IllegalArgumentException("Key '" + key + "' is not alpha numeric or '.'!");
        }
        if (value == null || value.equals("")) {
            this.fMap.remove(key);
        } else {
            this.fMap.put(key, value);
        }
    }

    public void saveState(IMemento memento) {
        Object[] keyNames = this.fMap.keySet().toArray(new String[this.fMap.size()]);
        Arrays.sort(keyNames);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < keyNames.length) {
            Object key = keyNames[i];
            String[] path = ((String)key).split("\\.");
            IMemento m = memento;
            int iPath = 0;
            while (iPath + 1 < path.length) {
                IMemento child = m.getChild(path[iPath]);
                if (child == null) {
                    child = m.createChild(path[iPath]);
                }
                m = child;
                ++iPath;
            }
            m.putString(path[path.length - 1], (String)this.fMap.get(key));
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append((String)key);
            ++i;
        }
        memento.putString(KEYS, buffer.toString());
    }
}

