/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.terminal.ISettingsStore;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalConnectorExtension;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.control.ITerminalListener;
import org.eclipse.tm.terminal.control.ITerminalViewControl;
import org.eclipse.tm.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.terminal.internal.actions.TerminalAction;
import org.eclipse.tm.terminal.internal.actions.TerminalActionClearAll;
import org.eclipse.tm.terminal.internal.actions.TerminalActionConnect;
import org.eclipse.tm.terminal.internal.actions.TerminalActionCopy;
import org.eclipse.tm.terminal.internal.actions.TerminalActionCut;
import org.eclipse.tm.terminal.internal.actions.TerminalActionDisconnect;
import org.eclipse.tm.terminal.internal.actions.TerminalActionNewTerminal;
import org.eclipse.tm.terminal.internal.actions.TerminalActionPaste;
import org.eclipse.tm.terminal.internal.actions.TerminalActionSelectAll;
import org.eclipse.tm.terminal.internal.actions.TerminalActionSettings;
import org.eclipse.tm.terminal.internal.view.ITerminalView;
import org.eclipse.tm.terminal.internal.view.SettingStorePrefixDecorator;
import org.eclipse.tm.terminal.internal.view.SettingsStore;
import org.eclipse.tm.terminal.internal.view.TerminalSettingsDlg;
import org.eclipse.tm.terminal.internal.view.TerminalViewPlugin;
import org.eclipse.tm.terminal.internal.view.ViewMessages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ITerminalView,
ITerminalListener {
    public static final String FONT_DEFINITION = "terminal.views.view.font.definition";
    protected ITerminalViewControl fCtlTerminal;
    protected TerminalAction fActionTerminalNewTerminal;
    protected TerminalAction fActionTerminalConnect;
    protected TerminalAction fActionTerminalDisconnect;
    protected TerminalAction fActionTerminalSettings;
    protected TerminalAction fActionEditCopy;
    protected TerminalAction fActionEditCut;
    protected TerminalAction fActionEditPaste;
    protected TerminalAction fActionEditClearAll;
    protected TerminalAction fActionEditSelectAll;
    protected TerminalMenuHandlerEdit fMenuHandlerEdit;
    protected TerminalPropertyChangeHandler fPropertyChangeHandler;
    protected boolean fMenuAboutToShow;
    private SettingsStore fStore;
    private IContextActivation fRememberedContextActivation;
    static /* synthetic */ Class class$0;

    public TerminalView() {
        Logger.log((String)"===============================================================");
    }

    private void XXXXX() {
        Preferences preferences = TerminalViewPlugin.getDefault().getPluginPreferences();
        preferences.getBoolean("TerminalPrefLimitOutput");
        preferences.getInt("TerminalPrefBufferLines");
    }

    public void setState(TerminalState state) {
        Runnable runnable = new Runnable(){

            public void run() {
                TerminalView.this.updateStatus();
                TerminalView.this.onTerminalStatus();
            }
        };
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    public void onTerminalNewTerminal() {
        Logger.log((String)"creating new Terminal instance.");
        try {
            this.getSite().getPage().showView("org.eclipse.tm.terminal.view.TerminalView", "SecondaryTerminal" + System.currentTimeMillis(), 1);
        }
        catch (PartInitException ex) {
            Logger.logException((Exception)((Object)ex));
        }
    }

    public void onTerminalConnect() {
        if (this.isConnected()) {
            return;
        }
        if (this.fCtlTerminal.getTerminalConnection() == null) {
            this.setConnector(this.showSettingsDialog());
        }
        this.fCtlTerminal.connectTerminal();
    }

    public void updateStatus() {
        this.updateTerminalConnect();
        this.updateTerminalDisconnect();
        this.updateTerminalSettings();
    }

    public void updateTerminalConnect() {
        boolean bEnabled = !this.isConnecting() && !this.fCtlTerminal.isConnected();
        this.fActionTerminalConnect.setEnabled(bEnabled);
    }

    private boolean isConnecting() {
        return this.fCtlTerminal.getState() == TerminalState.CONNECTING;
    }

    private boolean isConnected() {
        return this.fCtlTerminal.getState() == TerminalState.CONNECTED;
    }

    public void onTerminalDisconnect() {
        this.fCtlTerminal.disconnectTerminal();
    }

    public void updateTerminalDisconnect() {
        boolean bEnabled = this.isConnecting() || this.fCtlTerminal.isConnected();
        this.fActionTerminalDisconnect.setEnabled(bEnabled);
    }

    public void onTerminalSettings() {
        ITerminalConnector c = this.showSettingsDialog();
        if (c != null) {
            this.setConnector(c);
            this.onTerminalConnect();
        }
    }

    private ITerminalConnector showSettingsDialog() {
        TerminalSettingsDlg dlgTerminalSettings = new TerminalSettingsDlg(this.getViewSite().getShell(), this.fCtlTerminal.getConnectors(), this.fCtlTerminal.getTerminalConnection());
        Logger.log((String)"opening Settings dialog.");
        if (dlgTerminalSettings.open() == 1) {
            Logger.log((String)"Settings dialog cancelled.");
            return null;
        }
        Logger.log((String)"Settings dialog OK'ed.");
        this.saveSettings(dlgTerminalSettings.getConnector());
        return dlgTerminalSettings.getConnector();
    }

    private void setConnector(ITerminalConnector connector) {
        this.fCtlTerminal.setConnector(connector);
    }

    public void updateTerminalSettings() {
        boolean bEnabled = !this.isConnecting() && !this.fCtlTerminal.isConnected();
        this.fActionTerminalSettings.setEnabled(bEnabled);
    }

    public void setTerminalTitle(String strTitle) {
        if (this.fCtlTerminal.isDisposed()) {
            return;
        }
        if (strTitle == null) {
            String strConnected = this.getStateDisplayName(this.fCtlTerminal.getState());
            String status = "";
            status = this.fCtlTerminal.getStatusString(strConnected);
            strTitle = String.valueOf(ViewMessages.PROP_TITLE) + status;
        }
        this.setContentDescription(strTitle);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(strTitle);
    }

    public void onTerminalStatus() {
        this.setTerminalTitle(null);
    }

    private String getStateDisplayName(TerminalState state) {
        if (state == TerminalState.CONNECTED) {
            return ViewMessages.STATE_CONNECTED;
        }
        if (state == TerminalState.CONNECTING) {
            return ViewMessages.STATE_CONNECTING;
        }
        if (state == TerminalState.OPENED) {
            return ViewMessages.STATE_OPENED;
        }
        if (state == TerminalState.CLOSED) {
            return ViewMessages.STATE_CLOSED;
        }
        throw new IllegalStateException(state.toString());
    }

    public void onTerminalFontChanged() {
        this.fCtlTerminal.getCtlText().setFont(JFaceResources.getFont((String)FONT_DEFINITION));
        this.fCtlTerminal.onFontChanged();
    }

    public void onEditCopy() {
        String selection = this.fCtlTerminal.getSelection();
        if (!selection.equals("")) {
            this.fCtlTerminal.copy();
        } else {
            this.fCtlTerminal.sendKey('\u0003');
        }
    }

    public void updateEditCopy() {
        boolean bEnabled = true;
        if (this.fMenuAboutToShow) {
            bEnabled = this.fCtlTerminal.getSelection().length() > 0;
        }
        this.fActionEditCopy.setEnabled(bEnabled);
    }

    public void onEditCut() {
        this.fCtlTerminal.sendKey('\u0018');
    }

    public void updateEditCut() {
        boolean bEnabled = !this.fMenuAboutToShow;
        this.fActionEditCut.setEnabled(bEnabled);
    }

    public void onEditPaste() {
        this.fCtlTerminal.paste();
    }

    public void updateEditPaste() {
        String strText = (String)this.fCtlTerminal.getClipboard().getContents((Transfer)TextTransfer.getInstance());
        boolean bEnabled = strText != null && !strText.equals("") && this.isConnected();
        this.fActionEditPaste.setEnabled(bEnabled);
    }

    public void onEditClearAll() {
        this.fCtlTerminal.clearTerminal();
    }

    public void updateEditClearAll() {
        this.fActionEditClearAll.setEnabled(!this.fCtlTerminal.isEmpty());
    }

    public void onEditSelectAll() {
        this.fCtlTerminal.selectAll();
    }

    public void updateEditSelectAll() {
        this.fActionEditSelectAll.setEnabled(!this.fCtlTerminal.isEmpty());
    }

    public void createPartControl(Composite wndParent) {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContextService ctxtService = (IContextService)iWorkbenchPartSite.getService((Class)clazz);
        this.fRememberedContextActivation = ctxtService.activateContext("org.eclipse.tm.terminal.TerminalPreferencePage");
        this.setPartName(ViewMessages.PROP_TITLE);
        this.setupControls(wndParent);
        this.setupActions();
        this.setupMenus();
        this.setupLocalToolBars();
        this.setupContextMenus();
        this.setupListeners(wndParent);
        this.onTerminalStatus();
    }

    public void dispose() {
        Logger.log((String)"entered.");
        this.setPartName("Terminal");
        if (this.fRememberedContextActivation != null) {
            IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService ctxService = (IContextService)iWorkbenchPartSite.getService((Class)clazz);
            ctxService.deactivateContext(this.fRememberedContextActivation);
            this.fRememberedContextActivation = null;
        }
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fPropertyChangeHandler);
        TerminalViewPlugin plugin = TerminalViewPlugin.getDefault();
        IWorkbench workbench = plugin.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        MenuManager menuMgr = workbenchWindow.getMenuManager();
        menuMgr = (MenuManager)menuMgr.findMenuUsingPath("edit");
        Menu menu = menuMgr.getMenu();
        menuMgr.removeMenuListener((IMenuListener)this.fMenuHandlerEdit);
        if (menu != null) {
            menu.removeMenuListener((MenuListener)this.fMenuHandlerEdit);
        }
        this.fCtlTerminal.disposeTerminal();
    }

    public void setFocus() {
        this.fCtlTerminal.setFocus();
    }

    protected void setupControls(Composite wndParent) {
        ITerminalConnector[] connectors = TerminalConnectorExtension.getTerminalConnectors();
        this.fCtlTerminal = TerminalViewControlFactory.makeControl((ITerminalListener)this, (Composite)wndParent, (ITerminalConnector[])connectors);
        String connectionType = this.fStore.get("ConnectionType");
        int i = 0;
        while (i < connectors.length) {
            connectors[i].load(this.getStore(connectors[i]));
            if (connectors[i].getId().equals(connectionType)) {
                this.fCtlTerminal.setConnector(connectors[i]);
            }
            ++i;
        }
    }

    private void saveSettings(ITerminalConnector connector) {
        ITerminalConnector[] connectors = this.fCtlTerminal.getConnectors();
        int i = 0;
        while (i < connectors.length) {
            connectors[i].save(this.getStore(connectors[i]));
            ++i;
        }
        if (connector != null) {
            this.fStore.put("ConnectionType", connector.getId());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fStore = new SettingsStore(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.fStore.saveState(memento);
    }

    private ISettingsStore getStore(ITerminalConnector connector) {
        return new SettingStorePrefixDecorator(this.fStore, String.valueOf(connector.getClass().getName()) + ".");
    }

    protected void setupActions() {
        this.fActionTerminalNewTerminal = new TerminalActionNewTerminal(this);
        this.fActionTerminalConnect = new TerminalActionConnect(this);
        this.fActionTerminalDisconnect = new TerminalActionDisconnect(this);
        this.fActionTerminalSettings = new TerminalActionSettings(this);
        this.fActionEditCopy = new TerminalActionCopy(this);
        this.fActionEditCut = new TerminalActionCut(this);
        this.fActionEditPaste = new TerminalActionPaste(this);
        this.fActionEditClearAll = new TerminalActionClearAll(this);
        this.fActionEditSelectAll = new TerminalActionSelectAll(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fActionEditCopy);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fActionEditCut);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fActionEditPaste);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fActionEditSelectAll);
    }

    protected void setupMenus() {
        this.fMenuHandlerEdit = new TerminalMenuHandlerEdit();
        TerminalViewPlugin plugin = TerminalViewPlugin.getDefault();
        IWorkbench workbench = plugin.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        MenuManager menuMgr = workbenchWindow.getMenuManager();
        menuMgr = (MenuManager)menuMgr.findMenuUsingPath("edit");
        Menu menu = menuMgr.getMenu();
        menuMgr.addMenuListener((IMenuListener)this.fMenuHandlerEdit);
        menu.addMenuListener((MenuListener)this.fMenuHandlerEdit);
    }

    protected void setupLocalToolBars() {
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.add((IAction)this.fActionTerminalNewTerminal);
        toolBarMgr.add((IAction)this.fActionTerminalConnect);
        toolBarMgr.add((IAction)this.fActionTerminalDisconnect);
        toolBarMgr.add((IAction)this.fActionTerminalSettings);
    }

    protected void setupContextMenus() {
        StyledText ctlText = this.fCtlTerminal.getCtlText();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu((Control)ctlText);
        TerminalContextMenuHandler contextMenuHandler = new TerminalContextMenuHandler();
        ctlText.setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)contextMenuHandler);
        menu.addMenuListener((MenuListener)contextMenuHandler);
    }

    protected void loadContextMenus(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.fActionEditCopy);
        menuMgr.add((IAction)this.fActionEditPaste);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionEditClearAll);
        menuMgr.add((IAction)this.fActionEditSelectAll);
        menuMgr.add((IContributionItem)new Separator("Additions"));
    }

    protected void setupListeners(Composite wndParent) {
        this.fPropertyChangeHandler = new TerminalPropertyChangeHandler();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fPropertyChangeHandler);
    }

    protected class TerminalMenuHandlerEdit
    implements MenuListener,
    IMenuListener {
        protected String fActionDefinitionIdCopy = "";
        protected String fActionDefinitionIdPaste = "";
        protected String fActionDefinitionIdSelectAll = "";
        protected int fAcceleratorCopy = 0;
        protected int fAcceleratorPaste = 0;
        protected int fAcceleratorSelectAll = 0;

        protected TerminalMenuHandlerEdit() {
        }

        public void menuAboutToShow(IMenuManager menuMgr) {
            TerminalView.this.fMenuAboutToShow = true;
            TerminalView.this.updateEditCopy();
            TerminalView.this.updateEditCut();
            TerminalView.this.updateEditPaste();
            TerminalView.this.updateEditSelectAll();
            ActionContributionItem item = (ActionContributionItem)menuMgr.find(ActionFactory.COPY.getId());
            RetargetAction action = (RetargetAction)item.getAction();
            this.fActionDefinitionIdCopy = action.getActionDefinitionId();
            this.fAcceleratorCopy = action.getAccelerator();
            action.setActionDefinitionId(null);
            action.enableAccelerator(false);
            item.update();
            item = (ActionContributionItem)menuMgr.find(ActionFactory.PASTE.getId());
            action = (RetargetAction)item.getAction();
            this.fActionDefinitionIdPaste = action.getActionDefinitionId();
            this.fAcceleratorPaste = action.getAccelerator();
            action.setActionDefinitionId(null);
            action.enableAccelerator(false);
            item.update();
            item = (ActionContributionItem)menuMgr.find(ActionFactory.SELECT_ALL.getId());
            action = (RetargetAction)item.getAction();
            this.fActionDefinitionIdSelectAll = action.getActionDefinitionId();
            this.fAcceleratorSelectAll = action.getAccelerator();
            action.setActionDefinitionId(null);
            action.enableAccelerator(false);
            item.update();
        }

        public void menuShown(MenuEvent event) {
        }

        public void menuHidden(MenuEvent event) {
            TerminalView.this.fMenuAboutToShow = false;
            TerminalView.this.updateEditCopy();
            TerminalView.this.updateEditCut();
            TerminalViewPlugin plugin = TerminalViewPlugin.getDefault();
            IWorkbench workbench = plugin.getWorkbench();
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
            MenuManager menuMgr = workbenchWindow.getMenuManager();
            menuMgr = (MenuManager)menuMgr.findMenuUsingPath("edit");
            ActionContributionItem item = (ActionContributionItem)menuMgr.find(ActionFactory.COPY.getId());
            RetargetAction action = (RetargetAction)item.getAction();
            action.setActionDefinitionId(this.fActionDefinitionIdCopy);
            action.setAccelerator(this.fAcceleratorCopy);
            action.enableAccelerator(true);
            item.update();
            item = (ActionContributionItem)menuMgr.find(ActionFactory.PASTE.getId());
            action = (RetargetAction)item.getAction();
            action.setActionDefinitionId(this.fActionDefinitionIdPaste);
            action.setAccelerator(this.fAcceleratorPaste);
            action.enableAccelerator(true);
            item.update();
            item = (ActionContributionItem)menuMgr.find(ActionFactory.SELECT_ALL.getId());
            action = (RetargetAction)item.getAction();
            action.setActionDefinitionId(this.fActionDefinitionIdSelectAll);
            action.setAccelerator(this.fAcceleratorSelectAll);
            action.enableAccelerator(true);
            item.update();
        }
    }

    protected class TerminalContextMenuHandler
    implements MenuListener,
    IMenuListener {
        protected TerminalContextMenuHandler() {
        }

        public void menuHidden(MenuEvent event) {
            TerminalView.this.fMenuAboutToShow = false;
            TerminalView.this.updateEditCopy();
        }

        public void menuShown(MenuEvent e) {
        }

        public void menuAboutToShow(IMenuManager menuMgr) {
            TerminalView.this.fMenuAboutToShow = true;
            TerminalView.this.updateEditCopy();
            TerminalView.this.updateEditCut();
            TerminalView.this.updateEditPaste();
            TerminalView.this.updateEditClearAll();
            TerminalView.this.loadContextMenus(menuMgr);
        }
    }

    protected class TerminalPropertyChangeHandler
    implements IPropertyChangeListener {
        protected TerminalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(TerminalView.FONT_DEFINITION)) {
                TerminalView.this.onTerminalFontChanged();
            }
        }
    }
}

