/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.eclipse.dstore.core.client.ClientCommandHandler;
import org.eclipse.dstore.core.java.ClassByteStreamHandler;
import org.eclipse.dstore.core.java.ClassByteStreamHandlerRegistry;
import org.eclipse.dstore.core.java.IClassByteStreamHandler;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.java.RemoteClassLoader;
import org.eclipse.dstore.core.model.ByteStreamHandler;
import org.eclipse.dstore.core.model.ByteStreamHandlerRegistry;
import org.eclipse.dstore.core.model.CommandHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStoreAttributes;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.DataStoreSchema;
import org.eclipse.dstore.core.model.DefaultByteConverter;
import org.eclipse.dstore.core.model.IByteConverter;
import org.eclipse.dstore.core.model.IByteStreamHandler;
import org.eclipse.dstore.core.model.ISSLProperties;
import org.eclipse.dstore.core.model.UpdateHandler;
import org.eclipse.dstore.core.util.DataElementRemover;
import org.eclipse.dstore.core.util.ExternalLoader;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.dstore.core.util.XMLgenerator;
import org.eclipse.dstore.core.util.XMLparser;
import org.eclipse.dstore.extra.internal.extra.DomainNotifier;

public final class DataStore {
    private DataStoreAttributes _dataStoreAttributes;
    private RemoteClassLoader _remoteLoader;
    private DataElement _root;
    private DataElement _descriptorRoot;
    private DataElement _logRoot;
    private DataElement _hostRoot;
    private DataElement _minerRoot;
    private DataElement _tempRoot;
    private DataElement _dummy;
    private DataElement _externalRoot;
    private DataElement _status;
    private DataElement _ticket;
    private String _remoteIP;
    private DataStoreSchema _dataStoreSchema;
    private CommandHandler _commandHandler;
    private UpdateHandler _updateHandler;
    private IByteConverter _byteConverter;
    private ByteStreamHandlerRegistry _byteStreamHandlerRegistry;
    private ClassByteStreamHandlerRegistry _classbyteStreamHandlerRegistry;
    private DomainNotifier _domainNotifier;
    private ArrayList _loaders;
    private ArrayList _minersLocations;
    private ArrayList _localClassLoaders;
    private HashMap _dataStorePreferences;
    private ISSLProperties _sslProperties;
    private boolean _autoRefresh;
    private boolean _isConnected;
    private boolean _logTimes;
    private int _timeout;
    private HashMap _hashMap;
    private HashMap _objDescriptorMap;
    private HashMap _cmdDescriptorMap;
    private HashMap _relDescriptorMap;
    private ArrayList _recycled;
    private Random _random;
    private int _initialSize;
    private File _traceFileHandle;
    private RandomAccessFile _traceFile;
    private boolean _tracingOn;
    private boolean _spiritModeOn = false;
    private boolean _spiritCommandReceived = false;
    private File _memLoggingFileHandle;
    private RandomAccessFile _memLogFile;
    private boolean _memLoggingOn;
    private ArrayList _waitingStatuses = null;
    private String _userPreferencesDirectory = null;
    private HashMap _classReqRepository;
    private File _cacheJar;
    public static final String REMOTE_CLASS_CACHE_JARFILE_NAME = "rmt_classloader_cache";
    public static final String JARFILE_EXTENSION = ".jar";
    private DataElementRemover _deRemover;
    public static final int SPIRIT_ON_INITIAL_SIZE = 1000;
    private String referenceTag = null;
    private int _serverVersion;
    private int _serverMinor;
    private List _lastCreatedElements;
    static /* synthetic */ Class class$0;

    public DataStore(DataStoreAttributes attributes) {
        this._dataStoreAttributes = attributes;
        this._commandHandler = null;
        this._updateHandler = null;
        this._domainNotifier = null;
        this._isConnected = false;
        this._logTimes = false;
        this.setSpiritModeOnState();
        this._initialSize = this._spiritModeOn && !this.isVirtual() ? 1000 : 100000;
        this.initialize();
    }

    public DataStore(DataStoreAttributes attributes, int initialSize) {
        this._dataStoreAttributes = attributes;
        this._commandHandler = null;
        this._updateHandler = null;
        this._domainNotifier = null;
        this._isConnected = false;
        this._logTimes = false;
        this.setSpiritModeOnState();
        this._initialSize = this._spiritModeOn && !this.isVirtual() ? 1000 : initialSize;
        this.initialize();
    }

    public DataStore(DataStoreAttributes attributes, CommandHandler commandHandler, UpdateHandler updateHandler, DomainNotifier domainNotifier) {
        this._dataStoreAttributes = attributes;
        this._commandHandler = commandHandler;
        this._updateHandler = updateHandler;
        this._domainNotifier = domainNotifier;
        this._isConnected = true;
        this._logTimes = false;
        this.setSpiritModeOnState();
        this._initialSize = this._spiritModeOn && !this.isVirtual() ? 1000 : 10000;
        this.initialize();
        this.createRoot();
    }

    public DataStore(DataStoreAttributes attributes, CommandHandler commandHandler, UpdateHandler updateHandler, DomainNotifier domainNotifier, int initialSize) {
        this._dataStoreAttributes = attributes;
        this._commandHandler = commandHandler;
        this._updateHandler = updateHandler;
        this._domainNotifier = domainNotifier;
        this._isConnected = true;
        this._logTimes = false;
        this.setSpiritModeOnState();
        this._initialSize = this._spiritModeOn && !this.isVirtual() ? 1000 : initialSize;
        this.initialize();
        this.createRoot();
    }

    protected void setSpiritModeOnState() {
        String doSpirit;
        this._spiritModeOn = this.isVirtual() ? true : (doSpirit = System.getProperty("DSTORE_SPIRIT_ON")) != null && doSpirit.equals("true");
    }

    public void setServerVersion(int version) {
        this._serverVersion = version;
    }

    public void setServerMinor(int minor) {
        this._serverMinor = minor;
    }

    public int getServerVersion() {
        return this._serverVersion;
    }

    public int getServerMinor() {
        return this._serverMinor;
    }

    public void setTicket(DataElement ticket) {
        this._ticket = ticket;
    }

    public void setLoaders(ArrayList loaders) {
        this._loaders = loaders;
    }

    public void addLoader(ExternalLoader loader) {
        if (this._loaders == null) {
            this._loaders = new ArrayList();
        }
        this._loaders.add(loader);
    }

    public boolean usingSSL() {
        if (this._sslProperties != null) {
            return this._sslProperties.usingSSL() && this._sslProperties.usingServerSSL();
        }
        return false;
    }

    public void setSSLProperties(ISSLProperties properties) {
        this._sslProperties = properties;
    }

    public String getKeyStoreLocation() {
        if (this._sslProperties != null) {
            return this._sslProperties.getServerKeyStorePath();
        }
        return null;
    }

    public String getKeyStorePassword() {
        if (this._sslProperties != null) {
            return this._sslProperties.getServerKeyStorePassword();
        }
        return null;
    }

    public DataElement addMinersLocation(String minersLocation) {
        if (this._minersLocations == null) {
            this._minersLocations = new ArrayList();
        }
        if (!this._minersLocations.contains(minersLocation)) {
            this._minersLocations.add(minersLocation);
            if (this.isVirtual()) {
                DataElement location = this.createObject(this._tempRoot, "location", minersLocation);
                DataElement cmd = this.findCommandDescriptor("C_ADD_MINERS");
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                args.add(location);
                return this.command(cmd, args, this._dummy);
            }
        }
        return null;
    }

    public void addMinersLocation(DataElement location) {
        String name = location.getName();
        if (this._minersLocations == null) {
            this._minersLocations = new ArrayList();
        }
        if (!this._minersLocations.contains(name)) {
            this._minersLocations.add(name);
        }
    }

    public void setConnected(boolean isConnected) {
        this._isConnected = isConnected;
    }

    public void setDomainNotifier(DomainNotifier domainNotifier) {
        this._domainNotifier = domainNotifier;
    }

    public void setUpdateHandler(UpdateHandler updateHandler) {
        this._updateHandler = updateHandler;
    }

    public void setCommandHandler(CommandHandler commandHandler) {
        this._commandHandler = commandHandler;
    }

    public void setUpdateWaitTime(int time) {
        this._updateHandler.setWaitTime(time);
    }

    public void setCommandWaitTime(int time) {
        this._commandHandler.setWaitTime(time);
    }

    public void setTimeoutValue(int time) {
        this._timeout = time;
    }

    public int getTimeoutValue() {
        return this._timeout;
    }

    public void setAttribute(int attribute, String value) {
        this._dataStoreAttributes.setAttribute(attribute, value);
    }

    public void setLogTimes(boolean flag) {
        this._logTimes = flag;
    }

    public boolean isVirtual() {
        if (this._commandHandler == null) {
            return true;
        }
        return this._commandHandler instanceof ClientCommandHandler;
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    public boolean logTimes() {
        return this._logTimes;
    }

    public DataElement getTicket() {
        return this._ticket;
    }

    public int getUpdateWaitTime() {
        return this._updateHandler.getWaitTime();
    }

    public int getCommandWaitTime() {
        return this._commandHandler.getWaitTime();
    }

    public String getName() {
        return this.getAttribute(3);
    }

    public DataElement getRoot() {
        return this._root;
    }

    public DataElement getDummy() {
        return this._dummy;
    }

    public DataElement getHostRoot() {
        return this._hostRoot;
    }

    public DataElement getExternalRoot() {
        return this._externalRoot;
    }

    public DataElement getMinerRoot() {
        return this._minerRoot;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public DataElement getLogRoot() {
        return this._logRoot;
    }

    public DataElement getDescriptorRoot() {
        return this._descriptorRoot;
    }

    public DataElement getTempRoot() {
        return this._tempRoot;
    }

    public CommandHandler getCommandHandler() {
        return this._commandHandler;
    }

    public UpdateHandler getUpdateHandler() {
        return this._updateHandler;
    }

    public ArrayList getLoaders() {
        return this._loaders;
    }

    public ArrayList getLocalClassLoaders() {
        return this._localClassLoaders;
    }

    public void registerLocalClassLoader(ClassLoader loader) {
        if (this._localClassLoaders == null) {
            this._localClassLoaders = new ArrayList();
        }
        if (!this._localClassLoaders.contains(loader)) {
            this._localClassLoaders.add(loader);
        }
    }

    public DataElement getContentsRelation() {
        return this._dataStoreSchema.getContentsRelation();
    }

    public DataElement getAttributesRelation() {
        return this._dataStoreSchema.getAttributesRelation();
    }

    public DataElement getAbstractedByRelation() {
        return this._dataStoreSchema.getAbstractedByRelation();
    }

    public DataElement getAbstractsRelation() {
        return this._dataStoreSchema.getAbstractsRelation();
    }

    public ArrayList getMinersLocation() {
        return this._minersLocations;
    }

    public DomainNotifier getDomainNotifier() {
        return this._domainNotifier;
    }

    public String getAttribute(int attribute) {
        return this._dataStoreAttributes.getAttribute(attribute);
    }

    public int getNumElements() {
        return this._hashMap.size();
    }

    public int getNumRecycled() {
        return this._recycled.size();
    }

    public HashMap getHashMap() {
        return this._hashMap;
    }

    public void createRoot() {
        this._root = this.createObject(null, DataStoreResources.model_root, this._dataStoreAttributes.getAttribute(1), this._dataStoreAttributes.getAttribute(2), "rootID");
        this._descriptorRoot = this.createObject(this._root, "objectdescriptor", DataStoreResources.model_descriptors, "", "schemaID");
        this._ticket = this.createObject(this._root, DataStoreResources.model_ticket, "null", "", "ticketID");
        this.createRoots();
        this.initializeDescriptors();
    }

    public DataElement createReference(DataElement from, DataElement to) {
        return this.createReference(from, to, this.getContentsRelation());
    }

    public DataElement createReference(DataElement parent, DataElement realObject, DataElement relationType) {
        if (parent != null) {
            DataElement reference = this.createElement();
            reference.reInit(parent, realObject, relationType);
            parent.addNestedData(reference, false);
            String sugId = reference.getId();
            this._hashMap.put(sugId, reference);
            this.refresh(parent);
            return reference;
        }
        return null;
    }

    public DataElement createReference(DataElement parent, DataElement realObject, String relationType) {
        return this.createReference(parent, realObject, relationType, true);
    }

    public DataElement createReference(DataElement parent, DataElement realObject, String relationType, boolean doRefresh) {
        if (parent != null) {
            DataElement reference = this.createElement();
            DataElement toDescriptor = this.findDescriptor("relationdescriptor", relationType);
            if (toDescriptor != null) {
                reference.reInit(parent, realObject, toDescriptor);
            } else {
                reference.reInit(parent, realObject, relationType);
            }
            parent.addNestedData(reference, false);
            String sugId = reference.getId();
            this._hashMap.put(sugId, reference);
            if (doRefresh) {
                this.refresh(parent);
            }
            return reference;
        }
        return null;
    }

    public void createReferences(DataElement from, ArrayList to, String type) {
        DataElement toDescriptor = this.findDescriptor("relationdescriptor", type);
        if (toDescriptor != null) {
            this.createReferences(from, to, toDescriptor);
        } else {
            int i = 0;
            while (i < to.size()) {
                DataElement toObject = (DataElement)to.get(i);
                this.createReference(from, toObject, type);
                ++i;
            }
        }
    }

    public void createReferences(DataElement from, ArrayList to, DataElement type) {
        int i = 0;
        while (i < to.size()) {
            DataElement toObject = (DataElement)to.get(i);
            this.createReference(from, toObject, type);
            ++i;
        }
    }

    public DataElement createReference(DataElement parent, DataElement realObject, DataElement toRelation, DataElement fromRelation) {
        if (parent != null) {
            DataElement toReference = this.createElement();
            toReference.reInit(parent, realObject, toRelation);
            parent.addNestedData(toReference, false);
            String toId = toReference.getId();
            this._hashMap.put(toId, toReference);
            DataElement fromReference = this.createElement();
            fromReference.reInit(realObject, parent, fromRelation);
            realObject.addNestedData(fromReference, false);
            String fromId = fromReference.getId();
            this._hashMap.put(fromId, fromReference);
            this.refresh(parent);
            return toReference;
        }
        return null;
    }

    public DataElement createReference(DataElement parent, DataElement realObject, String toRelation, String fromRelation) {
        if (parent != null) {
            DataElement toReference = this.createElement();
            DataElement toDescriptor = this.findDescriptor("relationdescriptor", toRelation);
            if (toDescriptor != null) {
                toReference.reInit(parent, realObject, toDescriptor);
            } else {
                toReference.reInit(parent, realObject, toRelation);
            }
            parent.addNestedData(toReference, false);
            String toId = toReference.getId();
            this._hashMap.put(toId, toReference);
            DataElement fromReference = this.createElement();
            DataElement fromDescriptor = this.findDescriptor("relationdescriptor", fromRelation);
            if (fromDescriptor != null) {
                fromReference.reInit(realObject, parent, fromDescriptor);
            } else {
                fromReference.reInit(realObject, parent, fromRelation);
            }
            realObject.addNestedData(fromReference, false);
            String fromId = fromReference.getId();
            this._hashMap.put(fromId, fromReference);
            this.refresh(parent);
            return toReference;
        }
        return null;
    }

    public void createReferences(DataElement from, ArrayList to, DataElement toRel, DataElement fromRel) {
        int i = 0;
        while (i < to.size()) {
            DataElement toObject = (DataElement)to.get(i);
            this.createReference(from, toObject, toRel, fromRel);
            ++i;
        }
    }

    public void createReferences(DataElement from, ArrayList to, String toRel, String fromRel) {
        DataElement toDescriptor = this.findDescriptor("relationdescriptor", toRel);
        DataElement fromDescriptor = this.findDescriptor("relationdescriptor", fromRel);
        if (toDescriptor != null && fromDescriptor != null) {
            this.createReferences(from, to, toDescriptor, fromDescriptor);
        } else {
            int i = 0;
            while (i < to.size()) {
                DataElement toObject = (DataElement)to.get(i);
                this.createReference(from, toObject, toRel, fromRel);
                ++i;
            }
        }
    }

    public DataElement createTransientObject(String[] attributes) {
        DataElement newObject = this.createElement();
        newObject.reInitAsTransient(attributes);
        return newObject;
    }

    public DataElement createObject(DataElement parent, DataElement type, String name) {
        return this.createObject(parent, type, name, "");
    }

    public DataElement createObject(DataElement parent, String type, String name) {
        return this.createObject(parent, type, name, "");
    }

    public DataElement createObject(DataElement parent, DataElement type, String name, String source) {
        String id = this.generateId();
        return this.createObject(parent, type, name, source, id);
    }

    public DataElement createObject(DataElement parent, String type, String name, String source) {
        String id = this.generateId(parent, type, name);
        if (id == null) {
            return null;
        }
        return this.createObject(parent, type, name, source, id);
    }

    public DataElement createObject(DataElement parent, DataElement type, String name, String source, String sugId) {
        return this.createObject(parent, type, name, source, sugId, false);
    }

    public DataElement createObject(DataElement parent, String type, String name, String source, String sugId) {
        return this.createObject(parent, type, name, source, sugId, false);
    }

    public DataElement createObject(DataElement parent, DataElement type, String name, String source, String sugId, boolean isReference) {
        String id = this.makeIdUnique(sugId);
        DataElement newObject = this.createElement();
        if (parent == null) {
            parent = this._tempRoot;
        }
        newObject.reInit(parent, type, id, name, source, isReference);
        if (parent != null) {
            parent.addNestedData(newObject, false);
        }
        this._hashMap.put(id, newObject);
        if (this._autoRefresh) {
            this.refresh(parent);
        }
        return newObject;
    }

    public DataElement createObject(DataElement parent, String type, String name, String source, String sugId, boolean isReference) {
        DataElement descriptor;
        String id = this.makeIdUnique(sugId);
        DataElement newObject = this.createElement();
        if (parent == null) {
            parent = this._tempRoot;
        }
        if ((descriptor = this.findDescriptor("objectdescriptor", type)) != null && parent != this._descriptorRoot) {
            newObject.reInit(parent, descriptor, id, name, source, isReference);
        } else {
            newObject.reInit(parent, type, id, name, source, isReference);
        }
        if (parent != null) {
            parent.addNestedData(newObject, false);
        }
        this._hashMap.put(id, newObject);
        if (this._autoRefresh) {
            this.refresh(parent);
        }
        return newObject;
    }

    public DataElement createObject(DataElement parent, String[] attributes) {
        DataElement descriptor;
        DataElement newObject = this.createElement();
        if (parent == null) {
            parent = this._tempRoot;
        }
        if ((descriptor = this.findObjectDescriptor(attributes[0])) != null && parent != this._descriptorRoot) {
            newObject.reInit(parent, descriptor, attributes);
        } else {
            newObject.reInit(parent, attributes);
        }
        if (parent != null) {
            parent.addNestedData(newObject, false);
        }
        if (descriptor == this._dataStoreSchema.getObjectDescriptor() || descriptor == this._dataStoreSchema.getAbstractObjectDescriptor()) {
            this._objDescriptorMap.put(attributes[2], newObject);
        } else if (descriptor == this._dataStoreSchema.getCommandDescriptor() || descriptor == this._dataStoreSchema.getAbstractCommandDescriptor()) {
            this._cmdDescriptorMap.put(attributes[2], newObject);
        } else if (descriptor == this._dataStoreSchema.getRelationDescriptor() || descriptor == this._dataStoreSchema.getAbstractRelationDescriptor()) {
            this._relDescriptorMap.put(attributes[2], newObject);
        }
        this._hashMap.put(attributes[1], newObject);
        return newObject;
    }

    public DataElement createAbstractObjectDescriptor(DataElement parent, String name) {
        DataElement descriptor = this.createObject(parent, "abstractobjectdescriptor", name, "org.eclipse.rse.dstore.core", name);
        this._objDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createAbstractObjectDescriptor(DataElement parent, String name, String source) {
        DataElement descriptor = this.createObject(parent, "abstractobjectdescriptor", name, source, name);
        this._objDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createObjectDescriptor(DataElement parent, String name) {
        DataElement parentDescriptor = this._dataStoreSchema.getObjectDescriptor();
        DataElement descriptor = null;
        descriptor = parentDescriptor != null ? this.createObject(parent, parentDescriptor, name, "org.eclipse.rse.dstore.core", name) : this.createObject(parent, "objectdescriptor", name, "org.eclipse.rse.dstore.core", name);
        this._objDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createObjectDescriptor(DataElement parent, String name, String source) {
        DataElement parentDescriptor = this._dataStoreSchema.getObjectDescriptor();
        DataElement descriptor = null;
        descriptor = parentDescriptor != null ? this.createObject(parent, parentDescriptor, name, source, name) : this.createObject(parent, "objectdescriptor", name, source, name);
        this._objDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createAbstractRelationDescriptor(DataElement parent, String name) {
        DataElement descriptor = this.createObject(parent, "abstractrelationdescriptor", name, "org.eclipse.rse.dstore.core", name);
        this._relDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createAbstractRelationDescriptor(DataElement parent, String name, String source) {
        DataElement descriptor = this.createObject(parent, "abstractrelationdescriptor", name, source, name);
        this._relDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createRelationDescriptor(DataElement parent, String name) {
        DataElement descriptor = this.createObject(parent, "relationdescriptor", name, "org.eclipse.rse.dstore.core", name);
        this._relDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createRelationDescriptor(DataElement parent, String name, String source) {
        DataElement descriptor = this.createObject(parent, "relationdescriptor", name, source, name);
        this._relDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createAbstractCommandDescriptor(DataElement parent, String name) {
        DataElement descriptor = this.createAbstractCommandDescriptor(parent, name, name);
        this._cmdDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createAbstractCommandDescriptor(DataElement parent, String name, String value) {
        DataElement cmd = this.createObject(parent, "abstractcommanddescriptor", name, "org.eclipse.rse.dstore.core", name);
        cmd.setAttribute(3, value);
        this._cmdDescriptorMap.put(value, cmd);
        return cmd;
    }

    public DataElement createAbstractCommandDescriptor(DataElement parent, String name, String source, String value) {
        DataElement cmd = this.createObject(parent, "abstractcommanddescriptor", name, source, name);
        cmd.setAttribute(3, value);
        this._cmdDescriptorMap.put(value, cmd);
        return cmd;
    }

    public DataElement createCommandDescriptor(DataElement parent, String name) {
        DataElement descriptor = this.createCommandDescriptor(parent, name, name);
        this._cmdDescriptorMap.put(name, descriptor);
        return descriptor;
    }

    public DataElement createCommandDescriptor(DataElement parent, String name, String value) {
        DataElement parentDescriptor = this._dataStoreSchema.getCommandDescriptor();
        DataElement cmd = null;
        cmd = parentDescriptor != null ? this.createObject(parent, parentDescriptor, name, "org.eclipse.rse.dstore.core", name) : this.createObject(parent, "commanddescriptor", name, "org.eclipse.rse.dstore.core", name);
        cmd.setAttribute(3, value);
        this._cmdDescriptorMap.put(value, cmd);
        return cmd;
    }

    public DataElement createCommandDescriptor(DataElement parent, String name, String source, String value) {
        DataElement parentDescriptor = this._dataStoreSchema.getCommandDescriptor();
        DataElement cmd = null;
        cmd = parentDescriptor != null ? this.createObject(parent, parentDescriptor, name, source, name) : this.createObject(parent, "commanddescriptor", name, source, name);
        cmd.setAttribute(3, value);
        this._cmdDescriptorMap.put(value, cmd);
        return cmd;
    }

    public DataElement createCommandDescriptor(DataElement parent, String name, String source, String value, boolean visible) {
        DataElement parentDescriptor = this._dataStoreSchema.getCommandDescriptor();
        DataElement cmd = null;
        cmd = parentDescriptor != null ? this.createObject(parent, parentDescriptor, name, source, name) : this.createObject(parent, "commanddescriptor", name, source, name);
        cmd.setAttribute(3, value);
        if (!visible) {
            cmd.setDepth(0);
        }
        this._cmdDescriptorMap.put(value, cmd);
        return cmd;
    }

    public void moveObject(DataElement source, DataElement target) {
        DataElement oldParent = source.getParent();
        List nested = oldParent.getNestedData();
        if (nested != null) {
            nested.remove(source);
        }
        this.refresh(oldParent, true);
        target.addNestedData(source, false);
        source.setParent(target);
        this.refresh(target, true);
    }

    public void deleteObjects(DataElement from) {
        if (from != null) {
            int i = from.getNestedSize() - 1;
            while (i >= 0) {
                DataElement deletee = from.get(i);
                if (deletee != null) {
                    this.deleteObjectHelper(from, deletee, 5);
                }
                --i;
            }
        }
    }

    public void disconnectObjects(DataElement from) {
        if (!this.isDoSpirit()) {
            return;
        }
        if (from != null) {
            int i = from.getNestedSize() - 1;
            while (i >= 0) {
                DataElement disconnectee = from.get(i);
                if (disconnectee != null) {
                    this.disconnectObjectHelper(disconnectee, 5);
                }
                --i;
            }
        }
    }

    public void deleteObject(DataElement from, DataElement toDelete) {
        if (toDelete != null) {
            this.deleteObjectHelper(from, toDelete, 5);
        }
    }

    public void disconnectObject(DataElement toDisconnect) {
        if (!this.isDoSpirit()) {
            return;
        }
        if (toDisconnect != null) {
            this.disconnectObjectHelper(toDisconnect, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement replaceDeleted(DataElement deletedObject) {
        if (deletedObject != null) {
            DataElement dataElement = deletedObject;
            synchronized (dataElement) {
                String name = deletedObject.getName();
                String type = deletedObject.getType();
                DataElement parent = deletedObject.getParent();
                if (parent != null && parent.isDeleted()) {
                    parent = this.replaceDeleted(parent);
                }
                if (parent != null && !parent.isDeleted()) {
                    int i = 0;
                    while (i < parent.getNestedSize()) {
                        DataElement child = parent.get(i);
                        if (!child.isDeleted() && child.getName().equals(name) && child.getType().equals(type)) {
                            return child;
                        }
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    public boolean contains(String id) {
        return this._hashMap.containsKey(id);
    }

    public void refresh(ArrayList elements) {
        int i = 0;
        while (i < elements.size()) {
            this.refresh((DataElement)elements.get(i));
            ++i;
        }
    }

    public void refresh(DataElement element) {
        if (element != null) {
            if (element.isReference()) {
                this.refresh(element.dereference(), false);
            }
            this.refresh(element, false);
        }
    }

    public void refresh(DataElement element, boolean immediate) {
        if (this._updateHandler != null && element != null) {
            this._updateHandler.update(element, immediate);
        }
    }

    public void refresh(DataElement element, int depth, boolean immediate) {
        if (depth < 0) {
            return;
        }
        if (depth == 0) {
            this.refresh(element, immediate);
        }
        if (depth > 0) {
            if (element.getNestedSize() > 0) {
                List children = element.getNestedData();
                int i = 0;
                while (i < children.size()) {
                    this.refresh((DataElement)children.get(i), depth - 1, immediate);
                    ++i;
                }
            }
            this.refresh(element, immediate);
        }
    }

    public void update(ArrayList objects) {
        int i = 0;
        while (i < objects.size()) {
            this.update((DataElement)objects.get(i));
            ++i;
        }
    }

    public void update(DataElement dataElement) {
        this.refresh(dataElement);
    }

    public void updateRemoteClassInstance(IRemoteClassInstance instance, String byteStreamHandlerId) {
        this.getUpdateHandler().updateClassInstance(instance, byteStreamHandlerId);
    }

    public void updateFile(String remotePath, byte[] bytes, int size, boolean binary) {
        this.updateFile(remotePath, bytes, size, binary, DataStoreResources.DEFAULT_BYTESTREAMHANDLER);
    }

    public void updateFile(String remotePath, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        String fileName = this.mapToLocalPath(remotePath = new String(remotePath.replace('\\', '/')));
        if (fileName != null) {
            this._updateHandler.updateFile(remotePath, bytes, size, binary, byteStreamHandlerId);
        }
    }

    public void updateAppendFile(String remotePath, byte[] bytes, int size, boolean binary) {
        this.updateAppendFile(remotePath, bytes, size, binary, DataStoreResources.DEFAULT_BYTESTREAMHANDLER);
    }

    public void updateAppendFile(String remotePath, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        String fileName = this.mapToLocalPath(remotePath = new String(remotePath.replace('\\', '/')));
        if (fileName != null) {
            this._updateHandler.updateAppendFile(remotePath, bytes, size, binary, byteStreamHandlerId);
        }
    }

    public void replaceFile(String remotePath, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        remotePath = new String(remotePath.replace('\\', '/'));
        this._commandHandler.sendFile(remotePath, bytes, size, binary, byteStreamHandlerId);
    }

    public void replaceFile(String remotePath, byte[] bytes, int size, boolean binary) {
        this.replaceFile(remotePath, bytes, size, binary, DataStoreResources.DEFAULT_BYTESTREAMHANDLER);
    }

    public void replaceAppendFile(String remotePath, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        remotePath = new String(remotePath.replace('\\', '/'));
        this._commandHandler.sendAppendFile(remotePath, bytes, size, binary, byteStreamHandlerId);
    }

    public void replaceAppendFile(String remotePath, byte[] bytes, int size, boolean binary) {
        this.replaceAppendFile(remotePath, bytes, size, binary, DataStoreResources.DEFAULT_BYTESTREAMHANDLER);
    }

    public void setObject(DataElement localObject) {
        this.setObject(localObject, true);
    }

    public void setObject(DataElement localObject, boolean noRef) {
        DataElement cmd = this.findCommandDescriptor("C_SET");
        this.command(cmd, localObject, noRef);
    }

    public void modifyObject(DataElement localObject) {
        DataElement cmd = this.find(this._descriptorRoot, 2, DataStoreResources.model_Modify, 2);
        DataElement status = this._commandHandler.command(cmd, localObject, true);
        this.waitUntil(status, DataStoreResources.model_done);
    }

    public DataElement setHost(DataElement localHostObject) {
        DataElement cmd = this.findCommandDescriptor("C_SET_HOST");
        DataElement status = this._commandHandler.command(cmd, localHostObject, false);
        this.waitUntil(status, DataStoreResources.model_done);
        return status;
    }

    public DataElement getSchema() {
        DataElement cmd = this.findCommandDescriptor("C_SCHEMA");
        return this.command(cmd, this._dummy);
    }

    public void setPreference(String property, String value) {
        DataElement cmd;
        this._dataStorePreferences.put(property, value);
        if (this.isVirtual() && (cmd = this.findCommandDescriptor("C_SET_PREFERENCE")) != null) {
            DataElement prefObj = this.createObject(null, "preference", property);
            prefObj.setAttribute(3, value);
            this.command(cmd, prefObj, true);
        }
    }

    public String getPreference(String property) {
        return (String)this._dataStorePreferences.get(property);
    }

    public DataElement activateMiner(String minerId) {
        DataElement minerInfo = this.findMinerInformation(minerId);
        if (minerInfo == null && this.isVirtual()) {
            DataElement cmd = this.findCommandDescriptor("C_ACTIVATE_MINER");
            DataElement minerObj = this.createObject(null, DataStoreResources.model_miner, minerId);
            return this.command(cmd, minerObj, true);
        }
        return null;
    }

    public DataElement initMiners() {
        DataElement cmd = this.findCommandDescriptor("C_INIT_MINERS");
        return this.command(cmd, this._dummy);
    }

    public DataElement queryInstall() {
        DataElement cmd = this.findCommandDescriptor("C_QUERY_INSTALL");
        return this.synchronizedCommand(cmd, this._dummy);
    }

    public DataElement queryClientIP() {
        DataElement cmd = this.findCommandDescriptor("C_QUERY_CLIENT_IP");
        return this.synchronizedCommand(cmd, this._dummy);
    }

    public boolean queryServerSpiritState() {
        DataElement spirittype = this.findObjectDescriptor("datastore.spirit");
        if (spirittype == null) {
            return false;
        }
        DataElement cmd = this.localDescriptorQuery(spirittype, "C_START_SPIRIT", 2);
        if (cmd == null) {
            return false;
        }
        DataElement status = this.synchronizedCommand(cmd, this._dummy);
        return status != null && status.getName().equals(DataStoreResources.model_done);
    }

    public DataElement queryHostJVM() {
        DataElement cmd = this.findCommandDescriptor("C_QUERY_JVM");
        return this.synchronizedCommand(cmd, this._dummy);
    }

    public void runRemoteClassInstance(IRemoteClassInstance runnable) {
        CommandHandler commandHandler = this.getCommandHandler();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dstore.core.java.ClassByteStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commandHandler.sendClassInstance(runnable, clazz.getName());
    }

    public boolean showTicket(String ticketStr) {
        DataElement ticket = this.createTicket(ticketStr);
        DataElement status = this.queryShowTicket(ticket);
        if (status == null) {
            return true;
        }
        this.waitUntil(status, DataStoreResources.model_done);
        return this.ticketValid(ticket);
    }

    public boolean ticketValid(DataElement ticket) {
        return ticket.getAttribute(3).equals(DataStoreResources.model_valid);
    }

    public DataElement createTicket(String ticketStr) {
        if (ticketStr == null) {
            ticketStr = "null";
        }
        return this.createObject(this._tempRoot, DataStoreResources.model_ticket, ticketStr);
    }

    public DataElement queryShowTicket(DataElement ticket) {
        DataElement cmd = this.findCommandDescriptor("C_VALIDATE_TICKET");
        DataElement status = this._commandHandler.command(cmd, ticket, false);
        if (ticket.getName().equals("null")) {
            return null;
        }
        return status;
    }

    public boolean validTicket() {
        return this._ticket.getAttribute(3).equals(DataStoreResources.model_valid);
    }

    public void waitUntil(DataElement status, String state) {
        this.waitUntil(status, state, this._timeout);
    }

    public boolean isWaiting(DataElement status) {
        return this._waitingStatuses.contains(status);
    }

    public void stopWaiting(DataElement status) {
        this._waitingStatuses.remove(status);
    }

    public void startWaiting(DataElement status) {
        this._waitingStatuses.add(status);
    }

    public void waitUntil(DataElement status, String state, int timeout) {
        int timeToWait = 500;
        int timeWaited = 0;
        boolean timedOut = false;
        this.startWaiting(status);
        while (!(status == null || this._status != null && !this._status.getName().equals("okay") || status.getName().equals(state) || status.getValue().equals(state) || status.getName().equals(DataStoreResources.model_incomplete) || timedOut)) {
            if (timeout != -1 && timeWaited > timeout) {
                timedOut = true;
            }
            status.waitForUpdate(timeToWait);
            timeWaited += timeToWait;
            if (this.isWaiting(status)) continue;
            return;
        }
        this.stopWaiting(status);
        if (timedOut && status != null) {
            status.setAttribute(2, DataStoreResources.model_timeout);
        }
    }

    public void cleanBadReferences(DataElement root) {
    }

    public void cancelAllCommands() {
        this._commandHandler.cancelAllCommands();
    }

    public DataElement synchronizedCommand(DataElement commandDescriptor, DataElement dataObject) {
        return this.synchronizedCommand(commandDescriptor, dataObject, false);
    }

    public DataElement synchronizedCommand(DataElement commandDescriptor, DataElement dataObject, boolean noRef) {
        DataElement status = this.command(commandDescriptor, dataObject, noRef, true);
        this.waitUntil(status, DataStoreResources.model_done);
        return status;
    }

    public DataElement synchronizedCommand(DataElement commandDescriptor, ArrayList arguments, DataElement dataObject) {
        DataElement status = this.command(commandDescriptor, arguments, dataObject, true);
        this.waitUntil(status, DataStoreResources.model_done);
        return status;
    }

    public DataElement command(DataElement commandDescriptor, ArrayList arguments, DataElement dataObject) {
        return this.command(commandDescriptor, arguments, dataObject, false);
    }

    public DataElement command(DataElement commandDescriptor, ArrayList arguments, DataElement dataObject, boolean immediate) {
        if (this._commandHandler != null) {
            return this._commandHandler.command(commandDescriptor, arguments, dataObject, true, immediate);
        }
        return null;
    }

    public DataElement command(DataElement commandDescriptor, DataElement arg, DataElement dataObject) {
        return this.command(commandDescriptor, arg, dataObject, false);
    }

    public DataElement command(DataElement commandDescriptor, DataElement arg, DataElement dataObject, boolean immediate) {
        if (this._commandHandler != null) {
            return this._commandHandler.command(commandDescriptor, arg, dataObject, true, immediate);
        }
        return null;
    }

    public DataElement command(DataElement commandDescriptor, DataElement dataObject) {
        return this.command(commandDescriptor, dataObject, false);
    }

    public DataElement command(DataElement commandDescriptor, DataElement dataObject, boolean noRef) {
        return this.command(commandDescriptor, dataObject, noRef, false);
    }

    public DataElement command(DataElement commandDescriptor, DataElement dataObject, boolean noRef, boolean immediate) {
        if (this._commandHandler != null) {
            return this._commandHandler.command(commandDescriptor, dataObject, !noRef);
        }
        return null;
    }

    public DataElement command(DataElement commandObject) {
        return this._commandHandler.command(commandObject);
    }

    public void flush() {
        this.flush(this._logRoot);
        this.flush(this._hostRoot);
        this.flush(this._minerRoot);
        this.flush(this._tempRoot);
    }

    public void flush(DataElement element) {
        if (element != null) {
            this.deleteObjects(element);
        }
    }

    public DataElement localDescriptorQuery(DataElement object, String keyName) {
        return this.localDescriptorQuery(object, keyName, 5);
    }

    public DataElement localDescriptorQuery(DataElement descriptor, String keyName, int depth) {
        if (descriptor != null && depth > 0) {
            int i = 0;
            while (i < descriptor.getNestedSize()) {
                DataElement subDescriptor = descriptor.get(i).dereference();
                String type = subDescriptor.getType();
                if (type != null) {
                    DataElement result;
                    if (type.equals("commanddescriptor")) {
                        if (keyName.equals(subDescriptor.getValue())) {
                            return subDescriptor;
                        }
                    } else if (type.equals("abstractcommanddescriptor") && (result = this.localDescriptorQuery(subDescriptor, keyName, depth - 1)) != null) {
                        return result;
                    }
                }
                ++i;
            }
            DataElement abstractedBy = this.getAbstractedByRelation();
            List abstractDescriptors = descriptor.getAssociated(abstractedBy);
            int numInherited = abstractDescriptors.size();
            int j = 0;
            while (j < numInherited) {
                DataElement abstractDescriptor = (DataElement)abstractDescriptors.get(j);
                DataElement result = this.localDescriptorQuery(abstractDescriptor, keyName, depth - 1);
                if (result != null) {
                    return result;
                }
                ++j;
            }
        }
        return null;
    }

    public void addToRecycled(DataElement toRecycle) {
        if (!this._recycled.contains(toRecycle)) {
            this._recycled.add(0, toRecycle);
        }
    }

    public DataElement getMinerFor(DataElement commandDescriptor) {
        String minerName = commandDescriptor.getSource();
        DataElement theMinerElement = this.find(this._minerRoot, 2, minerName, 1);
        return theMinerElement;
    }

    public List findObjectsOfType(DataElement root, DataElement type) {
        ArrayList<DataElement> results = new ArrayList<DataElement>();
        List searchList = root.getAssociated(this.getContentsRelation());
        if (searchList != null) {
            int i = 0;
            while (i < searchList.size()) {
                DataElement child = (DataElement)searchList.get(i);
                if (child.isOfType(type)) {
                    results.add(child);
                }
                List subResults = this.findObjectsOfType(child, type);
                int j = 0;
                while (j < subResults.size()) {
                    results.add((DataElement)subResults.get(j));
                    ++j;
                }
                ++i;
            }
        }
        return results;
    }

    public List findObjectsOfType(DataElement root, String type) {
        ArrayList<DataElement> results = new ArrayList<DataElement>();
        List searchList = root.getAssociated(this.getContentsRelation());
        if (searchList != null) {
            int i = 0;
            while (i < searchList.size()) {
                DataElement child = (DataElement)searchList.get(i);
                if (child.getType().equals(type) || child.isOfType(type)) {
                    results.add(child);
                }
                List subResults = this.findObjectsOfType(child, type);
                int j = 0;
                while (j < subResults.size()) {
                    results.add((DataElement)subResults.get(j));
                    ++j;
                }
                ++i;
            }
        }
        return results;
    }

    public synchronized List findDeleted(DataElement root) {
        return this.findDeleted(root, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List findDeleted(DataElement root, int depth) {
        ArrayList<DataElement> results = new ArrayList<DataElement>();
        DataElement dataElement = root;
        synchronized (dataElement) {
            if (root != null && root.getDataStore() == this) {
                List searchList;
                if (results.contains(root)) {
                    return results;
                }
                if (root.isDeleted()) {
                    results.add(root);
                }
                if ((searchList = root.getNestedData()) != null) {
                    int i = 0;
                    while (i < searchList.size()) {
                        DataElement child = (DataElement)searchList.get(i);
                        if (child != null) {
                            DataElement dataElement2 = child;
                            synchronized (dataElement2) {
                                if (child.isDeleted() && !results.contains(child)) {
                                    results.add(child);
                                    if (!child.isReference() && depth > 0) {
                                        List sResults = this.findDeleted(child, depth - 1);
                                        int j = 0;
                                        while (j < sResults.size()) {
                                            results.add((DataElement)sResults.get(j));
                                            ++j;
                                        }
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return results;
    }

    public ArrayList getRelationItems(DataElement descriptor, String fixateOn) {
        ArrayList<DataElement> result = new ArrayList<DataElement>();
        if (descriptor != null) {
            int i = 0;
            while (i < descriptor.getNestedSize()) {
                DataElement object = descriptor.get(i).dereference();
                String objType = (String)object.getElementProperty("type");
                if (objType.equals("relationdescriptor") || objType.equals("abstractrelationdescriptor")) {
                    if (fixateOn != null) {
                        String objName = (String)object.getElementProperty("name");
                        if (objName.equals(fixateOn) && !result.contains(object)) {
                            result.add(object);
                        }
                    } else if (!result.contains(object)) {
                        result.add(object);
                    }
                }
                ++i;
            }
            List baseDescriptors = descriptor.getAssociated(this.getAbstractedByRelation());
            int j = 0;
            while (j < baseDescriptors.size()) {
                DataElement baseDescriptor = (DataElement)baseDescriptors.get(j);
                ArrayList baseRelations = this.getRelationItems(baseDescriptor, fixateOn);
                int k = 0;
                while (k < baseRelations.size()) {
                    DataElement relation = (DataElement)baseRelations.get(k);
                    if (!result.contains(relation)) {
                        result.add(relation);
                    }
                    ++k;
                }
                ++j;
            }
        }
        return result;
    }

    public ArrayList searchForPattern(DataElement root, int attribute, String pattern, boolean ignoreCase) {
        int[] attributes = new int[]{attribute};
        String[] patterns = new String[]{pattern};
        return this.searchForPattern(root, attributes, patterns, 1, ignoreCase);
    }

    public ArrayList searchForPattern(DataElement root, ArrayList attributes, ArrayList patterns, boolean ignoreCase) {
        int[] att = new int[attributes.size()];
        String[] ptn = new String[attributes.size()];
        int i = 0;
        while (i < attributes.size()) {
            att[i] = (Integer)attributes.get(i);
            ptn[i] = (String)patterns.get(i);
            ++i;
        }
        return this.searchForPattern(root, att, ptn, attributes.size(), ignoreCase);
    }

    public ArrayList searchForPattern(DataElement root, int[] attributes, String[] patterns, int numAttributes, boolean ignoreCase) {
        return this.searchForPattern(root, attributes, patterns, numAttributes, ignoreCase, 1);
    }

    public ArrayList searchForPattern(DataElement root, int[] attributes, String[] patterns, int numAttributes, boolean ignoreCase, int depth) {
        ArrayList searched = new ArrayList();
        return this.searchForPattern(root, attributes, patterns, numAttributes, ignoreCase, depth, searched);
    }

    public ArrayList searchForPattern(DataElement root, int[] attributes, String[] patterns, int numAttributes, boolean ignoreCase, int depth, ArrayList searched) {
        ArrayList<DataElement> result = new ArrayList<DataElement>();
        if (depth > 0) {
            int i = 0;
            while (i < root.getNestedSize()) {
                DataElement child = root.get(i);
                if ((child = child.dereference()) != null && !searched.contains(child)) {
                    searched.add(child);
                    if (child.patternMatch(attributes, patterns, numAttributes, ignoreCase)) {
                        result.add(child);
                    }
                    ArrayList subResults = this.searchForPattern(child, attributes, patterns, numAttributes, ignoreCase, depth - 1, searched);
                    int j = 0;
                    while (j < subResults.size()) {
                        result.add((DataElement)subResults.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public DataElement findMinerInformation(String minerName) {
        DataElement information = null;
        DataElement minerElement = this.find(this._minerRoot, 2, minerName, 1);
        if (minerElement != null) {
            information = this.find(minerElement, 0, DataStoreResources.model_data, 1);
        }
        return information;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement findDescriptor(String type, String name) {
        if (this._descriptorRoot != null) {
            DataElement dataElement = this._descriptorRoot;
            synchronized (dataElement) {
                if (type.equals("objectdescriptor")) {
                    return (DataElement)this._objDescriptorMap.get(name);
                }
                if (type.equals("commanddescriptor")) {
                    return (DataElement)this._cmdDescriptorMap.get(name);
                }
                if (type.equals("relationdescriptor")) {
                    return (DataElement)this._relDescriptorMap.get(name);
                }
                int i = 0;
                while (i < this._descriptorRoot.getNestedSize()) {
                    DataElement descriptor = this._descriptorRoot.get(i);
                    if (descriptor.getName().equals(name) && descriptor.getType().equals(type)) {
                        return descriptor;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public DataElement findObjectDescriptor(String name) {
        return (DataElement)this._objDescriptorMap.get(name);
    }

    public DataElement findRelationDescriptor(String name) {
        return (DataElement)this._relDescriptorMap.get(name);
    }

    public DataElement findCommandDescriptor(String name) {
        return (DataElement)this._cmdDescriptorMap.get(name);
    }

    public DataElement find(String id) {
        DataElement result = (DataElement)this._hashMap.get(id);
        return result;
    }

    public DataElement find(DataElement root, int attribute, String name) {
        return this.find(root, attribute, name, 10);
    }

    public DataElement find(DataElement root, int attribute, String name, int depth) {
        if (root != null && name != null && !root.isReference() && depth > 0) {
            if (StringCompare.compare(name, root.getAttribute(attribute), false)) {
                return root;
            }
            if (depth > 0) {
                int h = 0;
                while (h < root.getNestedSize()) {
                    DataElement nestedObject = root.get(h);
                    String compareName = nestedObject.getAttribute(attribute);
                    if (!nestedObject.isReference() && compareName != null) {
                        if (name.compareTo(compareName) == 0) {
                            return nestedObject;
                        }
                        DataElement foundObject = this.find(nestedObject, attribute, name, depth - 1);
                        if (foundObject != null) {
                            return foundObject;
                        }
                    }
                    ++h;
                }
            }
        }
        return null;
    }

    public String mapToLocalPath(String aPath) {
        return aPath;
    }

    public void saveFile(DataElement root, String remotePath, int depth) {
        remotePath = new String(remotePath.replace('\\', '/'));
        String fileName = this.mapToLocalPath(remotePath);
        try {
            File newFile;
            File file = new File(fileName);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {}
            if (!file.exists()) {
                File dir = new File(file.getParent());
                dir.mkdirs();
                file.createNewFile();
            }
            if ((newFile = new File(file.getCanonicalPath())).canWrite()) {
                FileOutputStream fileStream = new FileOutputStream(newFile);
                PrintStream fileWriter = new PrintStream(fileStream);
                BufferedWriter dataWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileStream, "UTF-8"));
                XMLgenerator generator = new XMLgenerator(this);
                generator.setIgnoreDeleted(true);
                generator.setFileWriter(fileWriter);
                generator.setDataWriter(dataWriter);
                generator.setBufferSize(1000);
                generator.generate(root, depth);
                generator.flushData();
                fileStream.close();
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void saveFile(String remotePath, byte[] buffer, int size, boolean binary) {
        this.getDefaultByteStreamHandler().receiveBytes(remotePath, buffer, size, binary);
    }

    public void saveFile(String remotePath, byte[] buffer, int size, boolean binary, String byteStreamHandlerId) {
        this.getByteStreamHandler(byteStreamHandlerId).receiveBytes(remotePath, buffer, size, binary);
    }

    public void saveClass(String className, byte[] buffer, int size) {
        this.getDefaultClassByteStreamHandler().receiveBytes(className, buffer, size);
    }

    public void saveClassInstance(byte[] buffer, int size, String classbyteStreamHandlerId) {
        this.getDefaultClassByteStreamHandler().receiveInstanceBytes(buffer, size);
    }

    public void saveClass(String className, byte[] buffer, int size, String classbyteStreamHandlerId) {
        this.getClassByteStreamHandler(classbyteStreamHandlerId).receiveBytes(className, buffer, size);
    }

    public void appendToFile(String remotePath, byte[] buffer, int size, boolean binary) {
        this.getDefaultByteStreamHandler().receiveAppendedBytes(remotePath, buffer, size, binary);
    }

    public void appendToFile(String remotePath, byte[] buffer, int size, boolean binary, String byteStreamHandlerId) {
        this.getByteStreamHandler(byteStreamHandlerId).receiveAppendedBytes(remotePath, buffer, size, binary);
    }

    public void load(DataElement root, String pathName) {
        String fileName = pathName;
        FileInputStream inFile = DataStore.loadFile(fileName);
        if (inFile != null) {
            BufferedInputStream document = new BufferedInputStream(inFile);
            try {
                XMLparser parser = new XMLparser(this);
                DataElement subRoot = parser.parseDocument(document, null);
                if (subRoot != null) {
                    root.removeNestedData();
                    List nestedData = subRoot.getNestedData();
                    if (nestedData != null) {
                        root.addNestedData(nestedData, true);
                    }
                    this.refresh(root);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static FileInputStream loadFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.length() > 0L) {
            try {
                FileInputStream inFile = new FileInputStream(file);
                return inFile;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    public boolean filter(DataElement descriptor, DataElement dataElement) {
        return this.filter(descriptor, dataElement, 2);
    }

    public boolean filter(DataElement descriptor, DataElement dataElement, int depth) {
        if (depth > 0) {
            --depth;
            String dataType = (String)dataElement.getElementProperty("type");
            String typeStr = (String)descriptor.getElementProperty("name");
            if (dataType != null && typeStr != null && (dataType.equals(typeStr) || typeStr.equals(DataStoreResources.model_all))) {
                return true;
            }
            int i = 0;
            while (i < descriptor.getNestedSize()) {
                if (this.filter(descriptor.get(i), dataElement, depth)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean filter(ArrayList descriptors, DataElement dataElement) {
        int i = 0;
        while (i < descriptors.size()) {
            if (this.filter((DataElement)descriptors.get(i), dataElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTransient(DataElement commandObject) {
        DataElement minerElement;
        DataElement transientObjects;
        boolean isTransient = false;
        DataElement subject = commandObject.get(0);
        DataElement subjectDescriptor = subject.getDescriptor();
        if (subjectDescriptor != null && (transientObjects = this.find(minerElement = this.getMinerFor(commandObject), 0, DataStoreResources.model_transient, 1)) != null) {
            int i = 0;
            while (i < transientObjects.getNestedSize()) {
                DataElement transientDescriptor = transientObjects.get(i).dereference();
                if (transientDescriptor == subjectDescriptor) {
                    isTransient = true;
                }
                ++i;
            }
        }
        return isTransient;
    }

    private void initializeDescriptors() {
        this._dataStoreSchema.extendSchema(this._descriptorRoot);
    }

    public void enableAutoRefresh(boolean flag) {
        this._autoRefresh = flag;
    }

    public boolean isAutoRefreshOn() {
        return this._autoRefresh;
    }

    public String getUserPreferencesDirectory() {
        if (this._userPreferencesDirectory == null) {
            this._userPreferencesDirectory = System.getProperty("user.home");
            String clientUserID = System.getProperty("client.username");
            clientUserID = clientUserID == null || clientUserID.equals("") ? "" : String.valueOf(clientUserID) + File.separator;
            if (this._userPreferencesDirectory.length() == 0 || this._userPreferencesDirectory.charAt(this._userPreferencesDirectory.length() - 1) != File.separatorChar) {
                this._userPreferencesDirectory = String.valueOf(this._userPreferencesDirectory) + File.separator;
            }
            this._userPreferencesDirectory = String.valueOf(this._userPreferencesDirectory) + ".eclipse" + File.separator + "RSE" + File.separator + clientUserID;
            File dirFile = new File(this._userPreferencesDirectory);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
        }
        return this._userPreferencesDirectory;
    }

    private void initialize() {
        this._lastCreatedElements = new ArrayList();
        this._minersLocations = new ArrayList();
        this._random = new Random(System.currentTimeMillis());
        this._objDescriptorMap = new HashMap(100);
        this._cmdDescriptorMap = new HashMap(100);
        this._relDescriptorMap = new HashMap(100);
        this._dataStorePreferences = new HashMap(10);
        this._hashMap = new HashMap(2 * this._initialSize);
        this._recycled = new ArrayList(this._initialSize);
        this.initElements(this._initialSize);
        this._timeout = 20000;
        this._autoRefresh = false;
        this._dataStoreSchema = new DataStoreSchema(this);
        String tracingProperty = System.getProperty("DSTORE_TRACING_ON");
        this._tracingOn = tracingProperty != null && tracingProperty.equals("true");
        if (this._tracingOn) {
            String logDir = this.getUserPreferencesDirectory();
            this._traceFileHandle = new File(logDir, ".dstoreTrace");
            try {
                this._traceFile = new RandomAccessFile(this._traceFileHandle, "rw");
                this.startTracing();
            }
            catch (IOException iOException) {}
        }
        this._classReqRepository = new HashMap();
        this._waitingStatuses = new ArrayList();
        this._byteStreamHandlerRegistry = new ByteStreamHandlerRegistry();
        this._classbyteStreamHandlerRegistry = new ClassByteStreamHandlerRegistry();
        this.setDefaultByteStreamHandler();
        this.setDefaultClassByteStreamHandler();
        this.assignCacheJar();
        this.registerLocalClassLoader(this.getClass().getClassLoader());
    }

    public void startDataElementRemoverThread() {
        if (!this.isVirtual() && this._deRemover == null) {
            String memLogging = System.getProperty("DSTORE_MEMLOGGING_ON");
            boolean bl = this._memLoggingOn = memLogging != null && memLogging.equals("true");
            if (this._memLoggingOn) {
                String logDir = this.getUserPreferencesDirectory();
                this._memLoggingFileHandle = new File(logDir, ".dstoreMemLogging");
                try {
                    this._memLogFile = new RandomAccessFile(this._memLoggingFileHandle, "rw");
                    this.startMemLogging();
                }
                catch (IOException iOException) {}
            }
            this._deRemover = new DataElementRemover(this);
            this._deRemover.start();
        }
    }

    public boolean isDoSpirit() {
        if (this.isVirtual()) {
            return this._spiritModeOn;
        }
        return this._spiritModeOn && this._spiritCommandReceived;
    }

    public void receiveStartSpiritCommand() {
        this._spiritCommandReceived = true;
    }

    public IByteStreamHandler getDefaultByteStreamHandler() {
        return this._byteStreamHandlerRegistry.getDefault();
    }

    public IClassByteStreamHandler getDefaultClassByteStreamHandler() {
        return this._classbyteStreamHandlerRegistry.getDefault();
    }

    public IByteStreamHandler getByteStreamHandler(String id) {
        return this._byteStreamHandlerRegistry.getByteStreamHandler(id);
    }

    public IClassByteStreamHandler getClassByteStreamHandler(String id) {
        return this._classbyteStreamHandlerRegistry.getClassByteStreamHandler(id);
    }

    public void setRemoteIP(String remoteIP) {
        this._remoteIP = remoteIP;
    }

    public String getRemoteIP() {
        return this._remoteIP;
    }

    public void setDefaultByteStreamHandler() {
        this.setDefaultByteStreamHandler(null);
    }

    public void setDefaultClassByteStreamHandler() {
        this.setDefaultClassByteStreamHandler(null);
    }

    public void setDefaultByteStreamHandler(IByteStreamHandler handler) {
        if (handler == null) {
            DataElement log = null;
            handler = new ByteStreamHandler(this, log);
        }
        this._byteStreamHandlerRegistry.setDefaultByteStreamHandler(handler);
    }

    public RemoteClassLoader getRemoteClassLoader() {
        if (this._remoteLoader == null) {
            this._remoteLoader = new RemoteClassLoader(this);
        }
        return this._remoteLoader;
    }

    public void setDefaultClassByteStreamHandler(IClassByteStreamHandler handler) {
        if (handler == null) {
            DataElement log = null;
            handler = new ClassByteStreamHandler(this, log);
        }
        this._classbyteStreamHandlerRegistry.setDefaultClassByteStreamHandler(handler);
    }

    public void registerByteStreamHandler(IByteStreamHandler handler) {
        this._byteStreamHandlerRegistry.registerByteStreamHandler(handler);
    }

    public void registerClassByteStreamHandler(IClassByteStreamHandler handler) {
        this._classbyteStreamHandlerRegistry.registerClassByteStreamHandler(handler);
    }

    public void setByteConverter(IByteConverter converter) {
        this._byteConverter = converter;
    }

    public IByteConverter getByteConverter() {
        if (this._byteConverter == null) {
            this._byteConverter = new DefaultByteConverter();
        }
        return this._byteConverter;
    }

    private void initElements(int size) {
        int i = 0;
        while (i < size) {
            this._recycled.add(new DataElement(this));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DataElement createElement() {
        DataElement newObject = null;
        int numRecycled = this._recycled.size();
        if (numRecycled > 1) {
            ArrayList arrayList = this._recycled;
            synchronized (arrayList) {
                newObject = (DataElement)this._recycled.remove(this._recycled.size() - 1);
            }
        }
        if (newObject == null) {
            newObject = new DataElement(this);
        }
        newObject.setUpdated(false);
        this.updateLastCreated(newObject);
        return newObject;
    }

    private void updateLastCreated(DataElement element) {
        this._lastCreatedElements.add(0, element);
        if (this._lastCreatedElements.size() > 4) {
            int i = this._lastCreatedElements.size() - 1;
            while (i > 4) {
                this._lastCreatedElements.remove(i);
                --i;
            }
        }
    }

    public List getLastCreatedElements() {
        return this._lastCreatedElements;
    }

    private void createRoots() {
        this._externalRoot = this.createObject(this._root, DataStoreResources.model_host, "External DataStores", "", "extID");
        this._tempRoot = this.createObject(this._root, "temp", "Temp Root", "", "tempID");
        this._dummy = this.createObject(this._root, "temp", "dummy");
        this._logRoot = this.createObject(this._root, DataStoreResources.model_log, DataStoreResources.model_Log_Root, "", "logID");
        this._minerRoot = this.createObject(this._root, DataStoreResources.model_miners, DataStoreResources.model_Tool_Root, "", "minersID");
        this._hostRoot = this.createObject(this._root, DataStoreResources.model_host, this._dataStoreAttributes.getAttribute(3), this._dataStoreAttributes.getAttribute(4), "hostID");
        this._status = this.createObject(this._root, DataStoreResources.model_status, "okay", "", "statusID");
    }

    private void deleteObjectHelper(DataElement from, DataElement toDelete, int depth) {
        if (depth > 0) {
            --depth;
            toDelete.delete();
            int i = 0;
            while (i < toDelete.getNestedSize()) {
                DataElement subDelete = toDelete.get(i);
                if (subDelete != null && subDelete.getDataStore() == this && !subDelete.isDeleted()) {
                    this.deleteObjectHelper(toDelete, subDelete, depth);
                }
                ++i;
            }
            String id = toDelete.getAttribute(1);
            this._hashMap.remove(id);
        }
    }

    private void disconnectObjectHelper(DataElement toDisconnect, int depth) {
        if (depth > 0) {
            --depth;
            this._deRemover.addToQueueForRemoval(toDisconnect);
            int i = 0;
            while (i < toDisconnect.getNestedSize()) {
                DataElement subDisconnect = toDisconnect.get(i);
                if (subDisconnect != null && subDisconnect.getDataStore() == this && !subDisconnect.isSpirit()) {
                    this.disconnectObjectHelper(subDisconnect, depth);
                }
                ++i;
            }
        }
    }

    private String makeIdUnique(String id) {
        if (!this._hashMap.containsKey(id)) {
            return id;
        }
        return this.generateId();
    }

    private String generateId(DataElement parent, String type, String name) {
        return this.generateId();
    }

    protected String generateId() {
        String newId = String.valueOf(this._random.nextInt());
        while (this._hashMap.containsKey(newId)) {
            newId = String.valueOf(this._random.nextInt());
        }
        return newId;
    }

    public void startTracing() {
        if (this._tracingOn && this._traceFile != null && this._traceFileHandle != null) {
            try {
                this._traceFile.seek(this._traceFileHandle.length());
            }
            catch (IOException iOException) {}
            this.trace("-----------------------------------------");
            this.trace("Start Tracing at " + System.currentTimeMillis());
        }
    }

    public void startMemLogging() {
        if (this._memLoggingOn && this._memLogFile != null && this._memLoggingFileHandle != null) {
            try {
                this._memLogFile.seek(this._memLoggingFileHandle.length());
            }
            catch (IOException iOException) {}
            this.memLog("-----------------------------------------");
            this.memLog("Start Memory Logging at " + System.currentTimeMillis());
        }
    }

    public void memLog(String str) {
        this.internalMemLog(str);
    }

    public void trace(String str) {
        this.internalTrace(str);
    }

    public void trace(Throwable e) {
        this.internalTrace(e.getMessage());
        this.internalTrace(e);
    }

    private void internalTrace(Throwable e) {
        if (this._tracingOn && this._traceFile != null && e != null) {
            try {
                StackTraceElement[] stack = e.getStackTrace();
                int i = 0;
                while (i < stack.length) {
                    this._traceFile.writeBytes(stack[i].toString());
                    this._traceFile.writeBytes(System.getProperty("line.separator"));
                    ++i;
                }
                this._traceFile.writeBytes(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        }
    }

    private void internalTrace(String message) {
        if (this._tracingOn && this._traceFile != null && message != null) {
            try {
                this._traceFile.writeBytes(message);
                this._traceFile.writeBytes(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        }
    }

    private void internalMemLog(String message) {
        if (this._memLoggingOn && this._memLogFile != null && message != null) {
            try {
                this._memLogFile.writeBytes(String.valueOf(new Date().toString()) + ": ");
                this._memLogFile.writeBytes(message);
                this._memLogFile.writeBytes(System.getProperty("line.separator"));
            }
            catch (IOException iOException) {}
        }
    }

    public void finish() {
        if (this._tracingOn) {
            try {
                this._traceFile.writeBytes("Finished Tracing");
                this._traceFile.writeBytes(System.getProperty("line.separator"));
                this._traceFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void requestClass(String className) {
        if (this.isVirtual()) {
            this._commandHandler.requestClass(className);
        } else {
            this._updateHandler.requestClass(className);
        }
    }

    public void sendKeepAliveRequest() {
        if (this.isVirtual()) {
            this._commandHandler.sendKeepAliveRequest();
        } else {
            this._updateHandler.sendKeepAliveRequest();
        }
    }

    public void sendClass(String className) {
        if (this.isVirtual()) {
            this._commandHandler.sendClass(className);
        } else {
            this._updateHandler.sendClass(className);
        }
    }

    public HashMap getClassRequestRepository() {
        return this._classReqRepository;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void cacheClass(String className, byte[] bytes, int size) {
        block22: {
            if (this._cacheJar == null) {
                return;
            }
            oldJarFile = null;
            try {
                oldJarFile = new JarFile(this._cacheJar);
            }
            catch (IOException v0) {
                System.out.println("Cache jarfile corrupted... erasing it.");
                if (!this._cacheJar.delete()) {
                    System.out.println("Couldn't erase corrupted jarfile!");
                }
                this.assignCacheJar();
                return;
            }
            oldEntries = oldJarFile.entries();
            newJarFile = new File(String.valueOf(this.getCacheDirectory()) + "rmt_classloader_cache" + "_next" + ".jar");
            newJarOutput = null;
            try {
                newJarOutput = this.createNewCacheJar(newJarFile);
                if (true) ** GOTO lbl50
            }
            catch (IOException v1) {
                System.out.println("Class caching failed. Could not create new cache jarfile.");
                return;
            }
            do {
                nextEntry = oldEntries.nextElement();
                source = null;
                try {
                    source = new BufferedInputStream(oldJarFile.getInputStream(nextEntry));
                }
                catch (Exception v2) {
                    continue;
                }
                nextEntry.setCompressedSize(-1L);
                try {
                    newJarOutput.putNextEntry(nextEntry);
                    buf = new byte[1024];
                    numRead = source.read(buf);
                    while (numRead > 0) {
                        newJarOutput.write(buf, 0, numRead);
                        numRead = source.read(buf);
                    }
                    newJarOutput.closeEntry();
                    source.close();
                }
                catch (IOException v3) {
                    System.out.println("Class caching failed. Could not recopy entry from old jar. Cleaning...");
                    try {
                        newJarOutput.close();
                    }
                    catch (IOException v4) {}
                    if (newJarFile.delete()) continue;
                    System.out.println("Couldn't erase new jarfile!");
                }
lbl50:
                // 5 sources

            } while (oldEntries.hasMoreElements());
            newEntry = new JarEntry(String.valueOf(className.replace('.', '/')) + ".class");
            newEntry.setCompressedSize(-1L);
            try {
                newJarOutput.putNextEntry(newEntry);
                newJarOutput.write(bytes, 0, size);
                newJarOutput.closeEntry();
                newJarOutput.close();
            }
            catch (IOException v5) {
                System.out.println("Class caching failed. Could not cache new class into new jar. Cleaning...");
                try {
                    newJarOutput.close();
                }
                catch (IOException v6) {}
                if (newJarFile.delete()) break block22;
                System.out.println("Couldn't erase new jarfile!");
            }
        }
        try {
            oldJarFile.close();
        }
        catch (IOException v7) {}
        if (!this._cacheJar.delete()) {
            System.out.println("Could not delete old cache jar.");
        }
        if (!newJarFile.renameTo(this._cacheJar)) {
            System.out.println("Could not rename new cache jar.");
        }
        System.out.println(String.valueOf(className) + " cached in " + this._cacheJar.getAbsolutePath());
    }

    protected JarOutputStream createNewCacheJar(File newJar) throws IOException {
        newJar.createNewFile();
        JarOutputStream dest = new JarOutputStream(new FileOutputStream(newJar));
        dest.setMethod(8);
        return dest;
    }

    protected void assignCacheJar() {
        String cacheDirectory = this.getCacheDirectory();
        File cacheJar = new File(String.valueOf(cacheDirectory) + REMOTE_CLASS_CACHE_JARFILE_NAME + JARFILE_EXTENSION);
        File nextCacheJar = new File(String.valueOf(cacheDirectory) + REMOTE_CLASS_CACHE_JARFILE_NAME + "_next" + JARFILE_EXTENSION);
        if (nextCacheJar.exists()) {
            nextCacheJar.renameTo(cacheJar);
        }
        if (!cacheJar.exists()) {
            try {
                JarOutputStream cacheOut = this.createNewCacheJar(cacheJar);
                cacheOut.putNextEntry(new JarEntry("/"));
                cacheOut.closeEntry();
                cacheOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                this._cacheJar = null;
                return;
            }
        }
        this._cacheJar = cacheJar;
    }

    protected String getCacheDirectory() {
        String cacheDirectory = this.getUserPreferencesDirectory();
        if (!cacheDirectory.endsWith(File.separator)) {
            cacheDirectory = String.valueOf(cacheDirectory) + File.separator;
        }
        return cacheDirectory;
    }

    public File getRemoteClassLoaderCache() {
        return this._cacheJar;
    }

    public void sendKeepAliveConfirmation() {
        if (this.isVirtual()) {
            this._commandHandler.sendKeepAliveConfirmation();
        } else {
            this._updateHandler.sendKeepAliveConfirmation();
        }
    }

    public String getReferenceTag() {
        return this.referenceTag;
    }

    public void setReferenceTag(String tag) {
        this.referenceTag = tag;
    }
}

