/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.command;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.rse.dstore.universal.miners.command.CommandMinerThread;

public class OutputHandler
extends Handler {
    private DataInputStream _reader;
    private boolean _isStdError;
    private boolean _isTerminal;
    private CommandMinerThread _commandThread;
    private boolean _isShell;
    private boolean _endOfStream = false;
    private List _encodings;

    public OutputHandler(DataInputStream reader, String qualifier, boolean isTerminal, boolean isStdError, boolean isShell, CommandMinerThread commandThread) {
        this._reader = reader;
        this._isStdError = isStdError;
        this._isTerminal = isTerminal;
        this._commandThread = commandThread;
        this._isShell = isShell;
        this._encodings = new ArrayList();
        String system = System.getProperty("os.name").toLowerCase();
        if (system.startsWith("z")) {
            this._encodings.add("IBM-1047");
        } else {
            String specialEncoding = System.getProperty("dstore.stdin.encoding");
            if (specialEncoding != null) {
                this._encodings.add(specialEncoding);
            }
            this._encodings.add(System.getProperty("file.encoding"));
        }
    }

    public void newCommand() {
    }

    public void handle() {
        String[] lines = this.readLines();
        if (lines != null) {
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                this._commandThread.interpretLine(line, this._isStdError);
                ++i;
            }
            if (!this._isTerminal) {
                this.doPrompt();
            }
        } else {
            this.finish();
        }
    }

    private void doPrompt() {
        block5: {
            try {
                if (this._reader.available() != 0 || this._isStdError || !this._isShell || this._isTerminal) break block5;
                try {
                    Thread.sleep(500L);
                    if (this._reader.available() == 0) {
                        this._commandThread.createPrompt(String.valueOf(this._commandThread.getCWD()) + '>', this._commandThread.getCWD());
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void waitForInput() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readLines() {
        if (this._endOfStream) {
            return null;
        }
        String[] output = null;
        try {
            int available = this._reader.available();
            int lookahead = 0;
            if (available <= 0) {
                OutputHandler.sleep((long)100L);
                available = this._reader.available();
                if (available == 0) {
                    lookahead = this._reader.read();
                    if (lookahead == -1) {
                        return null;
                    }
                    available = this._reader.available() + 1;
                }
            }
            byte[] readBytes = new byte[available];
            int numRead = 0;
            if (lookahead > 0) {
                readBytes[0] = (byte)lookahead;
                numRead = this._reader.read(readBytes, 1, available - 1) + 1;
            } else {
                numRead = this._reader.read(readBytes, 0, available);
            }
            if (numRead == -1) {
                return null;
            }
            if (readBytes[numRead - 1] == -1) {
                this._endOfStream = true;
            }
            int encodingIndex = 0;
            while (true) {
                if (encodingIndex >= this._encodings.size()) {
                    return output;
                }
                String encoding = (String)this._encodings.get(encodingIndex);
                try {
                    String fullOutput = new String(readBytes, 0, numRead, encoding);
                    StringTokenizer tokenizer = new StringTokenizer(fullOutput, "\n\r");
                    int numTokens = tokenizer.countTokens();
                    output = new String[numTokens];
                    int index = 0;
                    while (true) {
                        if (!tokenizer.hasMoreTokens()) {
                            return output;
                        }
                        output[index] = tokenizer.nextToken();
                        ++index;
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return output;
    }
}

