/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.util.StringTokenizer;
import org.eclipse.dstore.core.server.ConnectionEstablisher;

public class Server {
    private ConnectionEstablisher _establisher;

    public static void main(String[] args) {
        System.err.println("DStore Server Starting...");
        String jversion = System.getProperty("java.version");
        StringTokenizer tokenizer = new StringTokenizer(jversion, ".");
        try {
            String[] vers = new String[3];
            vers[0] = tokenizer.nextToken();
            vers[1] = tokenizer.nextToken();
            int version = Integer.parseInt(vers[0]);
            int major = Integer.parseInt(vers[1]);
            if (version < 1 || major < 4) {
                System.err.println("JRE 1.4 or higher required");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.err.println("JRE 1.4 or higher required");
            System.exit(-1);
        }
        try {
            Server theServer = null;
            switch (args.length) {
                case 0: {
                    theServer = new Server();
                    break;
                }
                case 1: {
                    theServer = new Server(args[0]);
                    break;
                }
                case 2: {
                    theServer = new Server(args[0], args[1]);
                    break;
                }
                case 3: {
                    theServer = new Server(args[0], args[1], args[2]);
                    break;
                }
            }
            if (theServer != null) {
                theServer.run();
            }
        }
        catch (SecurityException e) {
            System.err.println("Security error creating socket");
            throw e;
        }
    }

    public Server() {
        this._establisher = new ConnectionEstablisher();
    }

    public Server(String port) {
        this._establisher = new ConnectionEstablisher(port);
    }

    public Server(String port, String timeout) {
        this._establisher = new ConnectionEstablisher(port, timeout);
    }

    public Server(String port, String timeout, String ticket) {
        this._establisher = new ConnectionEstablisher(port, timeout, ticket);
    }

    public void run() {
        this._establisher.start();
    }
}

