/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.shell;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.shell.SshShellOutputReader;
import org.eclipse.rse.internal.services.ssh.shell.SshShellWriterThread;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class SshHostShell
extends AbstractHostShell
implements IHostShell {
    public static final String SHELL_INVOCATION = ">";
    private ISshSessionProvider fSessionProvider;
    private Channel fChannel;
    private SshShellOutputReader fStdoutHandler;
    private SshShellOutputReader fStderrHandler;
    private SshShellWriterThread fShellWriter;
    private static final Pattern cdCommands = Pattern.compile("\\A\\s*(cd|chdir|ls)\\b");

    public SshHostShell(ISshSessionProvider sessionProvider, String initialWorkingDirectory, String commandToRun, String encoding, String[] environment) {
        block10: {
            try {
                this.fSessionProvider = sessionProvider;
                this.fChannel = this.fSessionProvider.getSession().openChannel("shell");
                if (environment != null && environment.length > 0 && this.fChannel instanceof ChannelShell) {
                    Hashtable<String, String> envTable = new Hashtable<String, String>();
                    int i = 0;
                    while (i < environment.length) {
                        String curStr = environment[i];
                        int curLen = environment[i].length();
                        int idx = curStr.indexOf(61);
                        if (idx > 0 && idx < curLen - 1) {
                            String key = environment[i].substring(0, idx);
                            String value = environment[i].substring(idx + 1, curLen);
                            envTable.put(key, value);
                        }
                        ++i;
                    }
                    ((ChannelShell)this.fChannel).setEnv(envTable);
                }
                this.fStdoutHandler = new SshShellOutputReader(this, new BufferedReader(new InputStreamReader(this.fChannel.getInputStream())), false);
                this.fStderrHandler = new SshShellOutputReader(this, null, true);
                OutputStream outputStream = this.fChannel.getOutputStream();
                PrintWriter outputWriter = new PrintWriter(outputStream);
                this.fShellWriter = new SshShellWriterThread(outputWriter);
                this.fChannel.connect();
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                } else if (SHELL_INVOCATION.equals(commandToRun)) {
                    this.writeToShell(this.getPromptCommand());
                } else if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.fShellWriter == null) break block10;
                this.fShellWriter.stopThread();
                this.fShellWriter = null;
            }
        }
    }

    protected void start(IProgressMonitor monitor) {
    }

    public boolean isActive() {
        if (this.fChannel != null && !this.fChannel.isEOF()) {
            return true;
        }
        this.exit();
        Session session = this.fSessionProvider.getSession();
        if (session != null && !session.isConnected()) {
            this.fSessionProvider.handleSessionLost();
        }
        return false;
    }

    public String getPromptCommand() {
        return "echo $PWD'>'";
    }

    public void writeToShell(String command) {
        if (this.isActive()) {
            if ("#break".equals(command)) {
                command = "\u0003";
            } else if (cdCommands.matcher(command).find()) {
                command = String.valueOf(command) + "\r\n" + this.getPromptCommand();
            }
            if (!this.fShellWriter.sendCommand(command)) {
                this.exit();
                this.isActive();
            }
        }
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this.fStdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this.fStderrHandler;
    }

    public void exit() {
        if (this.fShellWriter != null) {
            this.fShellWriter.stopThread();
        }
        if (this.fChannel != null) {
            this.fChannel.disconnect();
        }
    }
}

