/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.internal.core.model.SystemProfile;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;

public class SystemProfileManager
implements ISystemProfileManager {
    private List _profiles = new ArrayList(10);
    private static SystemProfileManager singleton = null;
    private boolean restoring = false;

    private SystemProfileManager() {
    }

    public static SystemProfileManager getDefault() {
        if (singleton == null) {
            singleton = new SystemProfileManager();
            RSECorePlugin.getThePersistenceManager().restoreProfiles(5000L);
            singleton.ensureDefaultPrivateProfile();
            singleton.ensureDefaultTeamProfile();
        }
        return singleton;
    }

    public static void clearDefault() {
        singleton = null;
    }

    public void setRestoring(boolean flag) {
        this.restoring = flag;
    }

    public ISystemProfile createSystemProfile(String name, boolean makeActive) {
        ISystemProfile existingProfile = this.getSystemProfile(name);
        if (existingProfile != null) {
            this.deleteSystemProfile(existingProfile, false);
        }
        ISystemProfile newProfile = this.internalCreateSystemProfile(name);
        if (makeActive) {
            RSEPreferencesManager.addActiveProfile(name);
            ((SystemProfile)newProfile).setActive(makeActive);
        }
        newProfile.commit();
        return newProfile;
    }

    public void makeSystemProfileActive(ISystemProfile profile, boolean makeActive) {
        boolean wasActive = this.isSystemProfileActive(profile.getName());
        if (wasActive && !makeActive) {
            RSEPreferencesManager.deleteActiveProfile(profile.getName());
        } else if (makeActive && !wasActive) {
            RSEPreferencesManager.addActiveProfile(profile.getName());
        }
        ((SystemProfile)profile).setActive(makeActive);
    }

    public ISystemProfile[] getSystemProfiles() {
        return this.getSystemProfiles(!this.restoring);
    }

    public String[] getSystemProfileNames() {
        ISystemProfile[] profiles = this.getSystemProfiles();
        String[] profileNames = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            ISystemProfile profile = profiles[i];
            profileNames[i] = profile.getName();
            ++i;
        }
        return profileNames;
    }

    public ISystemProfile getSystemProfile(String name) {
        ISystemProfile result = null;
        Iterator z = this._profiles.iterator();
        while (z.hasNext()) {
            ISystemProfile p = (ISystemProfile)z.next();
            if (!p.getName().equals(name)) continue;
            result = p;
            break;
        }
        return result;
    }

    private ISystemProfile getSystemProfileOld(String name) {
        ISystemProfile[] profiles = this.getSystemProfiles();
        if (profiles == null || profiles.length == 0) {
            return null;
        }
        ISystemProfile match = null;
        int idx = 0;
        while (match == null && idx < profiles.length) {
            if (profiles[idx].getName().equals(name)) {
                match = profiles[idx];
            }
            ++idx;
        }
        return match;
    }

    public void renameSystemProfile(ISystemProfile profile, String newName) {
        boolean isActive = this.isSystemProfileActive(profile.getName());
        String oldName = profile.getName();
        profile.setName(newName);
        if (isActive) {
            RSEPreferencesManager.renameActiveProfile(oldName, newName);
        }
    }

    public void deleteSystemProfile(ISystemProfile profile, boolean persist) {
        String oldName = profile.getName();
        boolean isActive = this.isSystemProfileActive(oldName);
        this._profiles.remove(profile);
        if (isActive) {
            RSEPreferencesManager.deleteActiveProfile(oldName);
        }
        if (persist) {
            IRSEPersistenceProvider provider = profile.getPersistenceProvider();
            RSECorePlugin.getThePersistenceManager().deleteProfile(provider, oldName);
        }
    }

    public ISystemProfile cloneSystemProfile(ISystemProfile profile, String newName) {
        ISystemProfile newProfile = this.createSystemProfile(newName, false);
        return newProfile;
    }

    public boolean isSystemProfileActive(String profileName) {
        ISystemProfile profile = this.getSystemProfile(profileName);
        return profile.isActive();
    }

    private boolean isSystemProfileActiveOld(String profileName) {
        String[] activeProfiles = this.getActiveSystemProfileNames();
        boolean match = false;
        int idx = 0;
        while (!match && idx < activeProfiles.length) {
            if (activeProfiles[idx].equals(profileName)) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    public ISystemProfile[] getActiveSystemProfiles() {
        ArrayList<ISystemProfile> activeProfiles = new ArrayList<ISystemProfile>();
        Iterator z = this._profiles.iterator();
        while (z.hasNext()) {
            ISystemProfile p = (ISystemProfile)z.next();
            if (!p.isActive()) continue;
            activeProfiles.add(p);
        }
        ISystemProfile[] result = new ISystemProfile[activeProfiles.size()];
        activeProfiles.toArray(result);
        return result;
    }

    public String[] getActiveSystemProfileNames() {
        ISystemProfile[] profiles = this.getActiveSystemProfiles();
        String[] names = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            ISystemProfile systemProfile = profiles[i];
            names[i] = systemProfile.getName();
            ++i;
        }
        return names;
    }

    private String[] getActiveSystemProfileNamesOld() {
        String[] activeProfileNames = RSEPreferencesManager.getActiveProfiles();
        ISystemProfile[] systemProfiles = this.getSystemProfiles();
        boolean found_team = false;
        boolean found_private = false;
        boolean changed = false;
        String defaultProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
        int activeIdx = 0;
        while (activeIdx < activeProfileNames.length) {
            String activeProfileName = activeProfileNames[activeIdx];
            if (activeProfileName.equals(defaultProfileName)) {
                found_private = true;
            } else if (activeProfileName.equals(RSEPreferencesManager.getDefaultTeamProfileName())) {
                found_team = true;
            } else {
                boolean found = false;
                int systemIdx = 0;
                while (systemIdx < systemProfiles.length && !found) {
                    if (activeProfileNames[activeIdx].equals(systemProfiles[systemIdx].getName())) {
                        found = true;
                    }
                    ++systemIdx;
                }
                if (!found) {
                    RSEPreferencesManager.deleteActiveProfile(activeProfileNames[activeIdx]);
                    changed = true;
                }
            }
            ++activeIdx;
        }
        int systemIdx = 0;
        while (systemIdx < systemProfiles.length && !changed) {
            boolean matchesBoth = false;
            String name = systemProfiles[systemIdx].getName();
            int activeIdx2 = 0;
            while (activeIdx2 < activeProfileNames.length && !matchesBoth) {
                String aname = activeProfileNames[activeIdx2];
                if (name.equals(aname)) {
                    matchesBoth = true;
                }
                ++activeIdx2;
            }
            if (!matchesBoth && found_private && (systemProfiles[systemIdx].isActive() || systemProfiles[systemIdx].isDefaultPrivate())) {
                RSEPreferencesManager.addActiveProfile(name);
                RSEPreferencesManager.deleteActiveProfile(RSECorePlugin.getLocalMachineName());
                activeProfileNames = RSEPreferencesManager.getActiveProfiles();
            }
            ++systemIdx;
        }
        if (changed || !found_team || !found_private) {
            if (systemProfiles.length == 0) {
                if (!found_team) {
                    RSEPreferencesManager.addActiveProfile(RSEPreferencesManager.getDefaultTeamProfileName());
                    changed = true;
                }
                if (!found_private) {
                    RSEPreferencesManager.addActiveProfile(RSECorePlugin.getLocalMachineName());
                    changed = true;
                }
            } else {
                ISystemProfile defaultProfile = this.getDefaultPrivateSystemProfile();
                if (defaultProfile != null && !found_private) {
                    RSEPreferencesManager.addActiveProfile(defaultProfile.getName());
                    changed = true;
                }
            }
            if (changed) {
                activeProfileNames = RSEPreferencesManager.getActiveProfiles();
            }
        }
        return activeProfileNames;
    }

    public ISystemProfile getDefaultPrivateSystemProfile() {
        return this.getSystemProfile(RSEPreferencesManager.getDefaultPrivateSystemProfileName());
    }

    public ISystemProfile getDefaultTeamSystemProfile() {
        return this.getSystemProfile(RSEPreferencesManager.getDefaultTeamProfileName());
    }

    public int getSize() {
        return this._profiles.size();
    }

    public void addSystemProfile(ISystemProfile profile) {
        this._profiles.add(profile);
        profile.setProfileManager(this);
        String name = profile.getName();
        if (profile.isActive()) {
            RSEPreferencesManager.addActiveProfile(name);
        }
    }

    private void createDefaultPrivateProfile() {
        String initProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
        ISystemProfile profile = this.internalCreateSystemProfile(initProfileName);
        profile.setDefaultPrivate(true);
    }

    private ISystemProfile internalCreateSystemProfile(String name) {
        SystemProfile profile = new SystemProfile();
        profile.setName(name);
        this.addSystemProfile(profile);
        return profile;
    }

    private void ensureDefaultPrivateProfile() {
        ISystemProfile profile;
        Iterator z;
        boolean defaultProfileExists = false;
        Iterator z2 = this._profiles.iterator();
        while (z2.hasNext() && !defaultProfileExists) {
            ISystemProfile profile2 = (ISystemProfile)z2.next();
            defaultProfileExists = profile2.isDefaultPrivate();
        }
        if (!defaultProfileExists) {
            String defaultPrivateProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
            z = this._profiles.iterator();
            while (z.hasNext() && !defaultProfileExists) {
                profile = (ISystemProfile)z.next();
                if (!profile.getName().equals(defaultPrivateProfileName)) continue;
                profile.setDefaultPrivate(true);
                defaultProfileExists = true;
            }
        }
        if (!defaultProfileExists) {
            String defaultTeamProfileName = RSEPreferencesManager.getDefaultTeamProfileName();
            z = this._profiles.iterator();
            while (z.hasNext() && !defaultProfileExists) {
                profile = (ISystemProfile)z.next();
                if (profile.getName().equals(defaultTeamProfileName)) continue;
                profile.setDefaultPrivate(true);
                defaultProfileExists = true;
            }
        }
        if (!defaultProfileExists) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logWarning("Only one Profile Team exists - there is no Default Profile");
            this.createDefaultPrivateProfile();
        }
    }

    private void ensureDefaultTeamProfile() {
        String name = RSEPreferencesManager.getDefaultTeamProfileName();
        ISystemProfile teamProfile = this.getSystemProfile(name);
        if (teamProfile == null) {
            teamProfile = this.internalCreateSystemProfile(name);
        }
    }

    private ISystemProfile[] getSystemProfiles(boolean ensureDefaultPrivateProfileExists) {
        if (ensureDefaultPrivateProfileExists) {
            this.ensureDefaultPrivateProfile();
        }
        ISystemProfile[] result = new ISystemProfile[this._profiles.size()];
        this._profiles.toArray(result);
        return result;
    }
}

