/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.search.SystemSearchRemoteFolderAction;
import org.eclipse.rse.internal.files.ui.search.SystemSearchSelectFileTypesAction;
import org.eclipse.rse.internal.ui.view.search.SystemSearchUI;
import org.eclipse.rse.internal.ui.view.search.SystemSearchViewPart;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.search.SystemSearchUtil;
import org.eclipse.rse.services.search.HostSearchResultSet;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemSearchPage
extends DialogPage
implements ISearchPage {
    public static final String SYSTEM_SEARCH_PAGE_ID = "org.eclipse.rse.internal.files.ui.search.searchPage";
    private SystemSearchUtil util;
    private ISearchPageContainer container;
    private boolean isFirstShow = true;
    private Label stringLabel;
    private Combo stringCombo;
    private Button caseButton;
    private Label stringHintLabel;
    private Button stringRegexButton;
    private boolean initialCaseSensitive;
    private boolean initialStringRegex;
    private Label fileNameLabel;
    private Combo fileNameCombo;
    private Button fileNameBrowseButton;
    private Label fileNameHintLabel;
    private Button fileNameRegexButton;
    private boolean initialFileNameRegex;
    private FileNameEditor fileNameEditor;
    private Label folderNameLabel;
    private Combo folderNameCombo;
    private Button folderNameBrowseButton;
    private FolderNameEditor folderNameEditor;
    private Button searchArchivesButton;
    private Button searchSubfoldersButton;
    private boolean initialSearchArchives;
    private boolean initialSearchSubfolders;
    private static final String REMOTE_SEARCH_PAGE_NAME = "RemoteSearchPage";
    private static final String STORE_CONFIG_CASE_SENSITIVE = "caseSensitive";
    private static final String STORE_CONFIG_STRING_REGEX = "stringRegex";
    private static final String STORE_CONFIG_FILENAME_REGEX = "fileNameRegex";
    private static final String STORE_CONFIG_INCLUDE_ARCHIVES = "includeArchives";
    private static final String STORE_CONFIG_INCLUDE_SUBFOLDERS = "includeSubfolders";
    private static final String STORE_CONFIG_DATA_SIZE = "dataSize";
    private static final String STORE_DATA_PREFIX = "RemoteSearchPage.data";
    private static final String STORE_DATA_SEARCH_STRING = "searchString";
    private static final String STORE_DATA_CASE_SENSITIVE = "caseSensitive";
    private static final String STORE_DATA_STRING_REGEX = "stringRegex";
    private static final String STORE_DATA_FILE_NAMES = "fileNames";
    private static final String STORE_DATA_FILE_NAME_REGEX = "fileNameRegex";
    private static final String STORE_DATA_PROFILE_NAME = "profileName";
    private static final String STORE_DATA_CONNECTION_NAME = "connectionName";
    private static final String STORE_DATA_FOLDER_NAME = "folderName";
    private static final String STORE_DATA_INCLUDE_ARCHIVES = "includeArchives";
    private static final String STORE_DATA_INCLUDE_SUBFOLDERS = "includeSubfolders";
    private List previousSearchData = new ArrayList();
    private static final int MAX_DATA_SIZE = 20;

    public SystemSearchPage() {
        this.util = SystemSearchUtil.getInstance();
    }

    private RemoteSearchData getSearchData() {
        RemoteSearchData data = null;
        String searchString = this.stringCombo.getText();
        int i = this.previousSearchData.size() - 1;
        boolean matchFound = false;
        while (i >= 0) {
            data = (RemoteSearchData)this.previousSearchData.get(i);
            if (searchString.equals(data.searchString)) {
                matchFound = true;
                break;
            }
            --i;
        }
        if (matchFound && data != null) {
            data.searchString = searchString;
            data.caseSensitive = this.caseButton.getSelection();
            data.stringRegex = this.stringRegexButton.getSelection();
            data.fileNames = this.getFileNames();
            data.fileNameRegex = this.fileNameRegexButton.getSelection();
            data.profileName = this.getProfileName();
            data.connectionName = this.getConnectionName();
            data.folderName = this.getFolderName();
            data.includeArchives = this.searchArchivesButton.getSelection();
            data.includeSubfolders = this.searchSubfoldersButton.getSelection();
            this.previousSearchData.remove(data);
        } else {
            data = new RemoteSearchData(searchString, this.caseButton.getSelection(), this.stringRegexButton.getSelection(), this.getFileNames(), this.fileNameRegexButton.getSelection(), this.getProfileName(), this.getConnectionName(), this.getFolderName(), this.searchArchivesButton.getSelection(), this.searchSubfoldersButton.getSelection());
        }
        if (this.previousSearchData.size() == 20) {
            this.previousSearchData.remove(0);
        }
        this.previousSearchData.add(data);
        return data;
    }

    private String getFileNames() {
        return this.fileNameEditor.getFileNamesText();
    }

    private String getProfileName() {
        return this.folderNameEditor.getProfileName();
    }

    private String getConnectionName() {
        return this.folderNameEditor.getConnectionName();
    }

    private String getFolderName() {
        return this.folderNameEditor.getFolderPath();
    }

    public boolean performAction() {
        IRemoteFile remoteFile;
        String fileNameString;
        String searchString;
        if (this.stringRegexButton.getSelection() && (searchString = this.stringCombo.getText()) != null && searchString.length() != 0 && !this.util.isValidRegex(searchString)) {
            SystemMessage message = RSEUIPlugin.getPluginMessage((String)"RSEG1601");
            message.makeSubstitution((Object)searchString);
            SystemMessageDialog.displayErrorMessage((Shell)this.getShell(), (SystemMessage)message);
            this.stringCombo.setFocus();
            return false;
        }
        if (this.fileNameRegexButton.getSelection() && (fileNameString = this.fileNameEditor.getFileNamesText()) != null && fileNameString.length() != 0 && !this.util.isValidRegex(fileNameString)) {
            SystemMessage message = RSEUIPlugin.getPluginMessage((String)"RSEG1601");
            message.makeSubstitution((Object)fileNameString);
            SystemMessageDialog.displayErrorMessage((Shell)this.getShell(), (SystemMessage)message);
            this.fileNameCombo.setFocus();
            return false;
        }
        RemoteSearchData data = this.getSearchData();
        SystemSearchString searchString2 = new SystemSearchString(data.searchString, data.caseSensitive, data.stringRegex, data.fileNames, data.fileNameRegex, data.includeArchives, data.includeSubfolders);
        IRemoteFileSubSystem subsys = this.getRemoteFileSubSystem(data.profileName, data.connectionName);
        if (subsys == null) {
            return false;
        }
        try {
            remoteFile = subsys.getRemoteFileObject(data.folderName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"Error occured trying to get remote file object", (Throwable)e);
            return false;
        }
        HostSearchResultSet set = new HostSearchResultSet();
        if (subsys instanceof FileServiceSubSystem) {
            String name = String.valueOf(remoteFile.getAbsolutePath()) + " - " + searchString2.getFileNamesString() + "(" + searchString2.getTextString() + ")";
            set.setName(name);
            FileServiceSubSystem ss = (FileServiceSubSystem)subsys;
            IHostSearchResultConfiguration config = ss.createSearchConfiguration((IHostSearchResultSet)set, (Object)remoteFile, searchString2);
            this.showInView((IHostSearchResultSet)set);
            ss.search(config);
            this.writeConfiguration();
            this.writeData();
        }
        return true;
    }

    private void showInView(IHostSearchResultSet resultSet) {
        SystemSearchUI searchUI = SystemSearchUI.getInstance();
        SystemSearchViewPart searchPart = searchUI.activateSearchResultView();
        searchPart.addSearchResult((IAdaptable)resultSet);
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.isFirstShow) {
                this.isFirstShow = false;
                this.readData();
                this.setPreviousSearchStrings();
                this.setPreviousFileNames();
                this.setPreviousFolderNames();
                this.initialize();
            }
            this.stringCombo.setFocus();
            this.container.setPerformActionEnabled(this.isValid());
        }
        super.setVisible(visible);
    }

    private void setPreviousSearchStrings() {
        int size = this.previousSearchData.size();
        String[] searchStrings = new String[size];
        int i = 0;
        while (i < size) {
            searchStrings[i] = ((RemoteSearchData)this.previousSearchData.get(size - 1 - i)).searchString;
            ++i;
        }
        this.stringCombo.setItems(searchStrings);
    }

    private void setPreviousFileNames() {
        int size = this.previousSearchData.size();
        ArrayList<String> typesStringList = new ArrayList<String>(size);
        int i = size - 1;
        while (i >= 0) {
            RemoteSearchData data = (RemoteSearchData)this.previousSearchData.get(i);
            String typeString = data.fileNames;
            if (!typesStringList.contains(typeString)) {
                typesStringList.add(typeString);
            }
            --i;
        }
        String[] typesStringArray = typesStringList.toArray(new String[typesStringList.size()]);
        this.fileNameCombo.setItems(typesStringArray);
    }

    private void setPreviousFolderNames() {
        int size = this.previousSearchData.size();
        ArrayList<String> folderNamesList = new ArrayList<String>(size);
        int j = 0;
        int i = size - 1;
        while (i >= 0) {
            RemoteSearchData data = (RemoteSearchData)this.previousSearchData.get(i);
            String folderNameString = this.folderNameEditor.getFormattedText(data.profileName, data.connectionName, data.folderName);
            if (!folderNamesList.contains(folderNameString)) {
                folderNamesList.add(folderNameString);
                this.folderNameEditor.addData(j, data.profileName, data.connectionName, data.folderName);
                ++j;
            }
            --i;
        }
        String[] folderNamesArray = folderNamesList.toArray(new String[folderNamesList.size()]);
        this.folderNameCombo.setItems(folderNamesArray);
    }

    private void initialize() {
        ISelection selection = this.container.getSelection();
        String text = null;
        String fileName = null;
        String profileName = null;
        String connectionName = null;
        String folderName = null;
        if (selection != null && !selection.isEmpty()) {
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IRemoteFile) {
                    IRemoteFile remoteFile = (IRemoteFile)obj;
                    boolean supportsArchiveManagement = remoteFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
                    boolean supportsSearch = remoteFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsSearch();
                    if (supportsSearch && remoteFile.isFile() && !remoteFile.isArchive()) {
                        fileName = remoteFile.getName();
                        IHost conn = remoteFile.getSystemConnection();
                        profileName = conn.getSystemProfileName();
                        connectionName = conn.getAliasName();
                        folderName = remoteFile.getParentPath();
                    } else if (supportsSearch && (remoteFile.isDirectory() || remoteFile.isArchive() && supportsArchiveManagement)) {
                        IHost conn = remoteFile.getSystemConnection();
                        profileName = conn.getSystemProfileName();
                        connectionName = conn.getAliasName();
                        folderName = remoteFile.getAbsolutePath();
                    }
                }
            } else if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                text = textSelection.getText();
            }
        }
        text = text == null || text.equals("") ? "*" : this.insertEscapeChar(text);
        this.stringCombo.setText(text);
        if (fileName == null) {
            fileName = "*";
        }
        this.fileNameEditor.setFileNamesText(fileName);
        if (profileName != null && connectionName != null && folderName != null) {
            this.folderNameEditor.setFolderText(profileName, connectionName, folderName);
        }
    }

    private String insertEscapeChar(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            lengthOfFirstLine = reader.readLine().length();
        }
        catch (IOException iOException) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.horizontalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        main.setLayoutData((Object)gd);
        this.createSearchStringControls(main);
        this.createFileNameControls(main);
        this.createFolderControls(main);
        this.createAdvancedControls(main);
        Mnemonics m = new Mnemonics();
        StringBuffer usedMnemonics = new StringBuffer(5);
        usedMnemonics.append(Mnemonics.getMnemonic((String)SearchMessages.SearchDialog_customize));
        usedMnemonics.append(Mnemonics.getMnemonic((String)SearchMessages.SearchDialog_searchAction));
        m.clear(usedMnemonics.toString());
        m.setMnemonics(parent);
        this.setControl((Control)main);
        SystemWidgetHelpers.setHelp((Control)main, (String)"org.eclipse.rse.ui.rsdi0000");
    }

    private void createSearchStringControls(Composite comp) {
        this.stringLabel = new Label(comp, 16384);
        this.stringLabel.setText(FileResources.RESID_SEARCH_STRING_LABEL_LABEL);
        this.stringLabel.setToolTipText(FileResources.RESID_SEARCH_STRING_LABEL_TOOLTIP);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.stringLabel.setLayoutData((Object)gd);
        this.stringCombo = new Combo(comp, 2052);
        this.stringCombo.setToolTipText(FileResources.RESID_SEARCH_STRING_COMBO_TOOLTIP);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.stringCombo.setLayoutData((Object)gd);
        this.stringCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemSearchPage.this.container.setPerformActionEnabled(SystemSearchPage.this.isValid());
            }
        });
        this.stringCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSearchPage.this.handleStringComboSelected();
            }
        });
        this.caseButton = new Button(comp, 32);
        this.caseButton.setText(FileResources.RESID_SEARCH_CASE_BUTTON_LABEL);
        this.caseButton.setToolTipText(FileResources.RESID_SEARCH_CASE_BUTTON_TOOLTIP);
        gd = new GridData(32);
        this.caseButton.setLayoutData((Object)gd);
        this.caseButton.setSelection(this.initialCaseSensitive);
        this.stringHintLabel = new Label(comp, 16384);
        this.stringHintLabel.setText(FileResources.RESID_SEARCH_STRING_HINT_LABEL);
        this.stringHintLabel.setToolTipText(FileResources.RESID_SEARCH_STRING_HINT_TOOLTIP);
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        this.stringHintLabel.setLayoutData((Object)gd);
        this.stringRegexButton = new Button(comp, 32);
        this.stringRegexButton.setText(FileResources.RESID_SEARCH_STRING_REGEX_LABEL);
        this.stringRegexButton.setToolTipText(FileResources.RESID_SEARCH_STRING_REGEX_TOOLTIP);
        gd = new GridData(32);
        this.stringRegexButton.setLayoutData((Object)gd);
        this.stringRegexButton.setSelection(this.initialStringRegex);
        this.stringHintLabel.setVisible(!this.stringRegexButton.getSelection());
        this.stringRegexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSearchPage.this.stringHintLabel.setVisible(!SystemSearchPage.this.stringRegexButton.getSelection());
            }
        });
    }

    private void handleStringComboSelected() {
        if (this.stringCombo.getSelectionIndex() < 0) {
            return;
        }
        int index = this.previousSearchData.size() - 1 - this.stringCombo.getSelectionIndex();
        RemoteSearchData data = (RemoteSearchData)this.previousSearchData.get(index);
        if (data == null || !this.stringCombo.getText().equals(data.searchString)) {
            return;
        }
        this.stringCombo.setText(data.searchString);
        this.caseButton.setSelection(data.caseSensitive);
        this.stringHintLabel.setVisible(!data.stringRegex);
        this.stringRegexButton.setSelection(data.stringRegex);
        this.fileNameEditor.setFileNamesText(data.fileNames);
        this.fileNameHintLabel.setVisible(!data.fileNameRegex);
        this.fileNameRegexButton.setSelection(data.fileNameRegex);
        this.folderNameEditor.setFolderText(data.profileName, data.connectionName, data.folderName);
        this.searchArchivesButton.setSelection(data.includeArchives);
        this.searchSubfoldersButton.setSelection(data.includeSubfolders);
    }

    private IRemoteFileSubSystem getRemoteFileSubSystem(String profName, String connName) {
        if (profName == null || connName == null) {
            return null;
        }
        ISystemRegistry reg = RSECorePlugin.getTheSystemRegistry();
        ISystemProfile profile = reg.getSystemProfile(profName);
        if (profile == null) {
            return null;
        }
        IHost conn = reg.getHost(profile, connName);
        if (conn == null) {
            return null;
        }
        return RemoteFileUtility.getFileSubSystem((IHost)conn);
    }

    private void createFileNameControls(Composite comp) {
        this.fileNameLabel = new Label(comp, 16384);
        this.fileNameLabel.setText(FileResources.RESID_SEARCH_FILENAME_LABEL_LABEL);
        this.fileNameLabel.setToolTipText(FileResources.RESID_SEARCH_FILENAME_LABEL_TOOLTIP);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.fileNameLabel.setLayoutData((Object)gd);
        this.fileNameCombo = new Combo(comp, 2052);
        this.fileNameCombo.setToolTipText(FileResources.RESID_SEARCH_FILENAME_COMBO_TOOLTIP);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileNameCombo.setLayoutData((Object)gd);
        this.fileNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemSearchPage.this.container.setPerformActionEnabled(SystemSearchPage.this.isValid());
            }
        });
        this.fileNameBrowseButton = new Button(comp, 8);
        this.fileNameBrowseButton.setText(FileResources.RESID_SEARCH_FILENAME_BROWSE_LABEL);
        this.fileNameBrowseButton.setToolTipText(FileResources.RESID_SEARCH_FILENAME_BROWSE_TOOLTIP);
        gd = new GridData(32);
        this.fileNameBrowseButton.setLayoutData((Object)gd);
        this.fileNameEditor = new FileNameEditor(this.fileNameCombo, this.fileNameBrowseButton);
        this.fileNameHintLabel = new Label(comp, 16384);
        this.fileNameHintLabel.setText(FileResources.RESID_SEARCH_FILENAME_HINT_LABEL);
        this.fileNameHintLabel.setToolTipText(FileResources.RESID_SEARCH_FILENAME_HINT_TOOLTIP);
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        this.fileNameHintLabel.setLayoutData((Object)gd);
        this.fileNameRegexButton = new Button(comp, 32);
        this.fileNameRegexButton.setText(FileResources.RESID_SEARCH_FILENAME_REGEX_LABEL);
        this.fileNameRegexButton.setToolTipText(FileResources.RESID_SEARCH_FILENAME_REGEX_TOOLTIP);
        gd = new GridData(32);
        this.fileNameRegexButton.setLayoutData((Object)gd);
        this.fileNameRegexButton.setSelection(this.initialFileNameRegex);
        this.fileNameHintLabel.setVisible(!this.fileNameRegexButton.getSelection());
        this.fileNameRegexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSearchPage.this.fileNameHintLabel.setVisible(!SystemSearchPage.this.fileNameRegexButton.getSelection());
            }
        });
    }

    private void createFolderControls(Composite comp) {
        this.folderNameLabel = new Label(comp, 16384);
        this.folderNameLabel.setText(FileResources.RESID_SEARCH_FOLDERNAME_LABEL_LABEL);
        this.folderNameLabel.setToolTipText(FileResources.RESID_SEARCH_FOLDERNAME_LABEL_TOOLTIP);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.folderNameLabel.setLayoutData((Object)gd);
        this.folderNameCombo = new Combo(comp, 2060);
        this.folderNameCombo.setToolTipText(FileResources.RESID_SEARCH_FOLDERNAME_COMBO_TOOLTIP);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.folderNameCombo.setLayoutData((Object)gd);
        this.folderNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemSearchPage.this.container.setPerformActionEnabled(SystemSearchPage.this.isValid());
            }
        });
        this.folderNameBrowseButton = new Button(comp, 8);
        this.folderNameBrowseButton.setText(FileResources.RESID_SEARCH_FOLDERNAME_BROWSE_LABEL);
        this.folderNameBrowseButton.setToolTipText(FileResources.RESID_SEARCH_FOLDERNAME_BROWSE_TOOLTIP);
        gd = new GridData(32);
        this.folderNameBrowseButton.setLayoutData((Object)gd);
        this.folderNameEditor = new FolderNameEditor(this.folderNameCombo, this.folderNameBrowseButton);
    }

    private void createAdvancedControls(Composite comp) {
        Label dummyLabel = new Label(comp, 16384);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        dummyLabel.setLayoutData((Object)gd);
        this.searchArchivesButton = new Button(comp, 32);
        this.searchArchivesButton.setText(FileResources.RESID_SEARCH_INCLUDE_ARCHIVES_LABEL);
        this.searchArchivesButton.setToolTipText(FileResources.RESID_SEARCH_INCLUDE_ARCHIVES_TOOLTIP);
        gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.searchArchivesButton.setLayoutData((Object)gd);
        this.searchArchivesButton.setSelection(this.initialSearchArchives);
        this.searchSubfoldersButton = new Button(comp, 32);
        this.searchSubfoldersButton.setText(FileResources.RESID_SEARCH_INCLUDE_SUBFOLDERS_LABEL);
        this.searchSubfoldersButton.setToolTipText(FileResources.RESID_SEARCH_INCLUDE_SUBFOLDERS_TOOLTIP);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.searchSubfoldersButton.setLayoutData((Object)gd);
        this.searchSubfoldersButton.setSelection(this.initialSearchSubfolders);
    }

    private boolean isValid() {
        return this.isFolderNameValid() && this.isSearchStringValid() && this.isFileNameValid();
    }

    private boolean isSearchStringValid() {
        String searchString = this.stringCombo.getText();
        return searchString != null;
    }

    private boolean isFileNameValid() {
        String fileNameString = this.fileNameCombo.getText();
        return fileNameString != null;
    }

    private boolean isFolderNameValid() {
        String folderName = this.folderNameCombo.getText();
        return folderName != null && folderName.trim().length() != 0;
    }

    private IDialogSettings getPluginDialogSettings() {
        return RSEUIPlugin.getDefault().getDialogSettings();
    }

    private IDialogSettings getConfigDialogSettings() {
        IDialogSettings settings = this.getPluginDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(REMOTE_SEARCH_PAGE_NAME);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(REMOTE_SEARCH_PAGE_NAME);
        }
        return dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getConfigDialogSettings();
        this.initialCaseSensitive = s.getBoolean("caseSensitive");
        this.initialStringRegex = s.getBoolean("stringRegex");
        this.initialFileNameRegex = s.getBoolean("fileNameRegex");
        this.initialSearchArchives = s.getBoolean("includeArchives");
        this.initialSearchSubfolders = s.getBoolean("includeSubfolders");
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getConfigDialogSettings();
        s.put("caseSensitive", this.caseButton.getSelection());
        s.put("stringRegex", this.stringRegexButton.getSelection());
        s.put("fileNameRegex", this.fileNameRegexButton.getSelection());
        s.put("includeArchives", this.searchArchivesButton.getSelection());
        s.put("includeSubfolders", this.searchSubfoldersButton.getSelection());
    }

    private void readData() {
        int size = 0;
        try {
            size = this.getConfigDialogSettings().getInt(STORE_CONFIG_DATA_SIZE);
        }
        catch (NumberFormatException numberFormatException) {
            size = 0;
        }
        if (size > 0) {
            size = Math.min(size, 20);
            this.previousSearchData = new ArrayList(size);
        }
        int i = 0;
        while (i < size) {
            IDialogSettings dataSection = this.getPluginDialogSettings().getSection(STORE_DATA_PREFIX + i);
            String searchString = dataSection.get(STORE_DATA_SEARCH_STRING);
            boolean caseSensitive = dataSection.getBoolean("caseSensitive");
            boolean stringRegex = dataSection.getBoolean("stringRegex");
            String fileNamesString = dataSection.get(STORE_DATA_FILE_NAMES);
            boolean fileNameRegex = dataSection.getBoolean("fileNameRegex");
            String profileName = dataSection.get(STORE_DATA_PROFILE_NAME);
            String connectionName = dataSection.get(STORE_DATA_CONNECTION_NAME);
            String folderName = dataSection.get(STORE_DATA_FOLDER_NAME);
            boolean searchArchives = dataSection.getBoolean("includeArchives");
            boolean searchSubfolders = dataSection.getBoolean("includeSubfolders");
            RemoteSearchData data = new RemoteSearchData(searchString, caseSensitive, stringRegex, fileNamesString, fileNameRegex, profileName, connectionName, folderName, searchArchives, searchSubfolders);
            this.previousSearchData.add(data);
            ++i;
        }
    }

    private void writeData() {
        int size = this.previousSearchData.size();
        size = Math.min(size, 20);
        this.getConfigDialogSettings().put(STORE_CONFIG_DATA_SIZE, size);
        IDialogSettings pluginSettings = this.getPluginDialogSettings();
        int i = 0;
        while (i < size) {
            IDialogSettings dataSection = pluginSettings.getSection(STORE_DATA_PREFIX + i);
            if (dataSection == null) {
                dataSection = pluginSettings.addNewSection(STORE_DATA_PREFIX + i);
            }
            RemoteSearchData data = (RemoteSearchData)this.previousSearchData.get(i);
            dataSection.put(STORE_DATA_SEARCH_STRING, data.searchString);
            dataSection.put("caseSensitive", data.caseSensitive);
            dataSection.put("stringRegex", data.stringRegex);
            dataSection.put(STORE_DATA_FILE_NAMES, data.fileNames);
            dataSection.put("fileNameRegex", data.fileNameRegex);
            dataSection.put(STORE_DATA_PROFILE_NAME, data.profileName);
            dataSection.put(STORE_DATA_CONNECTION_NAME, data.connectionName);
            dataSection.put(STORE_DATA_FOLDER_NAME, data.folderName);
            dataSection.put("includeArchives", data.includeArchives);
            dataSection.put("includeSubfolders", data.includeSubfolders);
            ++i;
        }
    }

    private abstract class CommonEditor
    extends SelectionAdapter
    implements DisposeListener {
        protected Combo nameCombo;
        protected Button browseButton;

        private CommonEditor(Combo nameCombo, Button browseButton) {
            this.nameCombo = nameCombo;
            this.browseButton = browseButton;
            nameCombo.addDisposeListener((DisposeListener)this);
            browseButton.addDisposeListener((DisposeListener)this);
            browseButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == this.nameCombo) {
                this.nameCombo = null;
            } else if (e.widget == this.browseButton) {
                this.browseButton = null;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.browseButton) {
                this.handleBrowseSelected();
            }
        }

        protected abstract void handleBrowseSelected();
    }

    private class FileNameEditor
    extends CommonEditor {
        private FileNameEditor(Combo fileCombo, Button browseButton) {
            super(fileCombo, browseButton);
        }

        protected void handleBrowseSelected() {
            Shell shell = SystemSearchPage.this.getShell();
            SystemSearchSelectFileTypesAction action = new SystemSearchSelectFileTypesAction(shell);
            List prevTypes = SystemSearchPage.this.util.typesStringToList(this.getFileNamesText());
            action.setTypes(prevTypes);
            action.run();
            if (!action.wasCancelled()) {
                List newTypes = action.getTypes();
                this.setFileNamesText(SystemSearchPage.this.util.typesListToString(newTypes));
            }
        }

        private void setFileNamesText(String fileNames) {
            this.nameCombo.setText(fileNames);
        }

        private String getFileNamesText() {
            return this.nameCombo.getText();
        }
    }

    private class FolderNameEditor
    extends CommonEditor {
        private Info currInfo;

        private FolderNameEditor(Combo folderCombo, Button browseButton) {
            super(folderCombo, browseButton);
            folderCombo.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.browseButton) {
                super.widgetSelected(e);
            } else if (e.widget == this.nameCombo) {
                int selectionIndex = this.nameCombo.getSelectionIndex();
                this.currInfo = this.getInfo(selectionIndex);
            } else {
                super.widgetSelected(e);
            }
        }

        protected void handleBrowseSelected() {
            String preconnectionname;
            Shell shell = SystemSearchPage.this.getShell();
            SystemSearchRemoteFolderAction selectFolderAction = new SystemSearchRemoteFolderAction(shell);
            selectFolderAction.setShowNewConnectionPrompt(true);
            selectFolderAction.setShowPropertySheet(true, false);
            selectFolderAction.setNeedsProgressMonitor(true);
            selectFolderAction.setMultipleSelectionMode(false);
            if (this.nameCombo.getText().length() > 0 && (preconnectionname = this.getConnectionName()) != null && preconnectionname.length() > 0) {
                ISystemProfile profile = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getDefaultPrivateSystemProfile();
                IHost prehost = RSECorePlugin.getTheSystemRegistry().getHost(profile, preconnectionname);
                if (prehost != null) {
                    selectFolderAction.setDefaultConnection(prehost);
                    String prepath = this.getFolderPath();
                    if (prepath != null && prepath.length() > 0) {
                        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)prehost);
                        try {
                            IRemoteFile selection = ss.getRemoteFileObject(prepath, (IProgressMonitor)new NullProgressMonitor());
                            if (selection != null) {
                                selectFolderAction.setPreSelection(selection);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            LinkedList<IRSESystemType> types = new LinkedList<IRSESystemType>();
            IRSESystemType[] allSystemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
            int i = 0;
            while (i < allSystemTypes.length) {
                IRemoteFileSubSystemConfiguration rfssc = RemoteFileUtility.getFileSubSystemConfiguration((IRSESystemType)allSystemTypes[i]);
                if (rfssc != null && rfssc.supportsSearch()) {
                    types.add(allSystemTypes[i]);
                }
                ++i;
            }
            IRSESystemType[] allowedTypes = new IRSESystemType[types.size()];
            types.toArray(allowedTypes);
            selectFolderAction.setSystemTypes(allowedTypes);
            selectFolderAction.run();
            if (!selectFolderAction.wasCancelled()) {
                IRemoteFile remoteFile = selectFolderAction.getSelectedFolder();
                String folderPath = remoteFile.getAbsolutePath();
                IHost conn = selectFolderAction.getSelectedConnection();
                String profileName = conn.getSystemProfileName();
                String connectionName = conn.getAliasName();
                this.setFolderText(profileName, connectionName, folderPath);
            }
        }

        private void setFolderText(String profileName, String connectionName, String folderPath) {
            String text = this.getFormattedText(profileName, connectionName, folderPath);
            String[] currItems = this.nameCombo.getItems();
            int selectionIndex = -1;
            boolean matchFound = false;
            int i = 0;
            while (i < currItems.length) {
                if (currItems[i].equals(text)) {
                    selectionIndex = i;
                    matchFound = true;
                    break;
                }
                ++i;
            }
            if (!matchFound) {
                int oldLength = currItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currItems, 0, newItems, 0, currItems.length);
                newItems[oldLength] = text;
                this.nameCombo.setItems(newItems);
                selectionIndex = oldLength;
                this.addData(selectionIndex, profileName, connectionName, folderPath);
            }
            this.nameCombo.select(selectionIndex);
            this.currInfo = this.getInfo(selectionIndex);
        }

        private String getFormattedText(String profileName, String connectionName, String folderPath) {
            return String.valueOf(connectionName) + ":" + folderPath;
        }

        private void addData(int index, String profileName, String connectionName, String folderPath) {
            Info info = new Info(profileName, connectionName, folderPath);
            this.nameCombo.setData(String.valueOf(index), (Object)info);
        }

        private Info getInfo(int index) {
            return (Info)this.nameCombo.getData(String.valueOf(index));
        }

        private String getProfileName() {
            return this.currInfo.profileName;
        }

        private String getConnectionName() {
            return this.currInfo.connectionName;
        }

        private String getFolderPath() {
            return this.currInfo.folderPath;
        }

        private class Info {
            private String profileName;
            private String connectionName;
            private String folderPath;

            private Info(String profileName, String connectionName, String folderPath) {
                this.profileName = profileName;
                this.connectionName = connectionName;
                this.folderPath = folderPath;
            }
        }
    }

    private class RemoteSearchData {
        private String searchString;
        private boolean caseSensitive;
        private boolean stringRegex;
        private String fileNames;
        private boolean fileNameRegex;
        private String profileName;
        private String connectionName;
        private String folderName;
        private boolean includeArchives;
        private boolean includeSubfolders;

        private RemoteSearchData(String searchString, boolean caseSensitive, boolean stringRegex, String fileNames, boolean fileNameRegex, String profileName, String connectionName, String folderName, boolean includeArchives, boolean includeSubfolders) {
            this.searchString = searchString;
            this.caseSensitive = caseSensitive;
            this.stringRegex = stringRegex;
            this.fileNames = fileNames;
            this.fileNameRegex = fileNameRegex;
            this.profileName = profileName;
            this.connectionName = connectionName;
            this.folderName = folderName;
            this.includeArchives = includeArchives;
            this.includeSubfolders = includeSubfolders;
        }
    }
}

